/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.AlphabetRegistrationException;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;
import org.scilab.forge.jlatexmath.Extension;
import org.scilab.forge.jlatexmath.FontAlreadyLoadedException;
import org.scilab.forge.jlatexmath.FontInfo;
import org.scilab.forge.jlatexmath.Metrics;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolMappingNotFoundException;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TextStyleMappingNotFoundException;
import org.scilab.forge.jlatexmath.XMLResourceParseException;

public class DefaultTeXFont
implements TeXFont {
    private static String[] defaultTextStyleMappings;
    protected static final int NONE = -1;
    protected static final int NUMBERS = 0;
    protected static final int CAPITALS = 1;
    protected static final int SMALL = 2;
    protected static final int UNICODE = 3;
    private static Map<String, CharFont[]> textStyleMappings;
    private static Map<String, CharFont> symbolMappings;
    private static FontInfo[] fontInfo;
    private static Map<String, Float> parameters;
    private static Map<String, Number> generalSettings;
    private static boolean magnificationEnable;
    protected static final int TOP = 0;
    protected static final int MID = 1;
    protected static final int REP = 2;
    protected static final int BOT = 3;
    protected static final int WIDTH = 0;
    protected static final int HEIGHT = 1;
    protected static final int DEPTH = 2;
    protected static final int IT = 3;
    public static List<Character.UnicodeBlock> loadedAlphabets;
    public static Map<Character.UnicodeBlock, AlphabetRegistration> registeredAlphabets;
    protected float factor = 1.0f;
    public boolean isBold = false;
    public boolean isRoman = false;
    public boolean isSs = false;
    public boolean isTt = false;
    public boolean isIt = false;
    private final float size;

    public DefaultTeXFont(float pointSize) {
        this.size = pointSize;
    }

    public DefaultTeXFont(float pointSize, boolean b, boolean rm, boolean ss, boolean tt, boolean it) {
        this(pointSize, 1.0f, b, rm, ss, tt, it);
    }

    public DefaultTeXFont(float pointSize, float f, boolean b, boolean rm, boolean ss, boolean tt, boolean it) {
        this.size = pointSize;
        this.factor = f;
        this.isBold = b;
        this.isRoman = rm;
        this.isSs = ss;
        this.isTt = tt;
        this.isIt = it;
    }

    public static void addTeXFontDescription(String file) throws ResourceParseException {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceParseException(file, e);
        }
        DefaultTeXFont.addTeXFontDescription(in, file);
    }

    public static void addTeXFontDescription(InputStream in, String name) throws ResourceParseException {
        DefaultTeXFontParser dtfp = new DefaultTeXFontParser(in, name);
        fontInfo = dtfp.parseFontDescriptions(fontInfo);
        textStyleMappings.putAll(dtfp.parseTextStyleMappings());
        symbolMappings.putAll(dtfp.parseSymbolMappings());
    }

    public static void addTeXFontDescription(Object base, InputStream in, String name) throws ResourceParseException {
        DefaultTeXFontParser dtfp = new DefaultTeXFontParser(base, in, name);
        fontInfo = dtfp.parseFontDescriptions(fontInfo);
        dtfp.parseExtraPath();
        textStyleMappings.putAll(dtfp.parseTextStyleMappings());
        symbolMappings.putAll(dtfp.parseSymbolMappings());
    }

    public static void addAlphabet(Character.UnicodeBlock alphabet, InputStream inlanguage, String language, InputStream insymbols, String symbols, InputStream inmappings, String mappings) throws ResourceParseException {
        if (!loadedAlphabets.contains(alphabet)) {
            DefaultTeXFont.addTeXFontDescription(inlanguage, language);
            SymbolAtom.addSymbolAtom(insymbols, symbols);
            TeXFormula.addSymbolMappings(inmappings, mappings);
            loadedAlphabets.add(alphabet);
        }
    }

    public static void addAlphabet(Object base, Character.UnicodeBlock[] alphabet, String language) throws ResourceParseException {
        int i;
        boolean b = false;
        for (i = 0; !b && i < alphabet.length; ++i) {
            b = loadedAlphabets.contains(alphabet[i]) || b;
        }
        if (!b) {
            TeXParser.isLoading = true;
            DefaultTeXFont.addTeXFontDescription(base, base.getClass().getResourceAsStream(language), language);
            for (i = 0; i < alphabet.length; ++i) {
                loadedAlphabets.add(alphabet[i]);
            }
            TeXParser.isLoading = false;
        }
    }

    public static void addAlphabet(Character.UnicodeBlock alphabet, String name) {
        String lg = "fonts/" + name + "/language_" + name + ".xml";
        String sym = "fonts/" + name + "/symbols_" + name + ".xml";
        String map2 = "fonts/" + name + "/mappings_" + name + ".xml";
        try {
            DefaultTeXFont.addAlphabet(alphabet, TeXFormula.class.getResourceAsStream(lg), lg, TeXFormula.class.getResourceAsStream(sym), sym, TeXFormula.class.getResourceAsStream(map2), map2);
        }
        catch (FontAlreadyLoadedException fontAlreadyLoadedException) {
            // empty catch block
        }
    }

    public static void addAlphabet(AlphabetRegistration reg) {
        try {
            if (reg != null) {
                DefaultTeXFont.addAlphabet(reg.getPackage(), reg.getUnicodeBlock(), reg.getTeXFontFileName());
            }
        }
        catch (FontAlreadyLoadedException fontAlreadyLoadedException) {
        }
        catch (AlphabetRegistrationException e) {
            System.err.println(e.toString());
        }
    }

    public static void registerAlphabet(AlphabetRegistration reg) {
        Character.UnicodeBlock[] blocks = reg.getUnicodeBlock();
        for (int i = 0; i < blocks.length; ++i) {
            registeredAlphabets.put(blocks[i], reg);
        }
    }

    @Override
    public TeXFont copy() {
        return new DefaultTeXFont(this.size, this.factor, this.isBold, this.isRoman, this.isSs, this.isTt, this.isIt);
    }

    @Override
    public TeXFont deriveFont(float size) {
        return new DefaultTeXFont(size, this.factor, this.isBold, this.isRoman, this.isSs, this.isTt, this.isIt);
    }

    @Override
    public TeXFont scaleFont(float factor) {
        return new DefaultTeXFont(this.size, factor, this.isBold, this.isRoman, this.isSs, this.isTt, this.isIt);
    }

    @Override
    public float getScaleFactor() {
        return this.factor;
    }

    @Override
    public float getAxisHeight(int style) {
        return DefaultTeXFont.getParameter("axisheight") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getBigOpSpacing1(int style) {
        return DefaultTeXFont.getParameter("bigopspacing1") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getBigOpSpacing2(int style) {
        return DefaultTeXFont.getParameter("bigopspacing2") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getBigOpSpacing3(int style) {
        return DefaultTeXFont.getParameter("bigopspacing3") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getBigOpSpacing4(int style) {
        return DefaultTeXFont.getParameter("bigopspacing4") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getBigOpSpacing5(int style) {
        return DefaultTeXFont.getParameter("bigopspacing5") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    private Char getChar(char c, CharFont[] cf, int style) {
        int offset;
        int kind;
        if (c >= '0' && c <= '9') {
            kind = 0;
            offset = c - 48;
        } else if (c >= 'a' && c <= 'z') {
            kind = 2;
            offset = c - 97;
        } else if (c >= 'A' && c <= 'Z') {
            kind = 1;
            offset = c - 65;
        } else {
            kind = 3;
            offset = c;
        }
        if (cf[kind] == null) {
            return this.getDefaultChar(c, style);
        }
        return this.getChar(new CharFont((char)(cf[kind].c + offset), cf[kind].fontId), style);
    }

    @Override
    public Char getChar(char c, String textStyle, int style) throws TextStyleMappingNotFoundException {
        CharFont[] mapping = textStyleMappings.get(textStyle);
        if (mapping == null) {
            throw new TextStyleMappingNotFoundException(textStyle);
        }
        return this.getChar(c, mapping, style);
    }

    @Override
    public Char getChar(CharFont cf, int style) {
        float fsize = DefaultTeXFont.getSizeFactor(style);
        int id = this.isBold ? cf.boldFontId : cf.fontId;
        FontInfo info = fontInfo[id];
        if (this.isBold && cf.fontId == cf.boldFontId) {
            id = info.getBoldId();
            info = fontInfo[id];
            cf = new CharFont(cf.c, id, style);
        }
        if (this.isRoman) {
            id = info.getRomanId();
            info = fontInfo[id];
            cf = new CharFont(cf.c, id, style);
        }
        if (this.isSs) {
            id = info.getSsId();
            info = fontInfo[id];
            cf = new CharFont(cf.c, id, style);
        }
        if (this.isTt) {
            id = info.getTtId();
            info = fontInfo[id];
            cf = new CharFont(cf.c, id, style);
        }
        if (this.isIt) {
            id = info.getItId();
            info = fontInfo[id];
            cf = new CharFont(cf.c, id, style);
        }
        Font font = info.getFont();
        return new Char(cf.c, font, id, this.getMetrics(cf, this.factor * fsize));
    }

    @Override
    public Char getChar(String symbolName, int style) throws SymbolMappingNotFoundException {
        CharFont obj = symbolMappings.get(symbolName);
        if (obj == null) {
            throw new SymbolMappingNotFoundException(symbolName);
        }
        return this.getChar(obj, style);
    }

    @Override
    public Char getDefaultChar(char c, int style) {
        if (c >= '0' && c <= '9') {
            return this.getChar(c, defaultTextStyleMappings[0], style);
        }
        if (c >= 'a' && c <= 'z') {
            return this.getChar(c, defaultTextStyleMappings[2], style);
        }
        return this.getChar(c, defaultTextStyleMappings[1], style);
    }

    @Override
    public float getDefaultRuleThickness(int style) {
        return DefaultTeXFont.getParameter("defaultrulethickness") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getDenom1(int style) {
        return DefaultTeXFont.getParameter("denom1") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getDenom2(int style) {
        return DefaultTeXFont.getParameter("denom2") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public Extension getExtension(Char c, int style) {
        Font f = c.getFont();
        int fc = c.getFontCode();
        float s = DefaultTeXFont.getSizeFactor(style);
        FontInfo info = fontInfo[fc];
        int[] ext = info.getExtension(c.getChar());
        Char[] parts = new Char[ext.length];
        for (int i = 0; i < ext.length; ++i) {
            parts[i] = ext[i] == -1 ? null : new Char((char)ext[i], f, fc, this.getMetrics(new CharFont((char)ext[i], fc), s));
        }
        return new Extension(parts[0], parts[1], parts[2], parts[3]);
    }

    @Override
    public float getKern(CharFont left, CharFont right, int style) {
        if (left.fontId == right.fontId) {
            FontInfo info = fontInfo[left.fontId];
            return info.getKern(left.c, right.c, DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT);
        }
        return 0.0f;
    }

    @Override
    public CharFont getLigature(CharFont left, CharFont right) {
        if (left.fontId == right.fontId) {
            FontInfo info = fontInfo[left.fontId];
            return info.getLigature(left.c, right.c);
        }
        return null;
    }

    private Metrics getMetrics(CharFont cf, float size) {
        FontInfo info = fontInfo[cf.fontId];
        float[] m = info.getMetrics(cf.c);
        return new Metrics(m[0], m[1], m[2], m[3], size * TeXFormula.PIXELS_PER_POINT, size);
    }

    @Override
    public int getMuFontId() {
        return generalSettings.get("mufontid").intValue();
    }

    @Override
    public Char getNextLarger(Char c, int style) {
        FontInfo info = fontInfo[c.getFontCode()];
        CharFont ch = info.getNextLarger(c.getChar());
        FontInfo newInfo = fontInfo[ch.fontId];
        return new Char(ch.c, newInfo.getFont(), ch.fontId, this.getMetrics(ch, DefaultTeXFont.getSizeFactor(style)));
    }

    @Override
    public float getNum1(int style) {
        return DefaultTeXFont.getParameter("num1") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getNum2(int style) {
        return DefaultTeXFont.getParameter("num2") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getNum3(int style) {
        return DefaultTeXFont.getParameter("num3") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getQuad(int style, int fontCode) {
        FontInfo info = fontInfo[fontCode];
        return info.getQuad(DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT);
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public float getSkew(CharFont cf, int style) {
        FontInfo info = fontInfo[cf.fontId];
        char skew = info.getSkewChar();
        if (skew == '\uffffffff') {
            return 0.0f;
        }
        return this.getKern(cf, new CharFont(skew, cf.fontId), style);
    }

    @Override
    public float getSpace(int style) {
        int spaceFontId = generalSettings.get("spacefontid").intValue();
        FontInfo info = fontInfo[spaceFontId];
        return info.getSpace(DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT);
    }

    @Override
    public float getSub1(int style) {
        return DefaultTeXFont.getParameter("sub1") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getSub2(int style) {
        return DefaultTeXFont.getParameter("sub2") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getSubDrop(int style) {
        return DefaultTeXFont.getParameter("subdrop") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getSup1(int style) {
        return DefaultTeXFont.getParameter("sup1") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getSup2(int style) {
        return DefaultTeXFont.getParameter("sup2") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getSup3(int style) {
        return DefaultTeXFont.getParameter("sup3") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getSupDrop(int style) {
        return DefaultTeXFont.getParameter("supdrop") * DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public float getXHeight(int style, int fontCode) {
        FontInfo info = fontInfo[fontCode];
        return info.getXHeight(DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT);
    }

    @Override
    public float getEM(int style) {
        return DefaultTeXFont.getSizeFactor(style) * TeXFormula.PIXELS_PER_POINT;
    }

    @Override
    public boolean hasNextLarger(Char c) {
        FontInfo info = fontInfo[c.getFontCode()];
        return info.getNextLarger(c.getChar()) != null;
    }

    @Override
    public void setBold(boolean bold) {
        this.isBold = bold;
    }

    @Override
    public boolean getBold() {
        return this.isBold;
    }

    @Override
    public void setRoman(boolean rm) {
        this.isRoman = rm;
    }

    @Override
    public boolean getRoman() {
        return this.isRoman;
    }

    @Override
    public void setTt(boolean tt) {
        this.isTt = tt;
    }

    @Override
    public boolean getTt() {
        return this.isTt;
    }

    @Override
    public void setIt(boolean it) {
        this.isIt = it;
    }

    @Override
    public boolean getIt() {
        return this.isIt;
    }

    @Override
    public void setSs(boolean ss) {
        this.isSs = ss;
    }

    @Override
    public boolean getSs() {
        return this.isSs;
    }

    @Override
    public boolean hasSpace(int font) {
        FontInfo info = fontInfo[font];
        return info.hasSpace();
    }

    @Override
    public boolean isExtensionChar(Char c) {
        FontInfo info = fontInfo[c.getFontCode()];
        return info.getExtension(c.getChar()) != null;
    }

    public static void setMathSizes(float ds, float ts, float ss, float sss) {
        if (magnificationEnable) {
            generalSettings.put("scriptfactor", Float.valueOf(Math.abs(ss / ds)));
            generalSettings.put("scriptscriptfactor", Float.valueOf(Math.abs(sss / ds)));
            generalSettings.put("textfactor", Float.valueOf(Math.abs(ts / ds)));
            TeXIcon.defaultSize = Math.abs(ds);
        }
    }

    public static void setMagnification(float mag) {
        if (magnificationEnable) {
            TeXIcon.magFactor = mag / 1000.0f;
        }
    }

    public static void enableMagnification(boolean b) {
        magnificationEnable = b;
    }

    private static float getParameter(String parameterName) {
        Float param = parameters.get(parameterName);
        if (param == null) {
            return 0.0f;
        }
        return param.floatValue();
    }

    public static float getSizeFactor(int style) {
        if (style < 2) {
            return 1.0f;
        }
        if (style < 4) {
            return generalSettings.get("textfactor").floatValue();
        }
        if (style < 6) {
            return generalSettings.get("scriptfactor").floatValue();
        }
        return generalSettings.get("scriptscriptfactor").floatValue();
    }

    static {
        fontInfo = new FontInfo[0];
        magnificationEnable = true;
        loadedAlphabets = new ArrayList<Character.UnicodeBlock>();
        registeredAlphabets = new HashMap<Character.UnicodeBlock, AlphabetRegistration>();
        DefaultTeXFontParser parser = new DefaultTeXFontParser();
        loadedAlphabets.add(Character.UnicodeBlock.of('a'));
        fontInfo = parser.parseFontDescriptions(fontInfo);
        parameters = parser.parseParameters();
        textStyleMappings = parser.parseTextStyleMappings();
        defaultTextStyleMappings = parser.parseDefaultTextStyleMappings();
        symbolMappings = parser.parseSymbolMappings();
        generalSettings = parser.parseGeneralSettings();
        generalSettings.put("textfactor", 1);
        int muFontId = generalSettings.get("mufontid").intValue();
        if (muFontId < 0 || muFontId >= fontInfo.length || fontInfo[muFontId] == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", "GeneralSettings", "mufontid", "contains an unknown font id!");
        }
    }
}

