/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.askai.debug;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.askai.debug.AskAICodeStyleSettingsExtractor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/askai/debug/AskAICodeStyleSettingsApplier;", "", "<init>", "()V", "applyFieldValue", "", "field", "Ljava/lang/reflect/Field;", "target", "jsonValue", "Lkotlinx/serialization/json/JsonElement;", "metadata", "Lcom/intellij/ml/llm/askai/debug/AskAICodeStyleSettingsExtractor$FieldMetadata;", "parseEnumValueFromMetadata", "", "description", "", "(Ljava/lang/String;Lcom/intellij/ml/llm/askai/debug/AskAICodeStyleSettingsExtractor$FieldMetadata;)Ljava/lang/Integer;", "saveSettings", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "intellij.ml.llm.askai"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAskAICodeStyleSettingsApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AskAICodeStyleSettingsApplier.kt\ncom/intellij/ml/llm/askai/debug/AskAICodeStyleSettingsApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n360#2,7:78\n*S KotlinDebug\n*F\n+ 1 AskAICodeStyleSettingsApplier.kt\ncom/intellij/ml/llm/askai/debug/AskAICodeStyleSettingsApplier\n*L\n61#1:78,7\n*E\n"})
public final class AskAICodeStyleSettingsApplier {
    @NotNull
    public static final AskAICodeStyleSettingsApplier INSTANCE = new AskAICodeStyleSettingsApplier();
    public static final int $stable;

    private AskAICodeStyleSettingsApplier() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void applyFieldValue(@NotNull Field field, @NotNull Object target, @NotNull JsonElement jsonValue, @Nullable AskAICodeStyleSettingsExtractor.FieldMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        Class<?> clazz = field.getType();
        if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
            int n;
            if (!(jsonValue instanceof JsonPrimitive)) throw new IllegalArgumentException("Expected number or string for field " + field.getName() + ", got " + jsonValue);
            if (((JsonPrimitive)jsonValue).isString()) {
                Integer n2 = this.parseEnumValueFromMetadata(((JsonPrimitive)jsonValue).getContent(), metadata);
                if (n2 == null) throw new IllegalArgumentException("Could not parse enum value '" + ((JsonPrimitive)jsonValue).getContent() + "' for field " + field.getName());
                n = n2;
            } else {
                n = JsonElementKt.getInt((JsonPrimitive)((JsonPrimitive)jsonValue));
            }
            int value = n;
            field.setInt(target, value);
            return;
        } else if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
            if (!(jsonValue instanceof JsonPrimitive)) {
                throw new IllegalArgumentException("Expected boolean for field " + field.getName() + ", got " + jsonValue);
            }
            boolean value = JsonElementKt.getBoolean((JsonPrimitive)((JsonPrimitive)jsonValue));
            field.setBoolean(target, value);
            return;
        } else {
            if (!Intrinsics.areEqual(clazz, String.class)) throw new IllegalArgumentException("Unsupported field type: " + field.getType() + " for field " + field.getName());
            if (!(jsonValue instanceof JsonPrimitive)) {
                throw new IllegalArgumentException("Expected string for field " + field.getName() + ", got " + jsonValue);
            }
            String value = ((JsonPrimitive)jsonValue).getContent();
            field.set(target, value);
        }
    }

    @Nullable
    public final Integer parseEnumValueFromMetadata(@NotNull String description, @Nullable AskAICodeStyleSettingsExtractor.FieldMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        AskAICodeStyleSettingsExtractor.FieldMetadata fieldMetadata = metadata;
        if ((fieldMetadata != null ? fieldMetadata.getValueUiNames() : null) != null && metadata.getValues() != null) {
            int index;
            block4: {
                int n;
                List<String> $this$indexOfFirst$iv = metadata.getValueUiNames();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    String item$iv;
                    String it = item$iv = iterator.next();
                    boolean bl = false;
                    if (StringsKt.equals((String)it, (String)description, (boolean)true)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index >= 0) {
                return metadata.getValues().get(index);
            }
        }
        return null;
    }

    public final void saveSettings(@NotNull Project project, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        settings.getModificationTracker().incModificationCount();
        CodeStyleSettingsManager.getInstance((Project)project).fireCodeStyleSettingsChanged();
    }
}

