/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.junie.support;

import com.intellij.ml.llm.junie.support.StepBuildingEvent;
import com.intellij.ml.llm.matterhorn.AgentResponseWithData;
import com.intellij.ml.llm.matterhorn.AgentStateUpdatedEvent;
import com.intellij.ml.llm.matterhorn.Artifact;
import com.intellij.ml.llm.matterhorn.ArtifactId;
import com.intellij.ml.llm.matterhorn.ArtifactType;
import com.intellij.ml.llm.matterhorn.Artifactual;
import com.intellij.ml.llm.matterhorn.BeforeStepStartedEvent;
import com.intellij.ml.llm.matterhorn.CancelledArtifact;
import com.intellij.ml.llm.matterhorn.CustomArtifactEvent;
import com.intellij.ml.llm.matterhorn.FailedArtifact;
import com.intellij.ml.llm.matterhorn.PlanUpdatedEvent;
import com.intellij.ml.llm.matterhorn.RootExecutionContextListener;
import com.intellij.ml.llm.matterhorn.StepMetaInfoAppearedEvent;
import com.intellij.ml.llm.matterhorn.StepSummaryCreatedEvent;
import com.intellij.ml.llm.matterhorn.TaskReportCreatedEvent;
import com.intellij.ml.llm.matterhorn.TaskSummaryCreatedEvent;
import com.intellij.ml.llm.matterhorn.actions.edit.EditEvent;
import com.intellij.ml.llm.matterhorn.tasks.persistence.StepEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B/\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J\u0014\u0010 \u001a\u00020\t2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020%H\u0016J \u0010&\u001a\u00020\t2\n\u0010'\u001a\u00060(j\u0002`)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001e\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J\u001c\u0010.\u001a\u00020\t2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0007H\u0002J\u0014\u00100\u001a\u00020\t2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\u0013\u001a:\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00140\u000fj\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0014`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0016j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/ml/llm/junie/support/StepsBuildingContextListener;", "StepOutput", "Lcom/intellij/ml/llm/matterhorn/RootExecutionContextListener;", "singleStepArtifactType", "Lcom/intellij/ml/llm/matterhorn/ArtifactType;", "Lcom/intellij/ml/llm/matterhorn/AgentResponseWithData;", "eventCallback", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/junie/support/StepBuildingEvent;", "", "<init>", "(Lcom/intellij/ml/llm/matterhorn/ArtifactType;Lkotlin/jvm/functions/Function1;)V", "getSingleStepArtifactType", "()Lcom/intellij/ml/llm/matterhorn/ArtifactType;", "artifactsMap", "Ljava/util/HashMap;", "Lcom/intellij/ml/llm/matterhorn/ArtifactId;", "Lcom/intellij/ml/llm/matterhorn/Artifactual;", "Lkotlin/collections/HashMap;", "childArtifactsMap", "", "finishedArtifacts", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "steps", "Ljava/util/ArrayList;", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/StepEntity;", "Lkotlin/collections/ArrayList;", "newStepInProgress", "onUnfinishedArtifactCreated", "artifact", "requester", "onArtifactFinished", "Lcom/intellij/ml/llm/matterhorn/Artifact;", "onArtifactCancelled", "Lcom/intellij/ml/llm/matterhorn/CancelledArtifact;", "onArtifactFailed", "Lcom/intellij/ml/llm/matterhorn/FailedArtifact;", "onException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "artifactId", "onCustomEvent", "event", "Lcom/intellij/ml/llm/matterhorn/CustomArtifactEvent;", "updateLastOrInProgress", "update", "cleanUpArtifact", "intellij.ml.llm.junie"})
@SourceDebugExtension(value={"SMAP\nStepsBuildingContextListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StepsBuildingContextListener.kt\ncom/intellij/ml/llm/junie/support/StepsBuildingContextListener\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,143:1\n382#2,7:144\n*S KotlinDebug\n*F\n+ 1 StepsBuildingContextListener.kt\ncom/intellij/ml/llm/junie/support/StepsBuildingContextListener\n*L\n24#1:144,7\n*E\n"})
public final class StepsBuildingContextListener<StepOutput>
implements RootExecutionContextListener {
    @NotNull
    private final ArtifactType<AgentResponseWithData<StepOutput>> singleStepArtifactType;
    @NotNull
    private final Function1<StepBuildingEvent, Unit> eventCallback;
    @NotNull
    private final HashMap<ArtifactId<?>, Artifactual> artifactsMap;
    @NotNull
    private final HashMap<ArtifactId<?>, List<ArtifactId<?>>> childArtifactsMap;
    @NotNull
    private final HashSet<ArtifactId<?>> finishedArtifacts;
    @NotNull
    private final ArrayList<StepEntity> steps;
    @Nullable
    private StepEntity newStepInProgress;

    public StepsBuildingContextListener(@NotNull ArtifactType<AgentResponseWithData<StepOutput>> singleStepArtifactType, @NotNull Function1<? super StepBuildingEvent, Unit> eventCallback) {
        Intrinsics.checkNotNullParameter(singleStepArtifactType, (String)"singleStepArtifactType");
        Intrinsics.checkNotNullParameter(eventCallback, (String)"eventCallback");
        this.singleStepArtifactType = singleStepArtifactType;
        this.eventCallback = eventCallback;
        this.artifactsMap = new HashMap();
        this.childArtifactsMap = new HashMap();
        this.finishedArtifacts = new HashSet();
        this.steps = new ArrayList();
    }

    @NotNull
    public final ArtifactType<AgentResponseWithData<StepOutput>> getSingleStepArtifactType() {
        return this.singleStepArtifactType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void onUnfinishedArtifactCreated(@NotNull Artifactual artifact, @Nullable ArtifactId<?> requester) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        ((Map)this.artifactsMap).put(artifact.getId(), artifact);
        if (requester != null) {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = this.childArtifactsMap;
            ArtifactId<?> key$iv = requester;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List childList = (List)object;
            childList.add(artifact.getId());
        }
    }

    @Override
    public synchronized void onArtifactFinished(@NotNull Artifact<?> artifact) {
        Intrinsics.checkNotNullParameter(artifact, (String)"artifact");
        ((Map)this.artifactsMap).put(artifact.getId(), artifact);
        this.finishedArtifacts.add(artifact.getId());
        if (Intrinsics.areEqual(artifact.getId().getType(), this.singleStepArtifactType)) {
            this.cleanUpArtifact(artifact.getId());
        }
    }

    @Override
    public synchronized void onArtifactCancelled(@NotNull CancelledArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        ((Map)this.artifactsMap).put(artifact.getId(), artifact);
        this.finishedArtifacts.add(artifact.getId());
        this.cleanUpArtifact(artifact.getId());
    }

    @Override
    public synchronized void onArtifactFailed(@NotNull FailedArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        ((Map)this.artifactsMap).put(artifact.getId(), artifact);
        this.finishedArtifacts.add(artifact.getId());
        this.cleanUpArtifact(artifact.getId());
        this.eventCallback.invoke((Object)new StepBuildingEvent.ErrorOccurred(null));
    }

    @Override
    public synchronized void onException(@NotNull Exception e, @NotNull ArtifactId<?> artifactId) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(artifactId, (String)"artifactId");
        this.eventCallback.invoke((Object)new StepBuildingEvent.ErrorOccurred(e));
    }

    @Override
    public synchronized void onCustomEvent(@NotNull CustomArtifactEvent event, @Nullable ArtifactId<?> requester) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CustomArtifactEvent customArtifactEvent = event;
        if (customArtifactEvent instanceof BeforeStepStartedEvent) {
            this.newStepInProgress = new StepEntity(null, null, null, null, null, null, 24, null);
        } else if (customArtifactEvent instanceof StepMetaInfoAppearedEvent) {
            StepEntity stepInProgress = this.newStepInProgress;
            if (stepInProgress == null) {
                return;
            }
            this.newStepInProgress = null;
            int index = this.steps.size();
            StepEntity stepEntity = StepEntity.copy$default(stepInProgress, ((StepMetaInfoAppearedEvent)event).getStepName(), ((StepMetaInfoAppearedEvent)event).getStepType(), null, null, null, null, 60, null);
            this.steps.add(stepEntity);
            this.eventCallback.invoke((Object)new StepBuildingEvent.StepUpdated(stepEntity, index));
        } else if (customArtifactEvent instanceof EditEvent) {
            this.updateLastOrInProgress((Function1<StepEntity, StepEntity>)((Function1)arg_0 -> StepsBuildingContextListener.onCustomEvent$lambda$0(event, arg_0)));
        } else if (customArtifactEvent instanceof StepSummaryCreatedEvent) {
            this.updateLastOrInProgress((Function1<StepEntity, StepEntity>)((Function1)arg_0 -> StepsBuildingContextListener.onCustomEvent$lambda$1(event, arg_0)));
            this.eventCallback.invoke((Object)new StepBuildingEvent.ProgressUpdated(null));
        } else if (customArtifactEvent instanceof TaskReportCreatedEvent) {
            this.eventCallback.invoke((Object)new StepBuildingEvent.ReportAppeared(((TaskReportCreatedEvent)event).getTaskReport()));
            this.eventCallback.invoke((Object)new StepBuildingEvent.ProgressUpdated(null));
        } else if (customArtifactEvent instanceof TaskSummaryCreatedEvent) {
            this.eventCallback.invoke((Object)new StepBuildingEvent.NameAppeared(((TaskSummaryCreatedEvent)event).getTaskSummary()));
            this.eventCallback.invoke((Object)new StepBuildingEvent.ProgressUpdated(null));
        } else if (customArtifactEvent instanceof AgentStateUpdatedEvent) {
            this.eventCallback.invoke((Object)new StepBuildingEvent.AgentStateUpdated(((AgentStateUpdatedEvent)event).getState()));
            this.eventCallback.invoke((Object)new StepBuildingEvent.ProgressUpdated(null));
        } else if (customArtifactEvent instanceof PlanUpdatedEvent) {
            this.eventCallback.invoke((Object)new StepBuildingEvent.PlanUpdated(((PlanUpdatedEvent)event).getPlan()));
            this.eventCallback.invoke((Object)new StepBuildingEvent.ProgressUpdated(null));
        }
    }

    private final void updateLastOrInProgress(Function1<? super StepEntity, StepEntity> update) {
        if (this.newStepInProgress != null) {
            StepEntity stepEntity = this.newStepInProgress;
            Intrinsics.checkNotNull((Object)stepEntity);
            StepEntity stepInProgress = stepEntity;
            this.newStepInProgress = (StepEntity)update.invoke((Object)stepInProgress);
        } else {
            StepEntity lastStep = (StepEntity)CollectionsKt.last((List)this.steps);
            StepEntity updatedStep = (StepEntity)update.invoke((Object)lastStep);
            this.steps.set(CollectionsKt.getLastIndex((List)this.steps), updatedStep);
            this.eventCallback.invoke((Object)new StepBuildingEvent.StepUpdated(updatedStep, CollectionsKt.getLastIndex((List)this.steps)));
        }
    }

    private final synchronized void cleanUpArtifact(ArtifactId<?> artifactId) {
        this.artifactsMap.remove(artifactId);
        this.finishedArtifacts.remove(artifactId);
        List<ArtifactId<?>> childIds = this.childArtifactsMap.remove(artifactId);
        if (childIds != null) {
            for (ArtifactId<?> childId : childIds) {
                this.cleanUpArtifact(childId);
            }
        }
    }

    private static final StepEntity onCustomEvent$lambda$0(CustomArtifactEvent $event, StepEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StepEntity.copy$default(it, null, null, null, ((EditEvent)$event).getChanges(), null, null, 55, null);
    }

    private static final StepEntity onCustomEvent$lambda$1(CustomArtifactEvent $event, StepEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StepEntity.copy$default(it, null, null, ((StepSummaryCreatedEvent)$event).getStepSummary(), null, null, null, 59, null);
    }
}

