/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.AfterArtifactBuildingFinished;
import com.intellij.ml.llm.matterhorn.Artifact;
import com.intellij.ml.llm.matterhorn.ArtifactId;
import com.intellij.ml.llm.matterhorn.ArtifactReasoning;
import com.intellij.ml.llm.matterhorn.ArtifactRequest;
import com.intellij.ml.llm.matterhorn.ArtifactRequestExecutor;
import com.intellij.ml.llm.matterhorn.ArtifactRequestExecutorService;
import com.intellij.ml.llm.matterhorn.ArtifactResponse;
import com.intellij.ml.llm.matterhorn.ArtifactType;
import com.intellij.ml.llm.matterhorn.Artifactual;
import com.intellij.ml.llm.matterhorn.BeforeArtifactBuildingStarted;
import com.intellij.ml.llm.matterhorn.CancelledArtifact;
import com.intellij.ml.llm.matterhorn.CostLimitExceededException;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.FailedArtifact;
import com.intellij.ml.llm.matterhorn.FailedDependencyException;
import com.intellij.ml.llm.matterhorn.FailureReason;
import com.intellij.ml.llm.matterhorn.FileMatterhornCaches;
import com.intellij.ml.llm.matterhorn.InMemoryCaches;
import com.intellij.ml.llm.matterhorn.LLMBadResponseException;
import com.intellij.ml.llm.matterhorn.LLMContextLengthExceeded;
import com.intellij.ml.llm.matterhorn.LLMCountryForbiddenException;
import com.intellij.ml.llm.matterhorn.LLMPaymentRequiredException;
import com.intellij.ml.llm.matterhorn.MatterhornCaches;
import com.intellij.ml.llm.matterhorn.ProjectFileStructure;
import com.intellij.ml.llm.matterhorn.TeamCityReporter;
import com.intellij.ml.llm.matterhorn.TooManyAttemptsWithoutSuccessException;
import com.intellij.ml.llm.matterhorn.UnfinishedArtifact;
import com.intellij.ml.llm.matterhorn.helpers.Stopwatch;
import com.intellij.ml.llm.matterhorn.helpers.TeamCityLogger;
import com.intellij.ml.llm.matterhorn.helpers.TeamCityLoggerKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import io.ktor.client.plugins.HttpRequestTimeoutException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.NonCancellable;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.UnitSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0018J,\u0010\u0019\u001a\u0004\u0018\u00010\u0016\"\u0004\b\u0000\u0010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0018J,\u0010\u0019\u001a\u0004\u0018\u00010\u0016\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u001dJL\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010\u001a2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H\u001a0\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0002\u0010'J\u0014\u0010(\u001a\u00020)2\n\u0010*\u001a\u00060+j\u0002`,H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/matterhorn/ArtifactRequestExecutorService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "caches", "Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;", "getCaches", "()Lcom/intellij/ml/llm/matterhorn/MatterhornCaches;", "projectPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectPath", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createCaches", "getRequesterArtifact", "Lcom/intellij/ml/llm/matterhorn/ArtifactId;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "getArtifactCore", "Lcom/intellij/ml/llm/matterhorn/Artifactual;", "artifactId", "(Lcom/intellij/ml/llm/matterhorn/ArtifactId;Lcom/intellij/ml/llm/matterhorn/ExecutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getArtifact", "O", "type", "Lcom/intellij/ml/llm/matterhorn/ArtifactType;", "(Lcom/intellij/ml/llm/matterhorn/ArtifactType;Lcom/intellij/ml/llm/matterhorn/ExecutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOrCreateArtifact", "Lcom/intellij/ml/llm/matterhorn/ArtifactRequestExecutorService$ArtifactResult;", "I", "request", "Lcom/intellij/ml/llm/matterhorn/ArtifactRequest;", "source", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure;", "supervisorScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/ml/llm/matterhorn/ArtifactRequest;Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure;Lcom/intellij/ml/llm/matterhorn/ExecutionContext;Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFailureReason", "Lcom/intellij/ml/llm/matterhorn/FailureReason;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "ArtifactResult", "core"})
@SourceDebugExtension(value={"SMAP\nArtifactRequestExecutorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactRequestExecutorService.kt\ncom/intellij/ml/llm/matterhorn/ArtifactRequestExecutorService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,335:1\n14#2:336\n14#2:337\n*S KotlinDebug\n*F\n+ 1 ArtifactRequestExecutorService.kt\ncom/intellij/ml/llm/matterhorn/ArtifactRequestExecutorService\n*L\n267#1:336\n269#1:337\n*E\n"})
public final class ArtifactRequestExecutorService {
    @NotNull
    private final Project project;
    @NotNull
    private final MatterhornCaches caches;
    @NotNull
    private final VirtualFile projectPath;

    public ArtifactRequestExecutorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.caches = this.createCaches();
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        this.projectPath = virtualFile;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final MatterhornCaches getCaches() {
        return this.caches;
    }

    @NotNull
    public final VirtualFile getProjectPath() {
        return this.projectPath;
    }

    private final MatterhornCaches createCaches() {
        if (ApplicationKt.getApplication().isUnitTestMode() && !Registry.Companion.is("matterhorn.force.file.cache")) {
            return new InMemoryCaches();
        }
        return new FileMatterhornCaches(this.project);
    }

    private final ArtifactId<?> getRequesterArtifact(ExecutionContext context2) {
        return context2.getParent() != null ? context2.getArtifact() : null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getArtifactCore(ArtifactId<?> var1_1, ExecutionContext var2_2, Continuation<? super Artifactual> $completion) {
        block15: {
            block16: {
                block18: {
                    block17: {
                        if (!($completion instanceof getArtifactCore.1)) ** GOTO lbl-1000
                        var10_4 = $completion;
                        if ((var10_4.label & -2147483648) != 0) {
                            var10_4.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                Object L$0;
                                Object L$1;
                                /* synthetic */ Object result;
                                final /* synthetic */ ArtifactRequestExecutorService this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return ArtifactRequestExecutorService.access$getArtifactCore(this.this$0, null, null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                cached = context.getRoot().lookupArtifactInCaches(artifactId);
                                if (cached != null) {
                                    return cached;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = context;
                                $continuation.label = 1;
                                v0 = context.getRoot().lookupArtifact(artifactId, (Continuation<? super Artifactual>)$continuation);
                                if (v0 == var11_6) {
                                    return var11_6;
                                }
                                ** GOTO lbl27
                            }
                            case 1: {
                                context = (ExecutionContext)$continuation.L$1;
                                this = (ArtifactRequestExecutorService)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl27:
                                // 2 sources

                                if ((artifact = (Artifactual)v0) == null) break block15;
                                requestId = this.getRequesterArtifact(context);
                                request = new ArtifactRequest<Unit, ?>(artifact.getId(), Unit.INSTANCE, (KSerializer<Unit>)UnitSerializer.INSTANCE);
                                context.getRoot().registerArtifact(new UnfinishedArtifact<I, O>(request, null, null, null, null, 30, null), requestId);
                                context.getRoot().registerArtifact(new UnfinishedArtifact<I, O>(request, null, null, artifact.getDependencies(), null, 22, null), requestId);
                                var8_11 = artifact;
                                if (!(var8_11 instanceof FailedArtifact)) break;
                                $continuation.L$0 = artifact;
                                $continuation.L$1 = null;
                                $continuation.label = 2;
                                v1 = context.getRoot().registerArtifact((FailedArtifact)artifact, (Continuation<? super Unit>)$continuation);
                                if (v1 == var11_6) {
                                    return var11_6;
                                }
                                break block16;
                            }
                            case 2: {
                                artifact = (Artifactual)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break block16;
                            }
                        }
                        if (!(var8_11 instanceof CancelledArtifact)) break block17;
                        $continuation.L$0 = artifact;
                        $continuation.L$1 = null;
                        $continuation.label = 3;
                        v2 = context.getRoot().registerArtifact((CancelledArtifact)artifact, (Continuation<? super Unit>)$continuation);
                        if (v2 == var11_6) {
                            return var11_6;
                        }
                        break block16;
                        {
                            case 3: {
                                artifact = (Artifactual)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
                                break block16;
                            }
                        }
                    }
                    if (!(var8_11 instanceof Artifact)) break block18;
                    $continuation.L$0 = artifact;
                    $continuation.L$1 = null;
                    $continuation.label = 4;
                    v3 = context.getRoot().registerArtifact((Artifact)artifact, (Continuation<? super Unit>)$continuation);
                    if (v3 == var11_6) {
                        return var11_6;
                    }
                    break block16;
                    {
                        case 4: {
                            artifact = (Artifactual)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            break block16;
                        }
                    }
                }
                if (var8_11 instanceof UnfinishedArtifact) {
                    throw new IllegalStateException("Can't register unfinished artifact");
                }
                throw new NoWhenBranchMatchedException();
            }
            return artifact;
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final <O> Object getArtifact(@NotNull ArtifactId<O> artifactId, @NotNull ExecutionContext context2, @NotNull Continuation<? super Artifactual> $completion) {
        if (context2.getParent() != null) {
            UnfinishedArtifact unfinishedParentArtifact = new UnfinishedArtifact(context2.getRequest(), context2.getStatistics(), context2.getTitle(), context2.getDependencies(), null, 16, null);
            context2.getRoot().registerArtifact(unfinishedParentArtifact, this.getRequesterArtifact(context2.getParent()));
        }
        return this.getArtifactCore(artifactId, context2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <O> Object getArtifact(@NotNull ArtifactType<O> var1_1, @NotNull ExecutionContext var2_2, @NotNull Continuation<? super Artifactual> $completion) {
        if (!($completion instanceof getArtifact.2)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ ArtifactRequestExecutorService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getArtifact(null, (ExecutionContext)null, (Continuation<? super Artifactual>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (context.getParent() != null) {
                    unfinishedParentArtifact = new UnfinishedArtifact<I, O>(context.getRequest(), context.getStatistics(), context.getTitle(), context.getDependencies(), null, 16, null);
                    context.getRoot().registerArtifact(unfinishedParentArtifact, this.getRequesterArtifact(context.getParent()));
                }
                relativePath = context.getArtifact().changeType(type);
lbl16:
                // 2 sources

                while (relativePath != null) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = type;
                    $continuation.L$2 = context;
                    $continuation.L$3 = relativePath;
                    $continuation.label = 1;
                    v0 = this.getArtifactCore(relativePath, context, (Continuation<? super Artifactual>)$continuation);
                    if (v0 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl34
                }
                break;
            }
            case 1: {
                relativePath = (ArtifactId<? extends Object>)$continuation.L$3;
                context = (ExecutionContext)$continuation.L$2;
                type = (ArtifactType)$continuation.L$1;
                this = (ArtifactRequestExecutorService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                v1 = (Artifactual)v0;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-ArtifactRequestExecutorService$getArtifact$3 = false;
                    return it;
                }
                relativePath = relativePath.parentOfType(type);
                ** GOTO lbl16
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final <I, O> Object getOrCreateArtifact(@NotNull ArtifactRequest<I, O> var1_1, @Nullable ProjectFileStructure var2_2, @NotNull ExecutionContext var3_3, @Nullable CoroutineScope var4_4, @NotNull Continuation<? super ArtifactResult> $completion) {
        if (!($completion instanceof getOrCreateArtifact.1)) ** GOTO lbl-1000
        var21_6 = $completion;
        if ((var21_6.label & -2147483648) != 0) {
            var21_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                /* synthetic */ Object result;
                final /* synthetic */ ArtifactRequestExecutorService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getOrCreateArtifact(null, null, null, null, (Continuation<? super ArtifactResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var22_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                artifactId = request.getArtifact();
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = source;
                $continuation.L$3 = context;
                $continuation.L$4 = supervisorScope;
                $continuation.L$5 = artifactId;
                $continuation.label = 1;
                v0 = this.getArtifact(artifactId, context, (Continuation<? super Artifactual>)$continuation);
                if (v0 == var22_8) {
                    return var22_8;
                }
                ** GOTO lbl33
            }
            case 1: {
                artifactId = (ArtifactId)$continuation.L$5;
                supervisorScope = (CoroutineScope)$continuation.L$4;
                context = (ExecutionContext)$continuation.L$3;
                source = (ProjectFileStructure)$continuation.L$2;
                request = (ArtifactRequest)$continuation.L$1;
                this = (ArtifactRequestExecutorService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                v1 = shouldRecreate = (cached = (Artifactual)v0) instanceof CancelledArtifact != false && supervisorScope == null;
                if (cached != null && !shouldRecreate) {
                    return new ArtifactResult(cached, true);
                }
                executorUnsafe = request.getArtifact().getType().getExecutor();
                if (executorUnsafe == null) {
                    throw new Exception("Can't find executor for artifact type '" + artifactId.getType() + "'");
                }
                executor = executorUnsafe;
                subContext = context.createChildContext(request, source);
                stopwatch = new Stopwatch(true);
                flowId = teamCityTestCase = artifactId.getName() + "." + artifactId.getType();
                requestId = this.getRequesterArtifact(context);
                context.getRoot().registerArtifact(new UnfinishedArtifact<I, O>(request, null, null, null, null, 30, null), requestId);
                if (executor instanceof TeamCityReporter) {
                    TeamCityLogger.INSTANCE.testStarted((String)teamCityTestCase, (String)flowId);
                }
                context.sendEvent(new BeforeArtifactBuildingStarted(request.getArtifact()));
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = context;
                $continuation.L$3 = supervisorScope;
                $continuation.L$4 = artifactId;
                $continuation.L$5 = executor;
                $continuation.L$6 = subContext;
                $continuation.L$7 = stopwatch;
                $continuation.L$8 = teamCityTestCase;
                $continuation.L$9 = flowId;
                $continuation.label = 2;
                v2 = executor.produceArtifact(request.getDescription(), subContext, $continuation);
                ** if (v2 != var22_8) goto lbl64
lbl63:
                // 1 sources

                return var22_8;
lbl64:
                // 1 sources

                ** GOTO lbl80
            }
            case 2: {
                flowId = (String)$continuation.L$9;
                teamCityTestCase = (String)$continuation.L$8;
                stopwatch = (Stopwatch)$continuation.L$7;
                subContext = (ExecutionContext)$continuation.L$6;
                executor = (ArtifactRequestExecutor<?, O>)$continuation.L$5;
                artifactId = (ArtifactId)$continuation.L$4;
                supervisorScope = (CoroutineScope)$continuation.L$3;
                context = (ExecutionContext)$continuation.L$2;
                request = (ArtifactRequest)$continuation.L$1;
                this = (ArtifactRequestExecutorService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl80:
                // 2 sources

                response = (ArtifactResponse)v2;
                context.sendEvent(new AfterArtifactBuildingFinished(request.getArtifact()));
                descriptionText = Json.Default.encodeToString((SerializationStrategy)request.getSerializer(), request.getDescription());
                requestedArtifact = new Artifact<O>(artifactId, subContext.getStatistics(), subContext.getTitle(), descriptionText, subContext.getDependencies(), new ArtifactReasoning.Success(response.getReasoning()), response.getContent());
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = supervisorScope;
                $continuation.L$3 = artifactId;
                $continuation.L$4 = executor;
                $continuation.L$5 = subContext;
                $continuation.L$6 = stopwatch;
                $continuation.L$7 = teamCityTestCase;
                $continuation.L$8 = flowId;
                $continuation.L$9 = requestedArtifact;
                $continuation.label = 3;
                v3 = subContext.dumpSourceCode(requestedArtifact.getId(), (Continuation<? super Unit>)$continuation);
                ** if (v3 != var22_8) goto lbl98
lbl97:
                // 1 sources

                return var22_8;
lbl98:
                // 1 sources

                ** GOTO lbl114
            }
            case 3: {
                requestedArtifact = (Artifact)$continuation.L$9;
                flowId = (String)$continuation.L$8;
                teamCityTestCase = (String)$continuation.L$7;
                stopwatch = (Stopwatch)$continuation.L$6;
                subContext = (ExecutionContext)$continuation.L$5;
                executor = (ArtifactRequestExecutor)$continuation.L$4;
                artifactId = (ArtifactId)$continuation.L$3;
                supervisorScope = (CoroutineScope)$continuation.L$2;
                context = (ExecutionContext)$continuation.L$1;
                this = (ArtifactRequestExecutorService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl114:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = supervisorScope;
                $continuation.L$3 = artifactId;
                $continuation.L$4 = executor;
                $continuation.L$5 = subContext;
                $continuation.L$6 = stopwatch;
                $continuation.L$7 = teamCityTestCase;
                $continuation.L$8 = flowId;
                $continuation.L$9 = requestedArtifact;
                $continuation.label = 4;
                v4 = subContext.dumpArtifactTextRepresentation(requestedArtifact, (Continuation<? super Unit>)$continuation);
                ** if (v4 != var22_8) goto lbl128
lbl127:
                // 1 sources

                return var22_8;
lbl128:
                // 1 sources

                ** GOTO lbl144
            }
            case 4: {
                requestedArtifact = (Artifact)$continuation.L$9;
                flowId = (String)$continuation.L$8;
                teamCityTestCase = (String)$continuation.L$7;
                stopwatch = (Stopwatch)$continuation.L$6;
                subContext = (ExecutionContext)$continuation.L$5;
                executor = (ArtifactRequestExecutor)$continuation.L$4;
                artifactId = (ArtifactId)$continuation.L$3;
                supervisorScope = (CoroutineScope)$continuation.L$2;
                context = (ExecutionContext)$continuation.L$1;
                this = (ArtifactRequestExecutorService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl144:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = supervisorScope;
                $continuation.L$3 = artifactId;
                $continuation.L$4 = executor;
                $continuation.L$5 = subContext;
                $continuation.L$6 = stopwatch;
                $continuation.L$7 = teamCityTestCase;
                $continuation.L$8 = flowId;
                $continuation.L$9 = requestedArtifact;
                $continuation.label = 5;
                v5 = context.getRoot().registerArtifact(requestedArtifact, (Continuation<? super Unit>)$continuation);
                ** if (v5 != var22_8) goto lbl158
lbl157:
                // 1 sources

                return var22_8;
lbl158:
                // 1 sources

                ** GOTO lbl174
            }
            case 5: {
                requestedArtifact = (Artifact)$continuation.L$9;
                flowId = (String)$continuation.L$8;
                teamCityTestCase = (String)$continuation.L$7;
                stopwatch = (Stopwatch)$continuation.L$6;
                subContext = (ExecutionContext)$continuation.L$5;
                executor = (ArtifactRequestExecutor)$continuation.L$4;
                artifactId = (ArtifactId)$continuation.L$3;
                supervisorScope = (CoroutineScope)$continuation.L$2;
                context = (ExecutionContext)$continuation.L$1;
                this = (ArtifactRequestExecutorService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl174:
                // 2 sources

                if (executor instanceof TeamCityReporter) {
                    if (StringsKt.contains$default((CharSequence)context.getTitle(), (CharSequence)"[FAIL]", (boolean)false, (int)2, null)) {
                        TeamCityLogger.INSTANCE.testFailed((String)teamCityTestCase, (String)flowId, stopwatch.elapsedTime());
                    } else {
                        TeamCityLogger.INSTANCE.testFinished((String)teamCityTestCase, (String)flowId, stopwatch.elapsedTime());
                    }
                }
                var19_31 = new ArtifactResult(requestedArtifact, false, 2, null);
                $continuation.L$0 = var19_31;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.L$7 = null;
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.label = 6;
                v6 = subContext.flushArtifactRequestResponseLog((Continuation<? super Unit>)$continuation);
                if (v6 != var22_8) return var19_31;
                return var22_8;
            }
            case 6: {
                var19_31 = (ArtifactResult)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
                return var19_31;
            }
            catch (CancellationException e) {
                v7 = supervisorScope;
                if (!(v7 != null ? CoroutineScopeKt.isActive((CoroutineScope)v7) : false)) {
                    throw e;
                }
                if (executor instanceof TeamCityReporter) {
                    TeamCityLogger.INSTANCE.testFinished((String)teamCityTestCase, (String)flowId, stopwatch.elapsedTime());
                }
                cancelledArtifact = new CancelledArtifact(artifactId, subContext.getStatistics(), subContext.getTitle(), subContext.getDependencies(), new ArtifactReasoning.Cancelled(e.getMessage()));
                $continuation.L$0 = subContext;
                $continuation.L$1 = cancelledArtifact;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.L$7 = null;
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.label = 7;
                v8 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, cancelledArtifact, subContext, null){
                    int label;
                    final /* synthetic */ ExecutionContext $context;
                    final /* synthetic */ CancelledArtifact $cancelledArtifact;
                    final /* synthetic */ ExecutionContext $subContext;
                    {
                        this.$context = $context;
                        this.$cancelledArtifact = $cancelledArtifact;
                        this.$subContext = $subContext;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = this.$context.getRoot().registerArtifact(this.$cancelledArtifact, (Continuation<? super Unit>)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.label = 2;
                                v1 = this.$subContext.dumpSourceCode(this.$cancelledArtifact.getId(), (Continuation<? super Unit>)((Continuation)this));
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl21
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                this.label = 3;
                                v2 = this.$subContext.dumpArtifactTextRepresentation(this.$cancelledArtifact, (Continuation<? super Unit>)((Continuation)this));
                                if (v2 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl29
                            }
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl29:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $continuation);
                ** if (v8 != var22_8) goto lbl221
lbl220:
                // 1 sources

                return var22_8;
lbl221:
                // 1 sources

                ** GOTO lbl229
                case 7: {
                    cancelledArtifact = (CancelledArtifact)$continuation.L$1;
                    subContext = (ExecutionContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl229:
                    // 2 sources

                    requestedArtifact = new ArtifactResult(cancelledArtifact, false, 2, null);
                    $continuation.L$0 = requestedArtifact;
                    $continuation.L$1 = null;
                    $continuation.label = 8;
                    v9 = subContext.flushArtifactRequestResponseLog((Continuation<? super Unit>)$continuation);
                    if (v9 != var22_8) return requestedArtifact;
                    return var22_8;
                }
                case 8: {
                    requestedArtifact = (ArtifactResult)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
                    return requestedArtifact;
                }
                catch (Exception e) {
                    try {
                        paymentError = LLMPaymentRequiredException.Companion.fromException(e);
                        if (paymentError != null) {
                            $i$f$logger = false;
                            v10 = Logger.getInstance(ArtifactRequestExecutorService.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getInstance(...)");
                            v10.warn((Throwable)paymentError);
                        } else {
                            $i$f$logger = false;
                            v11 = Logger.getInstance(ArtifactRequestExecutorService.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getInstance(...)");
                            v11.error((Throwable)e);
                        }
                        if (executor instanceof TeamCityReporter) {
                            v12 = e.getMessage();
                            if (v12 == null) {
                                v12 = "";
                            }
                            message = v12;
                            details = TeamCityLoggerKt.exceptionToString(e);
                            TeamCityLogger.INSTANCE.testFailed((String)teamCityTestCase, (String)flowId, message, details, stopwatch.elapsedTime());
                        }
                        failedArtifact = new FailedArtifact(artifactId, subContext.getStatistics(), subContext.getTitle(), subContext.getDependencies(), new ArtifactReasoning.Failure(this.getFailureReason(e)));
                        $continuation.L$0 = subContext;
                        $continuation.L$1 = failedArtifact;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.L$4 = null;
                        $continuation.L$5 = null;
                        $continuation.L$6 = null;
                        $continuation.L$7 = null;
                        $continuation.L$8 = null;
                        $continuation.L$9 = null;
                        $continuation.label = 9;
                        v13 = context.getRoot().registerArtifact(failedArtifact, (Continuation<? super Unit>)$continuation);
                        ** if (v13 != var22_8) goto lbl276
                    }
                    catch (Throwable var16_22) {
                        $continuation.L$0 = var16_22;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.L$4 = null;
                        $continuation.L$5 = null;
                        $continuation.L$6 = null;
                        $continuation.L$7 = null;
                        $continuation.L$8 = null;
                        $continuation.L$9 = null;
                        $continuation.label = 13;
                        v17 = subContext.flushArtifactRequestResponseLog((Continuation<? super Unit>)$continuation);
                        if (v17 != var22_8) throw var16_23;
                        return var22_8;
                    }
lbl275:
                    // 1 sources

                    return var22_8;
lbl276:
                    // 1 sources

                    ** GOTO lbl284
                    case 9: {
                        failedArtifact = (FailedArtifact)$continuation.L$1;
                        subContext = (ExecutionContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v13 = $result;
lbl284:
                        // 2 sources

                        $continuation.L$0 = subContext;
                        $continuation.L$1 = failedArtifact;
                        $continuation.label = 10;
                        v14 = subContext.dumpSourceCode(failedArtifact.getId(), (Continuation<? super Unit>)$continuation);
                        ** if (v14 != var22_8) goto lbl290
lbl289:
                        // 1 sources

                        return var22_8;
lbl290:
                        // 1 sources

                        ** GOTO lbl298
                    }
                    case 10: {
                        failedArtifact = (FailedArtifact)$continuation.L$1;
                        subContext = (ExecutionContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v14 = $result;
lbl298:
                        // 2 sources

                        $continuation.L$0 = subContext;
                        $continuation.L$1 = failedArtifact;
                        $continuation.label = 11;
                        v15 = subContext.dumpArtifactTextRepresentation(failedArtifact, (Continuation<? super Unit>)$continuation);
                        ** if (v15 != var22_8) goto lbl304
lbl303:
                        // 1 sources

                        return var22_8;
lbl304:
                        // 1 sources

                        ** GOTO lbl312
                    }
                    case 11: {
                        failedArtifact = (FailedArtifact)$continuation.L$1;
                        subContext = (ExecutionContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v15 = $result;
lbl312:
                        // 2 sources

                        var19_32 = new ArtifactResult(failedArtifact, false, 2, null);
                        $continuation.L$0 = var19_32;
                        $continuation.L$1 = null;
                        $continuation.label = 12;
                        v16 = subContext.flushArtifactRequestResponseLog((Continuation<? super Unit>)$continuation);
                        if (v16 != var22_8) return var19_32;
                        return var22_8;
                    }
                    case 12: {
                        var19_32 = (ArtifactResult)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v16 = $result;
                        return var19_32;
                    }
                }
            }
            case 13: {
                var16_23 = (Throwable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v17 = $result;
                throw var16_23;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getOrCreateArtifact$default(ArtifactRequestExecutorService artifactRequestExecutorService, ArtifactRequest artifactRequest, ProjectFileStructure projectFileStructure, ExecutionContext executionContext, CoroutineScope coroutineScope, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            coroutineScope = null;
        }
        return artifactRequestExecutorService.getOrCreateArtifact(artifactRequest, projectFileStructure, executionContext, coroutineScope, (Continuation<? super ArtifactResult>)continuation);
    }

    private final FailureReason getFailureReason(Exception e) {
        FailureReason failureReason;
        Exception exception = e;
        if (exception instanceof CostLimitExceededException) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.CostExceeded(string);
        } else if (exception instanceof TooManyAttemptsWithoutSuccessException) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.FormatError(string);
        } else if (exception instanceof HttpRequestTimeoutException) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.InferenceServerTimeout(string);
        } else if (exception instanceof LLMPaymentRequiredException) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.PaymentRequired(string);
        } else if (exception instanceof LLMBadResponseException) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.ContextLengthExceeded(string);
        } else if (exception instanceof LLMContextLengthExceeded) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.ContextLengthExceeded(string);
        } else if (exception instanceof LLMCountryForbiddenException) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.CountryForbidden(string);
        } else if (exception instanceof FailedDependencyException) {
            failureReason = ((FailedDependencyException)e).getArtifact().getReasoning().getReason();
        } else {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            failureReason = new FailureReason.UnexpectedException(string);
        }
        return failureReason;
    }

    public static final /* synthetic */ Object access$getArtifactCore(ArtifactRequestExecutorService $this, ArtifactId artifactId, ExecutionContext context2, Continuation $completion) {
        return $this.getArtifactCore(artifactId, context2, (Continuation<? super Artifactual>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/matterhorn/ArtifactRequestExecutorService$ArtifactResult;", "", "artifact", "Lcom/intellij/ml/llm/matterhorn/Artifactual;", "cached", "", "<init>", "(Lcom/intellij/ml/llm/matterhorn/Artifactual;Z)V", "getArtifact", "()Lcom/intellij/ml/llm/matterhorn/Artifactual;", "getCached", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class ArtifactResult {
        @NotNull
        private final Artifactual artifact;
        private final boolean cached;

        public ArtifactResult(@NotNull Artifactual artifact, boolean cached) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            this.artifact = artifact;
            this.cached = cached;
        }

        public /* synthetic */ ArtifactResult(Artifactual artifactual, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(artifactual, bl);
        }

        @NotNull
        public final Artifactual getArtifact() {
            return this.artifact;
        }

        public final boolean getCached() {
            return this.cached;
        }

        @NotNull
        public final Artifactual component1() {
            return this.artifact;
        }

        public final boolean component2() {
            return this.cached;
        }

        @NotNull
        public final ArtifactResult copy(@NotNull Artifactual artifact, boolean cached) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            return new ArtifactResult(artifact, cached);
        }

        public static /* synthetic */ ArtifactResult copy$default(ArtifactResult artifactResult, Artifactual artifactual, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                artifactual = artifactResult.artifact;
            }
            if ((n & 2) != 0) {
                bl = artifactResult.cached;
            }
            return artifactResult.copy(artifactual, bl);
        }

        @NotNull
        public String toString() {
            return "ArtifactResult(artifact=" + this.artifact + ", cached=" + this.cached + ")";
        }

        public int hashCode() {
            int result = this.artifact.hashCode();
            result = result * 31 + Boolean.hashCode(this.cached);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactResult)) {
                return false;
            }
            ArtifactResult artifactResult = (ArtifactResult)other;
            if (!Intrinsics.areEqual((Object)this.artifact, (Object)artifactResult.artifact)) {
                return false;
            }
            return this.cached == artifactResult.cached;
        }
    }
}

