/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.Result;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.ActionUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.LocateTarget;
import com.intellij.ml.llm.matterhorn.actions.SearchProjectAction;
import com.intellij.ml.llm.matterhorn.actions.StringUtilKt;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import com.intellij.ml.llm.matterhorn.services.ProjectSearchEverywhereService;
import com.intellij.ml.llm.matterhorn.services.search.DirectoryFilter;
import com.intellij.ml.llm.matterhorn.services.search.FileFilter;
import com.intellij.ml.llm.matterhorn.services.search.SearchQuery;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultContent;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultItem;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultsFilter;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 22\u00020\u0001:\u000523456B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0082@\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u001e0\t2\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002JE\u0010 \u001a\u00020!*\b\u0012\u0004\u0012\u00020\"0\t2\u0006\u0010#\u001a\u00020\u00052\n\u0010$\u001a\u00060%j\u0002`&2\u001d\u0010'\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\t\u0012\u0004\u0012\u00020)0(\u00a2\u0006\u0002\b*H\u0002J \u0010\u001d\u001a\u00020)*\b\u0012\u0004\u0012\u00020\"0\t2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\u0016\u0010.\u001a\u0004\u0018\u00010\u0017*\u00020/2\u0006\u00100\u001a\u000201H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u00067"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFilter", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultsFilter;", "Lcom/intellij/psi/PsiFileSystemItem;", "searchEverywhere", "Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService;", "searchTerm", "filter", "(Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService;Ljava/lang/String;Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultsFilter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toFilteredResultGroup", "Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$SearchResultGroup;", "getSearchSummary", "processResults", "", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultItem;", "groupTitle", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "process", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$FilteredResultGroup;", "Lkotlin/ExtensionFunctionType;", "usedResults", "", "Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$MergableSearchResultItem;", "toPsi", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "SearchResultGroup", "FilteredResultGroup", "FileGroup", "MergableSearchResultItem", "ej-core"})
@SourceDebugExtension(value={"SMAP\nSearchProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchProjectAction.kt\ncom/intellij/ml/llm/matterhorn/actions/SearchProjectAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n31#2,2:257\n1557#3:259\n1628#3,3:260\n1863#3,2:263\n1485#3:265\n1510#3,3:266\n1513#3,3:276\n827#3:289\n855#3,2:290\n827#3:292\n855#3,2:293\n1053#3:295\n1557#3:296\n1628#3,3:297\n1863#3:304\n1863#3,2:305\n1864#3:307\n1863#3,2:308\n381#4,7:269\n136#5,9:279\n216#5:288\n217#5:302\n145#5:303\n1#6:300\n1#6:301\n*S KotlinDebug\n*F\n+ 1 SearchProjectAction.kt\ncom/intellij/ml/llm/matterhorn/actions/SearchProjectAction\n*L\n95#1:257,2\n131#1:259\n131#1:260,3\n143#1:263,2\n226#1:265\n226#1:266,3\n226#1:276,3\n227#1:289\n227#1:290,2\n228#1:292\n228#1:293,2\n230#1:295\n232#1:296\n232#1:297,3\n242#1:304\n243#1:305,2\n242#1:307\n148#1:308,2\n226#1:269,7\n226#1:279,9\n226#1:288\n226#1:302\n226#1:303\n226#1:301\n*E\n"})
public class SearchProjectAction
implements AgentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments;
    @NotNull
    private final String docstring;
    @NotNull
    public static final String INDENT = "  ";
    public static final int BLOCK_RESULTS_LIMIT = 100;
    public static final int MAX_SHOWN_LINE_LEN = 100;
    @NotNull
    public static final String FOUND_FILES_TITLE = "FOUND FILES";
    @NotNull
    public static final String FOUND_CLASSES_TITLE = "FOUND CLASSES";
    @NotNull
    public static final String FOUND_SYMBOLS_TITLE = "FOUND SYMBOLS";
    @NotNull
    public static final String FOUND_TEXT_TITLE = "FOUND TEXT";
    @NotNull
    public static final String SEARCH_TERM_ARGUMENT = "search_term";
    @NotNull
    public static final String PATH_ARGUMENT = "path";

    public SearchProjectAction() {
        this.name = "search_project";
        Object[] objectArray = new Argument[]{new Argument(SEARCH_TERM_ARGUMENT, ArgumentType.STRING, "the term to search for, always surround by quotes: e.g. \"text to search\", \"some \\\"special term\\\"\"", false, true, 8, null), new Argument(PATH_ARGUMENT, ArgumentType.STRING, "full path of the directory or full path of the file to search in (if not provided, searches in whole project)", true, false, 16, null)};
        this.arguments = CollectionsKt.listOf((Object[])objectArray);
        this.docstring = "\nIt is a powerful in-project search.\nThis is a fuzzy search meaning that the output will contain both exact and inexact matches.\nFeel free to use `*` for wildcard matching, however note that regex (other than `*` wildcard) are not supported.\nThe command can search for:\n1. Classes\n2. Symbols (any entities in code including classes, methods, variables, etc.)\n3. Files\n4. Plain text in files\n5. All of the above\n\nNote that querying `search_project \"class User\"` narrows the scope of the search to the definition of the mentioned class\nwhich could be beneficial for having more concise search output (the same logic applies when querying `search_project \"def user_authorization\"` and other types of entities equipped by their keywords).\nQuerying `search_project \"User\"` will search for all symbols in code containing the \"User\" substring,\nfor filenames containing \"User\" and for occurrences of \"User\" anywhere in code. This mode is beneficial to get\nthe exhaustive list of everything containing \"User\" in code.\n\nIf the full code of the file has already been provided, searching within it won't yield additional information, as you already have the complete code.\n\n#### Examples\n- `search_project \"class User\"`: Finds the definition of class `User`.\n- `search_project \"def query_with_retries\"`: Finds the definition of method `query_with_retries`.\n- `search_project \"authorization\"`: Searches for anything containing \"authorization\" in filenames, symbol names, or code.\n- `search_project \"authorization\" pathToFile/example.doc`: Searches \"authorization\" inside example.doc.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return SearchProjectAction.execute$suspendImpl(this, request2, context2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object execute$suspendImpl(SearchProjectAction var0, ActionRequest var1_1, ExecutionAgentContext var2_2, Continuation<? super String> $completion) {
        block20: {
            block21: {
                if (!($completion instanceof execute.1)) ** GOTO lbl-1000
                var13_4 = $completion;
                if ((var13_4.label & -2147483648) != 0) {
                    var13_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var0, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        /* synthetic */ Object result;
                        final /* synthetic */ SearchProjectAction this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return SearchProjectAction.execute$suspendImpl(this.this$0, null, null, (Continuation<? super String>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.L$0 = $this;
                        $continuation.L$1 = context;
                        $continuation.label = 1;
                        v0 = $this.getInputParams((ActionRequest)request, (Continuation<? super Map<String, ParameterValue>>)$continuation);
                        if (v0 == var14_6) {
                            return var14_6;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        context = (ExecutionAgentContext)$continuation.L$1;
                        $this = (SearchProjectAction)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        if ((v1 = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)(params = (Map)v0).get("search_term"))) == null) {
                            v1 = "ERROR: search_terms is missing or invalid";
                        }
                        searchTerm = v1;
                        $this$service$iv = (ComponentManager)context.getProject();
                        $i$f$service = false;
                        serviceClass$iv = ProjectSearchEverywhereService.class;
                        v2 = $this$service$iv.getService(serviceClass$iv);
                        if (v2 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        searchEverywhere = (ProjectSearchEverywhereService)v2;
                        path = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)params.get("path"));
                        StepMetadataKt.emitMetadata("Search in project \"" + searchTerm + "\"", StepType.Info, context);
                        if (path != null) break;
                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.label = 2;
                        v3 = SearchProjectAction.searchEverywhere$default($this, searchEverywhere, searchTerm, null, (Continuation)$continuation, 4, null);
                        if (v3 == var14_6) {
                            return var14_6;
                        }
                        ** GOTO lbl47
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl47:
                        // 2 sources

                        return v3;
                    }
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = context;
                $continuation.L$2 = searchTerm;
                $continuation.L$3 = searchEverywhere;
                $continuation.label = 3;
                v4 = AgentUtilsKt.smartLocate$default(path, context, LocateTarget.FileOrDirectory, false, (Continuation)$continuation, 8, null);
                if (v4 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl64
                {
                    case 3: {
                        searchEverywhere = (ProjectSearchEverywhereService)$continuation.L$3;
                        searchTerm = (String)$continuation.L$2;
                        context = (ExecutionAgentContext)$continuation.L$1;
                        $this = (SearchProjectAction)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl64:
                        // 2 sources

                        if (!((res = (Result)v4) instanceof Result.Err)) break;
                        var11_13 = ((Result.Err)res).getMessage();
                        $continuation.L$0 = var11_13;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.label = 4;
                        v5 = SearchProjectAction.searchEverywhere$default($this, searchEverywhere, searchTerm, null, (Continuation)$continuation, 4, null);
                        if (v5 == var14_6) {
                            return var14_6;
                        }
                        break block20;
                    }
                    case 4: {
                        var11_13 = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                        break block20;
                    }
                }
                if (!(res instanceof Result.Ok)) break block21;
                if (!VfsUtilCore.isAncestor((VirtualFile)context.getProjectDir(), (VirtualFile)((VirtualFile)((Result.Ok)res).getValue()), (boolean)false)) {
                    return "ERROR: Target directory is outside of the project directory";
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = searchTerm;
                $continuation.L$2 = searchEverywhere;
                $continuation.L$3 = null;
                $continuation.label = 5;
                v6 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(com.intellij.ml.llm.matterhorn.actions.SearchProjectAction com.intellij.ml.llm.matterhorn.Result com.intellij.ml.llm.matterhorn.ExecutionAgentContext ), ()Lcom/intellij/psi/PsiFileSystemItem;)((SearchProjectAction)$this, (Result)res, (ExecutionAgentContext)context), (Continuation)$continuation);
                if (v6 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl98
                {
                    case 5: {
                        searchEverywhere = (ProjectSearchEverywhereService)$continuation.L$2;
                        searchTerm = (String)$continuation.L$1;
                        $this = (SearchProjectAction)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl98:
                        // 2 sources

                        psiFileSystemItem = (PsiFileSystemItem)v6;
                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.label = 6;
                        v7 = $this.searchEverywhere(searchEverywhere, searchTerm, $this.getFilter(psiFileSystemItem), (Continuation<? super String>)$continuation);
                        if (v7 == var14_6) {
                            return var14_6;
                        }
                        ** GOTO lbl110
                    }
                    case 6: {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl110:
                        // 2 sources

                        return v7;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return var11_13 + "\nSearching in whole project.\n" + v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final SearchResultsFilter getFilter(PsiFileSystemItem $this$getFilter) {
        PsiFileSystemItem psiFileSystemItem = $this$getFilter;
        return psiFileSystemItem instanceof PsiDirectory ? (SearchResultsFilter)new DirectoryFilter((PsiDirectory)$this$getFilter) : (psiFileSystemItem instanceof PsiFile ? (SearchResultsFilter)new FileFilter((PsiFile)$this$getFilter) : null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object searchEverywhere(ProjectSearchEverywhereService var1_1, String var2_2, SearchResultsFilter var3_3, Continuation<? super String> $completion) {
        if (!($completion instanceof searchEverywhere.1)) ** GOTO lbl-1000
        var19_5 = $completion;
        if ((var19_5.label & -2147483648) != 0) {
            var19_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                /* synthetic */ Object result;
                final /* synthetic */ SearchProjectAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SearchProjectAction.access$searchEverywhere(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var22_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                query = new SearchQuery(searchTerm, 101, filter);
                $this$map$iv = searchEverywhere.detectSearchTypes(query);
                var16_10 = this;
                $i$f$map = false;
                var8_12 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var11_15 = $this$mapTo$iv$iv.iterator();
lbl20:
                // 2 sources

                while (var11_15.hasNext()) {
                    item$iv$iv = var11_15.next();
                    var13_17 = (ProjectSearchEverywhereService.SearchType)item$iv$iv;
                    var17_20 = destination$iv$iv;
                    $i$a$-map-SearchProjectAction$searchEverywhere$2 = false;
                    var15_19 = it;
                    $continuation.L$0 = searchEverywhere;
                    $continuation.L$1 = searchTerm;
                    $continuation.L$2 = filter;
                    $continuation.L$3 = query;
                    $continuation.L$4 = destination$iv$iv;
                    $continuation.L$5 = var11_15;
                    $continuation.L$6 = var15_19;
                    $continuation.L$7 = var16_10;
                    $continuation.L$8 = var17_20;
                    $continuation.label = 1;
                    v0 = searchEverywhere.search(query, (ProjectSearchEverywhereService.SearchType)it, (Continuation<? super List<SearchResultItem>>)$continuation);
                    if (v0 == var22_7) {
                        return var22_7;
                    }
                    ** GOTO lbl56
                }
                break;
            }
            case 1: {
                $i$f$map = false;
                $i$f$mapTo = false;
                $i$a$-map-SearchProjectAction$searchEverywhere$2 = false;
                var17_20 = (Collection)$continuation.L$8;
                var16_10 = (SearchProjectAction)$continuation.L$7;
                var15_19 = (ProjectSearchEverywhereService.SearchType)$continuation.L$6;
                var11_15 = (Iterator<T>)$continuation.L$5;
                destination$iv$iv = (Collection)$continuation.L$4;
                query = (SearchQuery)$continuation.L$3;
                filter = (SearchResultsFilter)$continuation.L$2;
                searchTerm = (String)$continuation.L$1;
                searchEverywhere = (ProjectSearchEverywhereService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl56:
                // 2 sources

                var20_21 = (List)v0;
                var21_22 = var15_19;
                var17_20.add(new SearchResultGroup(var21_22, var20_21));
                ** GOTO lbl20
            }
        }
        return var16_10.toFilteredResultGroup((List)destination$iv$iv, searchTerm, filter);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object searchEverywhere$default(SearchProjectAction searchProjectAction, ProjectSearchEverywhereService projectSearchEverywhereService, String string, SearchResultsFilter searchResultsFilter, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: searchEverywhere");
        }
        if ((n & 4) != 0) {
            searchResultsFilter = null;
        }
        return searchProjectAction.searchEverywhere(projectSearchEverywhereService, string, searchResultsFilter, (Continuation<? super String>)continuation);
    }

    private final String toFilteredResultGroup(List<SearchResultGroup> $this$toFilteredResultGroup, String searchTerm, SearchResultsFilter filter) {
        Set usedResults = new LinkedHashSet();
        StringBuilder result = new StringBuilder();
        Iterable $this$forEach$iv = $this$toFilteredResultGroup;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchResultGroup resultGroup = (SearchResultGroup)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[resultGroup.getSourceType().ordinal()]) {
                case 1: 
                case 2: {
                    this.processResults(resultGroup.getResults(), FOUND_FILES_TITLE, result, (Function1<? super List<SearchResultItem>, FilteredResultGroup>)((Function1)arg_0 -> SearchProjectAction.toFilteredResultGroup$lambda$7$lambda$3(usedResults, arg_0)));
                    break;
                }
                case 3: {
                    this.processResults(resultGroup.getResults(), FOUND_CLASSES_TITLE, result, (Function1<? super List<SearchResultItem>, FilteredResultGroup>)((Function1)arg_0 -> SearchProjectAction.toFilteredResultGroup$lambda$7$lambda$4(this, usedResults, arg_0)));
                    break;
                }
                case 4: {
                    this.processResults(resultGroup.getResults(), FOUND_SYMBOLS_TITLE, result, (Function1<? super List<SearchResultItem>, FilteredResultGroup>)((Function1)arg_0 -> SearchProjectAction.toFilteredResultGroup$lambda$7$lambda$5(this, usedResults, arg_0)));
                    break;
                }
                case 5: {
                    this.processResults(resultGroup.getResults(), FOUND_TEXT_TITLE, result, (Function1<? super List<SearchResultItem>, FilteredResultGroup>)((Function1)arg_0 -> SearchProjectAction.toFilteredResultGroup$lambda$7$lambda$6(this, usedResults, arg_0)));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return !StringsKt.isBlank((CharSequence)result) ? StringsKt.trimIndent((String)("\n                " + this.getSearchSummary(searchTerm, filter) + "\n                \n                Format:\n                <RESULT_TYPE> (count):\n                  <file_path> (<line number start>):: <code line>\n            ")) + "\n\n" + result : StringsKt.trimIndent((String)("\n                " + this.getSearchSummary(searchTerm, filter) + "\n\n                NOTHING FOUND\n        "));
    }

    private final String getSearchSummary(String searchTerm, SearchResultsFilter filter) {
        StringBuilder stringBuilder;
        StringBuilder $this$getSearchSummary_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getSearchSummary_u24lambda_u248.append("Searching for ");
        $this$getSearchSummary_u24lambda_u248.append("\"" + searchTerm + "\" in ");
        StringBuilder stringBuilder2 = filter != null ? $this$getSearchSummary_u24lambda_u248.append(filter.getFilterText()) : $this$getSearchSummary_u24lambda_u248.append("project");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void processResults(List<SearchResultItem> $this$processResults, String groupTitle, StringBuilder result, Function1<? super List<SearchResultItem>, FilteredResultGroup> process) {
        String sizeText;
        FilteredResultGroup filteredResult = (FilteredResultGroup)process.invoke((Object)CollectionsKt.take((Iterable)$this$processResults, (int)100));
        String string = sizeText = $this$processResults.size() > 100 ? "more than 100" : String.valueOf(filteredResult.getCount());
        if (filteredResult.getCount() > 0) {
            result.append(groupTitle + " (" + sizeText + "):\n");
            result.append(filteredResult.getResult());
            result.append($this$processResults.size() > 100 ? "...\n" : "\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FilteredResultGroup toFilteredResultGroup(List<SearchResultItem> $this$toFilteredResultGroup, Set<MergableSearchResultItem> usedResults) {
        void $this$mapNotNullTo$iv$iv22;
        Function1[] $this$mapNotNull$iv;
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = $this$toFilteredResultGroup;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Iterator destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SearchResultItem it = (SearchResultItem)element$iv$iv;
            boolean bl = false;
            VirtualFile key$iv$iv = it.getFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$groupByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        FileGroup $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            FileGroup fileGroup;
            Iterable $this$sortedBy$iv;
            SearchResultItem it;
            Iterable $this$filterNotTo$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)list$iv$iv.next();
            boolean bl = false;
            Map.Entry $i$f$getOrPut = element$iv$iv;
            boolean bl3 = false;
            VirtualFile file = (VirtualFile)$i$f$getOrPut.getKey();
            List contents = (List)$i$f$getOrPut.getValue();
            Iterable $this$filterNot$iv = contents;
            boolean $i$f$filterNot = false;
            Iterable iterable2 = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                it = (SearchResultItem)element$iv$iv2;
                boolean bl4 = false;
                if (usedResults.contains(new MergableSearchResultItem(it))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filterNot$iv = (List)destination$iv$iv2;
            $i$f$filterNot = false;
            $this$filterNotTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                it = (SearchResultItem)element$iv$iv2;
                boolean bl5 = false;
                if (it.getContent() == null) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filterNot$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            boolean $i$f$sortedBy = false;
            List filtered = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SearchResultItem it = (SearchResultItem)a;
                    boolean bl = false;
                    SearchResultContent searchResultContent = it.getContent();
                    it = (SearchResultItem)b;
                    Comparable comparable = Integer.valueOf(searchResultContent != null ? searchResultContent.getStartLine() : 0);
                    bl = false;
                    SearchResultContent searchResultContent2 = it.getContent();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(searchResultContent2 != null ? searchResultContent2.getStartLine() : 0));
                }
            });
            if (filtered.isEmpty()) {
                fileGroup = null;
            } else {
                String title;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$sortedBy$iv = filtered;
                Set<MergableSearchResultItem> set = usedResults;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SearchResultItem)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl6 = false;
                    collection.add(new MergableSearchResultItem(it));
                }
                set.addAll((List)destination$iv$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)file.getPath(), (String)"getPath(...)");
                Iterable iterable3 = filtered;
                double d = 0.0;
                for (Object t : iterable3) {
                    void it2;
                    SearchResultItem bl6 = (SearchResultItem)t;
                    double d2 = d;
                    boolean bl7 = false;
                    SearchResultContent searchResultContent = it2.getContent();
                    double d3 = searchResultContent != null ? (double)searchResultContent.getWeight() : 0.0;
                    d = d2 + d3;
                }
                double weightSum = d;
                fileGroup = new FileGroup(file, weightSum, title, filtered);
            }
            if (fileGroup == null) continue;
            FileGroup it$iv$iv = fileGroup;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = new Function1[]{SearchProjectAction::toFilteredResultGroup$lambda$16, SearchProjectAction::toFilteredResultGroup$lambda$17};
        List groups = CollectionsKt.sortedWith((Iterable)((List)((Object)destination$iv$iv)), (Comparator)ComparisonsKt.compareBy((Function1[])$this$mapNotNull$iv));
        Iterable $i$f$mapNotNull22 = groups;
        int $this$mapNotNullTo$iv$iv22 = 0;
        for (Object t : $i$f$mapNotNull22) {
            void it;
            $this$forEach$iv$iv$iv = (FileGroup)t;
            int n = $this$mapNotNullTo$iv$iv22;
            boolean bl = false;
            int n2 = it.getResults().size();
            $this$mapNotNullTo$iv$iv22 = n + n2;
        }
        int resultCount = $this$mapNotNullTo$iv$iv22;
        StringBuilder result = new StringBuilder();
        Iterable $this$forEach$iv = groups;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            FileGroup group = (FileGroup)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = group.getResults();
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SearchResultItem it = (SearchResultItem)element$iv2;
                boolean bl9 = false;
                Object[] objectArray = new String[2];
                objectArray[0] = group.getTitle();
                SearchResultContent searchResultContent = it.getContent();
                objectArray[1] = searchResultContent != null ? Companion.getText(searchResultContent) : null;
                result.append(StringsKt.prependIndent((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (String)INDENT)).append("\n");
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new FilteredResultGroup(string, resultCount);
    }

    private final PsiFileSystemItem toPsi(VirtualFile $this$toPsi, Project project) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        PsiFile psiFile = manager.findFile($this$toPsi);
        return psiFile != null ? (PsiFileSystemItem)psiFile : (PsiFileSystemItem)manager.findDirectory($this$toPsi);
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return AgentAction.DefaultImpls.getCustomSignature(this);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }

    private static final PsiFileSystemItem execute$lambda$0(SearchProjectAction this$0, Result $res, ExecutionAgentContext $context) {
        return this$0.toPsi((VirtualFile)((Result.Ok)$res).getValue(), $context.getProject());
    }

    private static final FilteredResultGroup toFilteredResultGroup$lambda$7$lambda$3(Set $usedResults, List $this$processResults) {
        Intrinsics.checkNotNullParameter((Object)$this$processResults, (String)"$this$processResults");
        StringBuilder res2 = new StringBuilder();
        int count = 0;
        Iterable $this$forEach$iv = $this$processResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchResultItem it = (SearchResultItem)element$iv;
            boolean bl = false;
            MergableSearchResultItem mergable = new MergableSearchResultItem(it);
            if ($usedResults.contains(mergable)) continue;
            res2.append(INDENT).append(it.getFile().getPath()).append("\n");
            $usedResults.add(mergable);
            ++count;
        }
        String string = res2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new FilteredResultGroup(string, count);
    }

    private static final FilteredResultGroup toFilteredResultGroup$lambda$7$lambda$4(SearchProjectAction this$0, Set $usedResults, List $this$processResults) {
        Intrinsics.checkNotNullParameter((Object)$this$processResults, (String)"$this$processResults");
        return this$0.toFilteredResultGroup($this$processResults, $usedResults);
    }

    private static final FilteredResultGroup toFilteredResultGroup$lambda$7$lambda$5(SearchProjectAction this$0, Set $usedResults, List $this$processResults) {
        Intrinsics.checkNotNullParameter((Object)$this$processResults, (String)"$this$processResults");
        return this$0.toFilteredResultGroup($this$processResults, $usedResults);
    }

    private static final FilteredResultGroup toFilteredResultGroup$lambda$7$lambda$6(SearchProjectAction this$0, Set $usedResults, List $this$processResults) {
        Intrinsics.checkNotNullParameter((Object)$this$processResults, (String)"$this$processResults");
        return this$0.toFilteredResultGroup($this$processResults, $usedResults);
    }

    private static final Comparable toFilteredResultGroup$lambda$16(FileGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Double.valueOf(-it.getWeight());
    }

    private static final Comparable toFilteredResultGroup$lambda$17(FileGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getFile().getPath());
    }

    public static final /* synthetic */ Object access$searchEverywhere(SearchProjectAction $this, ProjectSearchEverywhereService searchEverywhere2, String searchTerm, SearchResultsFilter filter, Continuation $completion) {
        return $this.searchEverywhere(searchEverywhere2, searchTerm, filter, (Continuation<? super String>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$Companion;", "", "<init>", "()V", "INDENT", "", "BLOCK_RESULTS_LIMIT", "", "MAX_SHOWN_LINE_LEN", "FOUND_FILES_TITLE", "FOUND_CLASSES_TITLE", "FOUND_SYMBOLS_TITLE", "FOUND_TEXT_TITLE", "SEARCH_TERM_ARGUMENT", "PATH_ARGUMENT", "getText", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultContent;", "getMultilineText", "lineLimit", "forceSingleLine", "", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getText(@NotNull SearchResultContent $this$getText) {
            Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
            return $this$getText.getStartLine() + 1 + ":: " + StringUtilKt.truncateWithEllipsis(((Object)StringsKt.trim((CharSequence)$this$getText.getLineText())).toString(), 100);
        }

        private final String getMultilineText(SearchResultContent $this$getMultilineText, int lineLimit, boolean forceSingleLine) {
            String string;
            if (forceSingleLine) {
                String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)$this$getMultilineText.getLineText()));
                if (string2 == null || (string2 = StringUtilKt.truncateWithEllipsis(string2, 100)) == null) {
                    string2 = "";
                }
                string = " " + string2;
            } else {
                string = "\n" + StringsKt.prependIndent((String)CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)StringsKt.trimIndent((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.lines((CharSequence)$this$getMultilineText.getLineText()), (int)lineLimit), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))), (CharSequence)"\n", null, null, (int)0, null, Companion::getMultilineText$lambda$0, (int)30, null), (String)SearchProjectAction.INDENT);
            }
            return string;
        }

        private static final CharSequence getMultilineText$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return StringUtilKt.truncateWithEllipsis(it, 100);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$FileGroup;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "weight", "", "title", "", "results", "", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultItem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;DLjava/lang/String;Ljava/util/List;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getWeight", "()D", "getTitle", "()Ljava/lang/String;", "getResults", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ej-core"})
    public static final class FileGroup {
        @NotNull
        private final VirtualFile file;
        private final double weight;
        @NotNull
        private final String title;
        @NotNull
        private final List<SearchResultItem> results;

        public FileGroup(@NotNull VirtualFile file, double weight, @NotNull String title, @NotNull List<SearchResultItem> results) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.file = file;
            this.weight = weight;
            this.title = title;
            this.results = results;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final double getWeight() {
            return this.weight;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final List<SearchResultItem> getResults() {
            return this.results;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        public final double component2() {
            return this.weight;
        }

        @NotNull
        public final String component3() {
            return this.title;
        }

        @NotNull
        public final List<SearchResultItem> component4() {
            return this.results;
        }

        @NotNull
        public final FileGroup copy(@NotNull VirtualFile file, double weight, @NotNull String title, @NotNull List<SearchResultItem> results) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            return new FileGroup(file, weight, title, results);
        }

        public static /* synthetic */ FileGroup copy$default(FileGroup fileGroup, VirtualFile virtualFile, double d, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = fileGroup.file;
            }
            if ((n & 2) != 0) {
                d = fileGroup.weight;
            }
            if ((n & 4) != 0) {
                string = fileGroup.title;
            }
            if ((n & 8) != 0) {
                list = fileGroup.results;
            }
            return fileGroup.copy(virtualFile, d, string, list);
        }

        @NotNull
        public String toString() {
            return "FileGroup(file=" + this.file + ", weight=" + this.weight + ", title=" + this.title + ", results=" + this.results + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Double.hashCode(this.weight);
            result = result * 31 + this.title.hashCode();
            result = result * 31 + ((Object)this.results).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileGroup)) {
                return false;
            }
            FileGroup fileGroup = (FileGroup)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)fileGroup.file)) {
                return false;
            }
            if (Double.compare(this.weight, fileGroup.weight) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.title, (Object)fileGroup.title)) {
                return false;
            }
            return Intrinsics.areEqual(this.results, fileGroup.results);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$FilteredResultGroup;", "", "result", "", "count", "", "<init>", "(Ljava/lang/String;I)V", "getResult", "()Ljava/lang/String;", "getCount", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "ej-core"})
    public static final class FilteredResultGroup {
        @NotNull
        private final String result;
        private final int count;

        public FilteredResultGroup(@NotNull String result, int count) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.result = result;
            this.count = count;
        }

        @NotNull
        public final String getResult() {
            return this.result;
        }

        public final int getCount() {
            return this.count;
        }

        @NotNull
        public final String component1() {
            return this.result;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final FilteredResultGroup copy(@NotNull String result, int count) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            return new FilteredResultGroup(result, count);
        }

        public static /* synthetic */ FilteredResultGroup copy$default(FilteredResultGroup filteredResultGroup, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = filteredResultGroup.result;
            }
            if ((n2 & 2) != 0) {
                n = filteredResultGroup.count;
            }
            return filteredResultGroup.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "FilteredResultGroup(result=" + this.result + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = this.result.hashCode();
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilteredResultGroup)) {
                return false;
            }
            FilteredResultGroup filteredResultGroup = (FilteredResultGroup)other;
            if (!Intrinsics.areEqual((Object)this.result, (Object)filteredResultGroup.result)) {
                return false;
            }
            return this.count == filteredResultGroup.count;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$MergableSearchResultItem;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Integer;)V", "searchResult", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultItem;", "(Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultItem;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "copy", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Integer;)Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$MergableSearchResultItem;", "equals", "", "other", "hashCode", "toString", "", "ej-core"})
    public static final class MergableSearchResultItem {
        @NotNull
        private final VirtualFile file;
        @Nullable
        private final Integer line;

        public MergableSearchResultItem(@NotNull VirtualFile file, @Nullable Integer line) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.line = line;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @Nullable
        public final Integer getLine() {
            return this.line;
        }

        public MergableSearchResultItem(@NotNull SearchResultItem searchResult) {
            Intrinsics.checkNotNullParameter((Object)searchResult, (String)"searchResult");
            SearchResultContent searchResultContent = searchResult.getContent();
            this(searchResult.getFile(), searchResultContent != null ? Integer.valueOf(searchResultContent.getStartLine()) : null);
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        @Nullable
        public final Integer component2() {
            return this.line;
        }

        @NotNull
        public final MergableSearchResultItem copy(@NotNull VirtualFile file, @Nullable Integer line) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new MergableSearchResultItem(file, line);
        }

        public static /* synthetic */ MergableSearchResultItem copy$default(MergableSearchResultItem mergableSearchResultItem, VirtualFile virtualFile, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                virtualFile = mergableSearchResultItem.file;
            }
            if ((n2 & 2) != 0) {
                n = mergableSearchResultItem.line;
            }
            return mergableSearchResultItem.copy(virtualFile, n);
        }

        @NotNull
        public String toString() {
            return "MergableSearchResultItem(file=" + this.file + ", line=" + this.line + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + (this.line == null ? 0 : ((Object)this.line).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MergableSearchResultItem)) {
                return false;
            }
            MergableSearchResultItem mergableSearchResultItem = (MergableSearchResultItem)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)mergableSearchResultItem.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.line, (Object)mergableSearchResultItem.line);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/SearchProjectAction$SearchResultGroup;", "", "sourceType", "Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$SearchType;", "results", "", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultItem;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$SearchType;Ljava/util/List;)V", "getSourceType", "()Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$SearchType;", "getResults", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ej-core"})
    public static final class SearchResultGroup {
        @NotNull
        private final ProjectSearchEverywhereService.SearchType sourceType;
        @NotNull
        private final List<SearchResultItem> results;

        public SearchResultGroup(@NotNull ProjectSearchEverywhereService.SearchType sourceType, @NotNull List<SearchResultItem> results) {
            Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.sourceType = sourceType;
            this.results = results;
        }

        @NotNull
        public final ProjectSearchEverywhereService.SearchType getSourceType() {
            return this.sourceType;
        }

        @NotNull
        public final List<SearchResultItem> getResults() {
            return this.results;
        }

        @NotNull
        public final ProjectSearchEverywhereService.SearchType component1() {
            return this.sourceType;
        }

        @NotNull
        public final List<SearchResultItem> component2() {
            return this.results;
        }

        @NotNull
        public final SearchResultGroup copy(@NotNull ProjectSearchEverywhereService.SearchType sourceType, @NotNull List<SearchResultItem> results) {
            Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            return new SearchResultGroup(sourceType, results);
        }

        public static /* synthetic */ SearchResultGroup copy$default(SearchResultGroup searchResultGroup, ProjectSearchEverywhereService.SearchType searchType, List list, int n, Object object) {
            if ((n & 1) != 0) {
                searchType = searchResultGroup.sourceType;
            }
            if ((n & 2) != 0) {
                list = searchResultGroup.results;
            }
            return searchResultGroup.copy(searchType, list);
        }

        @NotNull
        public String toString() {
            return "SearchResultGroup(sourceType=" + this.sourceType + ", results=" + this.results + ")";
        }

        public int hashCode() {
            int result = this.sourceType.hashCode();
            result = result * 31 + ((Object)this.results).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SearchResultGroup)) {
                return false;
            }
            SearchResultGroup searchResultGroup = (SearchResultGroup)other;
            if (this.sourceType != searchResultGroup.sourceType) {
                return false;
            }
            return Intrinsics.areEqual(this.results, searchResultGroup.results);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectSearchEverywhereService.SearchType.values().length];
            try {
                nArray[ProjectSearchEverywhereService.SearchType.FILES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectSearchEverywhereService.SearchType.FILES_OR_DIRECTORIES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectSearchEverywhereService.SearchType.CLASSES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectSearchEverywhereService.SearchType.SYMBOLS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectSearchEverywhereService.SearchType.TEXT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

