/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions.edit;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.ml.llm.matterhorn.actions.edit.FileChange$;
import com.intellij.ml.llm.matterhorn.tasks.persistence.PathSerializer;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 -2\u00020\u0001:\u0002-.B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bBI\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0007\u0010\u000fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\nH\u00d6\u0001J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001J%\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0001\u00a2\u0006\u0002\b,R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/edit/FileChange;", "", "path", "Ljava/nio/file/Path;", "initialContent", "", "newContent", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "linesAdded", "linesRemoved", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;IILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPath$annotations", "()V", "getPath", "()Ljava/nio/file/Path;", "getInitialContent", "()Ljava/lang/String;", "getNewContent", "value", "getLinesAdded", "()I", "getLinesRemoved", "isDeleted", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$ej_core", "Companion", "$serializer", "ej-core"})
@SourceDebugExtension(value={"SMAP\nAbstractEditAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractEditAction.kt\ncom/intellij/ml/llm/matterhorn/actions/edit/FileChange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,384:1\n1#2:385\n*E\n"})
public final class FileChange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @Nullable
    private final String initialContent;
    @Nullable
    private final String newContent;
    private int linesAdded;
    private int linesRemoved;

    public FileChange(@NotNull Path path, @Nullable String initialContent, @Nullable String newContent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.initialContent = initialContent;
        this.newContent = newContent;
        if (!(this.initialContent != null || this.newContent != null)) {
            boolean $i$a$-require-FileChange$32 = false;
            String $i$a$-require-FileChange$32 = "Either initialContent or newContent must be provided.";
            throw new IllegalArgumentException($i$a$-require-FileChange$32.toString());
        }
        if (!(!Intrinsics.areEqual((Object)this.initialContent, (Object)this.newContent))) {
            boolean $i$a$-require-FileChange$42 = false;
            String $i$a$-require-FileChange$42 = "Initial content and new content are the same: " + this.initialContent;
            throw new IllegalArgumentException($i$a$-require-FileChange$42.toString());
        }
        CharSequence charSequence = this.initialContent;
        if (charSequence == null || charSequence.length() == 0) {
            Object object = this.newContent;
            this.linesAdded = object != null && (object = StringsKt.lines((CharSequence)((CharSequence)object))) != null ? object.size() : 0;
            this.linesRemoved = 0;
        } else {
            charSequence = this.newContent;
            if (charSequence == null || charSequence.length() == 0) {
                this.linesAdded = 0;
                this.linesRemoved = StringsKt.lines((CharSequence)this.initialContent).size();
            } else {
                ComparisonManager comparisonManager = ComparisonManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance(...)");
                ComparisonManager comparisonManager2 = comparisonManager;
                ComparisonPolicy policy = ComparisonPolicy.DEFAULT;
                DumbProgressIndicator indicator = DumbProgressIndicator.INSTANCE;
                try {
                    List list = comparisonManager2.compareLines((CharSequence)this.initialContent, (CharSequence)this.newContent, policy, (ProgressIndicator)indicator);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLines(...)");
                    List lineFragments = list;
                    int added = 0;
                    int removed = 0;
                    for (LineFragment fragment : lineFragments) {
                        removed += fragment.getEndLine1() - fragment.getStartLine1();
                        added += fragment.getEndLine2() - fragment.getStartLine2();
                    }
                    this.linesAdded = added;
                    this.linesRemoved = removed;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.linesAdded = 0;
                    this.linesRemoved = 0;
                }
            }
        }
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Serializable(with=PathSerializer.class)
    public static /* synthetic */ void getPath$annotations() {
    }

    @Nullable
    public final String getInitialContent() {
        return this.initialContent;
    }

    @Nullable
    public final String getNewContent() {
        return this.newContent;
    }

    public final int getLinesAdded() {
        return this.linesAdded;
    }

    public final int getLinesRemoved() {
        return this.linesRemoved;
    }

    public final boolean isDeleted() {
        return this.newContent == null;
    }

    @NotNull
    public final Path component1() {
        return this.path;
    }

    @Nullable
    public final String component2() {
        return this.initialContent;
    }

    @Nullable
    public final String component3() {
        return this.newContent;
    }

    @NotNull
    public final FileChange copy(@NotNull Path path, @Nullable String initialContent, @Nullable String newContent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new FileChange(path, initialContent, newContent);
    }

    public static /* synthetic */ FileChange copy$default(FileChange fileChange, Path path, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            path = fileChange.path;
        }
        if ((n & 2) != 0) {
            string = fileChange.initialContent;
        }
        if ((n & 4) != 0) {
            string2 = fileChange.newContent;
        }
        return fileChange.copy(path, string, string2);
    }

    @NotNull
    public String toString() {
        return "FileChange(path=" + this.path + ", initialContent=" + this.initialContent + ", newContent=" + this.newContent + ")";
    }

    public int hashCode() {
        int result = ((Object)this.path).hashCode();
        result = result * 31 + (this.initialContent == null ? 0 : this.initialContent.hashCode());
        result = result * 31 + (this.newContent == null ? 0 : this.newContent.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileChange)) {
            return false;
        }
        FileChange fileChange = (FileChange)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)fileChange.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.initialContent, (Object)fileChange.initialContent)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.newContent, (Object)fileChange.newContent);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$ej_core(FileChange self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)PathSerializer.INSTANCE, (Object)self.path);
        output2.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.initialContent);
        output2.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.newContent);
        output2.encodeIntElement(serialDesc, 3, self.linesAdded);
        output2.encodeIntElement(serialDesc, 4, self.linesRemoved);
    }

    public /* synthetic */ FileChange(int seen0, Path path, String initialContent, String newContent, int linesAdded, int linesRemoved, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.path = path;
        this.initialContent = initialContent;
        this.newContent = newContent;
        this.linesAdded = linesAdded;
        this.linesRemoved = linesRemoved;
        if (!(this.initialContent != null || this.newContent != null)) {
            boolean $i$a$-require-FileChange$32 = false;
            String $i$a$-require-FileChange$32 = "Either initialContent or newContent must be provided.";
            throw new IllegalArgumentException($i$a$-require-FileChange$32.toString());
        }
        if (!(!Intrinsics.areEqual((Object)this.initialContent, (Object)this.newContent))) {
            boolean $i$a$-require-FileChange$42 = false;
            String $i$a$-require-FileChange$42 = "Initial content and new content are the same: " + this.initialContent;
            throw new IllegalArgumentException($i$a$-require-FileChange$42.toString());
        }
        CharSequence charSequence = this.initialContent;
        if (charSequence == null || charSequence.length() == 0) {
            Object object = this.newContent;
            this.linesAdded = object != null && (object = StringsKt.lines((CharSequence)((CharSequence)object))) != null ? object.size() : 0;
            this.linesRemoved = 0;
        } else {
            charSequence = this.newContent;
            if (charSequence == null || charSequence.length() == 0) {
                this.linesAdded = 0;
                this.linesRemoved = StringsKt.lines((CharSequence)this.initialContent).size();
            } else {
                ComparisonManager comparisonManager = ComparisonManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance(...)");
                ComparisonManager comparisonManager2 = comparisonManager;
                ComparisonPolicy policy = ComparisonPolicy.DEFAULT;
                DumbProgressIndicator indicator = DumbProgressIndicator.INSTANCE;
                try {
                    List list = comparisonManager2.compareLines((CharSequence)this.initialContent, (CharSequence)this.newContent, policy, (ProgressIndicator)indicator);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLines(...)");
                    List lineFragments = list;
                    int added = 0;
                    int removed = 0;
                    for (LineFragment fragment : lineFragments) {
                        removed += fragment.getEndLine1() - fragment.getStartLine1();
                        added += fragment.getEndLine2() - fragment.getStartLine2();
                    }
                    this.linesAdded = added;
                    this.linesRemoved = removed;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.linesAdded = 0;
                    this.linesRemoved = 0;
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/edit/FileChange$Companion;", "", "<init>", "()V", "from", "Lcom/intellij/ml/llm/matterhorn/actions/edit/FileChange;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "initialContent", "", "newContent", "serializer", "Lkotlinx/serialization/KSerializer;", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileChange from(@NotNull Project project, @NotNull VirtualFile file, @Nullable String initialContent, @Nullable String newContent) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
            Intrinsics.checkNotNull((Object)virtualFile);
            Path path = virtualFile.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Path projectPath = path;
            Path path2 = projectPath.relativize(file.toNioPath());
            Intrinsics.checkNotNull((Object)path2);
            return new FileChange(path2, initialContent, newContent);
        }

        @NotNull
        public final KSerializer<FileChange> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

