/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.helpers;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/matterhorn/helpers/PathHelpers;", "", "<init>", "()V", "getExtension", "", "fileName", "tryGetPathWithSameExtension", "Ljava/nio/file/Path;", "pathString", "core"})
public final class PathHelpers {
    @NotNull
    public static final PathHelpers INSTANCE = new PathHelpers();

    private PathHelpers() {
    }

    @NotNull
    public final String getExtension(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        block4: for (int i = fileName.length() - 1; -1 < i; --i) {
            String string;
            char ch = fileName.charAt(i);
            switch (ch) {
                case '.': {
                    String string2 = fileName.substring(i + 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    break;
                }
                case '/': 
                case '\\': {
                    string = "";
                    break;
                }
                default: {
                    continue block4;
                }
            }
            return string;
        }
        return "";
    }

    @Nullable
    public final Path tryGetPathWithSameExtension(@NotNull String pathString) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        try {
            Path path2 = Paths.get(pathString, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            path = path2;
        }
        catch (InvalidPathException invalidPathException) {
            Path path3;
            try {
                Path path4 = Paths.get("file." + this.getExtension(pathString), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                path3 = path4;
            }
            catch (InvalidPathException invalidPathException2) {
                return null;
            }
            path = path3;
        }
        return path;
    }
}

