/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.requests;

import com.intellij.ml.llm.matterhorn.ProjectFileStructure;
import com.intellij.ml.llm.matterhorn.llm.MatterhornTool;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolChoice;
import com.intellij.ml.llm.matterhorn.llm.ModelParameters;
import com.intellij.ml.llm.matterhorn.requests.GrazieRequest;
import com.intellij.ml.llm.matterhorn.requests.builder.AssistantMessageConsumer;
import com.intellij.ml.llm.matterhorn.requests.builder.AssistantMessageConsumerHandler;
import com.intellij.ml.llm.matterhorn.requests.builder.AssistantMessageHandler;
import com.intellij.ml.llm.matterhorn.requests.builder.AssistantMessageReviewHandler;
import com.intellij.ml.llm.matterhorn.requests.builder.AssistantMessageReviewer;
import com.intellij.ml.llm.matterhorn.requests.builder.FileContent;
import com.intellij.ml.llm.matterhorn.requests.builder.GrazieRequestImpl;
import com.intellij.ml.llm.matterhorn.requests.builder.ImageContent;
import com.intellij.ml.llm.matterhorn.requests.builder.MatterhornToolUsageHandler;
import com.intellij.ml.llm.matterhorn.requests.builder.ReviewStrategy;
import com.intellij.ml.llm.matterhorn.requests.builder.TextContent;
import io.ktor.http.ContentType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00102\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u001a\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00102\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0010J\u001a\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00102\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0010J\"\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0010J$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010'\u001a\u00020\u00132\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ\u0018\u0010)\u001a\u00020\u00002\b\b\u0002\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u00105\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0010J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/ml/llm/matterhorn/requests/GrazieRequestBuilder;", "", "<init>", "()V", "system", "", "Lcom/intellij/ml/llm/matterhorn/requests/GrazieRequest$Content;", "user", "tools", "", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornTool;", "Lcom/intellij/ml/llm/matterhorn/requests/builder/MatterhornToolUsageHandler;", "toolChoice", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornToolChoice;", "completionCheck", "Lkotlin/Function1;", "", "", "maxCompletionRequests", "", "handlers", "Lcom/intellij/ml/llm/matterhorn/requests/builder/AssistantMessageHandler;", "maxRetries", "reviewersCount", "assistantAnswerPrefix", "addSystemFile", "filePath", "source", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure;", "addSystemMessage", "message", "title", "addUserMessage", "addUserImage", "contentType", "Lio/ktor/http/ContentType;", "imageData", "", "imageName", "maxRequests", "check", "addResultConsumer", "applyToFailed", "consumer", "Lcom/intellij/ml/llm/matterhorn/requests/builder/AssistantMessageConsumer;", "addReviewer", "strategy", "Lcom/intellij/ml/llm/matterhorn/requests/builder/ReviewStrategy;", "reviewer", "Lcom/intellij/ml/llm/matterhorn/requests/builder/AssistantMessageReviewer;", "addTool", "tool", "handler", "choice", "value", "prefix", "build", "Lcom/intellij/ml/llm/matterhorn/requests/GrazieRequest;", "modelParameters", "Lcom/intellij/ml/llm/matterhorn/llm/ModelParameters;", "core"})
@SourceDebugExtension(value={"SMAP\nGrazieRequestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieRequestBuilder.kt\ncom/intellij/ml/llm/matterhorn/requests/GrazieRequestBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class GrazieRequestBuilder {
    @NotNull
    private final List<GrazieRequest.Content> system = new ArrayList();
    @NotNull
    private final List<GrazieRequest.Content> user = new ArrayList();
    @NotNull
    private final Map<MatterhornTool, MatterhornToolUsageHandler> tools = new LinkedHashMap();
    @NotNull
    private MatterhornToolChoice toolChoice = new MatterhornToolChoice.Auto(false, 1, null);
    @NotNull
    private Function1<? super String, Boolean> completionCheck = GrazieRequestBuilder::completionCheck$lambda$0;
    private int maxCompletionRequests = 2;
    @NotNull
    private final List<AssistantMessageHandler> handlers = new ArrayList();
    private int maxRetries = 3;
    private int reviewersCount;
    @Nullable
    private String assistantAnswerPrefix;

    @NotNull
    public final GrazieRequestBuilder addSystemFile(@NotNull String filePath, @Nullable ProjectFileStructure source) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.system.add(new FileContent(filePath, source));
        return this;
    }

    public static /* synthetic */ GrazieRequestBuilder addSystemFile$default(GrazieRequestBuilder grazieRequestBuilder, String string, ProjectFileStructure projectFileStructure, int n, Object object) {
        if ((n & 2) != 0) {
            projectFileStructure = null;
        }
        return grazieRequestBuilder.addSystemFile(string, projectFileStructure);
    }

    @NotNull
    public final GrazieRequestBuilder addSystemMessage(@NotNull String message, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.system.add(new TextContent(message, title));
        return this;
    }

    public static /* synthetic */ GrazieRequestBuilder addSystemMessage$default(GrazieRequestBuilder grazieRequestBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return grazieRequestBuilder.addSystemMessage(string, string2);
    }

    @NotNull
    public final GrazieRequestBuilder addUserMessage(@NotNull String message, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.user.add(new TextContent(message, title));
        return this;
    }

    public static /* synthetic */ GrazieRequestBuilder addUserMessage$default(GrazieRequestBuilder grazieRequestBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return grazieRequestBuilder.addUserMessage(string, string2);
    }

    @NotNull
    public final GrazieRequestBuilder addUserImage(@NotNull ContentType contentType, @NotNull byte[] imageData, @Nullable String imageName) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        String string = imageName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.user.add(new TextContent(imageName + ": ", null, 2, null));
        }
        this.user.add(new ImageContent(contentType, imageData));
        return this;
    }

    public static /* synthetic */ GrazieRequestBuilder addUserImage$default(GrazieRequestBuilder grazieRequestBuilder, ContentType contentType, byte[] byArray, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return grazieRequestBuilder.addUserImage(contentType, byArray, string);
    }

    @NotNull
    public final GrazieRequestBuilder completionCheck(int maxRequests, @NotNull Function1<? super String, Boolean> check) {
        Intrinsics.checkNotNullParameter(check, (String)"check");
        this.completionCheck = check;
        this.maxCompletionRequests = Math.max(maxRequests, 0);
        return this;
    }

    public static /* synthetic */ GrazieRequestBuilder completionCheck$default(GrazieRequestBuilder grazieRequestBuilder, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return grazieRequestBuilder.completionCheck(n, (Function1<? super String, Boolean>)function1);
    }

    @NotNull
    public final GrazieRequestBuilder addResultConsumer(boolean applyToFailed, @NotNull AssistantMessageConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.handlers.add(new AssistantMessageConsumerHandler(applyToFailed, consumer));
        return this;
    }

    public static /* synthetic */ GrazieRequestBuilder addResultConsumer$default(GrazieRequestBuilder grazieRequestBuilder, boolean bl, AssistantMessageConsumer assistantMessageConsumer, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return grazieRequestBuilder.addResultConsumer(bl, assistantMessageConsumer);
    }

    @NotNull
    public final GrazieRequestBuilder addReviewer(@NotNull ReviewStrategy strategy, @NotNull AssistantMessageReviewer reviewer) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)reviewer, (String)"reviewer");
        int n = this.reviewersCount;
        this.reviewersCount = n + 1;
        this.handlers.add(new AssistantMessageReviewHandler(n, strategy, reviewer));
        return this;
    }

    public static /* synthetic */ GrazieRequestBuilder addReviewer$default(GrazieRequestBuilder grazieRequestBuilder, ReviewStrategy reviewStrategy, AssistantMessageReviewer assistantMessageReviewer, int n, Object object) {
        if ((n & 1) != 0) {
            reviewStrategy = ReviewStrategy.Companion.getDEFAULT();
        }
        return grazieRequestBuilder.addReviewer(reviewStrategy, assistantMessageReviewer);
    }

    @NotNull
    public final GrazieRequestBuilder addTool(@NotNull MatterhornTool tool, @NotNull MatterhornToolUsageHandler handler) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.tools.put(tool, handler);
        return this;
    }

    @NotNull
    public final GrazieRequestBuilder toolChoice(@NotNull MatterhornToolChoice choice) {
        Intrinsics.checkNotNullParameter((Object)choice, (String)"choice");
        this.toolChoice = choice;
        return this;
    }

    @NotNull
    public final GrazieRequestBuilder maxRetries(int value) {
        this.maxRetries = Math.max(value, 1);
        return this;
    }

    @NotNull
    public final GrazieRequestBuilder assistantAnswerPrefix(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.assistantAnswerPrefix = prefix;
        return this;
    }

    @NotNull
    public final GrazieRequest build(@NotNull ModelParameters modelParameters) {
        Intrinsics.checkNotNullParameter((Object)modelParameters, (String)"modelParameters");
        return new GrazieRequestImpl(this.system, this.user, modelParameters, this.maxRetries, this.handlers, this.reviewersCount, this.tools, this.toolChoice, this.completionCheck, this.maxCompletionRequests, this.assistantAnswerPrefix);
    }

    private static final boolean completionCheck$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

