/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.run.local;

import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.ml.llm.matterhorn.run.PathConverter;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/matterhorn/run/local/ProjectRelativePathConverter;", "Lcom/intellij/ml/llm/matterhorn/run/PathConverter;", "projectRootDir", "Ljava/nio/file/Path;", "executionPath", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getProjectRootDir", "()Ljava/nio/file/Path;", "convertLocalPathToExecutionPath", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionPath;", "path", "Lcom/intellij/ml/llm/matterhorn/run/LocalPath;", "convertExecutionPathToLocalPath", "ej-core"})
@SourceDebugExtension(value={"SMAP\nLocalExecutionEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalExecutionEnvironment.kt\ncom/intellij/ml/llm/matterhorn/run/local/ProjectRelativePathConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class ProjectRelativePathConverter
implements PathConverter {
    @NotNull
    private final Path projectRootDir;
    @Nullable
    private final String executionPath;

    public ProjectRelativePathConverter(@NotNull Path projectRootDir, @Nullable String executionPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)projectRootDir, (String)"projectRootDir");
        this.projectRootDir = projectRootDir;
        String string2 = executionPath;
        if (string2 != null) {
            char[] cArray = new char[]{'/'};
            string = StringsKt.trimEnd((String)string2, (char[])cArray);
        } else {
            string = null;
        }
        this.executionPath = string;
    }

    public /* synthetic */ ProjectRelativePathConverter(Path path, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(path, string);
    }

    @NotNull
    public final Path getProjectRootDir() {
        return this.projectRootDir;
    }

    @Override
    @NotNull
    public ExecutionPath convertLocalPathToExecutionPath(@NotNull LocalPath path) {
        ExecutionPath executionPath;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path execRelativePath = this.projectRootDir.relativize(path.getPath());
        if (this.executionPath != null) {
            Intrinsics.checkNotNull((Object)execRelativePath);
            executionPath = ((CharSequence)((Object)execRelativePath).toString()).length() == 0 ? new ExecutionPath(this.executionPath) : new ExecutionPath(this.executionPath + "/" + execRelativePath);
        } else {
            executionPath = new ExecutionPath(((Object)execRelativePath).toString());
        }
        return executionPath;
    }

    @Override
    @NotNull
    public LocalPath convertExecutionPathToLocalPath(@NotNull ExecutionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.executionPath == null) {
            Path path2 = this.projectRootDir.relativize(Path.of(path.getPath(), new String[0]));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
            return new LocalPath(path2);
        }
        if (Intrinsics.areEqual((Object)path.getPath(), (Object)this.executionPath)) {
            return new LocalPath(this.projectRootDir);
        }
        if (!StringsKt.startsWith$default((String)path.getPath(), (String)this.executionPath, (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "The provided path must be absolute: " + path;
            throw new IllegalArgumentException(string.toString());
        }
        String string = path.getPath().substring(this.executionPath.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String relativePath = string;
        Path path3 = this.projectRootDir.resolve(relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        return new LocalPath(path3);
    }
}

