/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.statistics;

import com.intellij.ide.impl.ProjectOriginKt;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.ml.llm.matterhorn.actions.StringUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "VCS_LOG", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "logVcsState", "", "project", "Lcom/intellij/openapi/project/Project;", "vcsStateId", "Ljava/util/UUID;", "getVcsData", "Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger$VcsState;", "Companion", "VcsState", "ej-core"})
@SourceDebugExtension(value={"SMAP\nAbstractEJVcsStateLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractEJVcsStateLogger.kt\ncom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1557#2:70\n1628#2,3:71\n*S KotlinDebug\n*F\n+ 1 AbstractEJVcsStateLogger.kt\ncom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger\n*L\n52#1:70\n52#1:71,3\n*E\n"})
public abstract class AbstractEJVcsStateLogger
extends CounterUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VarargEventId VCS_LOG;
    @NotNull
    private static final PrimitiveEventField<String> VCS_STATE_ID = EventFields.AnonymizedId;
    @NotNull
    private static final LongEventField TIMESTAMP_MS = EventFields.Long$default((String)"timestamp_ms", null, (int)2, null);
    @NotNull
    private static final EventField<String> ORIGIN_URL = EventFields.AnonymizedField$default((String)"origin_url", null, (int)2, null);
    @NotNull
    private static final IntEventField USERS_COUNT = EventFields.Int((String)"users_count");
    @NotNull
    private static final IntEventField LOCAL_CHANGED_FILES_COUNT = EventFields.Int((String)"local_changed_files_count");

    public AbstractEJVcsStateLogger() {
        EventField[] eventFieldArray = new EventField[]{VCS_STATE_ID, TIMESTAMP_MS, ORIGIN_URL, USERS_COUNT, LOCAL_CHANGED_FILES_COUNT};
        this.VCS_LOG = this.getGroup().registerVarargEvent("state.log", "Log vcs state data for Matterhorn EJ plugin", eventFieldArray);
    }

    public final void logVcsState(@NotNull Project project, @NotNull UUID vcsStateId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcsStateId, (String)"vcsStateId");
        VcsState vcsData = this.getVcsData(project);
        EventPair[] eventPairArray = new EventPair[5];
        eventPairArray[0] = VCS_STATE_ID.with((Object)vcsStateId.toString());
        eventPairArray[1] = TIMESTAMP_MS.with((Object)System.currentTimeMillis());
        Object object = vcsData;
        if (object == null || (object = ((VcsState)object).getOriginUrl()) == null || (object = StringUtilKt.nullIfEmpty((String)object)) == null) {
            object = "unknown";
        }
        eventPairArray[2] = ORIGIN_URL.with(object);
        VcsState vcsState = vcsData;
        eventPairArray[3] = USERS_COUNT.with((Object)StatisticsUtil.roundToPowerOfTwo((int)(vcsState != null ? vcsState.getUsersCount() : 0)));
        VcsState vcsState2 = vcsData;
        eventPairArray[4] = LOCAL_CHANGED_FILES_COUNT.with((Object)StatisticsUtil.roundToPowerOfTwo((int)(vcsState2 != null ? vcsState2.getLocalChangedFiles() : 0)));
        this.VCS_LOG.log(project, eventPairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final VcsState getVcsData(Project project) {
        void $this$mapTo$iv$iv;
        if (!TrustedProjects.isTrusted((Project)project)) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager manager = changeListManager;
        Collection collection = manager.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Change change = (Change)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getVirtualFile());
        }
        int localChangedFiles = CollectionsKt.distinct((Iterable)((List)destination$iv$iv)).size();
        VcsProjectLog projectLog = VcsProjectLog.Companion.getInstance(project);
        VcsLogData logData = projectLog.getDataManager();
        int usersCount = 0;
        if (logData != null) {
            DataPack dataPack = logData.getDataPack();
            Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"getDataPack(...)");
            DataPack dataPack2 = dataPack;
            if (dataPack2.isFull()) {
                usersCount = logData.getAllUsers().size();
            }
        }
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        String string = ProjectOriginKt.getProjectOriginUrl((Path)(virtualFile != null ? virtualFile.toNioPath() : null));
        if (string == null) {
            string = "";
        }
        String originUrl = string;
        return new VcsState(originUrl, usersCount, localChangedFiles);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger$Companion;", "", "<init>", "()V", "VCS_STATE_ID", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "getVCS_STATE_ID$ej_core", "()Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "TIMESTAMP_MS", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "getTIMESTAMP_MS$ej_core", "()Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "ORIGIN_URL", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getORIGIN_URL$ej_core", "()Lcom/intellij/internal/statistic/eventLog/events/EventField;", "USERS_COUNT", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getUSERS_COUNT$ej_core", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "LOCAL_CHANGED_FILES_COUNT", "getLOCAL_CHANGED_FILES_COUNT$ej_core", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrimitiveEventField<String> getVCS_STATE_ID$ej_core() {
            return VCS_STATE_ID;
        }

        @NotNull
        public final LongEventField getTIMESTAMP_MS$ej_core() {
            return TIMESTAMP_MS;
        }

        @NotNull
        public final EventField<String> getORIGIN_URL$ej_core() {
            return ORIGIN_URL;
        }

        @NotNull
        public final IntEventField getUSERS_COUNT$ej_core() {
            return USERS_COUNT;
        }

        @NotNull
        public final IntEventField getLOCAL_CHANGED_FILES_COUNT$ej_core() {
            return LOCAL_CHANGED_FILES_COUNT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger$VcsState;", "", "originUrl", "", "usersCount", "", "localChangedFiles", "<init>", "(Ljava/lang/String;II)V", "getOriginUrl", "()Ljava/lang/String;", "getUsersCount", "()I", "getLocalChangedFiles", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "ej-core"})
    public static final class VcsState {
        @NotNull
        private final String originUrl;
        private final int usersCount;
        private final int localChangedFiles;

        public VcsState(@NotNull String originUrl, int usersCount, int localChangedFiles) {
            Intrinsics.checkNotNullParameter((Object)originUrl, (String)"originUrl");
            this.originUrl = originUrl;
            this.usersCount = usersCount;
            this.localChangedFiles = localChangedFiles;
        }

        public /* synthetic */ VcsState(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(string, n, n2);
        }

        @NotNull
        public final String getOriginUrl() {
            return this.originUrl;
        }

        public final int getUsersCount() {
            return this.usersCount;
        }

        public final int getLocalChangedFiles() {
            return this.localChangedFiles;
        }

        @NotNull
        public final String component1() {
            return this.originUrl;
        }

        public final int component2() {
            return this.usersCount;
        }

        public final int component3() {
            return this.localChangedFiles;
        }

        @NotNull
        public final VcsState copy(@NotNull String originUrl, int usersCount, int localChangedFiles) {
            Intrinsics.checkNotNullParameter((Object)originUrl, (String)"originUrl");
            return new VcsState(originUrl, usersCount, localChangedFiles);
        }

        public static /* synthetic */ VcsState copy$default(VcsState vcsState, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = vcsState.originUrl;
            }
            if ((n3 & 2) != 0) {
                n = vcsState.usersCount;
            }
            if ((n3 & 4) != 0) {
                n2 = vcsState.localChangedFiles;
            }
            return vcsState.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "VcsState(originUrl=" + this.originUrl + ", usersCount=" + this.usersCount + ", localChangedFiles=" + this.localChangedFiles + ")";
        }

        public int hashCode() {
            int result = this.originUrl.hashCode();
            result = result * 31 + Integer.hashCode(this.usersCount);
            result = result * 31 + Integer.hashCode(this.localChangedFiles);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VcsState)) {
                return false;
            }
            VcsState vcsState = (VcsState)other;
            if (!Intrinsics.areEqual((Object)this.originUrl, (Object)vcsState.originUrl)) {
                return false;
            }
            if (this.usersCount != vcsState.usersCount) {
                return false;
            }
            return this.localChangedFiles == vcsState.localChangedFiles;
        }
    }
}

