/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.statistics;

import com.intellij.ml.llm.matterhorn.AgentExitStatus;
import com.intellij.ml.llm.matterhorn.AgentIssue;
import com.intellij.ml.llm.matterhorn.AgentResponseWithData;
import com.intellij.ml.llm.matterhorn.Artifact;
import com.intellij.ml.llm.matterhorn.ArtifactId;
import com.intellij.ml.llm.matterhorn.ArtifactStatistic;
import com.intellij.ml.llm.matterhorn.Artifactual;
import com.intellij.ml.llm.matterhorn.CacheType;
import com.intellij.ml.llm.matterhorn.CancelledArtifact;
import com.intellij.ml.llm.matterhorn.CustomArtifactEvent;
import com.intellij.ml.llm.matterhorn.EditorContext;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.FailedArtifact;
import com.intellij.ml.llm.matterhorn.FailureReason;
import com.intellij.ml.llm.matterhorn.RootExecutionContext;
import com.intellij.ml.llm.matterhorn.RootExecutionContextListener;
import com.intellij.ml.llm.matterhorn.TrajectoryElement;
import com.intellij.ml.llm.matterhorn.UnfinishedArtifact;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatElement;
import com.intellij.ml.llm.matterhorn.llm.MatterhornChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornMultiPartChatMessage;
import com.intellij.ml.llm.matterhorn.llm.MatterhornToolResult;
import com.intellij.ml.llm.matterhorn.llm.MatterhornUserChatMessageWithToolResults;
import com.intellij.ml.llm.matterhorn.statistics.AbstractEJVcsStateLogger;
import com.intellij.ml.llm.matterhorn.statistics.CompositeActivity;
import com.intellij.ml.llm.matterhorn.statistics.EJResultStatus;
import com.intellij.ml.llm.matterhorn.statistics.processors.EJActivityProcessor;
import com.intellij.ml.llm.matterhorn.tasks.persistence.TaskChainId;
import com.intellij.ml.llm.matterhorn.tasks.persistence.TaskEntity;
import com.intellij.ml.llm.matterhorn.tasks.persistence.TaskId;
import com.intellij.ml.llm.matterhorn.utils.PluginUtilsKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 E2\u00020\u0001:\u0001EB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010!H\u0016J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020$H\u0016J\f\u0010+\u001a\u00020,*\u00020-H\u0002J\u000e\u0010.\u001a\u00020,*\u0004\u0018\u00010/H\u0002J\u0014\u00100\u001a\u00020'2\n\u0010(\u001a\u0006\u0012\u0002\b\u000301H\u0016J\u0010\u00102\u001a\u00020'2\u0006\u0010(\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020'2\u0006\u0010(\u001a\u000205H\u0016J\u0014\u00106\u001a\u00020'2\n\u00107\u001a\u000608j\u0002`9H\u0016J \u0010:\u001a\u00020'2\n\u00107\u001a\u00060;j\u0002`<2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0018\u0010>\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010?\u001a\u00020,H\u0002J\u0010\u0010@\u001a\u00020,2\u0006\u0010(\u001a\u000205H\u0002J\f\u0010A\u001a\u00020,*\u00020BH\u0002J\u0012\u0010C\u001a\u00020D*\b\u0012\u0002\b\u0003\u0018\u00010!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00050 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\u0004\u0012\u00020$0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/ml/llm/matterhorn/statistics/StatisticsExecutionContextListener;", "Lcom/intellij/ml/llm/matterhorn/RootExecutionContextListener;", "project", "Lcom/intellij/openapi/project/Project;", "activityProcessors", "", "Lcom/intellij/ml/llm/matterhorn/statistics/processors/EJActivityProcessor;", "vcsStateLogger", "Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger;", "task", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskEntity;", "context", "Lcom/intellij/ml/llm/matterhorn/RootExecutionContext;", "taskChainId", "Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskChainId;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger;Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskEntity;Lcom/intellij/ml/llm/matterhorn/RootExecutionContext;Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskChainId;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getActivityProcessors", "()Ljava/util/List;", "getVcsStateLogger", "()Lcom/intellij/ml/llm/matterhorn/statistics/AbstractEJVcsStateLogger;", "getTask", "()Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskEntity;", "getContext", "()Lcom/intellij/ml/llm/matterhorn/RootExecutionContext;", "getTaskChainId", "()Lcom/intellij/ml/llm/matterhorn/tasks/persistence/TaskChainId;", "compositeActivity", "Lcom/intellij/ml/llm/matterhorn/statistics/CompositeActivity;", "activities", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/matterhorn/ArtifactId;", "Lcom/intellij/ml/llm/matterhorn/statistics/CompositeActivity$CustomActivity;", "artifacts", "Lcom/intellij/ml/llm/matterhorn/Artifactual;", "rootNode", "onUnfinishedArtifactCreated", "", "artifact", "requester", "onUnfinishedArtifactUpdated", "toResultStatus", "Lcom/intellij/ml/llm/matterhorn/statistics/EJResultStatus;", "", "getStatus", "Lcom/intellij/ml/llm/matterhorn/llm/MatterhornChatElement;", "onArtifactFinished", "Lcom/intellij/ml/llm/matterhorn/Artifact;", "onArtifactCancelled", "Lcom/intellij/ml/llm/matterhorn/CancelledArtifact;", "onArtifactFailed", "Lcom/intellij/ml/llm/matterhorn/FailedArtifact;", "onCancellation", "e", "Ljava/util/concurrent/CancellationException;", "Lkotlin/coroutines/cancellation/CancellationException;", "onException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "artifactId", "onFinished", "status", "getFailedStatus", "toEJResultStatus", "Lcom/intellij/ml/llm/matterhorn/AgentExitStatus;", "isRootNode", "", "Companion", "ej-core"})
@SourceDebugExtension(value={"SMAP\nStatisticsExecutionContextListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsExecutionContextListener.kt\ncom/intellij/ml/llm/matterhorn/statistics/StatisticsExecutionContextListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KotlinUtil.kt\ncom/intellij/openapi/observable/util/KotlinUtilKt\n*L\n1#1,195:1\n1557#2:196\n1628#2,3:197\n1755#2,3:200\n1863#2,2:208\n8#3,5:203\n*S KotlinDebug\n*F\n+ 1 StatisticsExecutionContextListener.kt\ncom/intellij/ml/llm/matterhorn/statistics/StatisticsExecutionContextListener\n*L\n61#1:196\n61#1:197,3\n92#1:200,3\n122#1:208,2\n99#1:203,5\n*E\n"})
public final class StatisticsExecutionContextListener
implements RootExecutionContextListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<EJActivityProcessor> activityProcessors;
    @NotNull
    private final AbstractEJVcsStateLogger vcsStateLogger;
    @NotNull
    private final TaskEntity task;
    @NotNull
    private final RootExecutionContext context;
    @NotNull
    private final TaskChainId taskChainId;
    @NotNull
    private final CompositeActivity compositeActivity;
    @NotNull
    private final ConcurrentHashMap<ArtifactId<?>, List<CompositeActivity.CustomActivity>> activities;
    @NotNull
    private final ConcurrentHashMap<ArtifactId<?>, Artifactual> artifacts;
    @Nullable
    private Artifactual rootNode;
    @NotNull
    public static final String EJ_PLUGIN_ID = "org.jetbrains.junie";

    public StatisticsExecutionContextListener(@NotNull Project project, @NotNull List<? extends EJActivityProcessor> activityProcessors, @NotNull AbstractEJVcsStateLogger vcsStateLogger, @NotNull TaskEntity task, @NotNull RootExecutionContext context2, @NotNull TaskChainId taskChainId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(activityProcessors, (String)"activityProcessors");
        Intrinsics.checkNotNullParameter((Object)((Object)vcsStateLogger), (String)"vcsStateLogger");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)taskChainId, (String)"taskChainId");
        this.project = project;
        this.activityProcessors = activityProcessors;
        this.vcsStateLogger = vcsStateLogger;
        this.task = task;
        this.context = context2;
        this.taskChainId = taskChainId;
        this.compositeActivity = new CompositeActivity(this.activityProcessors);
        this.activities = new ConcurrentHashMap();
        this.artifacts = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<EJActivityProcessor> getActivityProcessors() {
        return this.activityProcessors;
    }

    @NotNull
    public final AbstractEJVcsStateLogger getVcsStateLogger() {
        return this.vcsStateLogger;
    }

    @NotNull
    public final TaskEntity getTask() {
        return this.task;
    }

    @NotNull
    public final RootExecutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final TaskChainId getTaskChainId() {
        return this.taskChainId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUnfinishedArtifactCreated(@NotNull Artifactual artifact, @Nullable ArtifactId<?> requester) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (this.rootNode == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            EditorContext editorContext;
            UUID vcsStateId = UUID.randomUUID();
            Intrinsics.checkNotNull((Object)vcsStateId);
            this.vcsStateLogger.logVcsState(this.project, vcsStateId);
            if (artifact instanceof UnfinishedArtifact && ((UnfinishedArtifact)artifact).getRequest().getDescription() instanceof AgentIssue) {
                Object i = ((UnfinishedArtifact)artifact).getRequest().getDescription();
                Intrinsics.checkNotNull(i, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.AgentIssue");
                AgentIssue description = (AgentIssue)i;
                editorContext = description.getEditorContext();
            } else {
                editorContext = null;
            }
            EditorContext editorContext2 = editorContext;
            Iterable iterable = this.task.getExplicitlySelectedContextFiles();
            Object object = editorContext2;
            Collection collection2 = object != null && (object = ((EditorContext)object).getOpenFiles()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList();
            Object object2 = editorContext2;
            Collection collection3 = object2 != null && (object2 = ((EditorContext)object2).getRecentFiles()) != null ? (Collection)object2 : (Collection)CollectionsKt.emptyList();
            UUID uUID = vcsStateId;
            String string = this.task.getDescription();
            TaskId taskId = this.task.getId();
            TaskChainId taskChainId = this.taskChainId;
            Project project = this.project;
            ArtifactId<?> artifactId = artifact.getId();
            CompositeActivity compositeActivity = this.compositeActivity;
            boolean $i$f$map = false;
            void var8_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            collection = (List)destination$iv$iv;
            String string2 = PluginUtilsKt.getPluginVersion(EJ_PLUGIN_ID);
            if (string2 == null) {
                string2 = "";
            }
            List<CompositeActivity.CustomActivity> activity = compositeActivity.logGenerationStarted(artifactId, project, taskChainId, taskId, string, uUID, collection3, collection2, collection, string2);
            ((Map)this.activities).put(artifact.getId(), activity);
            ((Map)this.artifacts).put(artifact.getId(), artifact);
            this.rootNode = artifact;
        } else if (requester != null) {
            List<CompositeActivity.CustomActivity> activity = this.compositeActivity.logGenerationStepStarted(requester, artifact.getId(), this.project, this.taskChainId, this.task.getId());
            ((Map)this.activities).put(artifact.getId(), activity);
        }
    }

    @Override
    public void onUnfinishedArtifactUpdated(@NotNull Artifactual artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
    }

    private final EJResultStatus toResultStatus(String $this$toResultStatus) {
        return StringsKt.contains$default((CharSequence)$this$toResultStatus, (CharSequence)"Human rejected execution of the given action. Try doing something else.", (boolean)false, (int)2, null) ? EJResultStatus.DECLINED : (StringsKt.contains$default((CharSequence)$this$toResultStatus, (CharSequence)"ERROR: User cancelled the action, try something else or run in background", (boolean)false, (int)2, null) ? EJResultStatus.STOPPED : (StringsKt.startsWith$default((String)$this$toResultStatus, (String)"ERROR:", (boolean)false, (int)2, null) ? EJResultStatus.ERROR : EJResultStatus.SUBMIT));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final EJResultStatus getStatus(MatterhornChatElement $this$getStatus) {
        EJResultStatus eJResultStatus;
        if ($this$getStatus instanceof MatterhornChatMessage || $this$getStatus instanceof MatterhornMultiPartChatMessage) {
            eJResultStatus = this.toResultStatus($this$getStatus.getContent());
            return eJResultStatus;
        }
        if ($this$getStatus instanceof MatterhornUserChatMessageWithToolResults) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = ((MatterhornUserChatMessageWithToolResults)$this$getStatus).getToolResults();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MatterhornToolResult it = (MatterhornToolResult)element$iv;
                        boolean bl2 = false;
                        if (!it.isError()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                eJResultStatus = EJResultStatus.ERROR;
                return eJResultStatus;
            }
        }
        eJResultStatus = EJResultStatus.SUBMIT;
        return eJResultStatus;
    }

    @Override
    public void onArtifactFinished(@NotNull Artifact<?> artifact) {
        Object object;
        block8: {
            block6: {
                block7: {
                    AgentExitStatus agentExitStatus;
                    Intrinsics.checkNotNullParameter(artifact, (String)"artifact");
                    if (!this.isRootNode(artifact.getId())) break block6;
                    object = this.context.getService().getCaches().loadSingle(CacheType.ExitStatus);
                    if (object == null) break block7;
                    Object $this$toEnumOrNull$iv = object;
                    boolean $i$f$toEnumOrNull = false;
                    try {
                        agentExitStatus = Enum.valueOf(AgentExitStatus.class, (String)$this$toEnumOrNull$iv);
                    }
                    catch (IllegalArgumentException ex$iv) {
                        agentExitStatus = null;
                    }
                    if ((object = agentExitStatus) != null && (object = this.toEJResultStatus((AgentExitStatus)((Object)object))) != null) break block8;
                }
                object = EJResultStatus.UNKNOWN;
                break block8;
            }
            if (artifact.getContent() instanceof AgentResponseWithData) {
                Object obj = artifact.getContent();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.AgentResponseWithData<*>");
                MatterhornChatElement result = ((AgentResponseWithData)obj).getAgentResponse().getActionResult();
                object = this.getStatus(result);
            } else {
                object = EJResultStatus.SUBMIT;
            }
        }
        Object status = object;
        this.onFinished(artifact, (EJResultStatus)((Object)status));
    }

    @Override
    public void onArtifactCancelled(@NotNull CancelledArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        this.onFinished(artifact, EJResultStatus.EXIT_CANCELLATION);
    }

    @Override
    public void onArtifactFailed(@NotNull FailedArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        this.onFinished(artifact, this.getFailedStatus(artifact));
    }

    @Override
    public void onCancellation(@NotNull CancellationException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Set<Map.Entry<ArtifactId<?>, List<CompositeActivity.CustomActivity>>> set = this.activities.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Artifactual artifact;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            if (this.artifacts.get(it.getKey()) == null) continue;
            this.onFinished(artifact, EJResultStatus.EXIT_CANCELLATION);
        }
    }

    @Override
    public void onException(@NotNull Exception e, @NotNull ArtifactId<?> artifactId) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(artifactId, (String)"artifactId");
        Artifactual artifactual = this.artifacts.get(artifactId);
        if (artifactual == null) {
            return;
        }
        Artifactual artifact = artifactual;
        this.onFinished(artifact, EJResultStatus.EXIT_EXCEPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onFinished(Artifactual artifact, EJResultStatus status) {
        List<CompositeActivity.CustomActivity> list = this.activities.get(artifact.getId());
        if (list == null) {
            return;
        }
        List<CompositeActivity.CustomActivity> activities = list;
        try {
            ArtifactStatistic statistics = this.context.calculateTotalStatistics(artifact, false);
            if (this.isRootNode(artifact.getId())) {
                v1 = this.compositeActivity.logGenerationFinished(activities, artifact.getId(), this.taskChainId, this.task.getId(), status, statistics);
            } else {
                String string;
                if (artifact instanceof Artifact && ((Artifact)artifact).getContent() instanceof AgentResponseWithData) {
                    Object o = ((Artifact)artifact).getContent();
                    Intrinsics.checkNotNull(o, (String)"null cannot be cast to non-null type com.intellij.ml.llm.matterhorn.AgentResponseWithData<*>");
                    string = ((AgentResponseWithData)o).getAgentResponse().getActionRequest().getName();
                } else {
                    string = artifact instanceof Artifact ? ((Artifact)artifact).getId().getType().getName() : null;
                }
                String action2 = string;
                v1 = this.compositeActivity.logGenerationStepFinished(activities, artifact.getId(), this.taskChainId, this.task.getId(), action2, status, statistics);
            }
        }
        finally {
            this.activities.remove(artifact.getId());
        }
    }

    private final EJResultStatus getFailedStatus(FailedArtifact artifact) {
        EJResultStatus eJResultStatus;
        FailureReason failureReason = artifact.getReasoning().getReason();
        if (failureReason instanceof FailureReason.ContextLengthExceeded) {
            eJResultStatus = EJResultStatus.EXIT_CONTEXT;
        } else if (failureReason instanceof FailureReason.FormatError) {
            eJResultStatus = EJResultStatus.EXIT_FORMAT;
        } else if (failureReason instanceof FailureReason.CostExceeded) {
            eJResultStatus = EJResultStatus.EXIT_COST;
        } else if (failureReason instanceof FailureReason.PaymentRequired) {
            eJResultStatus = EJResultStatus.EXIT_PAYMENT_REQUIRED;
        } else if (failureReason instanceof FailureReason.InferenceServerTimeout) {
            eJResultStatus = EJResultStatus.EXIT_TIMEOUT;
        } else if (failureReason instanceof FailureReason.UnexpectedException) {
            eJResultStatus = EJResultStatus.EXIT_UNEXPECTED_EXCEPTION;
        } else if (failureReason instanceof FailureReason.CountryForbidden) {
            eJResultStatus = EJResultStatus.EXIT_COUNTRY_FORBIDDEN;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return eJResultStatus;
    }

    private final EJResultStatus toEJResultStatus(AgentExitStatus $this$toEJResultStatus) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toEJResultStatus.ordinal()]) {
            case 1 -> EJResultStatus.EXIT_COST;
            case 2 -> EJResultStatus.EXIT_PAYMENT_REQUIRED;
            case 3 -> EJResultStatus.EXIT_FORMAT;
            case 4 -> EJResultStatus.EXIT_TIMEOUT;
            case 5 -> EJResultStatus.EXIT_CONTEXT;
            case 6 -> EJResultStatus.EXIT_EARLY;
            case 7 -> EJResultStatus.SUBMIT;
            case 8 -> EJResultStatus.EXIT_MAX_ITERATIONS;
            case 9 -> EJResultStatus.EXIT_COUNTRY_FORBIDDEN;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRootNode(ArtifactId<?> $this$isRootNode) {
        if ($this$isRootNode == null) return false;
        Artifactual artifactual = this.rootNode;
        if (!Intrinsics.areEqual(artifactual != null ? artifactual.getId() : null, $this$isRootNode)) return false;
        return true;
    }

    @Override
    public void onTrajectoryElement(@NotNull TrajectoryElement element, @NotNull ExecutionContext context2) {
        RootExecutionContextListener.DefaultImpls.onTrajectoryElement(this, element, context2);
    }

    @Override
    public void onCustomEvent(@NotNull CustomArtifactEvent event, @Nullable ArtifactId<?> requester) {
        RootExecutionContextListener.DefaultImpls.onCustomEvent(this, event, requester);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/matterhorn/statistics/StatisticsExecutionContextListener$Companion;", "", "<init>", "()V", "EJ_PLUGIN_ID", "", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AgentExitStatus.values().length];
            try {
                nArray[AgentExitStatus.ExitCost.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.ExitPaymentRequired.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.ExitFormat.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.ExitInferenceServerTimeout.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.ExitContext.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.ExitEarly.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.Submit.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.ExitMaxIter.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentExitStatus.CountryForbidden.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

