/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.ml.llm.terminal.TerminalAskingAiBrightPlaceholderManager;
import com.intellij.ml.llm.terminal.TerminalAskingAiDimmedPlaceholderManager;
import com.intellij.ml.llm.terminal.TerminalLLMBundle;
import com.intellij.ml.llm.terminal.TerminalPromptPlaceholderManager;
import com.intellij.ml.llm.terminal.util.RendererBase;
import com.intellij.ml.llm.terminal.util.ShortcutRenderer;
import com.intellij.ml.llm.terminal.util.TextRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.BlockTerminalColors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H$J\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000b0\nH\u0016\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAskingAiPlaceholderManager;", "Lcom/intellij/ml/llm/terminal/TerminalPromptPlaceholderManager;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;)V", "wrapRenderer", "Lcom/intellij/ml/llm/terminal/util/RendererBase;", "renderer", "installInlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Companion", "Lcom/intellij/ml/llm/terminal/TerminalAskingAiBrightPlaceholderManager;", "Lcom/intellij/ml/llm/terminal/TerminalAskingAiDimmedPlaceholderManager;", "intellij.ml.llm.terminal"})
public abstract sealed class TerminalAskingAiPlaceholderManager
extends TerminalPromptPlaceholderManager
permits TerminalAskingAiBrightPlaceholderManager, TerminalAskingAiDimmedPlaceholderManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private TerminalAskingAiPlaceholderManager(TerminalPromptModel promptModel) {
        super(promptModel);
        this.updatePlaceholder();
    }

    @NotNull
    protected abstract RendererBase wrapRenderer(@NotNull RendererBase var1);

    @Override
    @NotNull
    public List<Inlay<?>> installInlays() {
        EditorEx editor = this.getPromptModel().getEditor();
        int offset = editor.getDocument().getTextLength();
        List inlays = new ArrayList();
        String askingAiText = TerminalLLMBundle.INSTANCE.message("text.to.command.asking.ai.placeholder", new Object[0]);
        Color aiColor = editor.getColorsScheme().getColor(BlockTerminalColors.GENERATE_COMMAND_CARET_COLOR);
        Inlay askingAiInlay = editor.getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)this.wrapRenderer(new TextRenderer(askingAiText, 0, aiColor)));
        inlays.add(askingAiInlay);
        String additionalText = TerminalLLMBundle.INSTANCE.message("text.to.command.asking.ai.shortcut.placeholder", new Object[0]);
        Inlay additionalInlay = editor.getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)this.wrapRenderer(new TextRenderer(additionalText, 1, null, 4, null)));
        inlays.add(additionalInlay);
        Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)"Terminal.GenerateCommandFromText");
        if (shortcut != null) {
            String string = KeymapUtil.getShortcutText((Shortcut)shortcut);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortcutText(...)");
            String shortcutText = string;
            Inlay shortcutInlay = editor.getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)this.wrapRenderer(new ShortcutRenderer(shortcutText, 2)));
            inlays.add(shortcutInlay);
        }
        return inlays;
    }

    public /* synthetic */ TerminalAskingAiPlaceholderManager(TerminalPromptModel promptModel, DefaultConstructorMarker $constructor_marker) {
        this(promptModel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalAskingAiPlaceholderManager$Companion;", "", "<init>", "()V", "install", "", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.ml.llm.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull TerminalPromptModel promptModel, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            TerminalAskingAiBrightPlaceholderManager defaultManager = new TerminalAskingAiBrightPlaceholderManager(promptModel);
            TerminalAskingAiDimmedPlaceholderManager dimmedManager = new TerminalAskingAiDimmedPlaceholderManager(promptModel);
            Disposer.register((Disposable)parentDisposable, (Disposable)defaultManager);
            Disposer.register((Disposable)parentDisposable, (Disposable)dimmedManager);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

