/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.terminal.TerminalLLMBundle;
import com.intellij.ml.llm.terminal.TerminalPromptPlaceholderManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalOldAiPlaceholderManager;", "Lcom/intellij/ml/llm/terminal/TerminalPromptPlaceholderManager;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;)V", "shouldShowPlaceholder", "", "installInlays", "", "Lcom/intellij/openapi/editor/Inlay;", "PlaceholderInlayRenderer", "Companion", "intellij.ml.llm.terminal"})
public final class TerminalOldAiPlaceholderManager
extends TerminalPromptPlaceholderManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private TerminalOldAiPlaceholderManager(TerminalPromptModel promptModel) {
        super(promptModel);
        this.updatePlaceholder();
    }

    @Override
    public boolean shouldShowPlaceholder() {
        return ((CharSequence)this.getPromptModel().getCommandText()).length() == 0;
    }

    @Override
    @NotNull
    public List<Inlay<?>> installInlays() {
        EditorEx editor = this.getPromptModel().getEditor();
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        String text = TerminalLLMBundle.INSTANCE.message("text.to.command.placeholder", objectArray);
        PlaceholderInlayRenderer renderer = new PlaceholderInlayRenderer(text);
        Inlay inlay = editor.getInlayModel().addAfterLineEndElement(editor.getCaretModel().getOffset(), true, (EditorCustomElementRenderer)renderer);
        return CollectionsKt.listOf((Object)inlay);
    }

    public /* synthetic */ TerminalOldAiPlaceholderManager(TerminalPromptModel promptModel, DefaultConstructorMarker $constructor_marker) {
        this(promptModel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalOldAiPlaceholderManager$Companion;", "", "<init>", "()V", "install", "", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.ml.llm.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void install(@NotNull TerminalPromptModel promptModel, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            TerminalOldAiPlaceholderManager manager = new TerminalOldAiPlaceholderManager(promptModel, null);
            Disposer.register((Disposable)parentDisposable, (Disposable)manager);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J,\u0010\n\u001a\u00020\u000b2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalOldAiPlaceholderManager$PlaceholderInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "<init>", "(Ljava/lang/String;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getFontMetrics", "Ljava/awt/FontMetrics;", "font", "Ljava/awt/Font;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.terminal"})
    private static final class PlaceholderInlayRenderer
    implements EditorCustomElementRenderer {
        @NotNull
        private final String text;

        public PlaceholderInlayRenderer(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Font font = inlay.getEditor().getColorsScheme().getFont(EditorFontType.PLAIN);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font font2 = font;
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            FontMetrics fontMetrics = this.getFontMetrics(font2, editor);
            return fontMetrics.stringWidth(this.text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            Font font = editor2.getColorsScheme().getFont(EditorFontType.PLAIN);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font font2 = font;
            FontMetrics fontMetrics = this.getFontMetrics(font2, editor2);
            int caretX = editor2.offsetToXY((int)editor2.getCaretModel().getOffset()).x;
            CaretVisualAttributes caretVisualAttributes = editor2.getCaretModel().getPrimaryCaret().getVisualAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)caretVisualAttributes, (String)"getVisualAttributes(...)");
            CaretVisualAttributes caretAttributes = caretVisualAttributes;
            int caretWidth = JBUIScale.scale((int)caretAttributes.getWidth(editor2.getSettings().getLineCursorWidth()));
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                g.setColor(editor2.getColorsScheme().getColor(BlockTerminalColors.GENERATE_COMMAND_PLACEHOLDER_FOREGROUND));
                g.setFont(font2);
                g.drawString(this.text, caretX + caretWidth, r.y + fontMetrics.getAscent());
            }
            finally {
                g2d.dispose();
            }
        }

        private final FontMetrics getFontMetrics(Font font, Editor editor) {
            FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)editor.getContentComponent());
            FontRenderContext actualContext = new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), UISettings.Companion.getEditorFractionalMetricsHint());
            FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)actualContext);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            return fontMetrics;
        }
    }
}

