/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\fH&J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\tH&J\b\u0010\u000f\u001a\u00020\u0010H\u0005J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalPromptPlaceholderManager;", "Lcom/intellij/openapi/Disposable;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;)V", "getPromptModel", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "isDisposed", "", "shouldShowPlaceholder", "installInlays", "updatePlaceholder", "", "installPlaceholder", "deinstallPlaceholder", "dispose", "intellij.ml.llm.terminal"})
public abstract class TerminalPromptPlaceholderManager
implements Disposable {
    @NotNull
    private final TerminalPromptModel promptModel;
    @Nullable
    private List<? extends Inlay<?>> inlays;
    private volatile boolean isDisposed;

    public TerminalPromptPlaceholderManager(@NotNull TerminalPromptModel promptModel) {
        Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
        this.promptModel = promptModel;
        this.promptModel.getEditor().getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> 1.documentChanged$lambda$0(this));
            }

            private static final Unit documentChanged$lambda$0(TerminalPromptPlaceholderManager this$0) {
                this$0.updatePlaceholder();
                return Unit.INSTANCE;
            }
        }, (Disposable)this);
    }

    @NotNull
    protected final TerminalPromptModel getPromptModel() {
        return this.promptModel;
    }

    public abstract boolean shouldShowPlaceholder();

    @NotNull
    public abstract List<Inlay<?>> installInlays();

    @RequiresEdt
    protected final void updatePlaceholder() {
        if (this.isDisposed || this.promptModel.getEditor().isDisposed()) {
            return;
        }
        if (this.shouldShowPlaceholder()) {
            this.installPlaceholder();
        } else {
            this.deinstallPlaceholder();
        }
    }

    private final void installPlaceholder() {
        if (this.inlays != null) {
            return;
        }
        List<Inlay<?>> newInlays = this.installInlays();
        this.inlays = CollectionsKt.filterNotNull((Iterable)newInlays);
    }

    private final void deinstallPlaceholder() {
        List<Inlay<?>> list = this.inlays;
        if (list != null) {
            List<Inlay<?>> it = list;
            boolean bl = false;
            for (Inlay<?> inlay : it) {
                Disposer.dispose((Disposable)((Disposable)inlay));
            }
        }
        this.inlays = null;
    }

    public void dispose() {
        this.deinstallPlaceholder();
        this.isDisposed = true;
    }
}

