/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J#\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J!\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/settingsRepository/RepositoryService;", "", "checkUrl", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "uriString", "project", "Lcom/intellij/openapi/project/Project;", "checkFileRepo", "url", "isValidRepository", "", "file", "Ljava/nio/file/Path;", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\nRepositoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryService.kt\norg/jetbrains/settingsRepository/RepositoryService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public interface RepositoryService {
    @Nullable
    default public String checkUrl(@NotNull String uriString, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        URIish uri = new URIish(uriString);
        boolean isFile = Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file") || uri.getScheme() == null && uri.getHost() == null;
        return isFile ? this.checkFileRepo(uriString, project) : null;
    }

    public static /* synthetic */ String checkUrl$default(RepositoryService repositoryService, String string, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkUrl");
        }
        if ((n & 2) != 0) {
            project = null;
        }
        return repositoryService.checkUrl(string, project);
    }

    private String checkFileRepo(String url, Project project) {
        block13: {
            String string;
            String suffix = "/.git";
            if (StringsKt.endsWith$default((String)url, (String)suffix, (boolean)false, (int)2, null)) {
                String string2 = url.substring(0, url.length() - suffix.length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = url;
            }
            Path file = Paths.get(string, new String[0]);
            Intrinsics.checkNotNull((Object)file);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    return IcsBundleKt.icsMessage("dialog.message.path.is.not.directory", new Object[0]);
                }
                if (this.isValidRepository(file)) {
                    return null;
                }
            } else if (!file.isAbsolute()) {
                return IcsBundleKt.icsMessage("specify.absolute.path.dialog.message", new Object[0]);
            }
            Object object = new Object[]{file};
            if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(IcsBundleKt.icsMessage("init.dialog.title", new Object[0]), IcsBundleKt.icsMessage("init.dialog.message", object)).yesText(IcsBundleKt.icsMessage("init.dialog.create.button", new Object[0]))).ask(project)) break block13;
            try {
                GitExKt.createBareRepository(file);
                object = null;
            }
            catch (IOException e) {
                String string3;
                block15: {
                    block14: {
                        string3 = e.getMessage();
                        if (string3 == null) break block14;
                        String it = string3;
                        boolean bl = false;
                        Object[] objectArray = new Object[]{it};
                        String string4 = IcsBundleKt.icsMessage("init.failed.message", objectArray);
                        string3 = string4;
                        if (string4 != null) break block15;
                    }
                    string3 = IcsBundleKt.icsMessage("init.failed.message.without.details", new Object[0]);
                }
                object = string3;
            }
            return object;
        }
        return "";
    }

    public boolean isValidRepository(@NotNull Path var1);
}

