/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.transport.sshd.agent.ConnectorFactoryProvider;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Factory;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.InputStreamWrapper;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a,\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\n\u0010\u0012\u001a\u00020\u000b*\u00020\u000b\u001a:\u0010\u0013\u001a\u00020\u0014*\u00020\u000b2\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0003\u0010\u0015\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u000b\u001a\n\u0010\u001b\u001a\u00020\u0007*\u00020\u001c\u001a\u001c\u0010 \u001a\u00020!*\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u0007\u001a\n\u0010$\u001a\u00020%*\u00020\u000b\u001a2\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010-\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010.H\u0002\u001a\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\nH\u0002\u001aq\u00102\u001a\u00020\u0001*\u00020\u000b2\u0006\u00103\u001a\u00020\u00072%\b\u0002\u00104\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(7\u0012\u0004\u0012\u00020\u0005\u0018\u00010526\u00108\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(7\u0012\u0013\u0012\u00110:\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(;\u0012\u0004\u0012\u00020\u000509\u001a\u0014\u0010<\u001a\u0004\u0018\u00010:*\u00020\u000b2\u0006\u00103\u001a\u00020\u0007\u001a\f\u0010=\u001a\u00020>*\u00020\u000bH\u0000\u001a=\u0010?\u001a\u0002H@\"\f\b\u0000\u0010A*\u00060Bj\u0002`C\"\u0004\b\u0001\u0010@*\u0002HA2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u0002HA\u0012\u0004\u0012\u0002H@05H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010E\u001a2\u0010F\u001a\u00020\u000b2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010H\u001a\u00020\u00052\n\b\u0002\u0010I\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010J\u001a\u00020\u0005\u001a\u000e\u0010K\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020)\u001a\u0010\u0010L\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0000\"\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u0007*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006M"}, d2={"wrapIfNeedAndReThrow", "", "e", "Lorg/eclipse/jgit/errors/TransportException;", "isAuthFailedMessage", "", "message", "", "ensureSshSessionFactory", "fetch", "Lorg/eclipse/jgit/transport/FetchResult;", "Lorg/eclipse/jgit/lib/Repository;", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "progressMonitor", "Lorg/eclipse/jgit/lib/ProgressMonitor;", "disableAutoCrLf", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "reflogComment", "author", "Lorg/eclipse/jgit/lib/PersonIdent;", "committer", "resetHard", "Lorg/eclipse/jgit/dircache/DirCacheCheckout;", "getRemoteBranchFullName", "Lorg/eclipse/jgit/lib/Config;", "upstream", "getUpstream", "(Lorg/eclipse/jgit/lib/Repository;)Ljava/lang/String;", "setUpstream", "Lorg/eclipse/jgit/lib/StoredConfig;", "url", "remoteBranchName", "computeIndexDiff", "Lorg/eclipse/jgit/lib/IndexDiff;", "cloneBare", "uri", "dir", "Ljava/nio/file/Path;", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "getDefaultBranch", "Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "findBranchToCheckout", "Lorg/eclipse/jgit/lib/Ref;", "result", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "read", "getAheadCommitCount", "", "use", "R", "T", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "block", "(Ljava/lang/AutoCloseable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "buildRepository", "workTree", "bare", "gitDir", "mustExists", "buildBareRepository", "createBareRepository", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\nGitEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitEx.kt\norg/jetbrains/settingsRepository/git/GitExKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n384#1,3:433\n400#1,2:436\n388#1,10:438\n384#1,3:448\n400#1,2:451\n388#1,10:453\n384#1,3:465\n400#1,2:473\n384#1,3:475\n400#1,2:478\n388#1,10:480\n388#1,10:490\n295#2,2:463\n60#3,5:468\n1#4:500\n*S KotlinDebug\n*F\n+ 1 GitEx.kt\norg/jetbrains/settingsRepository/git/GitExKt\n*L\n80#1:433,3\n80#1:436,2\n80#1:438,10\n212#1:448,3\n212#1:451,2\n212#1:453,10\n252#1:465,3\n252#1:473,2\n284#1:475,3\n284#1:478,2\n284#1:480,10\n252#1:490,10\n245#1:463,2\n255#1:468,5\n*E\n"})
public final class GitExKt {
    public static final void wrapIfNeedAndReThrow(@NotNull TransportException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof org.eclipse.jgit.errors.NoRemoteRepositoryException || e.getStatus() == TransportException.Status.CANNOT_RESOLVE_REPO) {
            throw new NoRemoteRepositoryException(e);
        }
        String message = e.getMessage();
        if (e.getStatus() == TransportException.Status.NOT_AUTHORIZED || e.getStatus() == TransportException.Status.NOT_PERMITTED || message != null && GitExKt.isAuthFailedMessage(message)) {
            throw new AuthenticationException(e);
        }
        if (e.getStatus() == TransportException.Status.CANCELLED || Intrinsics.areEqual((Object)message, (Object)"Download cancelled")) {
            throw new ProcessCanceledException();
        }
        throw e;
    }

    private static final boolean isAuthFailedMessage(String message) {
        CharSequence charSequence = message;
        String string = JGitText.get().notAuthorized;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notAuthorized");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth cancel", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth fail", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)": reject HostKey:", (boolean)false, (int)2, null);
    }

    private static final void ensureSshSessionFactory() {
        SshSessionFactory sessionFactoryInstance;
        ConnectorFactory connectorFactoryInstance = ConnectorFactoryProvider.getDefaultFactory();
        if (connectorFactoryInstance == null) {
            connectorFactoryInstance = (ConnectorFactory)new Factory();
            ConnectorFactoryProvider.setDefaultFactory((ConnectorFactory)connectorFactoryInstance);
        }
        if ((sessionFactoryInstance = SshSessionFactory.getInstance()) == null) {
            sessionFactoryInstance = (SshSessionFactory)new SshdSessionFactory();
            SshSessionFactory.setInstance((SshSessionFactory)sessionFactoryInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final FetchResult fetch(@NotNull Repository $this$fetch, @NotNull RemoteConfig remoteConfig, @Nullable CredentialsProvider credentialsProvider, @Nullable ProgressMonitor progressMonitor) {
        Intrinsics.checkNotNullParameter((Object)$this$fetch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
        GitExKt.ensureSshSessionFactory();
        try {
            FetchResult fetchResult;
            AutoCloseable $this$use$iv = (AutoCloseable)Transport.open((Repository)$this$fetch, (RemoteConfig)remoteConfig);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                Transport transport = (Transport)$this$use$iv;
                boolean bl = false;
                transport.setCredentialsProvider(credentialsProvider);
                transport.setRemoveDeletedRefs(true);
                ProgressMonitor progressMonitor2 = progressMonitor;
                if (progressMonitor2 == null) {
                    progressMonitor2 = (ProgressMonitor)NullProgressMonitor.INSTANCE;
                }
                fetchResult = transport.fetch(progressMonitor2, null);
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        $this$use$iv.close();
                    }
                    catch (Exception closeException$iv) {
                        Intrinsics.checkNotNull((Object)e$iv, (String)"null cannot be cast to non-null type java.lang.Throwable");
                        ((Throwable)e$iv).addSuppressed(closeException$iv);
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
            return fetchResult;
        }
        catch (TransportException e) {
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"Remote does not have ", (boolean)false, (int)2, null) : false;
            if (bl) {
                IcsManagerKt.getLOG().warn(e.getMessage());
                return null;
            }
            GitExKt.wrapIfNeedAndReThrow(e);
            return null;
        }
    }

    public static /* synthetic */ FetchResult fetch$default(Repository repository, RemoteConfig remoteConfig, CredentialsProvider credentialsProvider, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 2) != 0) {
            credentialsProvider = null;
        }
        if ((n & 4) != 0) {
            progressMonitor = null;
        }
        return GitExKt.fetch(repository, remoteConfig, credentialsProvider, progressMonitor);
    }

    @NotNull
    public static final Repository disableAutoCrLf(@NotNull Repository $this$disableAutoCrLf) {
        Intrinsics.checkNotNullParameter((Object)$this$disableAutoCrLf, (String)"<this>");
        StoredConfig config = $this$disableAutoCrLf.getConfig();
        config.setString("core", null, "autocrlf", "false");
        config.save();
        return $this$disableAutoCrLf;
    }

    @NotNull
    public static final RevCommit commit(@NotNull Repository $this$commit, @NonNls @Nullable String message, @NonNls @Nullable String reflogComment, @Nullable PersonIdent author, @Nullable PersonIdent committer) {
        Intrinsics.checkNotNullParameter((Object)$this$commit, (String)"<this>");
        CommitCommand commitCommand = new CommitCommand($this$commit).setAuthor(author).setCommitter(committer);
        if (message != null) {
            commitCommand.setMessage(message);
        }
        if (reflogComment != null) {
            commitCommand.setReflogComment(reflogComment);
        }
        RevCommit revCommit = commitCommand.call();
        Intrinsics.checkNotNullExpressionValue((Object)revCommit, (String)"call(...)");
        return revCommit;
    }

    public static /* synthetic */ RevCommit commit$default(Repository repository, String string, String string2, PersonIdent personIdent, PersonIdent personIdent2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            personIdent = null;
        }
        if ((n & 8) != 0) {
            personIdent2 = null;
        }
        return GitExKt.commit(repository, string, string2, personIdent, personIdent2);
    }

    @NotNull
    public static final DirCacheCheckout resetHard(@NotNull Repository $this$resetHard) {
        Intrinsics.checkNotNullParameter((Object)$this$resetHard, (String)"<this>");
        ResetCommand resetCommand = new ResetCommand($this$resetHard).setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
        DirCacheCheckout dirCacheCheckout = resetCommand.getDirCacheCheckout();
        Intrinsics.checkNotNull((Object)dirCacheCheckout);
        return dirCacheCheckout;
    }

    @NotNull
    public static final String getRemoteBranchFullName(@NotNull Config $this$getRemoteBranchFullName) {
        Intrinsics.checkNotNullParameter((Object)$this$getRemoteBranchFullName, (String)"<this>");
        String name = $this$getRemoteBranchFullName.getString("branch", "master", "merge");
        if (StringUtil.isEmpty((String)name)) {
            throw new IllegalStateException("branch.master.merge refspec must be specified");
        }
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public static final String getUpstream(@NotNull Repository $this$upstream) {
        Intrinsics.checkNotNullParameter((Object)$this$upstream, (String)"<this>");
        return StringKt.nullize$default((String)$this$upstream.getConfig().getString("remote", "origin", "url"), (boolean)false, (int)1, null);
    }

    @NotNull
    public static final StoredConfig setUpstream(@NotNull Repository $this$setUpstream, @Nullable String url, @NotNull String remoteBranchName) {
        Intrinsics.checkNotNullParameter((Object)$this$setUpstream, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)remoteBranchName, (String)"remoteBranchName");
        String localBranchName = "master";
        StoredConfig config = $this$setUpstream.getConfig();
        String remoteName = "origin";
        CharSequence charSequence = url;
        if (charSequence == null || charSequence.length() == 0) {
            IcsManagerKt.getLOG().debug("Unset remote");
            config.unsetSection("remote", remoteName);
            config.unsetSection("branch", localBranchName);
        } else {
            IcsManagerKt.getLOG().debug("Set remote " + url);
            config.setString("remote", remoteName, "url", url);
            char c = '+';
            String string = "refs/heads/";
            config.setString("remote", remoteName, "fetch", c + string + remoteBranchName + ":refs/remotes/" + remoteName + "/" + remoteBranchName);
            config.setString("branch", localBranchName, "remote", remoteName);
            config.setString("branch", localBranchName, "merge", "refs/heads/" + remoteBranchName);
        }
        config.save();
        Intrinsics.checkNotNull((Object)config);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IndexDiff computeIndexDiff(@NotNull Repository $this$computeIndexDiff) {
        Intrinsics.checkNotNullParameter((Object)$this$computeIndexDiff, (String)"<this>");
        FileTreeIterator workingTreeIterator = new FileTreeIterator($this$computeIndexDiff);
        try {
            IndexDiff indexDiff = new IndexDiff($this$computeIndexDiff, "HEAD", (WorkingTreeIterator)workingTreeIterator);
            return indexDiff;
        }
        finally {
            workingTreeIterator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Repository cloneBare(@NotNull String uri, @NotNull Path dir, @Nullable Lazy<IcsCredentialsStore> credentialsStore, @NotNull ProgressMonitor progressMonitor) {
        RevCommit revCommit;
        String branch;
        Ref ref;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)progressMonitor, (String)"progressMonitor");
        Repository repository = GitExKt.createBareRepository(dir);
        JGitCredentialsProvider credentialsProvider = credentialsStore == null ? null : new JGitCredentialsProvider(credentialsStore, repository);
        String string = GitExKt.getDefaultBranch(uri, credentialsProvider);
        if (string == null) {
            string = "master";
        }
        StoredConfig config = GitExKt.setUpstream(repository, uri, string);
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, "origin");
        FetchResult fetchResult = GitExKt.fetch(repository, remoteConfig, credentialsProvider, progressMonitor);
        if (fetchResult == null) {
            return repository;
        }
        FetchResult result = fetchResult;
        Ref head = null;
        head = GitExKt.findBranchToCheckout(result);
        if (head == null && (ref = result.getAdvertisedRef(branch = "HEAD")) == null && (ref = result.getAdvertisedRef("refs/heads/" + branch)) == null) {
            ref = head = result.getAdvertisedRef("refs/tags/" + branch);
        }
        if (head == null || head.getObjectId() == null) {
            return repository;
        }
        String string2 = head.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string2, (String)"refs/heads/", (boolean)false, (int)2, null)) {
            RefUpdate newHead = repository.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            String branchName = Repository.shortenRefName((String)head.getName());
            config.setString("branch", branchName, "remote", "origin");
            config.setString("branch", branchName, "merge", head.getName());
            String autoSetupRebase = config.getString("branch", null, "autosetuprebase");
            if (Intrinsics.areEqual((Object)"always", (Object)autoSetupRebase) || Intrinsics.areEqual((Object)"remote", (Object)autoSetupRebase)) {
                config.setBoolean("branch", branchName, "rebase", true);
            }
            config.save();
        }
        AutoCloseable $this$use$iv = (AutoCloseable)new RevWalk(repository);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            RevWalk it = (RevWalk)$this$use$iv;
            boolean bl = false;
            revCommit = it.parseCommit((AnyObjectId)head.getObjectId());
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception closeException$iv) {
                    Intrinsics.checkNotNull((Object)e$iv, (String)"null cannot be cast to non-null type java.lang.Throwable");
                    ((Throwable)e$iv).addSuppressed(closeException$iv);
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        RevCommit commit2 = revCommit;
        String string3 = head.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        RefUpdate u = repository.updateRef("HEAD", !StringsKt.startsWith$default((String)string3, (String)"refs/heads/", (boolean)false, (int)2, null));
        u.setNewObjectId((AnyObjectId)commit2.getId());
        u.forceUpdate();
        return repository;
    }

    public static /* synthetic */ Repository cloneBare$default(String string, Path path, Lazy lazy, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 4) != 0) {
            lazy = null;
        }
        if ((n & 8) != 0) {
            NullProgressMonitor nullProgressMonitor = NullProgressMonitor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)nullProgressMonitor, (String)"INSTANCE");
            progressMonitor = (ProgressMonitor)nullProgressMonitor;
        }
        return GitExKt.cloneBare(string, path, (Lazy<IcsCredentialsStore>)lazy, progressMonitor);
    }

    private static final String getDefaultBranch(String uri, JGitCredentialsProvider credentialsProvider) {
        Map remoteRefs = ((LsRemoteCommand)new LsRemoteCommand(null).setRemote(uri).setTags(false).setCredentialsProvider((CredentialsProvider)credentialsProvider)).callAsMap();
        Ref remoteHeadRef = (Ref)remoteRefs.get("HEAD");
        if (remoteHeadRef != null) {
            Intrinsics.checkNotNull((Object)remoteRefs);
            for (Map.Entry entry : remoteRefs.entrySet()) {
                String refName = (String)entry.getKey();
                Ref ref = (Ref)entry.getValue();
                if (ref == remoteHeadRef || !Intrinsics.areEqual((Object)ref.getObjectId(), (Object)remoteHeadRef.getObjectId())) continue;
                Intrinsics.checkNotNull((Object)refName);
                if (!StringsKt.startsWith$default((String)refName, (String)"refs/heads/", (boolean)false, (int)2, null)) continue;
                return StringsKt.removePrefix((String)refName, (CharSequence)"refs/heads/");
            }
        }
        return null;
    }

    private static final Ref findBranchToCheckout(FetchResult result) {
        Object v3;
        block3: {
            Ref ref = result.getAdvertisedRef("HEAD");
            if (ref == null) {
                return null;
            }
            Ref idHead = ref;
            Ref master = result.getAdvertisedRef("refs/heads/master");
            if (master != null && Intrinsics.areEqual((Object)master.getObjectId(), (Object)idHead.getObjectId())) {
                return master;
            }
            Collection collection = result.getAdvertisedRefs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAdvertisedRefs(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Ref it = (Ref)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!(StringsKt.startsWith$default((String)string, (String)"refs/heads/", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.getObjectId(), (Object)idHead.getObjectId()))) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void processChildren(@NotNull Repository $this$processChildren, @NotNull String path, @Nullable Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        TreeWalk rootTreeWalk;
        ObjectReader reader;
        boolean closed$iv;
        AutoCloseable $this$use$iv;
        block22: {
            block20: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)$this$processChildren, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Intrinsics.checkNotNullParameter(processor, (String)"processor");
                    ObjectId objectId = $this$processChildren.resolve("FETCH_HEAD");
                    if (objectId == null) {
                        return;
                    }
                    ObjectId lastCommitId = objectId;
                    $this$use$iv = (AutoCloseable)$this$processChildren.newObjectReader();
                    boolean $i$f$use = false;
                    closed$iv = false;
                    reader = (ObjectReader)$this$use$iv;
                    boolean bl = false;
                    AnyObjectId[] anyObjectIdArray = new AnyObjectId[]{new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()};
                    rootTreeWalk = TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])anyObjectIdArray);
                    if (rootTreeWalk != null) break block20;
                    Logger $this$debug_u24default$iv = IcsManagerKt.getLOG();
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if (!$this$debug_u24default$iv.isDebugEnabled()) break block21;
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug(path + " not found", e$iv);
                }
                $this$use$iv.close();
                return;
            }
            if (rootTreeWalk.isSubtree()) break block22;
            IcsManagerKt.getLOG().warn("File " + path + " is not a directory");
            $this$use$iv.close();
            return;
        }
        try {
            TreeWalk treeWalk = new TreeWalk($this$processChildren);
            treeWalk.addTree((AnyObjectId)rootTreeWalk.getObjectId(0));
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                boolean bl;
                ObjectLoader objectLoader;
                FileMode fileMode = treeWalk.getFileMode(0);
                if (!Intrinsics.areEqual((Object)fileMode, (Object)FileMode.REGULAR_FILE) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.SYMLINK) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.EXECUTABLE_FILE)) continue;
                String fileName = treeWalk.getNameString();
                if (filter != null) {
                    Intrinsics.checkNotNull((Object)fileName);
                    if (!((Boolean)filter.invoke((Object)fileName)).booleanValue()) continue;
                }
                if ((objectLoader = reader.open((AnyObjectId)treeWalk.getObjectId(0), 3)).getSize() == 0L) {
                    IcsManagerKt.getLOG().warn("File " + path + " skipped because empty (length 0)");
                    continue;
                }
                AutoCloseable $this$use$iv2 = (AutoCloseable)objectLoader.openStream();
                boolean $i$f$use = false;
                boolean closed$iv2 = false;
                try {
                    ObjectStream it = (ObjectStream)$this$use$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)fileName);
                    Intrinsics.checkNotNull((Object)it);
                    bl = (Boolean)processor.invoke((Object)fileName, (Object)it);
                }
                catch (Exception e$iv) {
                    try {
                        closed$iv2 = true;
                        try {
                            $this$use$iv2.close();
                        }
                        catch (Exception closeException$iv) {
                            Intrinsics.checkNotNull((Object)e$iv, (String)"null cannot be cast to non-null type java.lang.Throwable");
                            ((Throwable)e$iv).addSuppressed(closeException$iv);
                        }
                        throw e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv2) {
                            $this$use$iv2.close();
                        }
                        throw throwable;
                    }
                }
                $this$use$iv2.close();
                if (bl) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception closeException$iv) {
                    Intrinsics.checkNotNull((Object)e$iv, (String)"null cannot be cast to non-null type java.lang.Throwable");
                    ((Throwable)e$iv).addSuppressed(closeException$iv);
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
    }

    public static /* synthetic */ void processChildren$default(Repository repository, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        GitExKt.processChildren(repository, string, (Function1<? super String, Boolean>)function1, (Function2<? super String, ? super InputStream, Boolean>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final InputStream read(@NotNull Repository $this$read, @NotNull String path) {
        ObjectStream input;
        ObjectReader reader;
        block7: {
            TreeWalk treeWalk;
            boolean releaseReader;
            block6: {
                AnyObjectId[] anyObjectIdArray;
                Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                ObjectId lastCommitId = $this$read.resolve("HEAD");
                if (lastCommitId == null) {
                    IcsManagerKt.getLOG().warn("Repository " + $this$read.getDirectory().getName() + " doesn't have HEAD");
                    return null;
                }
                reader = $this$read.newObjectReader();
                releaseReader = true;
                try {
                    anyObjectIdArray = new AnyObjectId[]{new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()};
                    if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])anyObjectIdArray) != null) break block6;
                    anyObjectIdArray = null;
                }
                catch (Throwable throwable) {
                    if (releaseReader) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
                return anyObjectIdArray;
            }
            TreeWalk treeWalk2 = treeWalk;
            ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), 3);
            input = objectLoader.openStream();
            if (!objectLoader.isLarge()) break block7;
            releaseReader = false;
            Intrinsics.checkNotNull((Object)input);
            InputStream inputStream = (InputStream)input;
            Intrinsics.checkNotNull((Object)reader);
            InputStream inputStream2 = new InputStreamWrapper(inputStream, reader);
            return inputStream2;
        }
        InputStream inputStream = (InputStream)input;
        reader.close();
        return inputStream;
    }

    public static final int getAheadCommitCount(@NotNull Repository $this$getAheadCommitCount) {
        RevCommit revCommit;
        Intrinsics.checkNotNullParameter((Object)$this$getAheadCommitCount, (String)"<this>");
        StoredConfig config = $this$getAheadCommitCount.getConfig();
        Intrinsics.checkNotNull((Object)config);
        String shortBranchName = Repository.shortenRefName((String)GitExKt.getRemoteBranchFullName((Config)config));
        String string = new BranchConfig((Config)config, shortBranchName).getTrackingBranch();
        if (string == null) {
            return -1;
        }
        String trackingBranch = string;
        Ref ref = $this$getAheadCommitCount.exactRef("refs/heads/" + shortBranchName);
        if (ref == null) {
            return -1;
        }
        Ref local = ref;
        RevWalk walk = new RevWalk($this$getAheadCommitCount);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
        Ref ref2 = $this$getAheadCommitCount.findRef(trackingBranch);
        if (ref2 != null) {
            Ref it = ref2;
            boolean bl = false;
            revCommit = walk.parseCommit((AnyObjectId)it.getObjectId());
        } else {
            revCommit = null;
        }
        RevCommit trackingCommit = revCommit;
        walk.setRevFilter(RevFilter.MERGE_BASE);
        if (trackingCommit == null) {
            walk.markStart(localCommit);
            walk.sort(RevSort.REVERSE);
        } else {
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.markStart(localCommit);
            walk.markUninteresting(mergeBase);
        }
        walk.setRevFilter(RevFilter.ALL);
        return CollectionsKt.count((Iterable)((Iterable)walk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends AutoCloseable, R> R use(@NotNull T $this$use, @NotNull Function1<? super T, ? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter($this$use, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$use = false;
        boolean closed = false;
        try {
            object = block.invoke($this$use);
        }
        catch (Exception e) {
            try {
                closed = true;
                try {
                    $this$use.close();
                }
                catch (Exception closeException) {
                    Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type java.lang.Throwable");
                    ((Throwable)e).addSuppressed(closeException);
                }
                throw e;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed) {
                    $this$use.close();
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        $this$use.close();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public static final Repository buildRepository(@Nullable Path workTree, boolean bare, @Nullable Path gitDir, boolean mustExists) {
        Path it;
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().setAutonomous(true);
        if (bare) {
            v0 = (FileRepositoryBuilder)repositoryBuilder.setBare();
        } else {
            Path path = workTree;
            if (path != null) {
                it = path;
                boolean bl = false;
                v0 = (FileRepositoryBuilder)repositoryBuilder.setWorkTree(it.toFile());
            } else {
                v0 = null;
            }
        }
        Path path = gitDir;
        if (path != null) {
            it = path;
            boolean bl = false;
            FileRepositoryBuilder cfr_ignored_0 = (FileRepositoryBuilder)repositoryBuilder.setGitDir(gitDir.toFile());
        }
        repositoryBuilder.setMustExist(mustExists);
        Repository repository = repositoryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"build(...)");
        return repository;
    }

    public static /* synthetic */ Repository buildRepository$default(Path path, boolean bl, Path path2, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            path2 = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return GitExKt.buildRepository(path, bl, path2, bl2);
    }

    @NotNull
    public static final Repository buildBareRepository(@NotNull Path gitDir) {
        Intrinsics.checkNotNullParameter((Object)gitDir, (String)"gitDir");
        return GitExKt.buildRepository$default(null, true, gitDir, false, 9, null);
    }

    @NotNull
    public static final Repository createBareRepository(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Repository repository = GitExKt.buildRepository$default(null, true, dir, false, 9, null);
        repository.create(true);
        return repository;
    }
}

