/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthFormKt;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.GitCredentialKt;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;
import org.jetbrains.settingsRepository.git.JGitCredentialsProviderKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J!\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ4\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0082@\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "<init>", "(Lkotlin/Lazy;Lorg/eclipse/jgit/lib/Repository;)V", "credentialsFromGit", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lorg/eclipse/jgit/transport/URIish;", "Lcom/intellij/credentialStore/Credentials;", "getCredentialsFromGit", "()Lcom/github/benmanes/caffeine/cache/LoadingCache;", "credentialsFromGit$delegate", "Lkotlin/Lazy;", "isInteractive", "", "supports", "items", "", "Lorg/eclipse/jgit/transport/CredentialItem;", "([Lorg/eclipse/jgit/transport/CredentialItem;)Z", "get", "uri", "(Lorg/eclipse/jgit/transport/URIish;[Lorg/eclipse/jgit/transport/CredentialItem;)Z", "doGet", "userNameItem", "Lorg/eclipse/jgit/transport/CredentialItem$Username;", "passwordItem", "sshKeyFile", "", "(Lorg/eclipse/jgit/transport/URIish;Lorg/eclipse/jgit/transport/CredentialItem$Username;Lorg/eclipse/jgit/transport/CredentialItem;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "", "intellij.settingsRepository"})
@SourceDebugExtension(value={"SMAP\nJGitCredentialsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JGitCredentialsProvider.kt\norg/jetbrains/settingsRepository/git/JGitCredentialsProvider\n+ 2 autoSync.kt\norg/jetbrains/settingsRepository/AutoSyncKt\n*L\n1#1,156:1\n131#2,16:157\n*S KotlinDebug\n*F\n+ 1 JGitCredentialsProvider.kt\norg/jetbrains/settingsRepository/git/JGitCredentialsProvider\n*L\n91#1:157,16\n*E\n"})
public final class JGitCredentialsProvider
extends CredentialsProvider {
    @NotNull
    private final Lazy<IcsCredentialsStore> credentialsStore;
    @NotNull
    private final Repository repository;
    @NotNull
    private final Lazy credentialsFromGit$delegate;

    public JGitCredentialsProvider(@NotNull Lazy<IcsCredentialsStore> credentialsStore, @NotNull Repository repository) {
        Intrinsics.checkNotNullParameter(credentialsStore, (String)"credentialsStore");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.credentialsStore = credentialsStore;
        this.repository = repository;
        this.credentialsFromGit$delegate = LazyKt.lazy(() -> JGitCredentialsProvider.credentialsFromGit_delegate$lambda$0(this));
    }

    private final LoadingCache<URIish, Credentials> getCredentialsFromGit() {
        Lazy lazy = this.credentialsFromGit$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LoadingCache)object;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.Password || item instanceof CredentialItem.Username || item instanceof CredentialItem.StringType || item instanceof CredentialItem.YesNoType) continue;
            return false;
        }
        return true;
    }

    public boolean get(@NotNull URIish uri, CredentialItem ... items) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        Ref.ObjectRef userNameItem = new Ref.ObjectRef();
        Ref.ObjectRef passwordItem = new Ref.ObjectRef();
        Ref.ObjectRef sshKeyFile = new Ref.ObjectRef();
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.Username) {
                userNameItem.element = item;
                continue;
            }
            if (item instanceof CredentialItem.Password) {
                passwordItem.element = item;
                continue;
            }
            if (item instanceof CredentialItem.StringType) {
                String marker;
                String promptText = ((CredentialItem.StringType)item).getPromptText();
                if (promptText == null || !StringsKt.startsWith$default((String)promptText, (String)(marker = "Passphrase for "), (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)promptText.substring(marker.length()), (String)"substring(...)");
                sshKeyFile.element = sshKeyFile.element;
                passwordItem.element = item;
                continue;
            }
            if (!(item instanceof CredentialItem.YesNoType)) continue;
            UIUtil.invokeAndWaitIfNeeded(() -> JGitCredentialsProvider.get$lambda$0(item));
            return true;
        }
        if (userNameItem.element == null && passwordItem.element == null) {
            return false;
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return (Boolean)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, uri, (Ref.ObjectRef<CredentialItem.Username>)userNameItem, (Ref.ObjectRef<CredentialItem>)passwordItem, (Ref.ObjectRef<String>)sshKeyFile, null){
            int label;
            final /* synthetic */ JGitCredentialsProvider this$0;
            final /* synthetic */ URIish $uri;
            final /* synthetic */ Ref.ObjectRef<CredentialItem.Username> $userNameItem;
            final /* synthetic */ Ref.ObjectRef<CredentialItem> $passwordItem;
            final /* synthetic */ Ref.ObjectRef<String> $sshKeyFile;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                this.$userNameItem = $userNameItem;
                this.$passwordItem = $passwordItem;
                this.$sshKeyFile = $sshKeyFile;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = JGitCredentialsProvider.access$doGet(this.this$0, this.$uri, (CredentialItem.Username)this.$userNameItem.element, (CredentialItem)this.$passwordItem.element, (String)this.$sshKeyFile.element, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private final Object doGet(URIish uri, CredentialItem.Username userNameItem, CredentialItem passwordItem, String sshKeyFile, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof doGet.1)) ** GOTO lbl-1000
        var15_6 = $completion;
        if ((var15_6.label & -2147483648) != 0) {
            var15_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                /* synthetic */ Object result;
                final /* synthetic */ JGitCredentialsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JGitCredentialsProvider.access$doGet(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                credentials = new Ref.ObjectRef();
                userFromUri = sshKeyFile == null ? StringKt.nullize$default((String)uri.getUser(), (boolean)false, (int)1, null) : null;
                passwordFromUri = StringKt.nullize$default((String)uri.getPass(), (boolean)false, (int)1, null);
                if (userFromUri != null && passwordFromUri != null) {
                    credentials.element = new Credentials(userFromUri, passwordFromUri);
                } else {
                    asWarning$iv = false;
                    $i$f$catchAndLog = false;
                    try {
                        $i$a$-catchAndLog$default-JGitCredentialsProvider$doGet$2 = false;
                        credentials.element = ((IcsCredentialsStore)this.credentialsStore.getValue()).get(uri.getHost(), sshKeyFile, userFromUri);
                        if (!(CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element)) || sshKeyFile != null && MacOsKeychainLibraryKt.isMacOsCredentialStoreSupported())) {
                            credentials.element = this.getCredentialsFromGit().get((Object)uri);
                        }
                    }
                    catch (CancellationException e$iv) {
                        throw e$iv;
                    }
                    catch (Throwable e$iv) {
                        if (e$iv instanceof AuthenticationException || e$iv instanceof NoRemoteRepositoryException) {
                            IcsManagerKt.getLOG().warn(e$iv);
                        }
                        IcsManagerKt.getLOG().error(e$iv);
                    }
                }
                if (CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element))) ** GOTO lbl64
                var13_19 = credentials;
                $continuation.L$0 = uri;
                $continuation.L$1 = userNameItem;
                $continuation.L$2 = passwordItem;
                $continuation.L$3 = sshKeyFile;
                $continuation.L$4 = credentials;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)userFromUri);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)passwordFromUri);
                $continuation.L$7 = var13_19;
                $continuation.label = 1;
                v0 = AuthFormKt.showAuthenticationForm((Credentials)credentials.element, JGitCredentialsProviderKt.access$toStringWithoutCredentials(uri), uri.getHost(), uri.getPath(), sshKeyFile, (Continuation<? super Credentials>)$continuation);
                if (v0 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl62
            }
            case 1: {
                var13_19 = (Ref.ObjectRef)$continuation.L$7;
                passwordFromUri = (String)$continuation.L$6;
                userFromUri = (String)$continuation.L$5;
                credentials = (Ref.ObjectRef)$continuation.L$4;
                sshKeyFile = (String)$continuation.L$3;
                passwordItem = (CredentialItem)$continuation.L$2;
                userNameItem = (CredentialItem.Username)$continuation.L$1;
                uri = (URIish)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = var13_19.element = $result;
lbl62:
                // 2 sources

                if (CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element))) {
                    ((IcsCredentialsStore)this.credentialsStore.getValue()).set(uri.getHost(), sshKeyFile, (Credentials)credentials.element);
                }
lbl64:
                // 4 sources

                v1 = userNameItem;
                if (v1 != null) {
                    v2 = (Credentials)credentials.element;
                    v1.setValue(v2 != null ? v2.getUserName() : null);
                }
                if (passwordItem != null) {
                    if (passwordItem instanceof CredentialItem.Password) {
                        v3 = (Credentials)credentials.element;
                        ((CredentialItem.Password)passwordItem).setValue(v3 != null && (v3 = v3.getPassword()) != null ? OneTimeString.toCharArray$default((OneTimeString)v3, (boolean)false, (int)1, null) : null);
                    } else {
                        v4 = (Credentials)credentials.element;
                        ((CredentialItem.StringType)passwordItem).setValue(v4 != null && (v4 = v4.getPassword()) != null ? v4.toString() : null);
                    }
                }
                return Boxing.boxBoolean((boolean)CredentialAttributesKt.isFulfilled((Credentials)((Credentials)credentials.element)));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void reset(@NotNull URIish uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.getCredentialsFromGit().invalidate((Object)uri);
        this.getCredentialsFromGit().cleanUp();
        IcsCredentialsStore icsCredentialsStore = (IcsCredentialsStore)this.credentialsStore.getValue();
        String string = uri.getHost();
        Intrinsics.checkNotNull((Object)string);
        icsCredentialsStore.set(string, null, null);
    }

    private static final LoadingCache credentialsFromGit_delegate$lambda$0(JGitCredentialsProvider this$0) {
        return Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader(this$0){
            final /* synthetic */ JGitCredentialsProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public final Credentials load(URIish it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Credentials credentials = GitCredentialKt.getCredentialsUsingGit(it, JGitCredentialsProvider.access$getRepository$p(this.this$0));
                if (credentials == null) {
                    credentials = new Credentials(null);
                }
                return credentials;
            }
        });
    }

    private static final void get$lambda$0(CredentialItem $item) {
        CredentialItem.YesNoType yesNoType = (CredentialItem.YesNoType)$item;
        String string = ((CredentialItem.YesNoType)$item).getPromptText();
        Intrinsics.checkNotNull((Object)string);
        yesNoType.setValue(MessageDialogBuilder.Companion.yesNo("", string).guessWindowAndAsk());
    }

    public static final /* synthetic */ Object access$doGet(JGitCredentialsProvider $this, URIish uri, CredentialItem.Username userNameItem, CredentialItem passwordItem, String sshKeyFile, Continuation $completion) {
        return $this.doGet(uri, userNameItem, passwordItem, sshKeyFile, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Repository access$getRepository$p(JGitCredentialsProvider $this) {
        return $this.repository;
    }
}

