/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.settingsSync;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.lang.reflect.Field;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.settingsSync.GenerationCodeStylePanel;

public class YAMLLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings originalSettings) {
        if (settings == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (originalSettings == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return new CodeStyleAbstractConfigurable(this, settings, originalSettings, YAMLLanguage.INSTANCE.getDisplayName()){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                CodeStyleSettings currentSettings = this.getCurrentSettings();
                return new TabbedLanguageCodeStylePanel(this, YAMLLanguage.INSTANCE, currentSettings, settings){

                    protected void initTabs(CodeStyleSettings settings) {
                        this.addIndentOptionsTab(settings);
                        this.addSpacesTab(settings);
                        this.addWrappingAndBracesTab(settings);
                        this.addTab(new GenerationCodeStylePanel(settings, YAMLLanguage.INSTANCE));
                    }
                };
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.yaml";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/yaml/settingsSync/YAMLLanguageCodeStyleSettingsProvider$1", "createPanel"));
            }
        };
    }

    public String getConfigurableDisplayName() {
        return YAMLLanguage.INSTANCE.getDisplayName();
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return new YAMLCodeStyleSettings(settings);
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (indentOptions == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        commonSettings.SPACE_WITHIN_BRACES = true;
        commonSettings.SPACE_WITHIN_BRACKETS = true;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new YAMLIndentOptionsEditor(this);
    }

    @NotNull
    public Language getLanguage() {
        YAMLLanguage yAMLLanguage = YAMLLanguage.INSTANCE;
        if (yAMLLanguage == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        return yAMLLanguage;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INDENT_SIZE", "KEEP_INDENTS_ON_EMPTY_LINES"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_WITHIN_BRACES", "SPACE_WITHIN_BRACKETS"});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "SPACE_BEFORE_COLON", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.label.before", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_LINE_BREAKS"});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "ALIGN_VALUES_PROPERTIES", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.values", new Object[0]), null, new Object[]{Holder.ALIGN_OPTIONS, Holder.ALIGN_VALUES});
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "SEQUENCE_ON_NEW_LINE", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.sequence.on.new.line", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value", new Object[0]), new Object[0]);
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "BLOCK_MAPPING_ON_NEW_LINE", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.block.mapping.on.new.line", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value", new Object[0]), new Object[0]);
            consumer.showCustomOption(YAMLCodeStyleSettings.class, "AUTOINSERT_SEQUENCE_MARKER", YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.autoinsert.sequence.marker", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.group.sequence.value", new Object[0]), new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_AT_FIRST_COLUMN.name(), CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_ADD_SPACE.name(), CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_ADD_SPACE_ON_REFORMAT.name()});
        }
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return CodeStyleAbstractPanel.readFromFile(YAMLBundle.class, (String)"indents.yml");
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        if (field == null) {
            YAMLLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        if (codeStyleObject instanceof YAMLCodeStyleSettings && "ALIGN_VALUES_PROPERTIES".equals(field.getName())) {
            return new MagicIntegerConstAccessor(codeStyleObject, field, Holder.ALIGN_VALUES, new String[]{"do_not_align", "on_colon", "on_value"});
        }
        return super.getAccessor(codeStyleObject, field);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/settingsSync/YAMLLanguageCodeStyleSettingsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/settingsSync/YAMLLanguageCodeStyleSettingsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class YAMLIndentOptionsEditor
    extends SmartIndentOptionsEditor {
        private JCheckBox myIndentSequence;

        YAMLIndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider) {
            super(provider);
        }

        protected void addComponents() {
            super.addComponents();
            this.myIndentSequence = new JCheckBox(YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.indent.sequence.value", new Object[0]));
            this.add(this.myIndentSequence);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.myIndentSequence.setEnabled(enabled);
        }

        public boolean isModified(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            if (settings == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(0);
            }
            if (options == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(1);
            }
            boolean isModified = super.isModified(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            return isModified |= YAMLIndentOptionsEditor.isFieldModified((JCheckBox)this.myIndentSequence, (boolean)yamlSettings.INDENT_SEQUENCE_VALUE);
        }

        public void apply(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            if (settings == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(2);
            }
            if (options == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(3);
            }
            super.apply(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            yamlSettings.INDENT_SEQUENCE_VALUE = this.myIndentSequence.isSelected();
        }

        public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
            if (settings == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(4);
            }
            if (options == null) {
                YAMLIndentOptionsEditor.$$$reportNull$$$0(5);
            }
            super.reset(settings, options);
            YAMLCodeStyleSettings yamlSettings = (YAMLCodeStyleSettings)settings.getCustomSettings(YAMLCodeStyleSettings.class);
            this.myIndentSequence.setSelected(yamlSettings.INDENT_SEQUENCE_VALUE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/yaml/settingsSync/YAMLLanguageCodeStyleSettingsProvider$YAMLIndentOptionsEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isModified";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Holder {
        private static final int[] ALIGN_VALUES = new int[]{0, 2, 1};
        private static final String[] ALIGN_OPTIONS = new String[]{YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.no", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.colon", new Object[0]), YAMLBundle.message("YAMLLanguageCodeStyleSettingsProvider.align.options.value", new Object[0])};

        private Holder() {
        }
    }
}

