/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public final class PathManagerEx {
    private static final ConcurrentMap<Class<?>, TestDataLookupStrategy> CLASS_STRATEGY_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();
    private static Set<String> ourCommunityModules;
    private static final List<Pair<TestDataLookupStrategy, String>> TEST_DATA_RELATIVE_PATHS;

    private PathManagerEx() {
    }

    public static String getTestDataPath() throws IllegalStateException {
        TestDataLookupStrategy strategy = PathManagerEx.guessTestDataLookupStrategy();
        return PathManagerEx.getTestDataPath(strategy);
    }

    public static String getTestDataPath(String relativePath) throws IllegalStateException {
        return PathManagerEx.getTestDataPath() + FileUtil.toSystemDependentName((String)relativePath);
    }

    public static String getTestDataPath(Class<?> testClass) throws IllegalStateException {
        TestDataLookupStrategy strategy = PathManagerEx.isLocatedInCommunity() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.determineLookupStrategy(testClass);
        return PathManagerEx.getTestDataPath(strategy);
    }

    @NotNull
    public static String getCommunityHomePath() {
        String string = PlatformTestUtil.getCommunityPath();
        if (string == null) {
            PathManagerEx.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String getHomePath(Class<?> testClass) {
        TestDataLookupStrategy strategy = PathManagerEx.isLocatedInCommunity() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.determineLookupStrategy(testClass);
        return strategy == TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE ? PathManagerEx.getCommunityHomePath() : PathManager.getHomePath();
    }

    @NotNull
    public static File findFileUnderCommunityHome(@NotNull String relativePath) {
        if (relativePath == null) {
            PathManagerEx.$$$reportNull$$$0(1);
        }
        File file = PathManagerEx.findFileByRelativePath(PathManagerEx.getCommunityHomePath(), relativePath).toFile();
        if (file == null) {
            PathManagerEx.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public static File findFileUnderProjectHome(@NotNull String relativePath, Class<? extends TestCase> testClass) {
        if (relativePath == null) {
            PathManagerEx.$$$reportNull$$$0(3);
        }
        File file = PathManagerEx.findFileByRelativePath(PathManagerEx.getHomePath(testClass), relativePath).toFile();
        if (file == null) {
            PathManagerEx.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    private static Path findFileByRelativePath(@NotNull String homePath, @NotNull String relativePath) {
        Path file;
        if (homePath == null) {
            PathManagerEx.$$$reportNull$$$0(5);
        }
        if (relativePath == null) {
            PathManagerEx.$$$reportNull$$$0(6);
        }
        if (!Files.exists(file = Paths.get(homePath, relativePath), new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot find file '" + relativePath + "' under '" + homePath + "' directory");
        }
        Path path = file;
        if (path == null) {
            PathManagerEx.$$$reportNull$$$0(7);
        }
        return path;
    }

    private static boolean isLocatedInCommunity() {
        FileSystemLocation projectLocation = PathManagerEx.parseProjectLocation();
        return projectLocation == FileSystemLocation.COMMUNITY;
    }

    public static String getTestDataPath(TestDataLookupStrategy strategy) throws IllegalStateException {
        String homePath = PathManager.getHomePath();
        for (Pair<TestDataLookupStrategy, String> pair : TEST_DATA_RELATIVE_PATHS) {
            File candidate;
            if (pair.first != strategy || !(candidate = new File(homePath, (String)pair.second)).isDirectory()) continue;
            return candidate.getPath();
        }
        throw new IllegalStateException("Can't determine test data path for strategy '" + String.valueOf((Object)strategy) + "' relative to home '" + homePath + "'. Configured mappings: " + String.valueOf(TEST_DATA_RELATIVE_PATHS));
    }

    public static TestDataLookupStrategy guessTestDataLookupStrategy() {
        TestDataLookupStrategy result = PathManagerEx.guessTestDataLookupStrategyOnClassLocation();
        if (result == null) {
            result = PathManagerEx.guessTestDataLookupStrategyOnDirectoryAvailability();
        }
        return result;
    }

    @Nullable
    private static TestDataLookupStrategy guessTestDataLookupStrategyOnClassLocation() {
        StackTraceElement[] stackTrace;
        if (PathManagerEx.isLocatedInCommunity()) {
            return TestDataLookupStrategy.COMMUNITY;
        }
        Class<?> testClass = null;
        Class<?> abstractTestClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new Exception().getStackTrace()) {
            String className = stackTraceElement.getClassName();
            Class<?> clazz = PathManagerEx.loadClass(className);
            if (clazz == null || TestCase.class == clazz || !PathManagerEx.isJUnitClass(clazz)) continue;
            if (PathManagerEx.determineLookupStrategy(clazz) == TestDataLookupStrategy.ULTIMATE) {
                return TestDataLookupStrategy.ULTIMATE;
            }
            if (!Modifier.isAbstract(clazz.getModifiers())) {
                testClass = clazz;
                continue;
            }
            abstractTestClass = clazz;
        }
        Class<?> classToUse = testClass == null ? abstractTestClass : testClass;
        return classToUse == null ? null : PathManagerEx.determineLookupStrategy(classToUse);
    }

    @Nullable
    private static Class<?> loadClass(String className) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = (Class<?>)CLASS_CACHE.get(className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader definingClassLoader = PathManagerEx.class.getClassLoader();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        for (ClassLoader classLoader : Arrays.asList(contextClassLoader, definingClassLoader, systemClassLoader)) {
            clazz = PathManagerEx.loadClass(className, classLoader);
            if (clazz == null) continue;
            CLASS_CACHE.put(className, clazz);
            return clazz;
        }
        CLASS_CACHE.put(className, TestCase.class);
        return null;
    }

    @Nullable
    private static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private static boolean isJUnitClass(Class<?> clazz) {
        return TestCase.class.isAssignableFrom(clazz) || TestFrameworkUtil.isJUnit4TestClass(clazz, true) || Parameterized.class.isAssignableFrom(clazz);
    }

    private static TestDataLookupStrategy determineLookupStrategy(Class<?> clazz) {
        TestDataLookupStrategy result = (TestDataLookupStrategy)((Object)CLASS_STRATEGY_CACHE.get(clazz));
        if (result != null) {
            return result;
        }
        FileSystemLocation location = PathManagerEx.computeClassLocation(clazz);
        result = location == FileSystemLocation.COMMUNITY ? TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE : TestDataLookupStrategy.ULTIMATE;
        CLASS_STRATEGY_CACHE.put(clazz, result);
        return result;
    }

    public static void replaceLookupStrategy(Class<?> substitutor, Class<?> ... initial) {
        TestDataLookupStrategy strategy = PathManagerEx.determineLookupStrategy(substitutor);
        CLASS_STRATEGY_CACHE.clear();
        for (Class<?> aClass : initial) {
            CLASS_STRATEGY_CACHE.put(aClass, strategy);
        }
    }

    private static FileSystemLocation computeClassLocation(Class<?> clazz) {
        String classRootPath = PathManager.getJarPathForClass(clazz);
        if (classRootPath == null) {
            throw new IllegalStateException("Cannot find root directory for " + String.valueOf(clazz));
        }
        File root = new File(classRootPath);
        if (!root.exists()) {
            throw new IllegalStateException("Classes root " + String.valueOf(root) + " doesn't exist");
        }
        if (!root.isDirectory()) {
            String relevantJarsRoot = ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation();
            Map mapping = ArchivedCompilationContextUtil.getArchivedCompiledClassesMapping();
            if (relevantJarsRoot != null && mapping != null && root.toPath().toAbsolutePath().startsWith(relevantJarsRoot)) {
                String moduleName = root.getParentFile().getName();
                if (mapping.containsKey(moduleName)) {
                    return PathManagerEx.getCommunityModules().contains(moduleName) ? FileSystemLocation.COMMUNITY : FileSystemLocation.ULTIMATE;
                }
                return ContainerUtil.exists(PathManagerEx.getCommunityModules(), s -> Objects.equals(mapping.get("production/" + s), classRootPath) || Objects.equals(mapping.get("test/" + s), classRootPath)) ? FileSystemLocation.COMMUNITY : FileSystemLocation.ULTIMATE;
            }
            return FileSystemLocation.ULTIMATE;
        }
        String moduleName = root.getName();
        return PathManagerEx.getCommunityModules().contains(moduleName) ? FileSystemLocation.COMMUNITY : FileSystemLocation.ULTIMATE;
    }

    private static synchronized Set<String> getCommunityModules() {
        if (ourCommunityModules != null) {
            return ourCommunityModules;
        }
        ourCommunityModules = new HashSet<String>();
        File modulesXml = PathManagerEx.findFileUnderCommunityHome(".idea/modules.xml");
        if (!modulesXml.exists()) {
            throw new IllegalStateException("Cannot obtain test data path: " + modulesXml.getAbsolutePath() + " not found");
        }
        try {
            Element element = JDomSerializationUtil.findComponent((Element)JDOMUtil.load((File)modulesXml), (String)"ProjectModuleManager");
            assert (element != null);
            for (ModulePath file : ModulePath.Companion.getPathsToModuleFiles(element)) {
                ourCommunityModules.add(file.getModuleName());
            }
            return ourCommunityModules;
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException("Cannot read modules from " + modulesXml.getAbsolutePath(), e);
        }
    }

    private static FileSystemLocation parseProjectLocation() {
        return new File(PathManager.getHomePath(), "community/.idea").isDirectory() ? FileSystemLocation.ULTIMATE : FileSystemLocation.COMMUNITY;
    }

    private static TestDataLookupStrategy guessTestDataLookupStrategyOnDirectoryAvailability() {
        String homePath = PathManager.getHomePath();
        for (Pair<TestDataLookupStrategy, String> pair : TEST_DATA_RELATIVE_PATHS) {
            if (!new File(homePath, (String)pair.second).isDirectory()) continue;
            return (TestDataLookupStrategy)((Object)pair.first);
        }
        return TestDataLookupStrategy.ULTIMATE;
    }

    static {
        TEST_DATA_RELATIVE_PATHS = Arrays.asList(new Pair((Object)TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE, (Object)FileUtil.toSystemDependentName((String)"community/java/java-tests/testData")), new Pair((Object)TestDataLookupStrategy.COMMUNITY, (Object)FileUtil.toSystemDependentName((String)"java/java-tests/testData")), new Pair((Object)TestDataLookupStrategy.ULTIMATE, (Object)"testData"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ex/PathManagerEx";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ex/PathManagerEx";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileUnderCommunityHome";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileUnderProjectHome";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileUnderCommunityHome";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileUnderProjectHome";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileByRelativePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static enum TestDataLookupStrategy {
        ULTIMATE,
        COMMUNITY,
        COMMUNITY_FROM_ULTIMATE;

    }

    private static enum FileSystemLocation {
        ULTIMATE,
        COMMUNITY;

    }
}

