/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JTabbedPaneTabIndexQuery;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.StringTextMatcher;
import org.assertj.swing.util.TextMatcher;

@InternalApi
public class JTabbedPaneLocation {
    @RunsInCurrentThread
    public int indexOf(@Nonnull JTabbedPane tabbedPane, @Nullable String title) {
        return this.indexOf(tabbedPane, new StringTextMatcher(title));
    }

    @RunsInCurrentThread
    public int indexOf(@Nonnull JTabbedPane tabbedPane, @Nonnull TextMatcher matcher) {
        int index = JTabbedPaneTabIndexQuery.indexOfTab(tabbedPane, matcher);
        if (index >= 0) {
            return index;
        }
        String format = "Unable to find a tab with title matching %s %s";
        String msg = String.format(format, matcher.description(), matcher.formattedValues());
        throw new LocationUnavailableException(msg);
    }

    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTabbedPane tabbedPane, int index) {
        this.checkIndexInBounds(tabbedPane, index);
        Rectangle rect = tabbedPane.getUI().getTabBounds(tabbedPane, index);
        if (rect == null || rect.x < 0) {
            String msg = String.format("The tab %d is not visible", index);
            throw new LocationUnavailableException(msg);
        }
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    @VisibleForTesting
    @RunsInCurrentThread
    void checkIndexInBounds(JTabbedPane tabbedPane, int index) {
        int max = tabbedPane.getTabCount() - 1;
        if (index >= 0 && index <= max) {
            return;
        }
        String format = "Index <%d> is not within the JTabbedPane bounds of <0> and <%d> (inclusive)";
        String msg = String.format(format, index, max);
        throw new IndexOutOfBoundsException(msg);
    }
}

