/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.commandInterface.commandLine.psi.impl;

import com.intellij.commandInterface.command.Argument;
import com.intellij.commandInterface.command.Help;
import com.intellij.commandInterface.command.Option;
import com.intellij.commandInterface.commandLine.CommandLinePart;
import com.intellij.commandInterface.commandLine.ValidationResult;
import com.intellij.commandInterface.commandLine.psi.CommandLineArgument;
import com.intellij.commandInterface.commandLine.psi.CommandLineFile;
import com.intellij.commandInterface.commandLine.psi.CommandLineOption;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommandLinePsiImplUtils {
    private CommandLinePsiImplUtils() {
    }

    static boolean isLong(@NotNull CommandLineOption o) {
        if (o == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(0);
        }
        return o.getLongOptionNameToken() != null;
    }

    @Nullable
    static CommandLineArgument findArgument(@NotNull CommandLineOption option) {
        if (option == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(1);
        }
        if (option.getText().endsWith("=")) {
            return (CommandLineArgument)ObjectUtils.tryCast((Object)option.getNextSibling(), CommandLineArgument.class);
        }
        return null;
    }

    @Nullable
    static Option findRealOption(@NotNull CommandLineOption option) {
        ValidationResult validationResult;
        if (option == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(2);
        }
        if ((validationResult = CommandLinePsiImplUtils.getValidationResult(option)) == null) {
            return null;
        }
        return validationResult.getOption(option);
    }

    @NotNull
    static String getValueNoQuotes(@NotNull CommandLineArgument argument) {
        char[] chars;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(3);
        }
        if ((chars = argument.getText().toCharArray()).length == 0) {
            return "";
        }
        char firstChar = chars[0];
        if (firstChar == chars[chars.length - 1] && firstChar == '\"' || firstChar == '\'') {
            String string = argument.getText().substring(1, argument.getTextLength() - 1);
            if (string == null) {
                CommandLinePsiImplUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = argument.getText();
        if (string == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    static Help findBestHelp(@NotNull CommandLineArgument argument) {
        Option option;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(6);
        }
        if ((option = argument.findOptionForOptionArgument()) != null) {
            return option.getHelp();
        }
        Argument realArgument = argument.findRealArgument();
        return realArgument != null ? realArgument.getHelp() : null;
    }

    @Nullable
    static Argument findRealArgument(@NotNull CommandLineArgument argument) {
        ValidationResult validationResult;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(7);
        }
        if ((validationResult = CommandLinePsiImplUtils.getValidationResult(argument)) == null) {
            return null;
        }
        return validationResult.getArgument(argument);
    }

    @Nullable
    static Option findOptionForOptionArgument(@NotNull CommandLineArgument argument) {
        ValidationResult validationResult;
        if (argument == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(8);
        }
        if ((validationResult = CommandLinePsiImplUtils.getValidationResult(argument)) == null) {
            return null;
        }
        return validationResult.getOptionForOptionArgument(argument);
    }

    @Nullable
    private static ValidationResult getValidationResult(@NotNull CommandLinePart commandLinePart) {
        CommandLineFile commandLineFile;
        if (commandLinePart == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(9);
        }
        if ((commandLineFile = commandLinePart.getCommandLineFile()) == null) {
            return null;
        }
        ValidationResult validationResult = commandLineFile.getValidationResult();
        if (validationResult == null) {
            return null;
        }
        return validationResult;
    }

    @Nullable
    @NonNls
    static String getOptionName(@NotNull CommandLineOption o) {
        PsiElement longNameToken;
        if (o == null) {
            CommandLinePsiImplUtils.$$$reportNull$$$0(10);
        }
        if ((longNameToken = o.getLongOptionNameToken()) != null) {
            return longNameToken.getText();
        }
        PsiElement shortOptionNameToken = o.getShortOptionNameToken();
        if (shortOptionNameToken != null) {
            return shortOptionNameToken.getText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/commandInterface/commandLine/psi/impl/CommandLinePsiImplUtils";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLinePart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/commandInterface/commandLine/psi/impl/CommandLinePsiImplUtils";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueNoQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLong";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findArgument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRealOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueNoQuotes";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBestHelp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRealArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOptionForOptionArgument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValidationResult";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOptionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

