/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.url;

import java.net.MalformedURLException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.url.Credentials;
import uk.co.ben_gibson.url.Fragment;
import uk.co.ben_gibson.url.Host;
import uk.co.ben_gibson.url.Path;
import uk.co.ben_gibson.url.Port;
import uk.co.ben_gibson.url.QueryString;
import uk.co.ben_gibson.url.Scheme;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0001;BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003JY\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u000fJ\u000e\u00102\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0005J\u000e\u00103\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u000bJ\u000e\u00104\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0007J\u000e\u00105\u001a\u00020\u00002\u0006\u00101\u001a\u00020\rJ\u000e\u00106\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0003J\u0006\u00107\u001a\u00020\u0000J\u0006\u00108\u001a\u00020\u0000J\u0006\u00109\u001a\u00020\u0000J\u0006\u0010:\u001a\u00020\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006<"}, d2={"Luk/co/ben_gibson/url/URL;", "", "scheme", "Luk/co/ben_gibson/url/Scheme;", "host", "Luk/co/ben_gibson/url/Host;", "port", "Luk/co/ben_gibson/url/Port;", "credentials", "Luk/co/ben_gibson/url/Credentials;", "path", "Luk/co/ben_gibson/url/Path;", "queryString", "Luk/co/ben_gibson/url/QueryString;", "fragment", "Luk/co/ben_gibson/url/Fragment;", "(Luk/co/ben_gibson/url/Scheme;Luk/co/ben_gibson/url/Host;Luk/co/ben_gibson/url/Port;Luk/co/ben_gibson/url/Credentials;Luk/co/ben_gibson/url/Path;Luk/co/ben_gibson/url/QueryString;Luk/co/ben_gibson/url/Fragment;)V", "getCredentials", "()Luk/co/ben_gibson/url/Credentials;", "getFragment", "()Luk/co/ben_gibson/url/Fragment;", "getHost", "()Luk/co/ben_gibson/url/Host;", "getPath", "()Luk/co/ben_gibson/url/Path;", "getPort", "()Luk/co/ben_gibson/url/Port;", "getQueryString", "()Luk/co/ben_gibson/url/QueryString;", "getScheme", "()Luk/co/ben_gibson/url/Scheme;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toHttp", "toHttps", "toString", "", "withFragment", "value", "withHost", "withPath", "withPort", "withQueryString", "withScheme", "withoutFragment", "withoutPath", "withoutPort", "withoutQueryString", "Companion", "url"})
public final class URL {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scheme scheme;
    @NotNull
    private final Host host;
    @Nullable
    private final Port port;
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final Path path;
    @Nullable
    private final QueryString queryString;
    @Nullable
    private final Fragment fragment;

    public URL(@NotNull Scheme scheme, @NotNull Host host, @Nullable Port port, @Nullable Credentials credentials, @Nullable Path path, @Nullable QueryString queryString, @Nullable Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.credentials = credentials;
        this.path = path;
        this.queryString = queryString;
        this.fragment = fragment;
    }

    public /* synthetic */ URL(Scheme scheme, Host host, Port port, Credentials credentials, Path path, QueryString queryString, Fragment fragment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            port = null;
        }
        if ((n & 8) != 0) {
            credentials = null;
        }
        if ((n & 0x10) != 0) {
            path = null;
        }
        if ((n & 0x20) != 0) {
            queryString = null;
        }
        if ((n & 0x40) != 0) {
            fragment = null;
        }
        this(scheme, host, port, credentials, path, queryString, fragment);
    }

    @NotNull
    public final Scheme getScheme() {
        return this.scheme;
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    @Nullable
    public final Port getPort() {
        return this.port;
    }

    @Nullable
    public final Credentials getCredentials() {
        return this.credentials;
    }

    @Nullable
    public final Path getPath() {
        return this.path;
    }

    @Nullable
    public final QueryString getQueryString() {
        return this.queryString;
    }

    @Nullable
    public final Fragment getFragment() {
        return this.fragment;
    }

    @NotNull
    public final URL withScheme(@NotNull Scheme value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new URL(value, this.host, this.port, this.credentials, this.path, this.queryString, this.fragment);
    }

    @NotNull
    public final URL withHost(@NotNull Host value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new URL(this.scheme, value, this.port, this.credentials, this.path, this.queryString, this.fragment);
    }

    @NotNull
    public final URL withPort(@NotNull Port value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new URL(this.scheme, this.host, value, this.credentials, this.path, this.queryString, this.fragment);
    }

    @NotNull
    public final URL withPath(@NotNull Path value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new URL(this.scheme, this.host, this.port, this.credentials, value, this.queryString, this.fragment);
    }

    @NotNull
    public final URL withQueryString(@NotNull QueryString value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new URL(this.scheme, this.host, this.port, this.credentials, this.path, value, this.fragment);
    }

    @NotNull
    public final URL withFragment(@NotNull Fragment value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new URL(this.scheme, this.host, this.port, this.credentials, this.path, this.queryString, value);
    }

    @NotNull
    public final URL withoutPort() {
        return new URL(this.scheme, this.host, null, this.credentials, this.path, this.queryString, this.fragment);
    }

    @NotNull
    public final URL withoutPath() {
        return new URL(this.scheme, this.host, this.port, this.credentials, null, this.queryString, this.fragment);
    }

    @NotNull
    public final URL withoutQueryString() {
        return new URL(this.scheme, this.host, this.port, this.credentials, this.path, null, this.fragment);
    }

    @NotNull
    public final URL withoutFragment() {
        return new URL(this.scheme, this.host, this.port, this.credentials, this.path, this.queryString, null);
    }

    @NotNull
    public final URL toHttps() {
        return this.withScheme(Scheme.Companion.https());
    }

    @NotNull
    public final URL toHttp() {
        return this.withScheme(Scheme.Companion.http());
    }

    @NotNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder;
        block15: {
            block14: {
                Object object2;
                StringBuilder stringBuilder2;
                StringBuilder stringBuilder3;
                Object it;
                block13: {
                    block12: {
                        Object object3;
                        StringBuilder stringBuilder4;
                        block11: {
                            block10: {
                                Object object4;
                                StringBuilder stringBuilder5;
                                block9: {
                                    block8: {
                                        stringBuilder5 = new StringBuilder().append(this.scheme).append("://").append(this.host);
                                        object4 = this.port;
                                        if (object4 == null) break block8;
                                        it = object4;
                                        stringBuilder3 = stringBuilder5;
                                        boolean bl = false;
                                        String string = "" + ':' + it;
                                        stringBuilder5 = stringBuilder3;
                                        object4 = string;
                                        if (string != null) break block9;
                                    }
                                    object4 = "";
                                }
                                stringBuilder4 = stringBuilder5.append((String)object4);
                                object3 = this.path;
                                if (object3 == null) break block10;
                                it = object3;
                                stringBuilder3 = stringBuilder4;
                                boolean bl = false;
                                String string = "" + '/' + it;
                                stringBuilder4 = stringBuilder3;
                                object3 = string;
                                if (string != null) break block11;
                            }
                            object3 = "";
                        }
                        stringBuilder2 = stringBuilder4.append((String)object3);
                        object2 = this.queryString;
                        if (object2 == null) break block12;
                        it = object2;
                        stringBuilder3 = stringBuilder2;
                        boolean bl = false;
                        String string = "" + '?' + it;
                        stringBuilder2 = stringBuilder3;
                        object2 = string;
                        if (string != null) break block13;
                    }
                    object2 = "";
                }
                stringBuilder = stringBuilder2.append((String)object2);
                object = this.fragment;
                if (object == null) break block14;
                it = object;
                stringBuilder3 = stringBuilder;
                boolean bl = false;
                String string = "" + '#' + it;
                stringBuilder = stringBuilder3;
                object = string;
                if (string != null) break block15;
            }
            object = "";
        }
        return stringBuilder.append((String)object).toString();
    }

    @NotNull
    public final Scheme component1() {
        return this.scheme;
    }

    @NotNull
    public final Host component2() {
        return this.host;
    }

    @Nullable
    public final Port component3() {
        return this.port;
    }

    @Nullable
    public final Credentials component4() {
        return this.credentials;
    }

    @Nullable
    public final Path component5() {
        return this.path;
    }

    @Nullable
    public final QueryString component6() {
        return this.queryString;
    }

    @Nullable
    public final Fragment component7() {
        return this.fragment;
    }

    @NotNull
    public final URL copy(@NotNull Scheme scheme, @NotNull Host host, @Nullable Port port, @Nullable Credentials credentials, @Nullable Path path, @Nullable QueryString queryString, @Nullable Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new URL(scheme, host, port, credentials, path, queryString, fragment);
    }

    public static /* synthetic */ URL copy$default(URL uRL, Scheme scheme, Host host, Port port, Credentials credentials, Path path, QueryString queryString, Fragment fragment, int n, Object object) {
        if ((n & 1) != 0) {
            scheme = uRL.scheme;
        }
        if ((n & 2) != 0) {
            host = uRL.host;
        }
        if ((n & 4) != 0) {
            port = uRL.port;
        }
        if ((n & 8) != 0) {
            credentials = uRL.credentials;
        }
        if ((n & 0x10) != 0) {
            path = uRL.path;
        }
        if ((n & 0x20) != 0) {
            queryString = uRL.queryString;
        }
        if ((n & 0x40) != 0) {
            fragment = uRL.fragment;
        }
        return uRL.copy(scheme, host, port, credentials, path, queryString, fragment);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = result * 31 + this.host.hashCode();
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.credentials == null ? 0 : this.credentials.hashCode());
        result = result * 31 + (this.path == null ? 0 : this.path.hashCode());
        result = result * 31 + (this.queryString == null ? 0 : this.queryString.hashCode());
        result = result * 31 + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URL)) {
            return false;
        }
        URL uRL = (URL)other;
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)uRL.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)uRL.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)uRL.port)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.credentials, (Object)uRL.credentials)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)uRL.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.queryString, (Object)uRL.queryString)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fragment, (Object)uRL.fragment);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Luk/co/ben_gibson/url/URL$Companion;", "", "()V", "fromString", "Luk/co/ben_gibson/url/URL;", "value", "", "url"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URL fromString(@NotNull String value) {
            Fragment fragment;
            QueryString queryString;
            QueryString queryString2;
            Path path;
            Port port;
            int it;
            Credentials credentials;
            char[] cArray;
            java.net.URL uRL;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                uRL = new java.net.URL(value);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL");
            }
            java.net.URL url = uRL;
            Object object = url.getUserInfo();
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{':'}), (boolean)false, (int)0, (int)6, null)) != null) {
                Object it2 = object;
                boolean bl = false;
                credentials = new Credentials((String)it2.get(0), (String)CollectionsKt.getOrNull((List)it2, (int)1));
            } else {
                credentials = null;
            }
            Credentials credentials2 = credentials;
            String string = url.getProtocol();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.protocol");
            Scheme scheme = Scheme.Companion.invoke(string);
            String string2 = url.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.host");
            Object object2 = url.getPort();
            int n = ((Number)object2).intValue();
            Host host = Host.Companion.invoke(string2);
            Scheme scheme2 = scheme;
            boolean bl = false;
            boolean bl2 = it > -1;
            Scheme scheme3 = scheme2;
            Host host2 = host;
            Object object3 = bl2 ? object2 : null;
            if (object3 != null) {
                it = ((Number)object3).intValue();
                host = host2;
                scheme2 = scheme3;
                boolean bl3 = false;
                Port port2 = new Port(it);
                scheme3 = scheme2;
                host2 = host;
                port = port2;
            } else {
                port = null;
            }
            Object it2 = object2 = url.getPath();
            Credentials credentials3 = credentials2;
            Port port3 = port;
            host = host2;
            scheme2 = scheme3;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            boolean bl5 = ((CharSequence)it2).length() > 0;
            Scheme scheme4 = scheme2;
            Host host3 = host;
            Port port4 = port3;
            Credentials credentials4 = credentials3;
            Object object4 = bl5 ? object2 : null;
            if (object4 != null) {
                it2 = object4;
                credentials3 = credentials4;
                port3 = port4;
                host = host3;
                scheme2 = scheme4;
                boolean bl6 = false;
                Path path2 = Path.Companion.invoke((String)it2);
                scheme4 = scheme2;
                host3 = host;
                port4 = port3;
                credentials4 = credentials3;
                path = path2;
            } else {
                path = null;
            }
            String string3 = url.getQuery();
            if (string3 != null) {
                it2 = string3;
                Path path3 = path;
                credentials3 = credentials4;
                port3 = port4;
                host = host3;
                scheme2 = scheme4;
                boolean bl7 = false;
                queryString2 = QueryString.Companion.invoke((String)it2);
                scheme4 = scheme2;
                host3 = host;
                port4 = port3;
                credentials4 = credentials3;
                path = path3;
                queryString = queryString2;
            } else {
                queryString = null;
            }
            String string4 = url.getRef();
            if (string4 != null) {
                it2 = string4;
                queryString2 = queryString;
                Path path4 = path;
                credentials3 = credentials4;
                port3 = port4;
                host = host3;
                scheme2 = scheme4;
                boolean bl8 = false;
                Fragment fragment2 = Fragment.Companion.invoke((String)it2);
                scheme4 = scheme2;
                host3 = host;
                port4 = port3;
                credentials4 = credentials3;
                path = path4;
                queryString = queryString2;
                fragment = fragment2;
            } else {
                fragment = null;
            }
            Fragment fragment3 = fragment;
            QueryString queryString3 = queryString;
            Path path5 = path;
            Credentials credentials5 = credentials4;
            Port port5 = port4;
            Host host4 = host3;
            Scheme scheme5 = scheme4;
            return new URL(scheme5, host4, port5, credentials5, path5, queryString3, fragment3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

