/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.pipeline.middleware;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import git4idea.GitLocalBranch;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.Context;
import uk.co.ben_gibson.git.link.ContextCommit;
import uk.co.ben_gibson.git.link.ContextCurrentFile;
import uk.co.ben_gibson.git.link.ContextFileAtCommit;
import uk.co.ben_gibson.git.link.git.Commit;
import uk.co.ben_gibson.git.link.git.File;
import uk.co.ben_gibson.git.link.git.RemoteExtensionsKt;
import uk.co.ben_gibson.git.link.git.RepositoryExtensionsKt;
import uk.co.ben_gibson.git.link.pipeline.Pass;
import uk.co.ben_gibson.git.link.pipeline.middleware.Middleware;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.settings.ProjectSettings;
import uk.co.ben_gibson.git.link.url.UrlOptions;
import uk.co.ben_gibson.git.link.url.factory.UrlFactoryLocator;
import uk.co.ben_gibson.url.URL;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J#\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0010H\u0096\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Luk/co/ben_gibson/git/link/pipeline/middleware/GenerateUrl;", "Luk/co/ben_gibson/git/link/pipeline/middleware/Middleware;", "()V", "priority", "", "getPriority", "()I", "createUrlOptions", "Luk/co/ben_gibson/git/link/url/UrlOptions;", "pass", "Luk/co/ben_gibson/git/link/pipeline/Pass;", "pullRequestWorkflowSupported", "", "invoke", "Luk/co/ben_gibson/url/URL;", "next", "Lkotlin/Function0;", "resolveBranch", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "settings", "Luk/co/ben_gibson/git/link/settings/ProjectSettings;", "resolveCommit", "Luk/co/ben_gibson/git/link/git/Commit;", "GitLink"})
@SourceDebugExtension(value={"SMAP\nGenerateUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateUrl.kt\nuk/co/ben_gibson/git/link/pipeline/middleware/GenerateUrl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n43#2,3:93\n30#3,3:96\n*S KotlinDebug\n*F\n+ 1 GenerateUrl.kt\nuk/co/ben_gibson/git/link/pipeline/middleware/GenerateUrl\n*L\n28#1:93,3\n35#1:96,3\n*E\n"})
public final class GenerateUrl
implements Middleware {
    private final int priority;

    public GenerateUrl() {
        this.priority = 50;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @Nullable
    public URL invoke(@NotNull Pass pass, @NotNull Function0<URL> next2) {
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        Intrinsics.checkNotNullParameter(next2, (String)"next");
        URL uRL = RemoteExtensionsKt.getHttpUrl(pass.remoteOrThrow());
        if (uRL == null) {
            return null;
        }
        URL baseUrl = uRL;
        Platform platform = pass.platformOrThrow();
        UrlOptions options = this.createUrlOptions(pass, platform.getPullRequestWorkflowSupported());
        boolean $i$f$service = false;
        Class<UrlFactoryLocator> serviceClass$iv = UrlFactoryLocator.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return ((UrlFactoryLocator)object).locate(platform).createUrl(baseUrl, options);
    }

    private final UrlOptions createUrlOptions(Pass pass, boolean pullRequestWorkflowSupported) {
        UrlOptions urlOptions;
        GitRemote remote = pass.remoteOrThrow();
        GitRepository repository = pass.repositoryOrThrow();
        Context context = pass.getContext();
        ComponentManager $this$service$iv = (ComponentManager)pass.getProject();
        boolean $i$f$service = false;
        Object serviceClass$iv = ProjectSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ProjectSettings settings2 = (ProjectSettings)object;
        File repositoryFile = File.Companion.forRepository(context.getFile(), repository);
        Context context2 = context;
        if (context2 instanceof ContextFileAtCommit) {
            Object object2 = repository.getCurrentBranch();
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = settings2.getFallbackBranch();
            }
            serviceClass$iv = object2;
            Intrinsics.checkNotNull((Object)serviceClass$iv);
            urlOptions = new UrlOptions.UrlOptionsFileAtCommit(repositoryFile, (String)serviceClass$iv, ((ContextFileAtCommit)context).getCommit(), ((ContextFileAtCommit)context).getLineSelection());
        } else if (context2 instanceof ContextCommit) {
            Commit commit = ((ContextCommit)context).getCommit();
            Object object3 = repository.getCurrentBranch();
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = settings2.getFallbackBranch();
            }
            serviceClass$iv = object3;
            Intrinsics.checkNotNull((Object)serviceClass$iv);
            urlOptions = new UrlOptions.UrlOptionsCommit(commit, (String)serviceClass$iv);
        } else if (context2 instanceof ContextCurrentFile) {
            Commit commit = this.resolveCommit(repository, remote, settings2, pullRequestWorkflowSupported);
            if (commit != null) {
                Object object4 = repository.getCurrentBranch();
                if (object4 == null || (object4 = object4.getName()) == null) {
                    object4 = settings2.getFallbackBranch();
                }
                object = object4;
                Intrinsics.checkNotNull((Object)object);
                urlOptions = new UrlOptions.UrlOptionsFileAtCommit(repositoryFile, (String)object, commit, ((ContextCurrentFile)context).getLineSelection());
            } else {
                urlOptions = new UrlOptions.UrlOptionsFileAtBranch(repositoryFile, this.resolveBranch(repository, remote, settings2), ((ContextCurrentFile)context).getLineSelection());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return urlOptions;
    }

    private final String resolveBranch(GitRepository repository, GitRemote remote, ProjectSettings settings2) {
        String string;
        GitLocalBranch gitLocalBranch = repository.getCurrentBranch();
        if (gitLocalBranch == null) {
            return settings2.getFallbackBranch();
        }
        GitLocalBranch branch = gitLocalBranch;
        if (!settings2.getShouldCheckRemote()) {
            String string2 = branch.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return string2;
        }
        if (RemoteExtensionsKt.contains(remote, repository, branch)) {
            String string3 = branch.getName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        } else {
            string = settings2.getFallbackBranch();
        }
        return string;
    }

    private final Commit resolveCommit(GitRepository repository, GitRemote remote, ProjectSettings settings2, boolean pullRequestWorkflowSupported) {
        Commit commit = RepositoryExtensionsKt.currentCommit(repository);
        if (commit == null) {
            return null;
        }
        Commit commit2 = commit;
        if (!pullRequestWorkflowSupported || !settings2.getShouldCheckRemote()) {
            return commit2;
        }
        return RemoteExtensionsKt.contains(remote, repository, commit2) ? commit2 : null;
    }

    @Override
    public int compareTo(@NotNull Middleware other) {
        return Middleware.DefaultImpls.compareTo(this, other);
    }
}

