/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.KeyStrokeAdapter;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.ActionEnableStatus;
import com.maddyhome.idea.vim.action.LogLevel;
import com.maddyhome.idea.vim.action.VimShortcutKeyActionKt;
import com.maddyhome.idea.vim.api.NativeAction;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.group.IjOptions;
import com.maddyhome.idea.vim.handler.VimEnterHandlerKt;
import com.maddyhome.idea.vim.helper.CaretVisualAttributesHelperKt;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.helper.HandlerInjector;
import com.maddyhome.idea.vim.key.ShortcutOwner;
import com.maddyhome.idea.vim.key.ShortcutOwnerInfo;
import com.maddyhome.idea.vim.listener.AceJumpService;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.ui.ex.ExEntryPanel;
import com.maddyhome.idea.vim.ui.ex.ExTextField;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0002\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/maddyhome/idea/vim/action/VimShortcutKeyAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "traceTime", "", "getTraceTime", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "isEnabled", "Lcom/maddyhome/idea/vim/action/ActionEnableStatus;", "keyStroke", "Ljavax/swing/KeyStroke;", "isEnabledForEscape", "editor", "Lcom/intellij/openapi/editor/Editor;", "isShortcutConflict", "keyStrokeCache", "Lkotlin/Pair;", "", "getKeyStroke", "getEditor", "LookupKeys", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimShortcutKeyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimShortcutKeyAction.kt\ncom/maddyhome/idea/vim/action/VimShortcutKeyAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,368:1\n13#2:369\n*S KotlinDebug\n*F\n+ 1 VimShortcutKeyAction.kt\ncom/maddyhome/idea/vim/action/VimShortcutKeyAction\n*L\n321#1:369\n*E\n"})
public final class VimShortcutKeyAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Pair<Long, ? extends KeyStroke> keyStrokeCache;
    @JvmField
    @NotNull
    public static final Set<KeyStroke> VIM_ONLY_EDITOR_KEYS;
    @NotNull
    private static final String ACTION_ID = "VimShortcutKeyAction";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<AnActionWrapper> instance$delegate;

    public VimShortcutKeyAction() {
        IjVimInjectorKt.initInjector();
        this.keyStrokeCache = TuplesKt.to(null, null);
    }

    private final boolean getTraceTime() {
        return VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getIdeatracetime();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LOG.trace("Executing shortcut key action");
        Editor editor = this.getEditor(e);
        KeyStroke keyStroke = this.getKeyStroke(e);
        if (editor != null && keyStroke != null) {
            ShortcutOwnerInfo owner = (ShortcutOwnerInfo)VimPlugin.getKey().getSavedShortcutConflicts().get(keyStroke);
            ShortcutOwnerInfo.AllModes allModes = owner instanceof ShortcutOwnerInfo.AllModes ? (ShortcutOwnerInfo.AllModes)owner : null;
            if ((allModes != null ? allModes.getOwner() : null) == ShortcutOwner.UNDEFINED) {
                VimPlugin.getNotifications(editor.getProject()).notifyAboutShortcutConflict(keyStroke);
            }
            try {
                Long start2 = this.getTraceTime() ? Long.valueOf(System.currentTimeMillis()) : null;
                KeyHandler keyHandler = KeyHandler.Companion.getInstance();
                VimEditor vimEditor = IjVimEditorKt.getVim(editor);
                DataContext dataContext = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                keyHandler.handleKey(vimEditor, keyStroke, IjEditorExecutionContextKt.getVim(dataContext), keyHandler.getKeyHandlerState());
                if (start2 != null) {
                    long duration = System.currentTimeMillis() - start2;
                    LOG.info("VimShortcut execution '" + keyStroke + "': " + duration + " ms");
                }
            }
            catch (ProcessCanceledException e2) {
                throw e2;
            }
            catch (Throwable throwable) {
                LOG.error(throwable);
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Long start2 = this.getTraceTime() ? Long.valueOf(System.currentTimeMillis()) : null;
        KeyStroke keyStroke = this.getKeyStroke(e);
        ActionEnableStatus actionEnableStatus = this.isEnabled(e, keyStroke);
        e.getPresentation().setEnabled(actionEnableStatus.isEnabled());
        actionEnableStatus.printLog(keyStroke);
        if (start2 != null) {
            long duration = System.currentTimeMillis() - start2;
            LOG.info("VimShortcut update '" + keyStroke + "': " + duration + " ms");
        }
    }

    private final ActionEnableStatus isEnabled(AnActionEvent e, KeyStroke keyStroke) {
        ShortcutOwnerInfo info;
        if (keyStroke == null) {
            return ActionEnableStatus.Companion.no("Keystroke is null", LogLevel.DEBUG);
        }
        if (VimPlugin.isNotEnabled()) {
            return ActionEnableStatus.Companion.no("IdeaVim is disabled", LogLevel.DEBUG);
        }
        Editor editor = this.getEditor(e);
        if (editor == null) {
            return ActionEnableStatus.Companion.no("Can't get Editor", LogLevel.DEBUG);
        }
        Editor editor2 = editor;
        if (VimEnterHandlerKt.getEnableOctopus() && VimEnterHandlerKt.isOctopusEnabled(keyStroke, editor2)) {
            return ActionEnableStatus.Companion.no("Processing VimShortcutKeyAction for the key that is used in the octopus handler", LogLevel.ERROR);
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        if (VimShortcutKeyActionKt.access$isNotSupportedContextComponent(dataContext) && Registry.Companion.is("ideavim.only.in.editor.component")) {
            return ActionEnableStatus.Companion.no("Context component is not editor", LogLevel.INFO);
        }
        if (EditorHelperRt.isIdeaVimDisabledHere(editor2)) {
            return ActionEnableStatus.Companion.no("IdeaVim is disabled in this place", LogLevel.INFO);
        }
        Key SMART_STEP_INPLACE_DATA = Key.findKeyByName((String)"SMART_STEP_INPLACE_DATA");
        if (SMART_STEP_INPLACE_DATA != null && editor2.getUserData(SMART_STEP_INPLACE_DATA) != null) {
            LOG.trace("Do not execute shortcut because of smart step");
            return ActionEnableStatus.Companion.no("Smart step into is active", LogLevel.INFO);
        }
        int keyCode = keyStroke.getKeyCode();
        if (HandlerInjector.Companion.notebookCommandMode(editor2)) {
            LOG.debug("Python Notebook command mode");
            switch (keyCode) {
                case 10: 
                case 39: 
                case 227: {
                    ActionsKt.invokeLater$default(null, () -> VimShortcutKeyAction.isEnabled$lambda$0(editor2), (int)1, null);
                }
            }
            return ActionEnableStatus.Companion.no("Python notebook is in command mode", LogLevel.INFO);
        }
        AceJumpService aceJumpService = AceJumpService.Companion.getInstance();
        boolean bl = aceJumpService != null ? aceJumpService.isActive(editor2) : false;
        if (bl) {
            return ActionEnableStatus.Companion.no("AceJump is active", LogLevel.INFO);
        }
        if (LookupManager.getActiveLookup((Editor)editor2) != null && !LookupKeys.INSTANCE.isEnabledForLookup(keyStroke)) {
            return ActionEnableStatus.Companion.no("Lookup keys are active", LogLevel.INFO);
        }
        if (keyCode == 27) {
            return this.isEnabledForEscape(editor2) ? ActionEnableStatus.Companion.yes("Is enabled for Esc", LogLevel.INFO) : ActionEnableStatus.Companion.no("Is disabled for Esc", LogLevel.INFO);
        }
        if (VIM_ONLY_EDITOR_KEYS.contains(keyStroke)) {
            return ActionEnableStatus.Companion.yes("Vim only editor keys", LogLevel.INFO);
        }
        Map savedShortcutConflicts = VimPlugin.getKey().getSavedShortcutConflicts();
        ShortcutOwnerInfo shortcutOwnerInfo = info = (ShortcutOwnerInfo)savedShortcutConflicts.get(keyStroke);
        ShortcutOwner shortcutOwner = shortcutOwnerInfo != null ? shortcutOwnerInfo.forEditor(IjVimEditorKt.getVim(editor2)) : null;
        return switch (shortcutOwner == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shortcutOwner.ordinal()]) {
            case 1 -> ActionEnableStatus.Companion.yes("Owner is vim", LogLevel.DEBUG);
            case 2 -> {
                if (!this.isShortcutConflict(keyStroke)) {
                    yield ActionEnableStatus.Companion.yes("Owner is IDE, but no actionve shortcut conflict", LogLevel.DEBUG);
                }
                yield ActionEnableStatus.Companion.no("Owner is IDE", LogLevel.DEBUG);
            }
            default -> {
                if (this.isShortcutConflict(keyStroke)) {
                    savedShortcutConflicts.put(keyStroke, ShortcutOwnerInfo.allUndefined);
                }
                yield ActionEnableStatus.Companion.yes("Enable vim for shortcut without owner", LogLevel.DEBUG);
            }
        };
    }

    private final boolean isEnabledForEscape(Editor editor) {
        boolean ideaVimSupportDialog = IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeavimsupport().contains((Object)"dialog");
        return EditorHelperRt.isPrimaryEditor(editor) || EditorHelper.isFileEditor(editor) && !CommandStateHelper.getInNormalMode(IjVimEditorKt.getVim(editor).getMode()) || ideaVimSupportDialog && !CommandStateHelper.getInNormalMode(IjVimEditorKt.getVim(editor).getMode());
    }

    private final boolean isShortcutConflict(KeyStroke keyStroke) {
        List<NativeAction> list = VimPlugin.getKey().getKeymapConflicts(keyStroke);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getKeymapConflicts(...)");
        return !((Collection)list).isEmpty();
    }

    private final KeyStroke getKeyStroke(AnActionEvent e) {
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof KeyEvent) {
            KeyStroke defaultKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke((KeyEvent)((KeyEvent)inputEvent));
            Pair<Long, ? extends KeyStroke> strokeCache = this.keyStrokeCache;
            if (defaultKeyStroke != null) {
                this.keyStrokeCache = TuplesKt.to((Object)((KeyEvent)inputEvent).getWhen(), (Object)defaultKeyStroke);
                return defaultKeyStroke;
            }
            Long l = (Long)strokeCache.getFirst();
            long l2 = ((KeyEvent)inputEvent).getWhen();
            if (l != null && l == l2) {
                this.keyStrokeCache = TuplesKt.to(null, null);
                return (KeyStroke)strokeCache.getSecond();
            }
            return KeyStroke.getKeyStrokeForEvent((KeyEvent)inputEvent);
        }
        return null;
    }

    private final Editor getEditor(AnActionEvent e) {
        Object object = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (object == null) {
            object = e.getData(PlatformDataKeys.CONTEXT_COMPONENT) instanceof ExTextField ? ExEntryPanel.Companion.getOrCreatePanelInstance().getIjEditor() : null;
        }
        return object;
    }

    private static final Unit isEnabled$lambda$0(Editor $editor) {
        CaretVisualAttributesHelperKt.updateCaretsVisualAttributes($editor);
        return Unit.INSTANCE;
    }

    private static final AnActionWrapper instance_delegate$lambda$0() {
        AnAction anAction = ActionManager.getInstance().getAction(ACTION_ID);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        return new AnActionWrapper(anAction);
    }

    @NotNull
    public static final AnAction getInstance() {
        return Companion.getInstance();
    }

    static {
        int[] nArray = new int[]{0};
        ImmutableSet.Builder builder = ImmutableSet.builder().addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(10, nArray));
        nArray = new int[]{0};
        ImmutableSet.Builder builder2 = builder.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(27, nArray));
        nArray = new int[]{0};
        ImmutableSet.Builder builder3 = builder2.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(9, nArray));
        nArray = new int[]{0, 128};
        ImmutableSet.Builder builder4 = builder3.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(8, nArray));
        nArray = new int[]{0};
        ImmutableSet.Builder builder5 = builder4.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(155, nArray));
        nArray = new int[]{0, 128};
        ImmutableSet.Builder builder6 = builder5.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(127, nArray));
        nArray = new int[]{0};
        ImmutableSet.Builder builder7 = builder6.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(38, nArray));
        nArray = new int[]{0};
        ImmutableSet.Builder builder8 = builder7.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(40, nArray));
        nArray = new int[]{0};
        ImmutableSet.Builder builder9 = builder8.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(37, nArray));
        nArray = new int[]{0};
        ImmutableSet.Builder builder10 = builder9.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(39, nArray));
        nArray = new int[]{0, 128, 64, 192};
        ImmutableSet.Builder builder11 = builder10.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(36, nArray));
        nArray = new int[]{0, 128, 64, 192};
        ImmutableSet.Builder builder12 = builder11.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(35, nArray));
        nArray = new int[]{0, 64, 192};
        ImmutableSet.Builder builder13 = builder12.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(33, nArray));
        nArray = new int[]{0, 64, 192};
        ImmutableSet immutableSet = builder13.addAll((Iterable)VimShortcutKeyAction.Companion.getKeyStrokes(34, nArray)).build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"build(...)");
        VIM_ONLY_EDITOR_KEYS = (Set)immutableSet;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VimShortcutKeyAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        instance$delegate = LazyKt.lazy(VimShortcutKeyAction::instance_delegate$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00060\u00060\u00132\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00020\u0018\"\u00020\u0016H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u00020\f8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/action/VimShortcutKeyAction$Companion;", "", "<init>", "()V", "VIM_ONLY_EDITOR_KEYS", "", "Ljavax/swing/KeyStroke;", "ACTION_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "instance", "Lcom/intellij/openapi/actionSystem/AnAction;", "getInstance$annotations", "getInstance", "()Lcom/intellij/openapi/actionSystem/AnAction;", "instance$delegate", "Lkotlin/Lazy;", "getKeyStrokes", "", "kotlin.jvm.PlatformType", "keyCode", "", "modifiers", "", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimShortcutKeyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimShortcutKeyAction.kt\ncom/maddyhome/idea/vim/action/VimShortcutKeyAction$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,368:1\n11591#2:369\n11926#2,3:370\n*S KotlinDebug\n*F\n+ 1 VimShortcutKeyAction.kt\ncom/maddyhome/idea/vim/action/VimShortcutKeyAction$Companion\n*L\n329#1:369\n329#1:370,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnAction getInstance() {
            Lazy lazy = instance$delegate;
            return (AnAction)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<KeyStroke> getKeyStrokes(int keyCode, int ... modifiers) {
            void $this$mapTo$iv$iv;
            int[] $this$map$iv = modifiers;
            boolean $i$f$map = false;
            int[] nArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeyStroke.getKeyStroke(keyCode, (int)it));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/action/VimShortcutKeyAction$LookupKeys;", "", "<init>", "()V", "isEnabledForLookup", "", "keyStroke", "Ljavax/swing/KeyStroke;", "parseLookupKeys", "", "keys", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimString;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimShortcutKeyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimShortcutKeyAction.kt\ncom/maddyhome/idea/vim/action/VimShortcutKeyAction$LookupKeys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1563#2:369\n1634#2,3:370\n774#2:373\n865#2,2:374\n1563#2:376\n1634#2,3:377\n*S KotlinDebug\n*F\n+ 1 VimShortcutKeyAction.kt\ncom/maddyhome/idea/vim/action/VimShortcutKeyAction$LookupKeys\n*L\n265#1:369\n265#1:370,3\n266#1:373\n266#1:374,2\n267#1:376\n267#1:377,3\n*E\n"})
    private static final class LookupKeys {
        @NotNull
        public static final LookupKeys INSTANCE = new LookupKeys();

        private LookupKeys() {
        }

        public final boolean isEnabledForLookup(@NotNull KeyStroke keyStroke) {
            Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
            Set parsedLookupKeys2 = (Set)VimInjectorKt.getInjector().getOptionGroup().getParsedEffectiveOptionValue((Option)IjOptions.INSTANCE.getLookupkeys(), null, (Function1)new Function1<VimString, Set<? extends KeyStroke>>((Object)this){

                public final Set<KeyStroke> invoke(VimString p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return LookupKeys.access$parseLookupKeys((LookupKeys)this.receiver, p0);
                }
            });
            return !parsedLookupKeys2.contains(keyStroke);
        }

        private final Set<KeyStroke> parseLookupKeys(VimString keys) {
            Iterable $this$filterTo$iv$iv;
            List it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = IjOptions.INSTANCE.getLookupkeys().split(keys.getValue());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VimInjectorKt.getInjector().getParser().parseKeys((String)((Object)it)));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (List)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((KeyStroke)CollectionsKt.first((List)it));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public static final /* synthetic */ Set access$parseLookupKeys(LookupKeys $this, VimString keys) {
            return $this.parseLookupKeys(keys);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShortcutOwner.values().length];
            try {
                nArray[ShortcutOwner.VIM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShortcutOwner.IDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

