/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.matchit;

import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.extension.matchit.LanguagePatterns;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/maddyhome/idea/vim/extension/matchit/FileTypePatterns;", "", "<init>", "()V", "getMatchitPatterns", "Lcom/maddyhome/idea/vim/extension/matchit/LanguagePatterns;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "htmlLikeFileTypes", "", "", "htmlPatterns", "javaPatterns", "rubyPatterns", "rubyAndHtmlPatterns", "phpPatterns", "cPatterns", "gnuMakePatterns", "cMakePatterns", "createHtmlPatterns", "tagNamePattern", "createJavaPatterns", "createRubyPatterns", "createPhpPatterns", "createCPatterns", "createGnuMakePatterns", "createCMakePatterns", "IdeaVIM"})
final class FileTypePatterns {
    @NotNull
    public static final FileTypePatterns INSTANCE = new FileTypePatterns();
    @NotNull
    private static final Set<String> htmlLikeFileTypes;
    @NotNull
    private static final LanguagePatterns htmlPatterns;
    @NotNull
    private static final LanguagePatterns javaPatterns;
    @NotNull
    private static final LanguagePatterns rubyPatterns;
    @NotNull
    private static final LanguagePatterns rubyAndHtmlPatterns;
    @NotNull
    private static final LanguagePatterns phpPatterns;
    @NotNull
    private static final LanguagePatterns cPatterns;
    @NotNull
    private static final LanguagePatterns gnuMakePatterns;
    @NotNull
    private static final LanguagePatterns cMakePatterns;

    private FileTypePatterns() {
    }

    @Nullable
    public final LanguagePatterns getMatchitPatterns(@Nullable VirtualFile virtualFile) {
        LanguagePatterns languagePatterns;
        String fileExtension;
        VirtualFile virtualFile2 = virtualFile;
        String fileTypeName = virtualFile2 != null && (virtualFile2 = virtualFile2.getFileType()) != null ? virtualFile2.getName() : null;
        VirtualFile virtualFile3 = virtualFile;
        String fileName = virtualFile3 != null ? virtualFile3.getNameWithoutExtension() : null;
        VirtualFile virtualFile4 = virtualFile;
        String string = fileExtension = virtualFile4 != null ? virtualFile4.getExtension() : null;
        if (CollectionsKt.contains((Iterable)htmlLikeFileTypes, (Object)fileTypeName)) {
            languagePatterns = htmlPatterns;
        } else if (Intrinsics.areEqual((Object)fileTypeName, (Object)"JAVA") || Intrinsics.areEqual((Object)fileExtension, (Object)"java")) {
            languagePatterns = javaPatterns;
        } else if (Intrinsics.areEqual((Object)fileTypeName, (Object)"Ruby") || Intrinsics.areEqual((Object)fileExtension, (Object)"rb")) {
            languagePatterns = rubyPatterns;
        } else if (Intrinsics.areEqual((Object)fileTypeName, (Object)"RHTML") || Intrinsics.areEqual((Object)fileExtension, (Object)"erb")) {
            languagePatterns = rubyAndHtmlPatterns;
        } else if (Intrinsics.areEqual((Object)fileTypeName, (Object)"PHP") || Intrinsics.areEqual((Object)fileExtension, (Object)"php")) {
            languagePatterns = phpPatterns;
        } else if (Intrinsics.areEqual((Object)fileTypeName, (Object)"C++") || Intrinsics.areEqual((Object)fileTypeName, (Object)"C#") || Intrinsics.areEqual((Object)fileTypeName, (Object)"ObjectiveC") || Intrinsics.areEqual((Object)fileExtension, (Object)"c")) {
            languagePatterns = cPatterns;
        } else if (Intrinsics.areEqual((Object)fileTypeName, (Object)"Makefile") || Intrinsics.areEqual((Object)fileName, (Object)"Makefile")) {
            languagePatterns = gnuMakePatterns;
        } else if (Intrinsics.areEqual((Object)fileTypeName, (Object)"CMakeLists.txt") || Intrinsics.areEqual((Object)fileName, (Object)"CMakeLists")) {
            languagePatterns = cMakePatterns;
        } else {
            return null;
        }
        return languagePatterns;
    }

    private final LanguagePatterns createHtmlPatterns(String tagNamePattern) {
        String string = "(?<=<)(%s)(?:\\s[^<>]*(\".*\")?)?";
        Object object = new Object[]{tagNamePattern};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String openingTagPattern = string2;
        object = "(?<=<)/(%s)(?=>)";
        Object[] objectArray = new Object[]{tagNamePattern};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String closingTagPattern = string3;
        Pair htmlSearchPair = new Pair((Object)"(?<=<)%s(?:\\s[^<>]*(\".*\")?)?(?=>)", (Object)"(?<=<)/%s>");
        object = new Pair[]{TuplesKt.to((Object)openingTagPattern, (Object)htmlSearchPair)};
        Map map = MapsKt.linkedMapOf((Pair[])object);
        object = new Pair[]{TuplesKt.to((Object)closingTagPattern, (Object)htmlSearchPair)};
        return LanguagePatterns.Companion.invoke("<", ">").plus(new LanguagePatterns(map, MapsKt.linkedMapOf((Pair[])object)));
    }

    static /* synthetic */ LanguagePatterns createHtmlPatterns$default(FileTypePatterns fileTypePatterns, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "[^/\\s><]+";
        }
        return fileTypePatterns.createHtmlPatterns(string);
    }

    private final LanguagePatterns createJavaPatterns() {
        return LanguagePatterns.Companion.invoke("\\b(?<!else\\s+)if\\b", "\\belse\\s+if\\b", "\\belse(?!\\s+if)\\b").plus(LanguagePatterns.Companion.invoke("\\bdo\\b", "\\bwhile\\b")).plus(LanguagePatterns.Companion.invoke("\\btry\\b", "\\bcatch\\b", "\\bfinally\\b"));
    }

    private final LanguagePatterns createRubyPatterns() {
        String openingKeywords = "(?:\\b(?:do|if|unless|case|def|for|while|until|module|begin)\\b)|(?:\\bclass\\b[^=])";
        String endKeyword = "\\bend\\b";
        String middleKeywords = "(?:\\b(?:else|elsif|break|when|rescue|ensure|redo|next|retry)\\b)";
        String blockCommentStart = "(?<==)begin\\b";
        String blockCommentEnd = "(?<==)end\\b";
        return LanguagePatterns.Companion.invoke(blockCommentStart, blockCommentEnd).plus(LanguagePatterns.Companion.invoke(openingKeywords, middleKeywords, endKeyword));
    }

    private final LanguagePatterns createPhpPatterns() {
        String loopOpenings = "(?:\\b(?:for|do|foreach|switch)\\b)|(?:\\bwhile \\(.*?\\)\\s*:)";
        String loopClosings = "(?:\\bend(?:for|foreach|while|switch)\\b)|(?:\\bwhile \\(.*\\)\\s*;)";
        String openingDoc = "(?<=<<<)\\s*'?(\\w+)'?";
        String closingDoc = "^\\s*(\\w+)\\s*[,;]";
        Pair docSearchPair = new Pair((Object)"(?<=<<<)\\s*'?%s'?", (Object)"%s");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)openingDoc, (Object)docSearchPair)};
        Map map = MapsKt.linkedMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)closingDoc, (Object)docSearchPair)};
        LanguagePatterns docPatterns = new LanguagePatterns(map, MapsKt.linkedMapOf((Pair[])pairArray));
        return LanguagePatterns.Companion.invoke("(?<=<)\\?(?:php|=)?", "\\?>").plus(LanguagePatterns.Companion.invoke("<(?=\\?(?:php|=)?)", "\\?>")).plus(LanguagePatterns.Companion.invoke("\\bif\\b", "\\b(?:else|elseif)\\b", "\\bendif\\b")).plus(LanguagePatterns.Companion.invoke(loopOpenings, "\\b(?:case|break|continue)\\b", loopClosings)).plus(docPatterns).plus(this.createHtmlPatterns("[^/\\s><?]+"));
    }

    private final LanguagePatterns createCPatterns() {
        return LanguagePatterns.Companion.invoke("#\\s*if(?:def|ndef)?\\b", "#\\s*(?:elif|else)\\b", "#\\s*endif\\b");
    }

    private final LanguagePatterns createGnuMakePatterns() {
        return LanguagePatterns.Companion.invoke("\\bdefine\\b", "\\bendef\\b").plus(LanguagePatterns.Companion.invoke("(?<!else )ifn?(?:eq|def)\\b", "\\belse(?:\\s+ifn?(?:eq|def))?\\b", "\\bendif\\b"));
    }

    private final LanguagePatterns createCMakePatterns() {
        return LanguagePatterns.Companion.invoke("\\bif\\b", "\\belse(?:if)?\\b", "\\bendif\\b").plus(LanguagePatterns.Companion.invoke("\\b(?:foreach)|(?:while)\\b", "\\bbreak\\b", "\\b(?:endforeach)|(?:endwhile)\\b")).plus(LanguagePatterns.Companion.invoke("\\bmacro\\b", "\\bendmacro\\b")).plus(LanguagePatterns.Companion.invoke("\\bfunction\\b", "\\bendfunction\\b"));
    }

    static {
        Object[] objectArray = new String[]{"HTML", "XML", "XHTML", "JSP", "JavaScript", "JSX Harmony", "TypeScript", "TypeScript JSX", "Vue.js", "Handlebars/Mustache", "Asp", "Razor", "UXML", "Xaml"};
        htmlLikeFileTypes = SetsKt.setOf((Object[])objectArray);
        htmlPatterns = FileTypePatterns.createHtmlPatterns$default(INSTANCE, null, 1, null);
        javaPatterns = INSTANCE.createJavaPatterns();
        rubyPatterns = INSTANCE.createRubyPatterns();
        rubyAndHtmlPatterns = rubyPatterns.plus(htmlPatterns);
        phpPatterns = INSTANCE.createPhpPatterns();
        cPatterns = INSTANCE.createCPatterns();
        gnuMakePatterns = INSTANCE.createGnuMakePatterns();
        cMakePatterns = INSTANCE.createCMakePatterns();
    }
}

