/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.register.Register;
import com.maddyhome.idea.vim.register.VimRegisterGroupBase;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VimRegisterSettings", storages={@Storage(value="$APP_CONFIG$/vim_settings_local.xml", roamingType=RoamingType.DISABLED)})
public class RegisterGroup
extends VimRegisterGroupBase
implements PersistentStateComponent<Element> {
    private static final Logger logger;

    public RegisterGroup() {
        this.initClipboardOptionListener();
    }

    public void saveData(@NotNull Element element) {
        if (element == null) {
            RegisterGroup.$$$reportNull$$$0(0);
        }
        logger.debug("Save registers data");
        Element registersElement = new Element("registers");
        if (logger.isTraceEnabled()) {
            logger.trace("Saving " + this.myRegisters.size() + " registers");
        }
        for (Character key : this.myRegisters.keySet()) {
            Register register = (Register)this.myRegisters.get(key);
            if (logger.isTraceEnabled()) {
                logger.trace("Saving register '" + key + "'");
            }
            Element registerElement = new Element("register");
            registerElement.setAttribute("name", String.valueOf(key));
            registerElement.setAttribute("type", register.getType().name());
            String text = register.getText();
            if (text != null) {
                logger.trace("Save register as 'text'");
                Element textElement = new Element("text");
                VimPlugin.getXML().setSafeXmlText(textElement, text);
                registerElement.addContent(textElement);
            } else {
                logger.trace("Save register as 'keys'");
                Element keys = new Element("keys");
                List list = register.getKeys();
                for (KeyStroke stroke : list) {
                    Element k = new Element("key");
                    k.setAttribute("char", Integer.toString(stroke.getKeyChar()));
                    k.setAttribute("code", Integer.toString(stroke.getKeyCode()));
                    k.setAttribute("mods", Integer.toString(stroke.getModifiers()));
                    keys.addContent(k);
                }
                registerElement.addContent(keys);
            }
            registersElement.addContent(registerElement);
        }
        element.addContent(registersElement);
        logger.debug("Finish saving registers data");
    }

    public void readData(@NotNull Element element) {
        if (element == null) {
            RegisterGroup.$$$reportNull$$$0(1);
        }
        logger.debug("Read registers data");
        Element registersElement = element.getChild("registers");
        if (registersElement != null) {
            logger.trace("'registers' element is not null");
            List registerElements = registersElement.getChildren("register");
            if (logger.isTraceEnabled()) {
                logger.trace("Detected " + registerElements.size() + " register elements");
            }
            for (Element registerElement : registerElements) {
                Register register;
                SelectionType type;
                char key = registerElement.getAttributeValue("name").charAt(0);
                if (logger.isTraceEnabled()) {
                    logger.trace("Read register '" + key + "'");
                }
                Element textElement = registerElement.getChild("text");
                String typeText = registerElement.getAttributeValue("type");
                try {
                    type = SelectionType.valueOf((String)typeText);
                }
                catch (IllegalArgumentException e) {
                    type = Integer.toString(2).equals(typeText) ? SelectionType.CHARACTER_WISE : (Integer.toString(4).equals(typeText) ? SelectionType.LINE_WISE : (Integer.toString(8).equals(typeText) ? SelectionType.BLOCK_WISE : SelectionType.CHARACTER_WISE));
                }
                if (textElement != null) {
                    logger.trace("Register has 'text' element");
                    String text = VimPlugin.getXML().getSafeXmlText(textElement);
                    if (text != null) {
                        logger.trace("Register data parsed");
                        register = new Register(key, VimInjectorKt.injector.getClipboardManager().dumbCopiedText(text), type);
                    } else {
                        logger.trace("Cannot parse register data");
                        register = null;
                    }
                } else {
                    logger.trace("Register has 'keys' element");
                    Element keysElement = registerElement.getChild("keys");
                    List keyElements = keysElement.getChildren("key");
                    ArrayList<KeyStroke> strokes = new ArrayList<KeyStroke>();
                    for (Element keyElement : keyElements) {
                        int code = Integer.parseInt(keyElement.getAttributeValue("code"));
                        int modifiers = Integer.parseInt(keyElement.getAttributeValue("mods"));
                        char c = (char)Integer.parseInt(keyElement.getAttributeValue("char"));
                        strokes.add(c == '\uffff' ? KeyStroke.getKeyStroke(code, modifiers) : KeyStroke.getKeyStroke(c));
                    }
                    register = new Register(key, type, strokes);
                }
                logger.trace("Save register to vim registers");
                this.myRegisters.put(Character.valueOf(key), register);
            }
        }
        logger.debug("Finish reading registers data");
    }

    @Nullable
    public Element getState() {
        Element element = new Element("registers");
        this.saveData(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            RegisterGroup.$$$reportNull$$$0(2);
        }
        this.readData(state);
    }

    static {
        IjVimInjectorKt.initInjector();
        logger = Logger.getInstance(RegisterGroup.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/maddyhome/idea/vim/group/RegisterGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

