/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.maddyhome.idea.vim.api.LocalOptionToGlobalLocalExternalSettingMapper;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.options.NumberOption;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/group/TextWidthOptionMapper;", "Lcom/maddyhome/idea/vim/api/LocalOptionToGlobalLocalExternalSettingMapper;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "textWidthOption", "Lcom/maddyhome/idea/vim/options/NumberOption;", "<init>", "(Lcom/maddyhome/idea/vim/options/NumberOption;)V", "canUserModifyExternalLocalValue", "", "getCanUserModifyExternalLocalValue", "()Z", "getGlobalExternalValue", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getEffectiveExternalValue", "setLocalExternalValue", "", "value", "resetLocalExternalValueToGlobal", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nOptionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionGroup.kt\ncom/maddyhome/idea/vim/group/TextWidthOptionMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1406:1\n1#2:1407\n*E\n"})
final class TextWidthOptionMapper
extends LocalOptionToGlobalLocalExternalSettingMapper<VimInt> {
    private final boolean canUserModifyExternalLocalValue;

    public TextWidthOptionMapper(@NotNull NumberOption textWidthOption) {
        Intrinsics.checkNotNullParameter((Object)textWidthOption, (String)"textWidthOption");
        super((Option)textWidthOption);
    }

    protected boolean getCanUserModifyExternalLocalValue() {
        return this.canUserModifyExternalLocalValue;
    }

    @NotNull
    protected VimInt getGlobalExternalValue(@NotNull VimEditor editor) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        Project project = ijEditor.getProject();
        if (project != null) {
            Project it = project;
            boolean bl = false;
            v1 = TextEditorImpl.Companion.getDocumentLanguage(ijEditor);
        } else {
            v1 = language = null;
        }
        if (CodeStyle.getSettings((Editor)ijEditor).isWrapOnTyping(language)) {
            return VimIntKt.asVimInt((int)CodeStyle.getSettings((Editor)ijEditor).getRightMargin(language));
        }
        return VimInt.Companion.getZERO();
    }

    @NotNull
    protected VimInt getEffectiveExternalValue(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        Project project = ijEditor.getProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        Project project3 = project;
        return ijEditor.getSettings().isWrapWhenTypingReachesRightMargin(project3) ? VimIntKt.asVimInt((int)ijEditor.getSettings().getRightMargin(ijEditor.getProject())) : VimInt.Companion.getZERO();
    }

    protected void setLocalExternalValue(@NotNull VimEditor editor, @NotNull VimInt value) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        ijEditor.getSettings().setWrapWhenTypingReachesRightMargin(value.getValue() > 0);
        if (value.getValue() > 0) {
            ijEditor.getSettings().setRightMargin(value.getValue());
        }
    }

    protected void resetLocalExternalValueToGlobal(@NotNull VimEditor editor) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        Project project = ijEditor.getProject();
        if (project != null) {
            Project it = project;
            boolean bl = false;
            language = TextEditorImpl.Companion.getDocumentLanguage(ijEditor);
        } else {
            language = null;
        }
        Language language2 = language;
        int globalRightMargin = CodeStyle.getSettings((Editor)ijEditor).getRightMargin(language2);
        if (ijEditor.getSettings().getRightMargin(ijEditor.getProject()) != globalRightMargin) {
            ijEditor.getSettings().setRightMargin(globalRightMargin);
        }
        boolean globalIsWrapOnTyping = CodeStyle.getSettings((Editor)ijEditor).isWrapOnTyping(language2);
        if (ijEditor.getSettings().isWrapWhenTypingReachesRightMargin(ijEditor.getProject()) != globalIsWrapOnTyping) {
            ijEditor.getSettings().setWrapWhenTypingReachesRightMargin(globalIsWrapOnTyping);
        }
    }
}

