/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Key;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\"'\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\r\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"commandContinuation", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCommandContinuation", "()Lcom/intellij/openapi/util/Key;", "isOctopusEnabled", "", "s", "Ljavax/swing/KeyStroke;", "editor", "Lcom/intellij/openapi/editor/Editor;", "enableOctopus", "getEnableOctopus", "()Z", "IdeaVIM"})
public final class VimEnterHandlerKt {
    @NotNull
    private static final Key<EditorActionHandler> commandContinuation;

    @NotNull
    public static final Key<EditorActionHandler> getCommandContinuation() {
        return commandContinuation;
    }

    public static final boolean isOctopusEnabled(@NotNull KeyStroke s, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!VimEnterHandlerKt.getEnableOctopus()) {
            return false;
        }
        if (IjVimEditorKt.getVim(editor).getMode() instanceof Mode.CMD_LINE) {
            return false;
        }
        if (s.getKeyCode() == 10 && s.getModifiers() == 0) {
            return true;
        }
        return s.getKeyCode() == 27 && s.getModifiers() == 0;
    }

    public static final boolean getEnableOctopus() {
        return VimInjectorKt.getInjector().getApplication().isOctopusEnabled();
    }

    static {
        Key key = Key.create((String)"commandContinuation");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        commandContinuation = key;
    }
}

