/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.group.NotificationService;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.icons.VimIcons;
import com.maddyhome.idea.vim.ui.HelpLink;
import com.maddyhome.idea.vim.ui.JoinEap;
import com.maddyhome.idea.vim.ui.ShortcutConflictsSettings;
import com.maddyhome.idea.vim.ui.TutorAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/ui/VimActionsPopup;", "", "<init>", "()V", "getPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "IdeaVIM"})
final class VimActionsPopup {
    @NotNull
    public static final VimActionsPopup INSTANCE = new VimActionsPopup();

    private VimActionsPopup() {
    }

    @NotNull
    public final ListPopup getPopup(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DefaultActionGroup actions = this.getActions();
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup("IdeaVim", (ActionGroup)actions, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, "popup");
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)VimPlugin.getVersion(), (String)"getVersion(...)");
        popup.setAdText(MessageHelper.message("widget.vim.actions.popup.advertisement.version", objectArray), 0);
        return popup;
    }

    private final DefaultActionGroup getActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.setPopup(true);
        actionGroup.add(ActionManager.getInstance().getAction("VimPluginToggle"));
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new NotificationService.OpenIdeaVimRcAction(null));
        actionGroup.add((AnAction)ShortcutConflictsSettings.INSTANCE);
        actionGroup.add((AnAction)new HelpLink("Plugin \u2197", "https://jb.gg/ideavim-plugins", null));
        actionGroup.add((AnAction)new HelpLink("Take Survey \u2197", "https://jb.gg/axootm", AllIcons.Actions.IntentionBulb));
        actionGroup.addSeparator(MessageHelper.message("widget.vim.actions.popup.eap.choice.active.text"));
        actionGroup.add((AnAction)JoinEap.INSTANCE);
        actionGroup.add((AnAction)new HelpLink("About EAP \u2197", "https://github.com/JetBrains/ideavim#get-early-access", null));
        actionGroup.addSeparator("Learn");
        actionGroup.add((AnAction)new TutorAction());
        actionGroup.add((AnAction)new HelpLink("IdeaVim Docs \u2197", "https://github.com/JetBrains/ideavim?tab=readme-ov-file#summary-of-supported-vim-features", null));
        actionGroup.addSeparator(MessageHelper.message("widget.vim.actions.popup.contacts.help.text"));
        actionGroup.add((AnAction)new HelpLink(MessageHelper.message("widget.vim.actions.popup.contact.on.twitter.text"), "https://twitter.com/ideavim", VimIcons.TWITTER));
        actionGroup.add((AnAction)new HelpLink(MessageHelper.message("widget.vim.actions.popup.create.issue.text"), "https://youtrack.jetbrains.com/newIssue?project=VIM&description=%0A%0A-----------%0AYou%20can%20improve%20the%20issue%20description%20by%20providing%3A%0A1)%20Your%20%60~%2F.ideavimrc%60%20configuration%20if%20you%20use%20it.%0A2)%20The%20%5Blog%5D(https%3A%2F%2Fintellij-support.jetbrains.com%2Fhc%2Fen-us%2Farticles%2F207241085-Locating-IDE-log-files)%20from%20your%20IDE.%0A%0AVersion:%20" + VimPlugin.getVersion() + "&c=Affected%20versions%20" + VimPlugin.getVersion(), VimIcons.YOUTRACK));
        actionGroup.add((AnAction)new HelpLink(MessageHelper.message("widget.vim.actions.popup.contribute.on.github.text"), "https://github.com/JetBrains/ideavim", AllIcons.Vcs.Vendors.Github));
        return actionGroup;
    }
}

