/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.SelectionInfo;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimJumpServiceKt;
import com.maddyhome.idea.vim.api.VimMarkService;
import com.maddyhome.idea.vim.api.VimVirtualFile;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.mark.Jump;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.mark.VimMark;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 Q2\u00020\u0001:\u0002QRB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000e\u001a\u00020\tJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0006H\u0004J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019*\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u001e\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001d0\u001f0\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0007H\u0016J \u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0017H\u0016J\"\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0017H\u0014J \u0010)\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0017H\u0016J\u0010\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007H\u0016J \u0010*\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0017H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010.2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u00100\u001a\u0004\u0018\u00010.2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0006H\u0002J\u0018\u00103\u001a\u00020,2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u00104\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u00105\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u00106\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u00107\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J \u00108\u001a\u00020,2\u0006\u0010 \u001a\u00020!2\u0006\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u0017H\u0016J \u0010;\u001a\u00020,2\u0006\u0010 \u001a\u00020!2\u0006\u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u0017H\u0016J\u0010\u0010>\u001a\u00020,2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010@\u001a\u00020,H\u0016J \u0010A\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020%H\u0016J\u001c\u0010E\u001a\u00020%*\u00020\u00062\u0006\u0010B\u001a\u00020C2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010F\u001a\u00020%*\u00020\u0006H\u0004J\f\u0010G\u001a\u00020%*\u00020\u0006H\u0004J\"\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\"\u0010J\u001a\u0004\u0018\u00010I2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0012\u0010L\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010M\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0017H\u0002J\u0018\u0010N\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0017H\u0002J\"\u0010O\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0017H\u0002J\f\u0010P\u001a\u00020\u0006*\u00020\u0006H\u0004R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\n0\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006S"}, d2={"Lcom/maddyhome/idea/vim/api/VimMarkServiceBase;", "Lcom/maddyhome/idea/vim/api/VimMarkService;", "<init>", "()V", "globalMarks", "Ljava/util/HashMap;", "", "Lcom/maddyhome/idea/vim/mark/Mark;", "filepathToLocalMarks", "", "Lcom/maddyhome/idea/vim/api/VimMarkServiceBase$LocalMarks;", "getFilepathToLocalMarks", "()Ljava/util/HashMap;", "getLocalMarks", "filePath", "getGlobalMark", "char", "getLocalMark", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "getMark", "getRelativeLowercaseMark", "count", "", "sortedWithAndDistinctBy", "", "comparator", "Ljava/util/Comparator;", "getAllLocalMarks", "", "getAllMarksForFile", "Lkotlin/Pair;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getAllGlobalMarks", "getGlobalMarks", "setMark", "", "mark", "offset", "createGlobalMark", "setGlobalMark", "setMarkForCaret", "setVisualSelectionMarks", "", "getVisualSelectionMarks", "Lcom/maddyhome/idea/vim/common/TextRange;", "getChangeMarks", "getMarksRange", "startMark", "endMark", "removeMark", "removeLocalMark", "removeSelectionStartMark", "removeSelectionEndMark", "removeGlobalMark", "updateMarksFromInsert", "insertStartOffset", "insertLength", "updateMarksFromDelete", "delStartOffset", "delLength", "editorReleased", "resetAllMarksForCaret", "resetAllMarks", "isValidMark", "operation", "Lcom/maddyhome/idea/vim/api/VimMarkService$Operation;", "isCaretPrimary", "isOperationValidOnMark", "isGlobalMark", "isLocalMark", "getParagraphMark", "Lcom/maddyhome/idea/vim/mark/VimMark;", "getSentenceMark", "createSelectionStartMark", "getSelectionEndMark", "setSelectionStartMark", "setSelectionEndMark", "createMark", "normalizeMarkChar", "Companion", "LocalMarks", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimMarkServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimMarkServiceBase.kt\ncom/maddyhome/idea/vim/api/VimMarkServiceBase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,672:1\n382#2,7:673\n774#3:680\n865#3,2:681\n1803#3,3:683\n774#3:686\n865#3,2:687\n1374#3:689\n1460#3,5:690\n1563#3:695\n1634#3,3:696\n774#3:699\n865#3,2:700\n1869#3,2:702\n1869#3,2:704\n1869#3,2:706\n808#3,11:712\n808#3,11:735\n1869#3,2:758\n34#4,4:708\n34#4,4:723\n34#4,4:727\n34#4,4:731\n34#4,4:746\n34#4,4:750\n34#4,4:754\n39#4:761\n1#5:760\n*S KotlinDebug\n*F\n+ 1 VimMarkServiceBase.kt\ncom/maddyhome/idea/vim/api/VimMarkServiceBase\n*L\n72#1:673,7\n132#1:680\n132#1:681,2\n162#1:683,3\n184#1:686\n184#1:687,2\n185#1:689\n185#1:690,5\n186#1:695\n186#1:696,3\n198#1:699\n198#1:700,2\n212#1:702,2\n287#1:704,2\n314#1:706,2\n370#1:712,11\n411#1:735,11\n465#1:758,2\n365#1:708,4\n371#1:723,4\n376#1:727,4\n408#1:731,4\n412#1:746,4\n415#1:750,4\n439#1:754,4\n42#1:761\n*E\n"})
public abstract class VimMarkServiceBase
implements VimMarkService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final HashMap<Character, Mark> globalMarks = new HashMap();
    @NotNull
    private final HashMap<String, LocalMarks<Character, Mark>> filepathToLocalMarks = new HashMap();
    @NotNull
    private static final VimLogger logger;

    @NotNull
    protected final HashMap<String, LocalMarks<Character, Mark>> getFilepathToLocalMarks() {
        return this.filepathToLocalMarks;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LocalMarks<Character, Mark> getLocalMarks(@NotNull String filePath) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Map map = this.filepathToLocalMarks;
        String key$iv = filePath;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            LocalMarks answer$iv = new LocalMarks();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (LocalMarks)object;
    }

    @Override
    @Nullable
    public Mark getGlobalMark(char c) {
        if (this.isGlobalMark(c)) {
            return this.globalMarks.get(Character.valueOf(c));
        }
        return null;
    }

    @Nullable
    protected final Mark getLocalMark(@NotNull ImmutableVimCaret caret, char c) {
        Mark mark;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        char markChar = this.normalizeMarkChar(c);
        if (!this.isLocalMark(markChar)) {
            return null;
        }
        switch (markChar) {
            case '<': {
                return this.createSelectionStartMark(caret);
            }
            case '>': {
                return this.getSelectionEndMark(caret);
            }
        }
        VimEditor editor = caret.getEditor();
        String string = editor.getPath();
        if (string == null) {
            return null;
        }
        String path = string;
        if (caret.isPrimary()) {
            Mark mark2 = (Mark)this.getLocalMarks(path).get(Character.valueOf(markChar));
            if (markChar == '\"') {
                mark = mark2;
                if (mark == null) {
                    mark = this.createMark(caret, '\"', 0);
                }
            } else {
                mark = mark2;
            }
        } else {
            mark = caret.getMarkStorage().getMark(markChar);
        }
        return mark;
    }

    @Override
    @Nullable
    public Mark getMark(@NotNull ImmutableVimCaret caret, char c) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        char markChar = this.normalizeMarkChar(c);
        if (!this.isOperationValidOnMark(markChar, VimMarkService.Operation.GET, caret)) {
            return null;
        }
        VimEditor editor = caret.getEditor();
        String path = editor.getPath();
        return path != null && (markChar == '{' || markChar == '}') ? (Mark)this.getParagraphMark(editor, caret, markChar) : (path != null && (markChar == '(' || markChar == ')') ? (Mark)this.getSentenceMark(editor, caret, markChar) : (this.isLocalMark(markChar) ? this.getLocalMark(caret, markChar) : (this.isGlobalMark(markChar) ? this.getGlobalMark(markChar) : null)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Mark getRelativeLowercaseMark(@NotNull ImmutableVimCaret caret, int count) {
        int n;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection<Mark> collection;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        String string = caret.getEditor().getPath();
        if (string == null) {
            return null;
        }
        String path = string;
        if (count == 0) {
            return null;
        }
        if (caret.isPrimary()) {
            Collection<Mark> collection2 = this.getLocalMarks(path).values();
            Intrinsics.checkNotNull(collection2);
            collection = collection2;
        } else {
            collection = CollectionsKt.toSet((Iterable)caret.getMarkStorage().getMarks().values());
        }
        Collection<Mark> marks = collection;
        Iterable iterable = marks;
        VimMarkServiceBase vimMarkServiceBase = this;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mark it = (Mark)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyz", (char)it.getKey(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<Mark> lowerCaseMarksWithDistinctPositions = vimMarkServiceBase.sortedWithAndDistinctBy((List)destination$iv$iv, Mark.PositionSorter.INSTANCE);
        Mark mark = this.createMark(caret, '[', caret.getOffset());
        if (mark == null) {
            return null;
        }
        Mark caretMark = mark;
        int result = CollectionsKt.binarySearch$default(lowerCaseMarksWithDistinctPositions, (Object)caretMark, (Comparator)Mark.PositionSorter.INSTANCE, (int)0, (int)0, (int)12, null);
        if (result >= 0) {
            n = result + count;
        } else {
            int insertionPoint = -1 * (result + 1);
            if (insertionPoint == 0 && count < 0 || insertionPoint == lowerCaseMarksWithDistinctPositions.size() && count > 0) {
                return null;
            }
            n = count < 0 ? insertionPoint + count : insertionPoint + count - 1;
        }
        int targetIndex = n;
        int actualIndex = RangesKt.coerceIn((int)targetIndex, (int)0, (int)CollectionsKt.getLastIndex(lowerCaseMarksWithDistinctPositions));
        return lowerCaseMarksWithDistinctPositions.get(actualIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Mark> sortedWithAndDistinctBy(List<? extends Mark> $this$sortedWithAndDistinctBy, Comparator<Mark> comparator) {
        void $this$fold$iv;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedWithAndDistinctBy, (Comparator)Mark.PositionSorter.INSTANCE);
        Iterable iterable = sorted;
        ArrayList<void> initial$iv = new ArrayList<void>(sorted.size());
        boolean $i$f$fold = false;
        ArrayList<void> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void mark;
            Mark mark2 = (Mark)element$iv;
            ArrayList<void> outputList = accumulator$iv;
            boolean bl = false;
            Mark previousMark = (Mark)CollectionsKt.lastOrNull((List)outputList);
            if (previousMark == null || Mark.PositionSorter.INSTANCE.compare(previousMark, (Mark)mark) != 0) {
                outputList.add(mark);
            }
            accumulator$iv = outputList;
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public Set<Mark> getAllLocalMarks(@NotNull ImmutableVimCaret caret) {
        Collection<Mark> collection;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        String string = caret.getEditor().getPath();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String path = string;
        if (caret.isPrimary()) {
            Collection<Mark> collection2 = this.getLocalMarks(path).values();
            Intrinsics.checkNotNull(collection2);
            collection = collection2;
        } else {
            collection = CollectionsKt.toSet((Iterable)caret.getMarkStorage().getMarks().values());
        }
        Collection<Mark> marks = collection;
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus(marks, (Object)this.getLocalMark(caret, '<')), (Object)this.getLocalMark(caret, '>'))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<ImmutableVimCaret, Set<Mark>>> getAllMarksForFile(@NotNull VimEditor editor) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        VimEditor it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$filter$iv = VimInjectorKt.getInjector().getEditorGroup().getEditors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VimEditor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPath(), (Object)editor.getPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (VimEditor)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.carets();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (VimCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it, this.getAllLocalMarks((ImmutableVimCaret)((Object)it))));
        }
        List localMarks = (List)destination$iv$iv;
        Pair globalMarks = new Pair(null, this.getGlobalMarks(editor));
        return CollectionsKt.plus((Collection)localMarks, (Object)globalMarks);
    }

    @Override
    @NotNull
    public Set<Mark> getAllGlobalMarks() {
        Collection<Mark> collection = this.globalMarks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Mark> getGlobalMarks(@NotNull VimEditor editor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = editor.getPath();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String filePath = string;
        Collection<Mark> collection = this.globalMarks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mark it = (Mark)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFilepath(), (Object)filePath)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    public boolean setMark(@NotNull VimEditor editor, char c) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        char markChar = this.normalizeMarkChar(c);
        if (!this.isOperationValidOnMark(markChar, VimMarkService.Operation.SET, editor.primaryCaret())) {
            return false;
        }
        if (this.isGlobalMark(markChar)) {
            bl = this.setGlobalMark(editor, markChar, editor.primaryCaret().getOffset());
        } else if (this.isLocalMark(markChar)) {
            Iterable $this$forEach$iv = editor.carets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl2 = false;
                this.setMark(it, markChar, it.getOffset());
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean setMark(@NotNull ImmutableVimCaret caret, @NotNull Mark mark) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)mark, (String)"mark");
        char markChar = mark.getKey();
        VimEditor editor = caret.getEditor();
        if (!this.isOperationValidOnMark(markChar, VimMarkService.Operation.SET, caret)) {
            return false;
        }
        if (this.isGlobalMark(markChar)) {
            this.setGlobalMark(mark);
        } else if (markChar == '<') {
            this.setSelectionStartMark(caret, mark.offset(editor));
        } else if (markChar == '>') {
            this.setSelectionEndMark(caret, mark.offset(editor));
        } else if (this.isLocalMark(markChar)) {
            if (caret.isPrimary()) {
                if (mark.getKey() == '\'') {
                    Jump jump = new Jump(mark.getLine(), mark.getCol(), mark.getFilepath(), mark.getProtocol());
                    VimJumpServiceKt.addJump(VimInjectorKt.getInjector().getJumpService(), editor, jump, true);
                }
                ((Map)this.getLocalMarks(mark.getFilepath())).put(Character.valueOf(markChar), mark);
            } else {
                caret.getMarkStorage().setMark(mark);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean setMark(@NotNull ImmutableVimCaret caret, char c, int offset) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        char markChar = this.normalizeMarkChar(c);
        Mark mark = this.createMark(caret, markChar, offset);
        if (mark == null) {
            return false;
        }
        Mark mark2 = mark;
        return this.setMark(caret, mark2);
    }

    @Nullable
    protected Mark createGlobalMark(@NotNull VimEditor editor, char c, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        char markChar = this.normalizeMarkChar(c);
        if (!this.isGlobalMark(markChar)) {
            return null;
        }
        if (!this.isOperationValidOnMark(markChar, VimMarkService.Operation.SET, editor.primaryCaret())) {
            return null;
        }
        BufferPosition position = editor.offsetToBufferPosition(offset);
        VimVirtualFile vimVirtualFile = editor.getVirtualFile();
        if (vimVirtualFile == null) {
            return null;
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        String path = virtualFile.getPath();
        return new VimMark(markChar, position.getLine(), position.getColumn(), path, virtualFile.getProtocol());
    }

    @Override
    public boolean setGlobalMark(@NotNull VimEditor editor, char c, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Mark mark = this.createGlobalMark(editor, c, offset);
        if (mark == null) {
            return false;
        }
        Mark mark2 = mark;
        return this.setGlobalMark(mark2);
    }

    @Override
    public boolean setGlobalMark(@NotNull Mark mark) {
        Intrinsics.checkNotNullParameter((Object)mark, (String)"mark");
        if (!this.isValidMark(mark.getKey(), VimMarkService.Operation.SET, true)) {
            return false;
        }
        ((Map)this.globalMarks).put(Character.valueOf(mark.getKey()), mark);
        return true;
    }

    @Override
    public boolean setMarkForCaret(@NotNull ImmutableVimCaret caret, char c, int offset) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        char markChar = this.normalizeMarkChar(c);
        if (!this.isOperationValidOnMark(markChar, VimMarkService.Operation.SET, caret)) {
            return false;
        }
        return this.isGlobalMark(markChar) ? (caret.isPrimary() ? this.setGlobalMark(caret.getEditor(), c, offset) : false) : (this.isLocalMark(markChar) ? this.setMark(caret, c, offset) : false);
    }

    @Override
    public void setVisualSelectionMarks(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Mode mode = editor.getMode();
        if (!(mode instanceof Mode.VISUAL)) {
            return;
        }
        Iterable $this$forEach$iv = editor.carets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimCaret it = (VimCaret)element$iv;
            boolean bl = false;
            SelectionInfo selectionInfo = SelectionInfo.Companion.collectCurrentSelectionInfo(it);
            if (selectionInfo == null) {
                selectionInfo = new SelectionInfo(null, null, SelectionType.CHARACTER_WISE);
            }
            it.setLastSelectionInfo(selectionInfo);
        }
    }

    @Override
    @Nullable
    public TextRange getVisualSelectionMarks(@NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return caret.getLastSelectionInfo().getSelectionRange(caret.getEditor());
    }

    @Override
    @Nullable
    public TextRange getChangeMarks(@NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.getMarksRange(caret, '[', ']');
    }

    private final TextRange getMarksRange(ImmutableVimCaret caret, char startMark, char endMark) {
        VimEditor editor = caret.getEditor();
        Mark mark = this.getLocalMark(caret, startMark);
        if (mark == null) {
            return null;
        }
        int startOffset = mark.offset(editor);
        Mark mark2 = this.getLocalMark(caret, endMark);
        if (mark2 == null) {
            return null;
        }
        int endOffset = mark2.offset(editor);
        return new TextRange(startOffset, endOffset + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeMark(@NotNull VimEditor editor, char c) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        char markChar = this.normalizeMarkChar(c);
        if (this.isLocalMark(markChar)) {
            void $this$forEach$iv;
            Iterable iterable = editor.carets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                this.removeLocalMark(it, c);
            }
        }
        if (this.isGlobalMark(markChar)) {
            this.removeGlobalMark(c);
        }
    }

    @Override
    public void removeLocalMark(@NotNull ImmutableVimCaret caret, char c) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        char markChar = this.normalizeMarkChar(c);
        if (!this.isLocalMark(markChar)) {
            return;
        }
        if (markChar == '<') {
            this.removeSelectionStartMark(caret);
        } else if (markChar == '>') {
            this.removeSelectionEndMark(caret);
        } else if (caret.isPrimary()) {
            String string = caret.getEditor().getPath();
            if (string == null) {
                return;
            }
            String path = string;
            this.getLocalMarks(path).remove(Character.valueOf(markChar));
        } else {
            caret.getMarkStorage().removeMark(markChar);
        }
    }

    private final void removeSelectionStartMark(ImmutableVimCaret caret) {
        SelectionInfo selectionInfo = caret.getLastSelectionInfo();
        BufferPosition startPosition = selectionInfo.getStart();
        if (startPosition != null) {
            caret.setLastSelectionInfo(new SelectionInfo(null, selectionInfo.getEnd(), selectionInfo.getSelectionType()));
        }
    }

    private final void removeSelectionEndMark(ImmutableVimCaret caret) {
        SelectionInfo selectionInfo = caret.getLastSelectionInfo();
        BufferPosition endPosition = selectionInfo.getEnd();
        if (endPosition != null) {
            caret.setLastSelectionInfo(new SelectionInfo(selectionInfo.getStart(), null, selectionInfo.getSelectionType()));
        }
    }

    @Override
    public void removeGlobalMark(char c) {
        char markChar = this.normalizeMarkChar(c);
        if (this.isGlobalMark(markChar)) {
            this.globalMarks.remove(Character.valueOf(markChar));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateMarksFromInsert(@NotNull VimEditor editor, int insertStartOffset, int insertLength) {
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        List<Pair<ImmutableVimCaret, Set<Mark>>> caretToMarks = this.getAllMarksForFile(editor);
        if (caretToMarks.isEmpty()) {
            return;
        }
        int insertEndOffset = insertStartOffset + insertLength;
        BufferPosition insStart = editor.offsetToBufferPosition(insertStartOffset);
        BufferPosition insEnd = editor.offsetToBufferPosition(insertEndOffset);
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("mark insert. insStart = " + insertStartOffset + ", insEnd = " + insertEndOffset);
        }
        int lines = insEnd.getLine() - insStart.getLine();
        if (lines == 0) {
            return;
        }
        Iterator<Object> iterator = caretToMarks.iterator();
        while (iterator.hasNext()) {
            void $this$filterIsInstanceTo$iv$iv;
            Set marks = (Set)iterator.next().component2();
            Iterable $this$filterIsInstance$iv = marks;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VimMark)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (VimMark mark : (List)destination$iv$iv) {
                VimLogger $this$debug$iv2 = logger;
                boolean $i$f$debug2 = false;
                if ($this$debug$iv2.isDebug()) {
                    vimLogger = $this$debug$iv2;
                    boolean bl = false;
                    vimLogger.debug("mark = " + mark);
                }
                if (mark.getKey() == '<' || mark.getKey() == '>') continue;
                if (insStart.getLine() < mark.getLine()) {
                    mark.setLine(mark.getLine() + lines);
                }
                $this$debug$iv2 = logger;
                $i$f$debug2 = false;
                if (!$this$debug$iv2.isDebug()) continue;
                vimLogger = $this$debug$iv2;
                boolean bl = false;
                vimLogger.debug("Shifting mark by " + lines + " lines");
            }
        }
        for (VimCaret caret : editor.carets()) {
            BufferPosition endPosition;
            SelectionInfo selectionInfo = caret.getLastSelectionInfo();
            BufferPosition startPosition = selectionInfo.getStart();
            BufferPosition newStartPosition = selectionInfo.getStart();
            if (startPosition != null && insStart.getLine() <= startPosition.getLine()) {
                newStartPosition = new BufferPosition(startPosition.getLine() + lines, startPosition.getColumn(), startPosition.getLeansForward());
            }
            BufferPosition newEndPosition = endPosition = selectionInfo.getEnd();
            if (endPosition != null && insStart.getLine() <= endPosition.getLine()) {
                newEndPosition = new BufferPosition(endPosition.getLine() + lines, endPosition.getColumn(), endPosition.getLeansForward());
            }
            if (Intrinsics.areEqual((Object)newStartPosition, (Object)startPosition) && Intrinsics.areEqual((Object)newEndPosition, (Object)endPosition)) continue;
            caret.setLastSelectionInfo(new SelectionInfo(newStartPosition, newEndPosition, selectionInfo.getSelectionType()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateMarksFromDelete(@NotNull VimEditor editor, int delStartOffset, int delLength) {
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        List<Pair<ImmutableVimCaret, Set<Mark>>> caretToMarks = this.getAllMarksForFile(editor);
        if (caretToMarks.isEmpty()) {
            return;
        }
        int delEndOffset = delStartOffset + delLength - 1;
        BufferPosition delStart = editor.offsetToBufferPosition(delStartOffset);
        BufferPosition delEnd = editor.offsetToBufferPosition(delEndOffset + 1);
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("mark delete. delStart = " + delStart + ", delEnd = " + delEnd);
        }
        for (Pair<ImmutableVimCaret, Set<Mark>> pair : caretToMarks) {
            void $this$filterIsInstanceTo$iv$iv;
            ImmutableVimCaret caret = (ImmutableVimCaret)pair.component1();
            Set marks = (Set)pair.component2();
            Iterable $this$filterIsInstance$iv = marks;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VimMark)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (VimMark mark : (List)destination$iv$iv) {
                boolean changeFromMarkLineStart;
                VimLogger $this$debug$iv2 = logger;
                boolean $i$f$debug2 = false;
                if ($this$debug$iv2.isDebug()) {
                    vimLogger = $this$debug$iv2;
                    boolean bl = false;
                    vimLogger.debug("mark = " + mark);
                }
                if (delEnd.getLine() < mark.getLine()) {
                    int lines = delEnd.getLine() - delStart.getLine();
                    VimLogger $this$debug$iv3 = logger;
                    boolean $i$f$debug3 = false;
                    if ($this$debug$iv3.isDebug()) {
                        vimLogger = $this$debug$iv3;
                        boolean bl = false;
                        vimLogger.debug("Shifting mark by " + lines + " lines");
                    }
                    mark.setLine(mark.getLine() - lines);
                    continue;
                }
                if (delStart.getLine() > mark.getLine()) continue;
                int markLineStartOffset = editor.getLineStartOffset(mark.getLine());
                int markLineEndOffset = EngineEditorHelperKt.getLineEndOffset(editor, mark.getLine(), true);
                Command command2 = VimInjectorKt.getInjector().getVimState().getExecutingCommand();
                boolean bl = changeFromMarkLineStart = command2 != null && command2.getType() == Command.Type.CHANGE && delStartOffset == markLineStartOffset;
                if (delStartOffset <= markLineStartOffset && delEndOffset >= markLineEndOffset && !changeFromMarkLineStart) {
                    if (caret == null) {
                        this.removeGlobalMark(mark.getKey());
                    } else {
                        VimInjectorKt.getInjector().getMarkService().removeLocalMark(caret, mark.getKey());
                    }
                    logger.debug("Removed mark");
                    continue;
                }
                if (delStart.getLine() >= mark.getLine()) continue;
                mark.setLine(delStart.getLine());
                if ((mark.getKey() == '<' || mark.getKey() == '>') && caret != null) {
                    this.setMark(caret, mark);
                }
                VimLogger $this$debug$iv4 = logger;
                boolean $i$f$debug4 = false;
                if (!$this$debug$iv4.isDebug()) continue;
                vimLogger = $this$debug$iv4;
                boolean bl2 = false;
                vimLogger.debug("Shifting mark to line " + delStart.getLine());
            }
        }
    }

    @Override
    public void editorReleased(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.setMark(editor.primaryCaret(), '\"', editor.primaryCaret().getOffset());
    }

    @Override
    public void resetAllMarksForCaret(@NotNull ImmutableVimCaret caret) {
        SelectionInfo selectionInfo;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (caret.isPrimary()) {
            this.filepathToLocalMarks.clear();
        } else {
            caret.getMarkStorage().clear(caret);
        }
        SelectionInfo $this$resetAllMarksForCaret_u24lambda_u240 = selectionInfo = caret.getLastSelectionInfo();
        boolean bl = false;
        $this$resetAllMarksForCaret_u24lambda_u240.setStart(null);
        $this$resetAllMarksForCaret_u24lambda_u240.setEnd(null);
    }

    @Override
    public void resetAllMarks() {
        for (VimEditor editor : VimInjectorKt.getInjector().getEditorGroup().getEditors()) {
            Iterable $this$forEach$iv = editor.carets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                this.resetAllMarksForCaret(it);
            }
        }
        this.filepathToLocalMarks.clear();
        this.globalMarks.clear();
    }

    @Override
    public boolean isValidMark(char c, @NotNull VimMarkService.Operation operation, boolean isCaretPrimary) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1 -> {
                if (this.isLocalMark(c) || this.isGlobalMark(c)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyz[]<>'.\"^", (char)c, (boolean)false, (int)2, null) || isCaretPrimary && StringsKt.contains$default((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (char)c, (boolean)false, (int)2, null)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyz[]<>.\"^", (char)c, (boolean)false, (int)2, null) || isCaretPrimary && StringsKt.contains$default((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (char)c, (boolean)false, (int)2, null)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (isCaretPrimary && StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyz'.^\"[]", (char)c, (boolean)false, (int)2, null)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isOperationValidOnMark(char $this$isOperationValidOnMark, VimMarkService.Operation operation, ImmutableVimCaret caret) {
        return this.isValidMark($this$isOperationValidOnMark, operation, caret.isPrimary());
    }

    protected final boolean isGlobalMark(char $this$isGlobalMark) {
        return StringsKt.contains$default((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (char)$this$isGlobalMark, (boolean)false, (int)2, null);
    }

    protected final boolean isLocalMark(char $this$isLocalMark) {
        return StringsKt.contains$default((CharSequence)"abcdefghijklmnopqrstuvwxyz[]<>(){}'.\"^", (char)$this$isLocalMark, (boolean)false, (int)2, null);
    }

    private final VimMark getParagraphMark(VimEditor editor, ImmutableVimCaret caret, char c) {
        VimVirtualFile vimVirtualFile = editor.getVirtualFile();
        if (vimVirtualFile == null) {
            return null;
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        String path = virtualFile.getPath();
        int count = switch (c) {
            case '{' -> -1;
            case '}' -> 1;
            default -> throw new IllegalArgumentException("Invalid paragraph mark char");
        };
        Integer offset = VimInjectorKt.getInjector().getSearchHelper().findNextParagraph(editor, caret, count, false);
        if (offset == null) {
            logger.error("Failed to find next paragraph with count = " + count);
            return null;
        }
        offset = EngineEditorHelperKt.normalizeOffset(editor, offset, false);
        BufferPosition lp = editor.offsetToBufferPosition(offset);
        String protocol = virtualFile.getProtocol();
        return new VimMark(c, lp.getLine(), lp.getColumn(), path, protocol);
    }

    private final VimMark getSentenceMark(VimEditor editor, ImmutableVimCaret caret, char c) {
        VimVirtualFile vimVirtualFile = editor.getVirtualFile();
        if (vimVirtualFile == null) {
            return null;
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        String path = virtualFile.getPath();
        int count = switch (c) {
            case '(' -> -1;
            case ')' -> 1;
            default -> throw new IllegalArgumentException("Invalid sentence mark char");
        };
        Integer n = VimInjectorKt.getInjector().getSearchHelper().findNextSentenceStart(editor, caret, count, false, true);
        if (n == null) {
            return null;
        }
        int offset = n;
        offset = EngineEditorHelperKt.normalizeOffset(editor, offset, false);
        BufferPosition lp = editor.offsetToBufferPosition(offset);
        String protocol = virtualFile.getProtocol();
        return new VimMark(c, lp.getLine(), lp.getColumn(), path, protocol);
    }

    @Nullable
    protected final Mark createSelectionStartMark(@NotNull ImmutableVimCaret caret) {
        Integer n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        SelectionInfo selectionInfo = caret.getLastSelectionInfo();
        BufferPosition bufferPosition = selectionInfo.getStart();
        if (bufferPosition != null) {
            BufferPosition it = bufferPosition;
            boolean bl = false;
            n2 = caret.getEditor().bufferPositionToOffset(it);
        } else {
            n2 = null;
        }
        Integer startOffset = n2;
        BufferPosition bufferPosition2 = selectionInfo.getEnd();
        if (bufferPosition2 != null) {
            BufferPosition it = bufferPosition2;
            boolean bl = false;
            n = caret.getEditor().bufferPositionToOffset(it);
        } else {
            n = null;
        }
        Integer endOffset = n;
        Integer n3 = startOffset != null && endOffset != null ? Integer.valueOf(Integer.min(startOffset, endOffset)) : startOffset;
        if (n3 == null) {
            return null;
        }
        int offset = n3;
        if (selectionInfo.getSelectionType() == SelectionType.LINE_WISE) {
            offset = EngineEditorHelperKt.getLineStartForOffset(caret.getEditor(), offset);
        }
        return this.createMark(caret, '<', offset);
    }

    @Nullable
    protected final Mark getSelectionEndMark(@NotNull ImmutableVimCaret caret) {
        Integer n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        SelectionInfo selectionInfo = caret.getLastSelectionInfo();
        BufferPosition bufferPosition = selectionInfo.getStart();
        if (bufferPosition != null) {
            BufferPosition it = bufferPosition;
            boolean bl = false;
            n2 = caret.getEditor().bufferPositionToOffset(it);
        } else {
            n2 = null;
        }
        Integer startOffset = n2;
        BufferPosition bufferPosition2 = selectionInfo.getEnd();
        if (bufferPosition2 != null) {
            BufferPosition it = bufferPosition2;
            boolean bl = false;
            n = caret.getEditor().bufferPositionToOffset(it);
        } else {
            n = null;
        }
        Integer endOffset = n;
        Integer n3 = startOffset != null && endOffset != null ? Integer.valueOf(Integer.max(startOffset, endOffset)) : endOffset;
        if (n3 == null) {
            return null;
        }
        int offset = n3;
        if (selectionInfo.getSelectionType() == SelectionType.LINE_WISE) {
            offset = EngineEditorHelperKt.getLineEndForOffset(caret.getEditor(), offset);
        }
        return this.createMark(caret, '>', offset);
    }

    private final void setSelectionStartMark(ImmutableVimCaret caret, int offset) {
        SelectionInfo selectionInfo = caret.getLastSelectionInfo();
        caret.setLastSelectionInfo(new SelectionInfo(caret.getEditor().offsetToBufferPosition(offset), selectionInfo.getEnd(), selectionInfo.getSelectionType()));
    }

    private final void setSelectionEndMark(ImmutableVimCaret caret, int offset) {
        SelectionInfo selectionInfo = caret.getLastSelectionInfo();
        caret.setLastSelectionInfo(new SelectionInfo(selectionInfo.getStart(), caret.getEditor().offsetToBufferPosition(offset), selectionInfo.getSelectionType()));
    }

    private final Mark createMark(ImmutableVimCaret caret, char c, int offset) {
        VimEditor editor = caret.getEditor();
        VimVirtualFile vimVirtualFile = editor.getVirtualFile();
        if (vimVirtualFile == null) {
            return null;
        }
        VimVirtualFile virtualFile = vimVirtualFile;
        BufferPosition position = editor.offsetToBufferPosition(offset);
        return new VimMark(c, position.getLine(), position.getColumn(), virtualFile.getPath(), virtualFile.getProtocol());
    }

    protected final char normalizeMarkChar(char $this$normalizeMarkChar) {
        return $this$normalizeMarkChar == '`' ? (char)'\'' : (char)$this$normalizeMarkChar;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimMarkServiceBase.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/api/VimMarkServiceBase$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u001f\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/api/VimMarkServiceBase$LocalMarks;", "K", "V", "Ljava/util/HashMap;", "<init>", "()V", "myTimestamp", "Ljava/util/Date;", "getMyTimestamp", "()Ljava/util/Date;", "setMyTimestamp", "(Ljava/util/Date;)V", "setTimestamp", "", "timestamp", "put", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "vim-engine"})
    public static final class LocalMarks<K, V>
    extends HashMap<K, V> {
        @NotNull
        private Date myTimestamp = new Date();

        @NotNull
        public final Date getMyTimestamp() {
            return this.myTimestamp;
        }

        public final void setMyTimestamp(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"<set-?>");
            this.myTimestamp = date;
        }

        public final void setTimestamp(@NotNull Date timestamp) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this.myTimestamp = timestamp;
        }

        @Override
        @Nullable
        public V put(K key, V value) {
            this.myTimestamp = new Date();
            return super.put(key, value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VimMarkService.Operation.values().length];
            try {
                nArray[VimMarkService.Operation.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimMarkService.Operation.SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimMarkService.Operation.REMOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VimMarkService.Operation.SAVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

