/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Address;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0017J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010#\u001a\u00020\u000fH\u0016R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/Range;", "", "<init>", "()V", "addresses", "", "Lcom/maddyhome/idea/vim/ex/ranges/Address;", "getAddresses", "()Ljava/util/List;", "addAddresses", "", "range", "", "([Lcom/maddyhome/idea/vim/ex/ranges/Address;)V", "size", "", "defaultRange", "", "getDefaultRange", "()Ljava/lang/String;", "setDefaultRange", "(Ljava/lang/String;)V", "getLine", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "getCount", "getLineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "processRange", "toString", "equals", "", "other", "hashCode", "vim-engine"})
public final class Range {
    @TestOnly
    @NotNull
    private final List<Address> addresses = new ArrayList();
    @NotNull
    private String defaultRange = ".";

    @NotNull
    public final List<Address> getAddresses() {
        return this.addresses;
    }

    public final void addAddresses(@NotNull Address[] range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        CollectionsKt.addAll((Collection)this.addresses, (Object[])range);
    }

    public final int size() {
        return this.addresses.size();
    }

    @NotNull
    public final String getDefaultRange() {
        return this.defaultRange;
    }

    public final void setDefaultRange(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultRange = string;
    }

    public final int getLine(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.getLineRange((VimEditor)editor, (VimCaret)caret).endLine;
    }

    public final int getCount(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.processRange(editor, caret).getEndLine1();
    }

    @NotNull
    public final LineRange getLineRange(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.processRange(editor, caret);
    }

    private final LineRange processRange(VimEditor editor, VimCaret caret) {
        Object object;
        int startLine1 = 0;
        int endLine1 = 0;
        Object[] objectArray = (Object[])this.addresses;
        if (objectArray.isEmpty()) {
            boolean bl = false;
            object = Address.Companion.createRangeAddresses(this.defaultRange, 0, false);
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                throw ExExceptionsKt.exExceptionMessage("E16", new Object[0]);
            }
        } else {
            object = objectArray;
        }
        List addresses = (List)object;
        for (Address address : addresses) {
            startLine1 = endLine1;
            endLine1 = address.getLine1(editor, caret);
            if (!address.isMove()) continue;
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineWithSameColumn(editor, endLine1 - 1, caret));
        }
        if (startLine1 < 0 || endLine1 < 0) {
            throw ExExceptionsKt.exExceptionMessage("E16", new Object[0]);
        }
        if (addresses.size() == 1) {
            startLine1 = endLine1;
        }
        return new LineRange(startLine1 - 1, endLine1 - 1);
    }

    @NonNls
    @NotNull
    public String toString() {
        return "Ranges[addresses=" + this.addresses + "]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultRange, (Object)((Range)other).defaultRange)) {
            return false;
        }
        return Intrinsics.areEqual(this.addresses, ((Range)other).addresses);
    }

    public int hashCode() {
        int result = this.defaultRange.hashCode();
        result = 31 * result + ((Object)this.addresses).hashCode();
        return result;
    }
}

