/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/SelectRegisterConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "<init>", "()V", "isApplicable", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "consumeKey", "handleSelectRegister", "", "chKey", "", "processBuilder", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nSelectRegisterConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectRegisterConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/SelectRegisterConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,69:1\n39#2:70\n*S KotlinDebug\n*F\n+ 1 SelectRegisterConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/SelectRegisterConsumer\n*L\n28#1:70\n*E\n"})
public final class SelectRegisterConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean isApplicable(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        return keyProcessResultBuilder.getState().getCommandBuilder().isRegisterPending();
    }

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        logger.trace("Entered SelectRegisterConsumer");
        CommandBuilder commandBuilder = keyProcessResultBuilder.getState().getCommandBuilder();
        commandBuilder.addTypedKeyStroke(key);
        char chKey = key.getKeyChar() == '\uffff' ? (char)'\u0000' : key.getKeyChar();
        this.handleSelectRegister(chKey, keyProcessResultBuilder);
        return true;
    }

    private final void handleSelectRegister(char chKey, KeyProcessResult.KeyProcessResultBuilder processBuilder) {
        logger.trace("Handle select register");
        if (VimInjectorKt.getInjector().getRegisterGroup().isValid(chKey)) {
            logger.trace("Valid register");
            processBuilder.getState().getCommandBuilder().selectRegister(chKey);
        } else {
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)SelectRegisterConsumer::handleSelectRegister$lambda$0));
        }
    }

    private static final Unit handleSelectRegister$lambda$0(KeyHandlerState lambdaKeyState, VimEditor lambdaEditor, ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
        Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<unused var>");
        logger.trace("Invalid register, set command state to BAD_COMMAND");
        KeyHandler.Companion.getInstance().setBadCommand(lambdaEditor, lambdaKeyState);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(SelectRegisterConsumer.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/SelectRegisterConsumer$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

