/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.thinapi;

import com.intellij.vim.api.VimApi;
import com.intellij.vim.api.scopes.TextObjectRange;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.command.TextObjectVisualType;
import com.maddyhome.idea.vim.common.ListenerOwner;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.thinapi.VimApiImpl;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012.\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\t\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J2\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\t\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/maddyhome/idea/vim/thinapi/ApiTextObjectActionHandler;", "Lcom/maddyhome/idea/vim/handler/TextObjectActionHandler;", "listenerOwner", "Lcom/maddyhome/idea/vim/common/ListenerOwner;", "mappingOwner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "preserveSelectionAnchor", "", "rangeProvider", "Lkotlin/Function2;", "Lcom/intellij/vim/api/VimApi;", "", "Lkotlin/ParameterName;", "name", "count", "Lcom/intellij/vim/api/scopes/TextObjectRange;", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lcom/maddyhome/idea/vim/common/ListenerOwner;Lcom/maddyhome/idea/vim/key/MappingOwner;ZLkotlin/jvm/functions/Function2;)V", "getPreserveSelectionAnchor", "()Z", "computedVisualType", "Lcom/maddyhome/idea/vim/command/TextObjectVisualType;", "visualType", "getVisualType", "()Lcom/maddyhome/idea/vim/command/TextObjectVisualType;", "getRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "rawCount", "vim-engine"})
final class ApiTextObjectActionHandler
extends TextObjectActionHandler {
    @NotNull
    private final ListenerOwner listenerOwner;
    @NotNull
    private final MappingOwner mappingOwner;
    private final boolean preserveSelectionAnchor;
    @NotNull
    private final Function2<VimApi, Integer, TextObjectRange> rangeProvider;
    @NotNull
    private TextObjectVisualType computedVisualType;

    public ApiTextObjectActionHandler(@NotNull ListenerOwner listenerOwner, @NotNull MappingOwner mappingOwner, boolean preserveSelectionAnchor, @NotNull Function2<? super VimApi, ? super Integer, ? extends TextObjectRange> rangeProvider) {
        Intrinsics.checkNotNullParameter((Object)listenerOwner, (String)"listenerOwner");
        Intrinsics.checkNotNullParameter((Object)mappingOwner, (String)"mappingOwner");
        Intrinsics.checkNotNullParameter(rangeProvider, (String)"rangeProvider");
        this.listenerOwner = listenerOwner;
        this.mappingOwner = mappingOwner;
        this.preserveSelectionAnchor = preserveSelectionAnchor;
        this.rangeProvider = rangeProvider;
        this.computedVisualType = TextObjectVisualType.CHARACTER_WISE;
    }

    @Override
    public boolean getPreserveSelectionAnchor() {
        return this.preserveSelectionAnchor;
    }

    @Override
    @NotNull
    public TextObjectVisualType getVisualType() {
        return this.computedVisualType;
    }

    @Override
    @Nullable
    public TextRange getRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, int count, int rawCount) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VimApiImpl vimApi = new VimApiImpl(this.listenerOwner, this.mappingOwner);
        TextObjectRange textObjectRange = (TextObjectRange)this.rangeProvider.invoke((Object)vimApi, (Object)count);
        if (textObjectRange == null) {
            return null;
        }
        TextObjectRange apiRange = textObjectRange;
        TextObjectRange textObjectRange2 = apiRange;
        if (textObjectRange2 instanceof TextObjectRange.CharacterWise) {
            this.computedVisualType = TextObjectVisualType.CHARACTER_WISE;
            textRange = new TextRange(((TextObjectRange.CharacterWise)apiRange).getStart(), ((TextObjectRange.CharacterWise)apiRange).getEnd());
        } else if (textObjectRange2 instanceof TextObjectRange.LineWise) {
            this.computedVisualType = TextObjectVisualType.LINE_WISE;
            int startOffset = editor.getLineStartOffset(((TextObjectRange.LineWise)apiRange).getStartLine());
            int endOffset = EngineEditorHelperKt.getLineEndOffset(editor, ((TextObjectRange.LineWise)apiRange).getEndLine(), true);
            textRange = new TextRange(startOffset, endOffset);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return textRange;
    }
}

