/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.LineRangeKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J'\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0007H\u00d6\u0001J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/ShiftRightCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "length", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;I)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getArgument", "()Ljava/lang/String;", "getLength", "()I", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nShiftRightCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShiftRightCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/ShiftRightCommand\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,58:1\n11591#2:59\n11926#2,3:60\n*S KotlinDebug\n*F\n+ 1 ShiftRightCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/ShiftRightCommand\n*L\n40#1:59\n40#1:60,3\n*E\n"})
public final class ShiftRightCommand
extends Command.ForEachCaret {
    @NotNull
    private final Range range;
    @NotNull
    private final String argument;
    private final int length;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public ShiftRightCommand(@NotNull Range range, @NotNull String argument, int length) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, CommandModifier.NONE, argument);
        this.range = range;
        this.argument = argument;
        this.length = length;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.WRITABLE, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        LineRange lineRange = this.getLineRangeWithCount(editor, caret);
        TextRange textRange = LineRangeKt.toTextRange(lineRange, editor);
        int[] $this$map$iv = textRange.getEndOffsets();
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var16_16 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)(it - true));
        }
        int[] endOffsets = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        VimInjectorKt.getInjector().getChangeGroup().indentRange(editor, caret, context, new TextRange(textRange.getStartOffsets(), endOffsets), this.length, 1, operatorArguments);
        int offset = VimInjectorKt.getInjector().getMotion().moveCaretToLineStartSkipLeading(editor, lineRange.endLine);
        caret.moveToOffset(offset);
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    public final int component3() {
        return this.length;
    }

    @NotNull
    public final ShiftRightCommand copy(@NotNull Range range, @NotNull String argument, int length) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new ShiftRightCommand(range, argument, length);
    }

    public static /* synthetic */ ShiftRightCommand copy$default(ShiftRightCommand shiftRightCommand, Range range, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            range = shiftRightCommand.range;
        }
        if ((n2 & 2) != 0) {
            string = shiftRightCommand.argument;
        }
        if ((n2 & 4) != 0) {
            n = shiftRightCommand.length;
        }
        return shiftRightCommand.copy(range, string, n);
    }

    @NotNull
    public String toString() {
        return "ShiftRightCommand(range=" + this.range + ", argument=" + this.argument + ", length=" + this.length + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.argument.hashCode();
        result = result * 31 + Integer.hashCode(this.length);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShiftRightCommand)) {
            return false;
        }
        ShiftRightCommand shiftRightCommand = (ShiftRightCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)shiftRightCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.argument, (Object)shiftRightCommand.argument)) {
            return false;
        }
        return this.length == shiftRightCommand.length;
    }
}

