/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.GoalCommand;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.InvalidCommandException;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0001,B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J1\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020 H\u00d6\u0001J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/UnknownCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "name", "", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getName", "()Ljava/lang/String;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "processPossiblyAliasCommand", "aliasCountdown", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "Constants", "vim-engine"})
public final class UnknownCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final String name;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public UnknownCommand(@NotNull Range range, @NotNull String name, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, argument);
        this.range = range;
        this.name = name;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        return this.processPossiblyAliasCommand(this.name + " " + this.argument, editor, context, 100);
    }

    private final ExecutionResult processPossiblyAliasCommand(String name, VimEditor editor, ExecutionContext context, int aliasCountdown) {
        if (VimInjectorKt.getInjector().getCommandGroup().isAlias(name)) {
            if (aliasCountdown > 0) {
                GoalCommand commandAlias = VimInjectorKt.getInjector().getCommandGroup().getAliasCommand(name, 1);
                GoalCommand goalCommand = commandAlias;
                if (goalCommand instanceof GoalCommand.Ex) {
                    ExecutionResult executionResult;
                    if (((CharSequence)((GoalCommand.Ex)commandAlias).getCommand()).length() == 0) {
                        Object[] objectArray = new Object[]{name};
                        String message = VimInjectorKt.getInjector().getMessages().message("E492", objectArray);
                        throw new InvalidCommandException(message, null);
                    }
                    Command command2 = VimInjectorKt.getInjector().getVimscriptParser().parseCommand(((GoalCommand.Ex)commandAlias).getCommand());
                    if (command2 == null) {
                        Object[] objectArray = new Object[]{((GoalCommand.Ex)commandAlias).getCommand()};
                        throw ExExceptionsKt.exExceptionMessage("E492", objectArray);
                    }
                    Command parsedCommand = command2;
                    if (parsedCommand instanceof UnknownCommand) {
                        executionResult = this.processPossiblyAliasCommand(((GoalCommand.Ex)commandAlias).getCommand(), editor, context, aliasCountdown - 1);
                    } else {
                        parsedCommand.setVimContext(this.getVimContext());
                        parsedCommand.execute(editor, context);
                        executionResult = ExecutionResult.Success.INSTANCE;
                    }
                    return executionResult;
                }
                if (goalCommand instanceof GoalCommand.Call) {
                    ((GoalCommand.Call)commandAlias).getHandler().execute(name, this.range, editor, context);
                    return ExecutionResult.Success.INSTANCE;
                }
                throw new NoWhenBranchMatchedException();
            }
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E169", new Object[0]));
            VimInjectorKt.getInjector().getMessages().indicateError();
            return ExecutionResult.Error.INSTANCE;
        }
        Object[] objectArray = new Object[]{name};
        throw ExExceptionsKt.exExceptionMessage("E492", objectArray);
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final CommandModifier component3() {
        return this.modifier;
    }

    @NotNull
    public final String component4() {
        return this.argument;
    }

    @NotNull
    public final UnknownCommand copy(@NotNull Range range, @NotNull String name, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new UnknownCommand(range, name, modifier, argument);
    }

    public static /* synthetic */ UnknownCommand copy$default(UnknownCommand unknownCommand, Range range, String string, CommandModifier commandModifier, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            range = unknownCommand.range;
        }
        if ((n & 2) != 0) {
            string = unknownCommand.name;
        }
        if ((n & 4) != 0) {
            commandModifier = unknownCommand.modifier;
        }
        if ((n & 8) != 0) {
            string2 = unknownCommand.argument;
        }
        return unknownCommand.copy(range, string, commandModifier, string2);
    }

    @NotNull
    public String toString() {
        return "UnknownCommand(range=" + this.range + ", name=" + this.name + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnknownCommand)) {
            return false;
        }
        UnknownCommand unknownCommand = (UnknownCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)unknownCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)unknownCommand.name)) {
            return false;
        }
        if (this.modifier != unknownCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)unknownCommand.argument);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/UnknownCommand$Constants;", "", "<init>", "()V", "MAX_RECURSION", "", "vim-engine"})
    private static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        public static final int MAX_RECURSION = 100;

        private Constants() {
        }
    }
}

