/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.datatypes;

import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFloat;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0000H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "value", "", "<init>", "(I)V", "getValue", "()I", "booleanValue", "", "getBooleanValue", "()Z", "toVimFloat", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimFloat;", "toVimNumber", "toVimString", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimString;", "toOutputString", "", "copy", "lockVar", "", "depth", "unlockVar", "compareTo", "b", "component1", "equals", "other", "", "hashCode", "Companion", "vim-engine"})
public final class VimInt
extends VimDataType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;
    private final boolean booleanValue;
    @NotNull
    private static final VimInt MINUS_ONE = new VimInt(-1);
    @NotNull
    private static final VimInt ZERO = new VimInt(0);
    @NotNull
    private static final VimInt ONE = new VimInt(1);

    public VimInt(int value) {
        super("number");
        this.value = value;
        this.booleanValue = this.value != 0;
    }

    public final int getValue() {
        return this.value;
    }

    public final boolean getBooleanValue() {
        return this.booleanValue;
    }

    @Override
    @NotNull
    public VimFloat toVimFloat() {
        throw new IllegalStateException("Using a Number as a Float is not allowed".toString());
    }

    @Override
    @NotNull
    public VimInt toVimNumber() {
        return this;
    }

    @Override
    @NotNull
    public VimString toVimString() {
        return new VimString(String.valueOf(this.value));
    }

    @Override
    @NotNull
    public String toOutputString() {
        return String.valueOf(this.value);
    }

    @Override
    @NotNull
    public VimInt copy() {
        return new VimInt(this.value);
    }

    @Override
    public void lockVar(int depth) {
        this.setLocked(true);
    }

    @Override
    public void unlockVar(int depth) {
        this.setLocked(false);
    }

    public final int compareTo(int b) {
        return Intrinsics.compare((int)this.value, (int)b);
    }

    public final int component1() {
        return this.value;
    }

    @NotNull
    public final VimInt copy(int value) {
        return new VimInt(value);
    }

    public static /* synthetic */ VimInt copy$default(VimInt vimInt, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = vimInt.value;
        }
        return vimInt.copy(n);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VimInt)) {
            return false;
        }
        VimInt vimInt = (VimInt)other;
        return this.value == vimInt.value;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt$Companion;", "", "<init>", "()V", "MINUS_ONE", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "getMINUS_ONE", "()Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "ZERO", "getZERO", "ONE", "getONE", "parseNumber", "binaryOctalDecimalOrHexNumber", "", "allowTrailingCharacters", "", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimInt getMINUS_ONE() {
            return MINUS_ONE;
        }

        @NotNull
        public final VimInt getZERO() {
            return ZERO;
        }

        @NotNull
        public final VimInt getONE() {
            return ONE;
        }

        @Nullable
        public final VimInt parseNumber(@NotNull String binaryOctalDecimalOrHexNumber, boolean allowTrailingCharacters) {
            int n;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)binaryOctalDecimalOrHexNumber, (String)"binaryOctalDecimalOrHexNumber");
            int index = 0;
            if (StringsKt.startsWith$default((String)binaryOctalDecimalOrHexNumber, (String)"-", (boolean)false, (int)2, null)) {
                ++index;
                bl = true;
            } else {
                bl = false;
            }
            boolean negative = bl;
            if (StringsKt.startsWith((String)binaryOctalDecimalOrHexNumber, (String)"0x", (int)index, (boolean)true)) {
                index += 2;
                n = 16;
            } else if (StringsKt.startsWith((String)binaryOctalDecimalOrHexNumber, (String)"0o", (int)index, (boolean)true)) {
                index += 2;
                n = 8;
            } else if (StringsKt.startsWith((String)binaryOctalDecimalOrHexNumber, (String)"0b", (int)index, (boolean)true)) {
                index += 2;
                n = 2;
            } else {
                CharSequence charSequence = binaryOctalDecimalOrHexNumber;
                if (new Regex("-?0[0-7]*[89]+.*").matches(charSequence)) {
                    ++index;
                    n = 10;
                } else if (StringsKt.startsWith$default((String)binaryOctalDecimalOrHexNumber, (String)"0", (int)index, (boolean)false, (int)4, null)) {
                    ++index;
                    n = 8;
                } else {
                    n = 10;
                }
            }
            int radix = n;
            int value = 0;
            while (index < binaryOctalDecimalOrHexNumber.length()) {
                Integer digit = CharsKt.digitToIntOrNull((char)binaryOctalDecimalOrHexNumber.charAt(index), (int)radix);
                if (digit == null) {
                    if (allowTrailingCharacters) break;
                    return null;
                }
                value = value * radix + digit;
                ++index;
            }
            return negative ? new VimInt(-value) : new VimInt(value);
        }

        public static /* synthetic */ VimInt parseNumber$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.parseNumber(string, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

