/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.LambdaExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/LambdaFunctionCallExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "lambda", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/LambdaExpression;", "arguments", "", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/LambdaExpression;Ljava/util/List;)V", "getLambda", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/LambdaExpression;", "getArguments", "()Ljava/util/List;", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "vim-engine"})
public final class LambdaFunctionCallExpression
extends Expression {
    @NotNull
    private final LambdaExpression lambda;
    @NotNull
    private final List<Expression> arguments;

    public LambdaFunctionCallExpression(@NotNull LambdaExpression lambda, @NotNull List<? extends Expression> arguments) {
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.lambda = lambda;
        this.arguments = arguments;
    }

    @NotNull
    public final LambdaExpression getLambda() {
        return this.lambda;
    }

    @NotNull
    public final List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public VimDataType evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimFuncref funcref = this.lambda.evaluate(editor, context, vimContext);
        return funcref.execute(this.arguments, null, editor, context, vimContext);
    }
}

