/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFloat;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.VariableExpression;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00011B\u001d\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ=\u0010\u0018\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020&2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J=\u0010+\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010.J7\u0010+\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020/2\b\u0010\u001c\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H$\u00a2\u0006\u0002\u00100R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010'\u001a\u00020(X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00062"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase;", "T", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "minArity", "", "maxArity", "<init>", "(ILjava/lang/Integer;)V", "getMinArity", "()I", "getMaxArity", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "getScope", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "executeFunction", "arguments", "", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "(Ljava/util/List;Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ExecutionContext;Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;)Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "checkFunctionCall", "", "handlesRange", "", "getHandlesRange", "()Z", "doFunction", "lineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "(Ljava/util/List;Lcom/maddyhome/idea/vim/ex/ranges/LineRange;Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ExecutionContext;Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;)Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase$Arguments;", "(Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase$Arguments;Lcom/maddyhome/idea/vim/ex/ranges/LineRange;Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ExecutionContext;Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;)Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "Arguments", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1563#2:211\n1634#2,3:212\n*S KotlinDebug\n*F\n+ 1 FunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase\n*L\n121#1:211\n121#1:212,3\n*E\n"})
public abstract class FunctionHandlerBase<T extends VimDataType>
implements FunctionHandler {
    private final int minArity;
    @Nullable
    private final Integer maxArity;
    public String name;
    @Nullable
    private final Scope scope;

    public FunctionHandlerBase(int minArity, @Nullable Integer maxArity) {
        this.minArity = minArity;
        this.maxArity = maxArity;
    }

    public /* synthetic */ FunctionHandlerBase(int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        this(n, n2);
    }

    protected final int getMinArity() {
        return this.minArity;
    }

    @Nullable
    protected final Integer getMaxArity() {
        return this.maxArity;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        return null;
    }

    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @NotNull
    public T executeFunction(@NotNull List<? extends Expression> arguments, @Nullable Range range, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        boolean hasRange;
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        this.checkFunctionCall(arguments);
        boolean bl = hasRange = range != null && range.size() > 0;
        if (hasRange) {
            LineRange lineRange = range.getLineRange(editor, editor.currentCaret());
            if (lineRange.getStartLine1() > editor.lineCount() || lineRange.getEndLine1() > editor.lineCount()) {
                throw ExExceptionsKt.exExceptionMessage("E16", new Object[0]);
            }
            if (this.getHandlesRange()) {
                editor.currentCaret().moveToBufferPosition(new BufferPosition(lineRange.startLine, 0, false, 4, null));
                return this.doFunction(arguments, lineRange, editor, context, vimContext);
            }
            T lastRetval = null;
            int line = lineRange.startLine;
            int n = lineRange.endLine;
            if (line <= n) {
                while (true) {
                    editor.currentCaret().moveToBufferPosition(new BufferPosition(line, 0, false, 4, null));
                    lastRetval = this.doFunction(arguments, lineRange, editor, context, vimContext);
                    if (line == n) break;
                    ++line;
                }
            }
            T t = lastRetval;
            if (t == null) {
                throw ExExceptionsKt.exExceptionMessage("E16", new Object[0]);
            }
            return t;
        }
        return this.doFunction(arguments, null, editor, context, vimContext);
    }

    private final void checkFunctionCall(List<? extends Expression> arguments) {
        if (arguments.size() < this.minArity) {
            Object[] objectArray = new Object[]{this.getName()};
            throw ExExceptionsKt.exExceptionMessage("E119", objectArray);
        }
        if (this.maxArity != null && arguments.size() > this.maxArity) {
            Object[] objectArray = new Object[]{this.getName()};
            throw ExExceptionsKt.exExceptionMessage("E118", objectArray);
        }
    }

    protected abstract boolean getHandlesRange();

    /*
     * WARNING - void declaration
     */
    private final T doFunction(List<? extends Expression> arguments, LineRange lineRange, VimEditor editor, ExecutionContext context, VimLContext vimContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = arguments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Expression expression = (Expression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.evaluate(editor, context, vimContext));
        }
        List values = (List)destination$iv$iv;
        return this.doFunction(new Arguments(values, editor, context), lineRange, editor, context, vimContext);
    }

    @NotNull
    protected abstract T doFunction(@NotNull Arguments var1, @Nullable LineRange var2, @NotNull VimEditor var3, @NotNull ExecutionContext var4, @NotNull VimLContext var5);

    public FunctionHandlerBase() {
        this(0, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\fH\u0086\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase$Arguments;", "", "arguments", "", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "<init>", "(Ljava/util/List;Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ExecutionContext;)V", "size", "", "getSize", "()I", "get", "index", "getOrNull", "getNumber", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "getNumberOrNull", "getString", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimString;", "getStringOrNull", "getNumberOrFloat", "", "getVariable", "name", "", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "setVariable", "", "value", "vim-engine"})
    protected static final class Arguments {
        @NotNull
        private final List<VimDataType> arguments;
        @NotNull
        private final VimEditor editor;
        @NotNull
        private final ExecutionContext context;
        private final int size;

        public Arguments(@NotNull List<? extends VimDataType> arguments, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.arguments = arguments;
            this.editor = editor;
            this.context = context;
            this.size = this.arguments.size();
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final VimDataType get(int index) {
            return this.arguments.get(index);
        }

        @Nullable
        public final VimDataType getOrNull(int index) {
            return (VimDataType)CollectionsKt.getOrNull(this.arguments, (int)index);
        }

        @NotNull
        public final VimInt getNumber(int index) {
            return this.arguments.get(index).toVimNumber();
        }

        @Nullable
        public final VimInt getNumberOrNull(int index) {
            VimDataType vimDataType = (VimDataType)CollectionsKt.getOrNull(this.arguments, (int)index);
            return vimDataType != null ? vimDataType.toVimNumber() : null;
        }

        @NotNull
        public final VimString getString(int index) {
            return this.arguments.get(index).toVimString();
        }

        @Nullable
        public final VimString getStringOrNull(int index) {
            VimDataType vimDataType = (VimDataType)CollectionsKt.getOrNull(this.arguments, (int)index);
            return vimDataType != null ? vimDataType.toVimString() : null;
        }

        public final double getNumberOrFloat(int index) {
            double d;
            VimDataType vimDataType = this.arguments.get(index);
            if (vimDataType instanceof VimFloat) {
                d = this.arguments.get(index).toVimFloat().getValue();
            } else if (vimDataType instanceof VimInt) {
                d = this.arguments.get(index).toVimNumber().getValue();
            } else {
                throw ExExceptionsKt.exExceptionMessage("E808", new Object[0]);
            }
            return d;
        }

        @NotNull
        public final VimDataType getVariable(@NotNull String name, @NotNull VimLContext vimContext) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
            return VimInjectorKt.getInjector().getVariableService().getNonNullVariableValue(new VariableExpression(Scope.FUNCTION_VARIABLE, name), this.editor, this.context, vimContext);
        }

        public final void setVariable(@NotNull String name, @NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
            VimInjectorKt.getInjector().getVariableService().storeVariable(new VariableExpression(Scope.FUNCTION_VARIABLE, name), value, editor, context, vimContext);
        }
    }
}

