/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.docker.ui.components.JBTextFieldWithHint;
import com.intellij.docker.ui.utils.TextFieldsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderDescriptor;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006\u001a\u001f\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001ao\u0010\r\u001a\u00020\u0001\"\b\b\u0000\u0010\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00192%\b\u0002\u0010\u001a\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001bH\u0007\u001aA\u0010 \u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172%\b\u0002\u0010\u001a\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001bH\u0007\"\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"updateExecutableVersion", "", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "versionResult", "Lkotlin/Result;", "", "(Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;Ljava/lang/Object;)V", "updateValidationInfo", "result", "setHint", "hint", "", "FILES_SEPARATOR", "installMultiFileCompletionAndBrowseDialog", "T", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "textField", "Ljavax/swing/JTextField;", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "textComponentAccessor", "Lcom/intellij/openapi/ui/TextComponentAccessor;", "fileChosen", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/ParameterName;", "name", "chosenFile", "textFieldWithMultiFileBrowseButton", "intellij.clouds.docker.shared"})
public final class TextFieldsKt {
    @NotNull
    private static final String FILES_SEPARATOR = "; ";

    public static final void updateExecutableVersion(@NotNull TextFieldWithBrowseButton $this$updateExecutableVersion, @NotNull Object versionResult) {
        Intrinsics.checkNotNullParameter((Object)$this$updateExecutableVersion, (String)"<this>");
        TextFieldsKt.updateValidationInfo($this$updateExecutableVersion, versionResult);
        Object object = versionResult;
        if (Result.isSuccess-impl((Object)object)) {
            Object it = object;
            boolean bl = false;
            TextFieldsKt.setHint($this$updateExecutableVersion, it.toString());
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            TextFieldsKt.setHint($this$updateExecutableVersion, "");
        }
        $this$updateExecutableVersion.invalidate();
        $this$updateExecutableVersion.repaint();
    }

    private static final void updateValidationInfo(TextFieldWithBrowseButton $this$updateValidationInfo, Object result) {
        block5: {
            Optional optional = ComponentValidator.getInstance((JComponent)((JComponent)$this$updateValidationInfo));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getInstance(...)");
            ComponentValidator validator = (ComponentValidator)OptionalsKt.getOrNull((Optional)optional);
            if (validator != null) {
                Object object = result;
                if (Result.isSuccess-impl((Object)object)) {
                    ValidationInfo currentInfo;
                    Object it = object;
                    boolean bl = false;
                    ValidationInfo validationInfo = currentInfo = validator.getValidationInfo();
                    boolean bl2 = validationInfo != null ? !validationInfo.warning : false;
                    if (bl2) {
                        validator.updateInfo(null);
                    }
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable throwable2;
                    Throwable it = throwable2 = throwable;
                    boolean bl = false;
                    String string = it.getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    validator.updateInfo(new ValidationInfo(string, (JComponent)$this$updateValidationInfo));
                }
            }
            ComponentValidator componentValidator = validator;
            if (componentValidator == null) break block5;
            componentValidator.revalidate();
        }
    }

    private static final void setHint(TextFieldWithBrowseButton $this$setHint, String hint) {
        JTextField jTextField = $this$setHint.getTextField();
        Intrinsics.checkNotNull((Object)jTextField, (String)"null cannot be cast to non-null type com.intellij.docker.ui.components.JBTextFieldWithHint");
        JBTextFieldWithHint textField = (JBTextFieldWithHint)((Object)jTextField);
        textField.setHint(hint);
    }

    @JvmOverloads
    public static final <T extends JComponent> void installMultiFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull ComponentWithBrowseButton<T> component2, @NotNull JTextField textField, @NotNull FileChooserDescriptor fileChooserDescriptor, @NotNull TextComponentAccessor<T> textComponentAccessor, @Nullable Function1<? super VirtualFile, String> fileChosen) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor, (String)"fileChooserDescriptor");
        Intrinsics.checkNotNullParameter(textComponentAccessor, (String)"textComponentAccessor");
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        BrowseFolderDescriptor browseFolderDescriptor = BrowseFolderDescriptor.Companion.asBrowseFolderDescriptor(fileChooserDescriptor);
        if (fileChosen != null) {
            browseFolderDescriptor.setConvertFileToText(fileChosen);
        }
        ComponentWithBrowseButton.BrowseFolderActionListener listener2 = new ComponentWithBrowseButton.BrowseFolderActionListener<T>(component2, project, browseFolderDescriptor, textComponentAccessor){

            private final String chosenFilesToResultingText(List<? extends VirtualFile> chosenFiles) {
                return CollectionsKt.joinToString$default((Iterable)chosenFiles, (CharSequence)"; ", null, null, (int)0, null, arg_0 -> installMultiFileCompletionAndBrowseDialog.listener.1.chosenFilesToResultingText$lambda$0(this, arg_0), (int)30, null);
            }

            protected void chooseFile(FileChooserDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.getProject(), (Component)this.myTextComponent, (VirtualFile)this.getInitialFile(), arg_0 -> installMultiFileCompletionAndBrowseDialog.listener.1.chooseFile$lambda$1(this, arg_0));
            }

            private static final CharSequence chosenFilesToResultingText$lambda$0(installMultiFileCompletionAndBrowseDialog.listener.1 this$0, VirtualFile chosenFile) {
                Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
                String string = this$0.chosenFileToResultingText(chosenFile);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chosenFileToResultingText(...)");
                return string;
            }

            private static final void chooseFile$lambda$1(installMultiFileCompletionAndBrowseDialog.listener.1 this$0, List chosenFiles) {
                Intrinsics.checkNotNullParameter((Object)chosenFiles, (String)"chosenFiles");
                this$0.myAccessor.setText((Component)this$0.myTextComponent, this$0.chosenFilesToResultingText(chosenFiles));
            }
        };
        component2.addActionListener((ActionListener)listener2);
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, null);
    }

    public static /* synthetic */ void installMultiFileCompletionAndBrowseDialog$default(Project project, ComponentWithBrowseButton componentWithBrowseButton, JTextField jTextField, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor textComponentAccessor, Function1 function1, int n, Object object) {
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        TextFieldsKt.installMultiFileCompletionAndBrowseDialog(project, componentWithBrowseButton, jTextField, fileChooserDescriptor, textComponentAccessor, (Function1<? super VirtualFile, String>)function1);
    }

    @JvmOverloads
    @NotNull
    public static final TextFieldWithBrowseButton textFieldWithMultiFileBrowseButton(@Nullable Project project, @NotNull FileChooserDescriptor fileChooserDescriptor, @Nullable Function1<? super VirtualFile, String> fileChosen) {
        Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor, (String)"fileChooserDescriptor");
        TextFieldWithBrowseButton component2 = new TextFieldWithBrowseButton();
        TextComponentAccessor textComponentAccessor = TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT;
        ComponentWithBrowseButton componentWithBrowseButton = (ComponentWithBrowseButton)component2;
        JTextField jTextField = component2.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        Intrinsics.checkNotNull((Object)textComponentAccessor);
        TextFieldsKt.installMultiFileCompletionAndBrowseDialog(project, componentWithBrowseButton, jTextField, fileChooserDescriptor, textComponentAccessor, fileChosen);
        return component2;
    }

    public static /* synthetic */ TextFieldWithBrowseButton textFieldWithMultiFileBrowseButton$default(Project project, FileChooserDescriptor fileChooserDescriptor, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return TextFieldsKt.textFieldWithMultiFileBrowseButton(project, fileChooserDescriptor, (Function1<? super VirtualFile, String>)function1);
    }

    @JvmOverloads
    public static final <T extends JComponent> void installMultiFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull ComponentWithBrowseButton<T> component2, @NotNull JTextField textField, @NotNull FileChooserDescriptor fileChooserDescriptor, @NotNull TextComponentAccessor<T> textComponentAccessor) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor, (String)"fileChooserDescriptor");
        Intrinsics.checkNotNullParameter(textComponentAccessor, (String)"textComponentAccessor");
        TextFieldsKt.installMultiFileCompletionAndBrowseDialog$default(project, component2, textField, fileChooserDescriptor, textComponentAccessor, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public static final TextFieldWithBrowseButton textFieldWithMultiFileBrowseButton(@Nullable Project project, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor, (String)"fileChooserDescriptor");
        return TextFieldsKt.textFieldWithMultiFileBrowseButton$default(project, fileChooserDescriptor, null, 4, null);
    }
}

