/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.codeInspection.IgnoreRemoveEntryFix;
import mobi.hsz.idea.gitignore.psi.IgnoreEntry;
import mobi.hsz.idea.gitignore.psi.IgnoreFile;
import mobi.hsz.idea.gitignore.services.IgnoreMatcher;
import mobi.hsz.idea.gitignore.util.Constants;
import mobi.hsz.idea.gitignore.util.Glob;
import mobi.hsz.idea.gitignore.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ=\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\fH\u0016J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\fH\u0002\u00a8\u0006\u001e"}, d2={"Lmobi/hsz/idea/gitignore/codeInspection/IgnoreCoverEntryInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getPathsSet", "", "Lmobi/hsz/idea/gitignore/psi/IgnoreEntry;", "", "", "contextDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "entries", "matcher", "Lmobi/hsz/idea/gitignore/services/IgnoreMatcher;", "(Lcom/intellij/openapi/vfs/VirtualFile;[Lmobi/hsz/idea/gitignore/psi/IgnoreEntry;Lmobi/hsz/idea/gitignore/services/IgnoreMatcher;)Ljava/util/Map;", "runForWholeFile", "message", "coveringEntry", "virtualFile", "onTheFly", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nIgnoreCoverEntryInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreCoverEntryInspection.kt\nmobi/hsz/idea/gitignore/codeInspection/IgnoreCoverEntryInspection\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,145:1\n30#2,2:146\n13472#3:148\n13473#3:151\n1869#4,2:149\n1869#4,2:152\n216#5,2:154\n*S KotlinDebug\n*F\n+ 1 IgnoreCoverEntryInspection.kt\nmobi/hsz/idea/gitignore/codeInspection/IgnoreCoverEntryInspection\n*L\n50#1:146,2\n53#1:148\n53#1:151\n74#1:149,2\n93#1:152,2\n115#1:154,2\n*E\n"})
public final class IgnoreCoverEntryInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        VirtualFile virtualFile;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                virtualFile = file.getVirtualFile();
                if (!(file instanceof IgnoreFile)) break block14;
                Intrinsics.checkNotNull((Object)virtualFile);
                Project project = ((IgnoreFile)file).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (Utils.INSTANCE.isInProject(virtualFile, project)) break block15;
            }
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile contextDirectory = virtualFile2;
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        Set ignored = new LinkedHashSet();
        Set unignored = new LinkedHashSet();
        List result = new ArrayList();
        Map map2 = new LinkedHashMap();
        Object[] objectArray = ((IgnoreFile)file).findChildrenByClass(IgnoreEntry.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findChildrenByClass(...)");
        IgnoreEntry[] entries = (IgnoreEntry[])objectArray;
        Project project = ((IgnoreFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<IgnoreMatcher> serviceClass$iv = IgnoreMatcher.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        IgnoreMatcher matcher = (IgnoreMatcher)object;
        Map<IgnoreEntry, Set<String>> matchedMap = this.getPathsSet(contextDirectory, entries, matcher);
        Object $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        int n = ((IgnoreEntry[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            Set<String> matched;
            IgnoreEntry element$iv;
            IgnoreEntry entry = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (matchedMap.get(entry) == null) continue;
            Collection intersection = null;
            if (!entry.isNegated()) {
                ignored.addAll((Collection)matched);
                intersection = CollectionsKt.intersect((Iterable)unignored, (Iterable)matched);
                if (unignored.removeAll(CollectionsKt.toSet((Iterable)intersection))) {
                    continue;
                }
            } else {
                unignored.addAll((Collection)matched);
                intersection = CollectionsKt.intersect((Iterable)ignored, (Iterable)matched);
                if (ignored.removeAll(CollectionsKt.toSet((Iterable)intersection))) continue;
            }
            Iterable $this$forEach$iv2 = map2.keySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Set recentValues;
                IgnoreEntry recent = (IgnoreEntry)element$iv2;
                boolean bl2 = false;
                ProgressManager.checkCanceled();
                if ((Set)map2.get(recent) == null || recentValues.isEmpty() || matched.isEmpty()) continue;
                if (entry.isNegated() == recent.isNegated()) {
                    if (recentValues.containsAll((Collection)matched)) {
                        Pair pair = Pair.create((Object)recent, (Object)entry);
                        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                        result.add(pair);
                        continue;
                    }
                    if (!matched.containsAll(recentValues)) continue;
                    Pair pair = Pair.create((Object)entry, (Object)recent);
                    Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                    result.add(pair);
                    continue;
                }
                if (!((Set)intersection).containsAll(recentValues)) continue;
                Pair pair = Pair.create((Object)entry, (Object)recent);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                result.add(pair);
            }
            map2.put(entry, matched);
        }
        $this$forEach$iv = result;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            PsiElement psiElement = (PsiElement)pair.second;
            Object object2 = pair.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            String string = this.message((IgnoreEntry)object2, virtualFile, isOnTheFly);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
            Object object3 = pair.second;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"second");
            localQuickFixArray[0] = new IgnoreRemoveEntryFix((IgnoreEntry)object3);
            problemsHolder.registerProblem(psiElement, string, localQuickFixArray);
        }
        return problemsHolder.getResultsArray();
    }

    private final Map<IgnoreEntry, Set<String>> getPathsSet(VirtualFile contextDirectory, IgnoreEntry[] entries, IgnoreMatcher matcher) {
        Map<IgnoreEntry, Set<String>> found;
        Map map2;
        Map $this$getPathsSet_u24lambda_u240 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        Map<IgnoreEntry, Set<String>> $this$forEach$iv = found = Glob.INSTANCE.findAsPaths(contextDirectory, ArraysKt.toList((Object[])entries), matcher, true);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IgnoreEntry, Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IgnoreEntry, Set<String>> element$iv;
            Map.Entry<IgnoreEntry, Set<String>> entry = element$iv = iterator.next();
            boolean bl2 = false;
            IgnoreEntry key = entry.getKey();
            Set<String> value = entry.getValue();
            ProgressManager.checkCanceled();
            $this$getPathsSet_u24lambda_u240.put(key, value);
        }
        return map2;
    }

    public boolean runForWholeFile() {
        return true;
    }

    private final String message(IgnoreEntry coveringEntry, VirtualFile virtualFile, boolean onTheFly) {
        String string;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (onTheFly || document == null) {
            Object[] objectArray = new Object[]{"'" + coveringEntry.getText() + "'"};
            string = IgnoreBundle.INSTANCE.message("codeInspection.coverEntry.message", objectArray);
        } else {
            Object[] objectArray = new Object[]{"<a href=\"" + virtualFile.getUrl() + Constants.INSTANCE.getHASH() + coveringEntry.getTextRange().getStartOffset() + "\">" + coveringEntry.getText() + "</a>"};
            string = IgnoreBundle.INSTANCE.message("codeInspection.coverEntry.message", objectArray);
        }
        return string;
    }
}

