/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.daemon;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.command.CreateFileCommandAction;
import mobi.hsz.idea.gitignore.file.type.kind.GitFileType;
import mobi.hsz.idea.gitignore.lang.kind.GitLanguage;
import mobi.hsz.idea.gitignore.settings.IgnoreSettings;
import mobi.hsz.idea.gitignore.ui.GeneratorDialog;
import mobi.hsz.idea.gitignore.util.Properties;
import mobi.hsz.idea.gitignore.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0011\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lmobi/hsz/idea/gitignore/daemon/MissingGitignoreNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "notifications", "Lcom/intellij/ui/EditorNotifications;", "Lorg/jetbrains/annotations/NotNull;", "settings", "Lmobi/hsz/idea/gitignore/settings/IgnoreSettings;", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "moduleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "file", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nMissingGitignoreNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingGitignoreNotificationProvider.kt\nmobi/hsz/idea/gitignore/daemon/MissingGitignoreNotificationProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n40#2,3:85\n1#3:88\n*S KotlinDebug\n*F\n+ 1 MissingGitignoreNotificationProvider.kt\nmobi/hsz/idea/gitignore/daemon/MissingGitignoreNotificationProvider\n*L\n31#1:85,3\n*E\n"})
public final class MissingGitignoreNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    private final EditorNotifications notifications;
    @NotNull
    private final IgnoreSettings settings;

    public MissingGitignoreNotificationProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EditorNotifications editorNotifications = EditorNotifications.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)editorNotifications, (String)"getInstance(...)");
        this.notifications = editorNotifications;
        boolean $i$f$service = false;
        Class<IgnoreSettings> serviceClass$iv = IgnoreSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.settings = (IgnoreSettings)object;
    }

    private final EditorNotificationPanel createNotificationPanel(Project project, VirtualFile moduleRoot) {
        EditorNotificationPanel editorNotificationPanel;
        EditorNotificationPanel $this$createNotificationPanel_u24lambda_u240 = editorNotificationPanel = new EditorNotificationPanel();
        boolean bl = false;
        GitFileType fileType = GitFileType.Companion.getINSTANCE();
        $this$createNotificationPanel_u24lambda_u240.setText(IgnoreBundle.INSTANCE.message("daemon.missingGitignore", new Object[0]));
        $this$createNotificationPanel_u24lambda_u240.createActionLabel(IgnoreBundle.INSTANCE.message("daemon.missingGitignore.create", new Object[0]), () -> MissingGitignoreNotificationProvider.createNotificationPanel$lambda$0$0(project, moduleRoot, fileType));
        $this$createNotificationPanel_u24lambda_u240.createActionLabel(IgnoreBundle.INSTANCE.message("daemon.cancel", new Object[0]), () -> MissingGitignoreNotificationProvider.createNotificationPanel$lambda$0$1(project, this));
        try {
            Icon icon = fileType.getIcon();
            if (icon != null) {
                Icon it = icon;
                boolean bl2 = false;
                $this$createNotificationPanel_u24lambda_u240.icon(it);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        return editorNotificationPanel;
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        if (!this.settings.getMissingGitignore() || Properties.INSTANCE.isIgnoreMissingGitignore(project)) {
            return null;
        }
        String string = GitLanguage.Companion.getINSTANCE().getVcsDirectory();
        if (string == null) {
            return null;
        }
        String vcsDirectory = string;
        VirtualFile virtualFile = Utils.INSTANCE.getModuleRootForFile(file, project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile moduleRoot = virtualFile;
        if (moduleRoot.findChild(vcsDirectory) == null) {
            return null;
        }
        if (moduleRoot.findChild(GitLanguage.Companion.getINSTANCE().getFilename()) != null) {
            return null;
        }
        return arg_0 -> MissingGitignoreNotificationProvider.collectNotificationData$lambda$0(this, project, moduleRoot, arg_0);
    }

    private static final void createNotificationPanel$lambda$0$0(Project $project, VirtualFile $moduleRoot, GitFileType $fileType) {
        PsiDirectory directory = PsiManager.getInstance((Project)$project).findDirectory($moduleRoot);
        if (directory != null) {
            try {
                PsiFile file = (PsiFile)new CreateFileCommandAction($project, directory, $fileType).execute();
                FileEditorManager.getInstance((Project)$project).openFile(file.getVirtualFile(), true);
                new GeneratorDialog($project, file, null, 4, null).show();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static final void createNotificationPanel$lambda$0$1(Project $project, MissingGitignoreNotificationProvider this$0) {
        Properties.INSTANCE.setIgnoreMissingGitignore($project);
        this$0.notifications.updateAllNotifications();
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(MissingGitignoreNotificationProvider this$0, Project $project, VirtualFile $moduleRoot, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createNotificationPanel($project, $moduleRoot);
    }
}

