/*
 * Decompiled with CFR 0.152.
 */
package com.carbonblack.intellij.rpmspec.shell;

import com.carbonblack.intellij.rpmspec.RpmSpecLanguage;
import com.carbonblack.intellij.rpmspec.shell.RpmSpecFileViewProviderKt;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0006H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0014\u00a8\u0006\u0015"}, d2={"Lcom/carbonblack/intellij/rpmspec/shell/RpmSpecFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getBaseLanguage", "Lcom/intellij/lang/Language;", "getTemplateDataLanguage", "getLanguages", "", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "intellij-rpmspec"})
public final class RpmSpecFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    public RpmSpecFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        super(manager, virtualFile, eventSystemEnabled);
    }

    @NotNull
    public Language getBaseLanguage() {
        return RpmSpecLanguage.INSTANCE;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = Language.findLanguageByID((String)"Shell Script");
        if (language == null) {
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
            language = (Language)plainTextLanguage;
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Object[] objectArray = new Language[]{RpmSpecLanguage.INSTANCE, this.getTemplateDataLanguage()};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new RpmSpecFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parser == null) {
            psiFile = null;
        } else if (lang == this.getBaseLanguage()) {
            psiFile = parser.createFile((FileViewProvider)this);
        } else if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl psiFileImpl;
            PsiFile psiFile2 = parser.createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl $this$createFile_u24lambda_u240 = psiFileImpl = (PsiFileImpl)psiFile2;
            boolean bl = false;
            $this$createFile_u24lambda_u240.setContentElementType((IElementType)RpmSpecFileViewProviderKt.access$getTEMPLATE_DATA_ELEMENT$p());
            psiFile = (PsiFile)psiFileImpl;
        } else {
            psiFile = null;
        }
        return psiFile;
    }
}

