/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.vfs;

import ai.grazie.code.files.vfs.VirtualPath;
import ai.grazie.code.files.vfs.memory.VirtualFile;
import ai.grazie.code.files.vfs.memory.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/grazie/code/files/vfs/VirtualSource;", "Lkotlinx/io/RawSource;", "fs", "Lai/grazie/code/files/vfs/memory/VirtualFileSystem;", "path", "Lai/grazie/code/files/vfs/VirtualPath;", "<init>", "(Lai/grazie/code/files/vfs/memory/VirtualFileSystem;Lai/grazie/code/files/vfs/VirtualPath;)V", "position", "", "isOpened", "", "content", "", "readAtMostTo", "", "sink", "Lkotlinx/io/Buffer;", "byteCount", "close", "", "code-files-vfs"})
@SourceDebugExtension(value={"SMAP\nVirtualSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualSource.kt\nai/grazie/code/files/vfs/VirtualSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class VirtualSource
implements RawSource {
    @NotNull
    private final VirtualPath path;
    private int position;
    private boolean isOpened;
    @NotNull
    private final byte[] content;

    public VirtualSource(@NotNull VirtualFileSystem fs, @NotNull VirtualPath path) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        VirtualFile virtualFile = fs.getFile(this.path);
        if (virtualFile == null) {
            throw new IllegalStateException(("Virtual Source error. Source file does not exit: '" + this.path + "'").toString());
        }
        VirtualFile targetFile = virtualFile;
        this.content = targetFile.getContent();
        this.isOpened = true;
    }

    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!this.isOpened) {
            boolean bl = false;
            String string = "Virtual Source is closed. Unable to read from a file source: '" + this.path + "'";
            throw new IllegalStateException(string.toString());
        }
        if (this.position >= this.content.length) {
            return -1L;
        }
        long actualByteCount = Math.min((int)byteCount, this.content.length - this.position);
        if (actualByteCount > 0L) {
            sink.write(this.content, this.position, this.position + (int)actualByteCount);
            this.position += (int)actualByteCount;
        }
        return actualByteCount;
    }

    public void close() {
        this.isOpened = false;
    }
}

