/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.vfs.mapped;

import ai.grazie.code.files.model.ExtensionsKt;
import ai.grazie.code.files.vfs.VirtualPath;
import ai.grazie.code.files.vfs.mapped.OutOfMappedFileSystemException;
import ai.koog.rag.base.files.FileSystemProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u0012J\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00028\u00012\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0010\u001a\u00028\u00012\u0006\u0010\n\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\n\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0004\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lai/grazie/code/files/vfs/mapped/PathMapping;", "InputPath", "OutputPath", "", "originalRoot", "getOriginalRoot", "()Ljava/lang/Object;", "mappedRoot", "getMappedRoot", "toOriginalPath", "path", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "(Ljava/lang/String;)Ljava/lang/Object;", "toAbsoluteOriginalPath", "(Ljava/lang/Object;)Ljava/lang/String;", "toMappedPath", "toAbsoluteMappedPath", "Virtual", "code-files-vfs"})
public interface PathMapping<InputPath, OutputPath> {
    public InputPath getOriginalRoot();

    public OutputPath getMappedRoot();

    public InputPath toOriginalPath(OutputPath var1);

    public InputPath toOriginalPath(@NotNull String var1);

    @NotNull
    public String toAbsoluteOriginalPath(InputPath var1);

    public OutputPath toMappedPath(InputPath var1);

    public OutputPath toMappedPath(@NotNull String var1);

    @NotNull
    public String toAbsoluteMappedPath(OutputPath var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0015\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u000b\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lai/grazie/code/files/vfs/mapped/PathMapping$Virtual;", "Path", "Lai/grazie/code/files/vfs/mapped/PathMapping;", "Lai/grazie/code/files/vfs/VirtualPath;", "originalFs", "Lai/koog/rag/base/files/FileSystemProvider$ReadOnly;", "<init>", "(Lai/koog/rag/base/files/FileSystemProvider$ReadOnly;)V", "getOriginalFs", "()Lai/koog/rag/base/files/FileSystemProvider$ReadOnly;", "toMappedPath", "path", "(Ljava/lang/Object;)Lai/grazie/code/files/vfs/VirtualPath;", "", "toAbsoluteMappedPath", "toOriginalPath", "(Lai/grazie/code/files/vfs/VirtualPath;)Ljava/lang/Object;", "(Ljava/lang/String;)Ljava/lang/Object;", "toAbsoluteOriginalPath", "(Ljava/lang/Object;)Ljava/lang/String;", "code-files-vfs"})
    public static abstract class Virtual<Path>
    implements PathMapping<Path, VirtualPath> {
        @NotNull
        private final FileSystemProvider.ReadOnly<Path> originalFs;

        public Virtual(@NotNull FileSystemProvider.ReadOnly<Path> originalFs) {
            Intrinsics.checkNotNullParameter(originalFs, (String)"originalFs");
            this.originalFs = originalFs;
        }

        @NotNull
        protected final FileSystemProvider.ReadOnly<Path> getOriginalFs() {
            return this.originalFs;
        }

        @Override
        @NotNull
        public VirtualPath toMappedPath(Path path) {
            if (!ExtensionsKt.contains(this.getOriginalRoot(), path, this.originalFs)) {
                throw new OutOfMappedFileSystemException(String.valueOf(path));
            }
            String string = this.originalFs.relativize(this.getOriginalRoot(), path);
            if (string == null) {
                throw new OutOfMappedFileSystemException(String.valueOf(path));
            }
            String relString = string;
            VirtualPath relVirtual = StringsKt.isBlank((CharSequence)relString) ? VirtualPath.Companion.getROOT() : VirtualPath.Companion.of(relString);
            return ((VirtualPath)this.getMappedRoot()).resolve(relVirtual);
        }

        @Override
        @NotNull
        public VirtualPath toMappedPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String[] stringArray = new String[]{path};
            return this.toMappedPath((Object)this.originalFs.joinPath(this.getOriginalRoot(), stringArray));
        }

        @Override
        @NotNull
        public String toAbsoluteMappedPath(@NotNull VirtualPath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return path.toString();
        }

        @Override
        public Path toOriginalPath(@NotNull VirtualPath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!Intrinsics.areEqual(this.getMappedRoot(), (Object)path) && !((VirtualPath)this.getMappedRoot()).isParentOf(path)) {
                throw new OutOfMappedFileSystemException(path.toString());
            }
            List relComponents = ((VirtualPath)this.getMappedRoot()).isRoot() ? path.getComponents() : CollectionsKt.drop((Iterable)path.getComponents(), (int)((VirtualPath)this.getMappedRoot()).getComponents().size());
            String relString = CollectionsKt.joinToString$default((Iterable)relComponents, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            String[] stringArray = new String[]{relString};
            Path originalPath = this.originalFs.joinPath(this.getOriginalRoot(), stringArray);
            if (!ExtensionsKt.contains(this.getOriginalRoot(), originalPath, this.originalFs)) {
                throw new OutOfMappedFileSystemException(path.toString());
            }
            return originalPath;
        }

        @Override
        public Path toOriginalPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.toOriginalPath(VirtualPath.Companion.of(path));
        }

        @Override
        @NotNull
        public String toAbsoluteOriginalPath(Path path) {
            return this.originalFs.toAbsolutePathString(path);
        }
    }
}

