/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.provider.alibaba.profile;

import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.LLMChatRole;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessage;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import ai.grazie.model.llm.definitions.ChatDefinition;
import ai.grazie.model.llm.definitions.CompletionDefinition;
import ai.grazie.model.llm.definitions.EmbeddingDefinition;
import ai.grazie.model.llm.definitions.FeatureDefinitions;
import ai.grazie.model.llm.definitions.LLMParameterDescriptor;
import ai.grazie.model.llm.definitions.ParameterDefinition;
import ai.grazie.model.llm.definitions.RoleDefinition;
import ai.grazie.model.llm.profile.LLMProfile;
import ai.grazie.model.llm.utils.AttributesExtensionKt;
import ai.grazie.utils.attributes.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions;", "Lai/grazie/model/llm/definitions/FeatureDefinitions;", "<init>", "()V", "roles", "", "Lai/grazie/model/llm/chat/LLMChatRole;", "parametersDescriptors", "Lai/grazie/model/llm/definitions/LLMParameterDescriptor;", "chatDefinition", "Lai/grazie/model/llm/definitions/ChatDefinition;", "getChatDefinition", "()Lai/grazie/model/llm/definitions/ChatDefinition;", "completionDefinition", "Lai/grazie/model/llm/definitions/CompletionDefinition;", "getCompletionDefinition", "()Lai/grazie/model/llm/definitions/CompletionDefinition;", "embeddingDefinition", "Lai/grazie/model/llm/definitions/EmbeddingDefinition;", "getEmbeddingDefinition", "()Lai/grazie/model/llm/definitions/EmbeddingDefinition;", "AlibabaParameterDefinition", "AlibabaDefinitionsImpl", "AlibabaCodeCompletion", "AlibabaRoleDefinition", "llm-provider-alibaba-profile"})
public final class AlibabaDefinitions
implements FeatureDefinitions {
    @NotNull
    public static final AlibabaDefinitions INSTANCE = new AlibabaDefinitions();
    @NotNull
    private static final Set<LLMChatRole> roles;
    @NotNull
    private static final Set<LLMParameterDescriptor> parametersDescriptors;
    @NotNull
    private static final ChatDefinition chatDefinition;
    @NotNull
    private static final CompletionDefinition completionDefinition;
    @NotNull
    private static final EmbeddingDefinition embeddingDefinition;

    private AlibabaDefinitions() {
    }

    @Override
    @NotNull
    public ChatDefinition getChatDefinition() {
        return chatDefinition;
    }

    @Override
    @NotNull
    public CompletionDefinition getCompletionDefinition() {
        return completionDefinition;
    }

    @Override
    @NotNull
    public EmbeddingDefinition getEmbeddingDefinition() {
        return embeddingDefinition;
    }

    static {
        Object object = new LLMChatRole[]{LLMChatRole.User, LLMChatRole.Assistant, LLMChatRole.System, LLMChatRole.Function, LLMChatRole.Tool};
        roles = SetsKt.setOf((Object[])object);
        object = new LLMParameterDescriptor[]{LLMParameterDescriptor.Temperature.INSTANCE, LLMParameterDescriptor.TopP.INSTANCE, LLMParameterDescriptor.TopK.INSTANCE, LLMParameterDescriptor.Seed.INSTANCE, LLMParameterDescriptor.FunctionCall.INSTANCE, LLMParameterDescriptor.Functions.INSTANCE, LLMParameterDescriptor.Length.INSTANCE, LLMParameterDescriptor.Tools.INSTANCE, LLMParameterDescriptor.ToolChoiceAuto.INSTANCE, LLMParameterDescriptor.ToolChoiceNone.INSTANCE, LLMParameterDescriptor.ToolChoiceNamed.INSTANCE, LLMParameterDescriptor.ParallelToolCalls.INSTANCE};
        parametersDescriptors = SetsKt.setOf((Object[])object);
        object = new AlibabaParameterDefinition(null, 1, null);
        AlibabaRoleDefinition alibabaRoleDefinition = new AlibabaRoleDefinition(null, 1, null);
        chatDefinition = new ChatDefinition(alibabaRoleDefinition, (ParameterDefinition)object, null, null, 12, null);
        object = new Object[]{LLMParameterDescriptor.CompletionCodeContext.INSTANCE, LLMParameterDescriptor.CompletionCodeFilename.INSTANCE};
        completionDefinition = new CompletionDefinition(new AlibabaParameterDefinition(SetsKt.setOf((Object[])object)));
        embeddingDefinition = new EmbeddingDefinition(new AlibabaParameterDefinition(SetsKt.emptySet()));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions$AlibabaCodeCompletion;", "Lai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions$AlibabaDefinitionsImpl;", "<init>", "()V", "chatDefinition", "Lai/grazie/model/llm/definitions/ChatDefinition;", "getChatDefinition", "()Lai/grazie/model/llm/definitions/ChatDefinition;", "embeddingDefinition", "Lai/grazie/model/llm/definitions/EmbeddingDefinition;", "getEmbeddingDefinition", "()Lai/grazie/model/llm/definitions/EmbeddingDefinition;", "llm-provider-alibaba-profile"})
    public static final class AlibabaCodeCompletion
    extends AlibabaDefinitionsImpl {
        @NotNull
        public static final AlibabaCodeCompletion INSTANCE = new AlibabaCodeCompletion();
        @NotNull
        private static final ChatDefinition chatDefinition;
        @NotNull
        private static final EmbeddingDefinition embeddingDefinition;

        private AlibabaCodeCompletion() {
            super(null, null, null, 7, null);
        }

        @Override
        @NotNull
        public ChatDefinition getChatDefinition() {
            return chatDefinition;
        }

        @Override
        @NotNull
        public EmbeddingDefinition getEmbeddingDefinition() {
            return embeddingDefinition;
        }

        static {
            AlibabaParameterDefinition alibabaParameterDefinition = new AlibabaParameterDefinition(SetsKt.emptySet());
            LLMChatRole[] lLMChatRoleArray = new LLMChatRole[]{LLMChatRole.User, LLMChatRole.Assistant, LLMChatRole.System};
            AlibabaRoleDefinition alibabaRoleDefinition = new AlibabaRoleDefinition(SetsKt.setOf((Object[])lLMChatRoleArray));
            chatDefinition = new ChatDefinition(alibabaRoleDefinition, alibabaParameterDefinition, null, null, 12, null);
            embeddingDefinition = new EmbeddingDefinition(new AlibabaParameterDefinition(SetsKt.emptySet()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions$AlibabaDefinitionsImpl;", "Lai/grazie/model/llm/definitions/FeatureDefinitions;", "chatDefinition", "Lai/grazie/model/llm/definitions/ChatDefinition;", "completionDefinition", "Lai/grazie/model/llm/definitions/CompletionDefinition;", "embeddingDefinition", "Lai/grazie/model/llm/definitions/EmbeddingDefinition;", "<init>", "(Lai/grazie/model/llm/definitions/ChatDefinition;Lai/grazie/model/llm/definitions/CompletionDefinition;Lai/grazie/model/llm/definitions/EmbeddingDefinition;)V", "getChatDefinition", "()Lai/grazie/model/llm/definitions/ChatDefinition;", "getCompletionDefinition", "()Lai/grazie/model/llm/definitions/CompletionDefinition;", "getEmbeddingDefinition", "()Lai/grazie/model/llm/definitions/EmbeddingDefinition;", "llm-provider-alibaba-profile"})
    public static abstract class AlibabaDefinitionsImpl
    implements FeatureDefinitions {
        @NotNull
        private final ChatDefinition chatDefinition;
        @NotNull
        private final CompletionDefinition completionDefinition;
        @NotNull
        private final EmbeddingDefinition embeddingDefinition;

        public AlibabaDefinitionsImpl(@NotNull ChatDefinition chatDefinition, @NotNull CompletionDefinition completionDefinition, @NotNull EmbeddingDefinition embeddingDefinition) {
            Intrinsics.checkNotNullParameter((Object)chatDefinition, (String)"chatDefinition");
            Intrinsics.checkNotNullParameter((Object)completionDefinition, (String)"completionDefinition");
            Intrinsics.checkNotNullParameter((Object)embeddingDefinition, (String)"embeddingDefinition");
            this.chatDefinition = chatDefinition;
            this.completionDefinition = completionDefinition;
            this.embeddingDefinition = embeddingDefinition;
        }

        public /* synthetic */ AlibabaDefinitionsImpl(ChatDefinition chatDefinition, CompletionDefinition completionDefinition, EmbeddingDefinition embeddingDefinition, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                chatDefinition = INSTANCE.getChatDefinition();
            }
            if ((n & 2) != 0) {
                completionDefinition = INSTANCE.getCompletionDefinition();
            }
            if ((n & 4) != 0) {
                embeddingDefinition = INSTANCE.getEmbeddingDefinition();
            }
            this(chatDefinition, completionDefinition, embeddingDefinition);
        }

        @Override
        @NotNull
        public ChatDefinition getChatDefinition() {
            return this.chatDefinition;
        }

        @Override
        @NotNull
        public CompletionDefinition getCompletionDefinition() {
            return this.completionDefinition;
        }

        @Override
        @NotNull
        public EmbeddingDefinition getEmbeddingDefinition() {
            return this.embeddingDefinition;
        }

        public AlibabaDefinitionsImpl() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions$AlibabaParameterDefinition;", "Lai/grazie/model/llm/definitions/ParameterDefinition;", "supportedLLMParameterDescriptors", "", "Lai/grazie/model/llm/definitions/LLMParameterDescriptor;", "<init>", "(Ljava/util/Set;)V", "getSupportedLLMParameterDescriptors", "()Ljava/util/Set;", "validateParameters", "", "name", "", "parameters", "Lai/grazie/utils/attributes/Attributes;", "profile", "Lai/grazie/model/llm/profile/LLMProfile;", "llm-provider-alibaba-profile"})
    private static final class AlibabaParameterDefinition
    implements ParameterDefinition {
        @NotNull
        private final Set<LLMParameterDescriptor> supportedLLMParameterDescriptors;

        public AlibabaParameterDefinition(@NotNull Set<? extends LLMParameterDescriptor> supportedLLMParameterDescriptors) {
            Intrinsics.checkNotNullParameter(supportedLLMParameterDescriptors, (String)"supportedLLMParameterDescriptors");
            this.supportedLLMParameterDescriptors = supportedLLMParameterDescriptors;
        }

        public /* synthetic */ AlibabaParameterDefinition(Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set2 = parametersDescriptors;
            }
            this(set2);
        }

        @Override
        @NotNull
        public Set<LLMParameterDescriptor> getSupportedLLMParameterDescriptors() {
            return this.supportedLLMParameterDescriptors;
        }

        @Override
        public void validateParameters(@NotNull String name2, @NotNull Attributes parameters, @NotNull LLMProfile profile) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                ParameterDefinition.super.validateParameters(name2, parameters, profile);
                Double d = AttributesExtensionKt.getTemperature(parameters);
                if (d != null) {
                    double temperature = ((Number)d).doubleValue();
                    boolean bl = false;
                    ExtensionsKt.requireOrBadRequest(temperature >= 0.0 && temperature < 2.0, (Function0<String>)((Function0)AlibabaParameterDefinition::validateParameters$lambda$1$lambda$0));
                }
                Double d2 = AttributesExtensionKt.getTopP(parameters);
                if (d2 != null) {
                    double topP = ((Number)d2).doubleValue();
                    boolean bl = false;
                    ExtensionsKt.requireOrBadRequest(0.0 <= topP ? topP <= 1.0 : false, (Function0<String>)((Function0)AlibabaParameterDefinition::validateParameters$lambda$3$lambda$2));
                }
                Long l = AttributesExtensionKt.getTopK(parameters);
                if (l != null) {
                    long topK = ((Number)l).longValue();
                    boolean bl = false;
                    ExtensionsKt.requireOrBadRequest(0L <= topK ? topK < 101L : false, (Function0<String>)((Function0)AlibabaParameterDefinition::validateParameters$lambda$5$lambda$4));
                }
                Long l2 = AttributesExtensionKt.getSeed(parameters);
                if (l2 == null) break block3;
                long seed = ((Number)l2).longValue();
                boolean bl = false;
                ExtensionsKt.requireOrBadRequest(0L <= seed ? seed <= Long.MAX_VALUE : false, (Function0<String>)((Function0)AlibabaParameterDefinition::validateParameters$lambda$7$lambda$6));
            }
        }

        private static final String validateParameters$lambda$1$lambda$0() {
            return "Acceptable values of temperature: [0.0: 2.0)";
        }

        private static final String validateParameters$lambda$3$lambda$2() {
            return "Acceptable values of top-p: [0.0: 1.0]";
        }

        private static final String validateParameters$lambda$5$lambda$4() {
            return "Acceptable values of top-k: [0: 100]";
        }

        private static final String validateParameters$lambda$7$lambda$6() {
            return "Acceptable values of seed: [0: 9223372036854775807]";
        }

        public AlibabaParameterDefinition() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions$AlibabaRoleDefinition;", "Lai/grazie/model/llm/definitions/RoleDefinition;", "supportedRoles", "", "Lai/grazie/model/llm/chat/LLMChatRole;", "<init>", "(Ljava/util/Set;)V", "getSupportedRoles", "()Ljava/util/Set;", "validateMessages", "", "name", "", "messages", "", "Lai/grazie/model/llm/chat/v5/LLMChatMessage;", "(Ljava/lang/String;[Lai/grazie/model/llm/chat/v5/LLMChatMessage;)V", "llm-provider-alibaba-profile"})
    @SourceDebugExtension(value={"SMAP\nAlibabaDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlibabaDefinitions.kt\nai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions$AlibabaRoleDefinition\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n11158#2:106\n11493#2,3:107\n13467#2,3:110\n*S KotlinDebug\n*F\n+ 1 AlibabaDefinitions.kt\nai/grazie/llm/provider/alibaba/profile/AlibabaDefinitions$AlibabaRoleDefinition\n*L\n71#1:106\n71#1:107,3\n72#1:110,3\n*E\n"})
    private static final class AlibabaRoleDefinition
    implements RoleDefinition {
        @NotNull
        private final Set<LLMChatRole> supportedRoles;

        public AlibabaRoleDefinition(@NotNull Set<? extends LLMChatRole> supportedRoles) {
            Intrinsics.checkNotNullParameter(supportedRoles, (String)"supportedRoles");
            this.supportedRoles = supportedRoles;
        }

        public /* synthetic */ AlibabaRoleDefinition(Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set2 = roles;
            }
            this(set2);
        }

        @Override
        @NotNull
        public Set<LLMChatRole> getSupportedRoles() {
            return this.supportedRoles;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void validateMessages(@NotNull String name2, @NotNull LLMChatMessage[] messages) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
            RoleDefinition.super.validateMessages(name2, messages);
            LLMChatMessage[] $this$map$iv = messages;
            boolean $i$f$map = false;
            LLMChatMessage[] lLMChatMessageArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_16 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRole());
            }
            List roles = (List)destination$iv$iv;
            LLMChatMessage[] $this$forEachIndexed$iv = messages;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (LLMChatMessage item$iv : $this$forEachIndexed$iv) {
                LLMChatAssistantMessage it;
                void message;
                int n2 = index$iv++;
                LLMChatMessage lLMChatMessage = item$iv;
                int index = n2;
                boolean bl = false;
                if (message.getRole() == LLMChatRole.Function && index != 0) {
                    ExtensionsKt.requireOrBadRequest(roles.get(index - 1) == LLMChatRole.Assistant, (Function0<String>)((Function0)AlibabaRoleDefinition::validateMessages$lambda$4$lambda$1));
                }
                if ((message instanceof LLMChatAssistantMessage ? (LLMChatAssistantMessage)message : null) == null) continue;
                it = it;
                boolean bl2 = false;
                if (!((LLMChatAssistantMessage)message).isFunctionCall()) continue;
                ExtensionsKt.requireOrBadRequest(index != ArraysKt.getLastIndex((Object[])messages) && roles.get(index + 1) == LLMChatRole.Function, (Function0<String>)((Function0)() -> AlibabaRoleDefinition.validateMessages$lambda$4$lambda$3$lambda$2(index)));
            }
        }

        private static final String validateMessages$lambda$4$lambda$1() {
            return "The function response should be after function call. \nExample:\n    user(\"How's the weather today in Beijing?\")\n    assistant(\"get_current_weather\", \"{\\\"location\\\": Beijing\\\", \\\"unit\\\": \\\"celsius\\\"}\")\n    function(\"get_current_weather\", \"{\\\"temperature\\\": \\\"22\\\", \\\"unit\\\": \\\"celsius\\\", \\\"description\\\": \\\"Sunny\\\"}\")";
        }

        private static final String validateMessages$lambda$4$lambda$3$lambda$2(int $index) {
            return StringsKt.trimIndent((String)("\n                                Function response is required after an assistant function call Check " + ($index + 1) + " message  \n                                Example:\n                                    user(\"How's the weather today in Beijing?\")\n                                    assistant(\"get_current_weather\", \"{\\\"location\\\": Beijing\\\", \\\"unit\\\": \\\"celsius\\\"}\")\n                                    function(\"get_current_weather\", \"{\\\"temperature\\\": \\\"22\\\", \\\"unit\\\": \\\"celsius\\\", \\\"description\\\": \\\"Sunny\\\"}\")\n                                Bad example:\n                                    user(\"How's the weather today in Beijing?\")\n                                    assistant(\"get_current_weather\", \"{\\\"location\\\": Beijing\\\", \\\"unit\\\": \\\"celsius\\\"}\")\n                                    user(\"Hi!\")\n                            "));
        }

        public AlibabaRoleDefinition() {
            this(null, 1, null);
        }
    }
}

