/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.gemini;

import com.intellij.ml.llm.agents.gemini.types.GeminiEvent;
import com.intellij.ml.llm.agents.gemini.types.ResultDisplay;
import com.intellij.ml.llm.agents.gemini.types.ToolCallArgs;
import com.intellij.ml.llm.agents.gemini.types.ToolCallStatus;
import com.intellij.ml.llm.agents.gemini.types.ToolKind;
import com.intellij.ml.llm.agents.gemini.types.ToolResponse;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.a2ux.api.AgentCurrentStatusUpdatedEvent;
import org.jetbrains.a2ux.api.AgentEvent;
import org.jetbrains.a2ux.api.File;
import org.jetbrains.a2ux.api.FileChange;
import org.jetbrains.a2ux.api.FileChangesBlockUpdatedEvent;
import org.jetbrains.a2ux.api.FileContent;
import org.jetbrains.a2ux.api.MarkdownBlockUpdatedEvent;
import org.jetbrains.a2ux.api.StepStatus;
import org.jetbrains.a2ux.api.TerminalBlockUpdatedEvent;
import org.jetbrains.a2ux.api.TextFileContent;
import org.jetbrains.a2ux.api.ToolBlockUpdatedEvent;
import org.jetbrains.a2ux.api.ViewFilesBlockUpdatedEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0011H\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00072\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00072\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/agents/gemini/GeminiEventsMapper;", "", "workspacePath", "", "<init>", "(Ljava/lang/String;)V", "createUIEvents", "", "Lorg/jetbrains/a2ux/api/AgentEvent;", "event", "Lcom/intellij/ml/llm/agents/gemini/types/GeminiEvent;", "textBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "textBlockNumber", "", "Lcom/intellij/ml/llm/agents/gemini/types/GeminiEvent$ToolCallUpdateEvent;", "Lcom/intellij/ml/llm/agents/gemini/types/GeminiEvent$TextContentEvent;", "Lcom/intellij/ml/llm/agents/gemini/types/GeminiEvent$ThoughtEvent;", "relativePath", "path", "createEditEvents", "Lorg/jetbrains/a2ux/api/FileChangesBlockUpdatedEvent;", "createFileContent", "Lorg/jetbrains/a2ux/api/TextFileContent;", "text", "createReadEvents", "Lorg/jetbrains/a2ux/api/ViewFilesBlockUpdatedEvent;", "createTerminalEvents", "Lorg/jetbrains/a2ux/api/TerminalBlockUpdatedEvent;", "createDefaultToolEvents", "Lorg/jetbrains/a2ux/api/ToolBlockUpdatedEvent;", "stepStatusOf", "Lorg/jetbrains/a2ux/api/StepStatus;", "intellij.ml.llm.agents.gemini"})
@SourceDebugExtension(value={"SMAP\nGeminiEventsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiEventsMapper.kt\ncom/intellij/ml/llm/agents/gemini/GeminiEventsMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1563#2:127\n1634#2,3:128\n*S KotlinDebug\n*F\n+ 1 GeminiEventsMapper.kt\ncom/intellij/ml/llm/agents/gemini/GeminiEventsMapper\n*L\n91#1:127\n91#1:128,3\n*E\n"})
public final class GeminiEventsMapper {
    @NotNull
    private final String workspacePath;
    @NotNull
    private final StringBuilder textBuilder;
    private int textBlockNumber;

    public GeminiEventsMapper(@NotNull String workspacePath) {
        Intrinsics.checkNotNullParameter((Object)workspacePath, (String)"workspacePath");
        this.workspacePath = workspacePath;
        this.textBuilder = new StringBuilder();
        this.textBlockNumber = 1;
    }

    @NotNull
    public final List<AgentEvent> createUIEvents(@NotNull GeminiEvent event2) {
        List<AgentEvent> list;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        GeminiEvent geminiEvent = event2;
        if (geminiEvent instanceof GeminiEvent.TextContentEvent) {
            list = this.createUIEvents((GeminiEvent.TextContentEvent)event2);
        } else if (geminiEvent instanceof GeminiEvent.StateAgentSettingsEvent) {
            list = CollectionsKt.emptyList();
        } else if (geminiEvent instanceof GeminiEvent.StateChangeEvent) {
            list = CollectionsKt.emptyList();
        } else if (geminiEvent instanceof GeminiEvent.ThoughtEvent) {
            list = this.createUIEvents((GeminiEvent.ThoughtEvent)event2);
        } else if (geminiEvent instanceof GeminiEvent.ToolCallConfirmationEvent) {
            list = CollectionsKt.emptyList();
        } else if (geminiEvent instanceof GeminiEvent.ToolCallUpdateEvent) {
            list = this.createUIEvents((GeminiEvent.ToolCallUpdateEvent)event2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<AgentEvent> createUIEvents(GeminiEvent.ToolCallUpdateEvent event2) {
        StringsKt.clear((StringBuilder)this.textBuilder);
        return switch (WhenMappings.$EnumSwitchMapping$0[event2.getTool().getKind().ordinal()]) {
            case 1 -> this.createEditEvents(event2);
            case 2 -> this.createReadEvents(event2);
            case 3 -> this.createTerminalEvents(event2);
            default -> this.createDefaultToolEvents(event2);
        };
    }

    private final List<AgentEvent> createUIEvents(GeminiEvent.TextContentEvent event2) {
        if (StringsKt.isBlank((CharSequence)this.textBuilder)) {
            ++this.textBlockNumber;
        }
        this.textBuilder.append(event2.getText());
        Object[] objectArray = new AgentEvent[2];
        String string = "text_block_" + this.textBlockNumber;
        String string2 = this.textBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        objectArray[0] = new MarkdownBlockUpdatedEvent(string, null, string2, 2, null);
        objectArray[1] = new AgentCurrentStatusUpdatedEvent(null);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<AgentEvent> createUIEvents(GeminiEvent.ThoughtEvent event2) {
        return CollectionsKt.listOf((Object)new AgentCurrentStatusUpdatedEvent(event2.getSubject() + "\n" + event2.getDescription()));
    }

    private final String relativePath(String path) {
        return StringsKt.removePrefix((String)path, (CharSequence)this.workspacePath);
    }

    private final List<FileChangesBlockUpdatedEvent> createEditEvents(GeminiEvent.ToolCallUpdateEvent event2) {
        ResultDisplay.EditResult editDisplay;
        ToolCallArgs args = event2.getRequest().getArgs();
        ToolCallArgs toolCallArgs = args;
        String filePath = toolCallArgs instanceof ToolCallArgs.ReplaceArgs ? this.relativePath(((ToolCallArgs.ReplaceArgs)args).getFilePath()) : (toolCallArgs instanceof ToolCallArgs.WriteFileArgs ? this.relativePath(((ToolCallArgs.WriteFileArgs)args).getFilePath()) : null);
        ToolCallArgs.ReplaceArgs replaceArgs = args instanceof ToolCallArgs.ReplaceArgs ? (ToolCallArgs.ReplaceArgs)args : null;
        String details = replaceArgs != null ? replaceArgs.getInstruction() : null;
        ToolResponse toolResponse = event2.getResponse();
        ResultDisplay resultDisplay = toolResponse != null ? toolResponse.getResultDisplay() : null;
        ResultDisplay.EditResult editResult = editDisplay = resultDisplay instanceof ResultDisplay.EditResult ? (ResultDisplay.EditResult)resultDisplay : null;
        ResultDisplay.EditResult editResult2 = editDisplay;
        FileChange fileChange = new FileChange((FileContent)this.createFileContent(editResult != null ? editResult.getOriginalContent() : null), (FileContent)this.createFileContent(editResult2 != null ? editResult2.getNewContent() : null), filePath, filePath);
        String string = "patch_" + event2.getRequest().getCallId();
        List list = CollectionsKt.listOfNotNull((Object)fileChange);
        StepStatus stepStatus = this.stepStatusOf(event2);
        FileChangesBlockUpdatedEvent changeEvent = new FileChangesBlockUpdatedEvent(string, null, null, null, stepStatus, list, details, 14, null);
        if (event2.getStatus() == ToolCallStatus.Success) {
            VirtualFileManager.getInstance().asyncRefresh();
        }
        return CollectionsKt.listOf((Object)changeEvent);
    }

    private final TextFileContent createFileContent(String text) {
        if (text == null) {
            return null;
        }
        return new TextFileContent(text);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ViewFilesBlockUpdatedEvent> createReadEvents(GeminiEvent.ToolCallUpdateEvent event2) {
        void $this$mapTo$iv$iv;
        ToolCallArgs args = event2.getRequest().getArgs();
        ToolCallArgs toolCallArgs = args;
        List paths = toolCallArgs instanceof ToolCallArgs.ReadManyFilesArgs ? ((ToolCallArgs.ReadManyFilesArgs)args).getPaths() : (toolCallArgs instanceof ToolCallArgs.ReadFile ? CollectionsKt.listOf((Object)((ToolCallArgs.ReadFile)args).getAbsolutePath()) : CollectionsKt.emptyList());
        String string = event2.getRequest().getCallId();
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void path;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File(this.relativePath((String)path), null, null, 6, null));
        }
        List list = (List)destination$iv$iv;
        StepStatus stepStatus = this.stepStatusOf(event2);
        ViewFilesBlockUpdatedEvent event3 = new ViewFilesBlockUpdatedEvent(string, null, null, null, stepStatus, list, null, 78, null);
        return CollectionsKt.listOf((Object)event3);
    }

    private final List<TerminalBlockUpdatedEvent> createTerminalEvents(GeminiEvent.ToolCallUpdateEvent event2) {
        ToolResponse toolResponse = event2.getResponse();
        ResultDisplay result = toolResponse != null ? toolResponse.getResultDisplay() : null;
        String output = result instanceof ResultDisplay.TextResult ? ((ResultDisplay.TextResult)result).unbox-impl() : null;
        Object object = event2.getRequest().getArgs();
        ToolCallArgs.TerminalArgs terminalArgs = object instanceof ToolCallArgs.TerminalArgs ? (ToolCallArgs.TerminalArgs)object : null;
        if (terminalArgs == null) {
            return CollectionsKt.emptyList();
        }
        ToolCallArgs.TerminalArgs args = terminalArgs;
        object = event2.getRequest().getCallId();
        String string = args.getCommand();
        String string2 = args.getDescription();
        StepStatus stepStatus = this.stepStatusOf(event2);
        TerminalBlockUpdatedEvent event3 = new TerminalBlockUpdatedEvent((String)object, null, null, null, null, null, stepStatus, string, output, null, null, null, string2, 3646, null);
        return CollectionsKt.listOf((Object)event3);
    }

    private final List<ToolBlockUpdatedEvent> createDefaultToolEvents(GeminiEvent.ToolCallUpdateEvent event2) {
        return CollectionsKt.listOf((Object)new ToolBlockUpdatedEvent(event2.getRequest().getCallId(), null, null, null, event2.getTool().getDisplayName(), null, this.stepStatusOf(event2), null, null, null, 942, null));
    }

    private final StepStatus stepStatusOf(GeminiEvent.ToolCallUpdateEvent event2) {
        return event2.getStatus() == ToolCallStatus.Success ? StepStatus.COMPLETED : StepStatus.IN_PROGRESS;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolKind.values().length];
            try {
                nArray[ToolKind.Edit.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.Read.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolKind.Execute.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

