/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.provider;

import ai.grazie.model.cloud.ContentType;
import ai.koog.prompt.llm.LLMCapability;
import ai.koog.prompt.llm.LLModel;
import com.intellij.ml.llm.core.providers.AiaLlmProviderType;
import com.intellij.ml.llm.core.providers.AiaThirdPartyProfileInfo;
import com.intellij.ml.llm.core.providers.ThirdPartyLLMProfileId;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/provider/AiaKoogLlmProfileInfo;", "Lcom/intellij/ml/llm/core/providers/AiaThirdPartyProfileInfo;", "providerId", "", "providerType", "Lcom/intellij/ml/llm/core/providers/AiaLlmProviderType;", "model", "Lai/koog/prompt/llm/LLModel;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/core/providers/AiaLlmProviderType;Lai/koog/prompt/llm/LLModel;)V", "getModel", "()Lai/koog/prompt/llm/LLModel;", "contextLimit", "", "getContextLimit", "()Ljava/lang/Integer;", "maxOutputTokens", "getMaxOutputTokens", "Ljava/lang/Integer;", "supportsContentType", "", "type", "Lai/grazie/model/cloud/ContentType;", "supportsToolCalling", "intellij.ml.llm.provider"})
public abstract class AiaKoogLlmProfileInfo
extends AiaThirdPartyProfileInfo {
    @NotNull
    private final LLModel model;
    private final int contextLimit;
    @Nullable
    private final Integer maxOutputTokens;

    public AiaKoogLlmProfileInfo(@NotNull String providerId, @NotNull AiaLlmProviderType providerType, @NotNull LLModel model) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)providerType, (String)"providerType");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(new ThirdPartyLLMProfileId(providerId, model.getId()), providerType);
        this.model = model;
        this.contextLimit = (int)this.model.getContextLength();
        Long l = this.model.getMaxOutputTokens();
        this.maxOutputTokens = l != null ? Integer.valueOf((int)l.longValue()) : null;
    }

    @NotNull
    public final LLModel getModel() {
        return this.model;
    }

    @NotNull
    public Integer getContextLimit() {
        return this.contextLimit;
    }

    @Nullable
    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public boolean supportsContentType(@NotNull ContentType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (ArraysKt.contains((Object[])ContentType.Image.INSTANCE.getAll(), (Object)type)) {
            return this.model.getCapabilities().contains(LLMCapability.Vision.Image.INSTANCE);
        }
        return false;
    }

    public boolean supportsToolCalling() {
        return this.model.getCapabilities().contains(LLMCapability.Tools.INSTANCE);
    }
}

