/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.askai.debug;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.askai.debug.AskAiEditorColorsApplierKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/askai/debug/AskAiEditorColorsApplier;", "", "<init>", "()V", "applyColorChanges", "", "changesJson", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyTextAttributeChange", "key", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "(Ljava/lang/String;Lcom/intellij/openapi/editor/markup/TextAttributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyColorChange", "color", "Ljava/awt/Color;", "(Ljava/lang/String;Ljava/awt/Color;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifySchemeChanged", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "change", "Lkotlinx/serialization/json/JsonObject;", "parseColor", "colorJson", "parseEffectType", "Lcom/intellij/openapi/editor/markup/EffectType;", "effectTypeName", "intellij.ml.llm.askai"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAskAiEditorColorsApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AskAiEditorColorsApplier.kt\ncom/intellij/ml/llm/askai/debug/AskAiEditorColorsApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1869#2,2:197\n1869#2,2:199\n1#3:201\n*S KotlinDebug\n*F\n+ 1 AskAiEditorColorsApplier.kt\ncom/intellij/ml/llm/askai/debug/AskAiEditorColorsApplier\n*L\n54#1:197,2\n64#1:199,2\n*E\n"})
public final class AskAiEditorColorsApplier {
    @NotNull
    public static final AskAiEditorColorsApplier INSTANCE = new AskAiEditorColorsApplier();
    public static final int $stable;

    private AskAiEditorColorsApplier() {
    }

    @Nullable
    public final Object applyColorChanges(@NotNull String changesJson, @NotNull Continuation<? super Unit> $completion) {
        JsonElement jsonElement;
        JsonElement change;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Json json = JsonKt.Json$default(null, AskAiEditorColorsApplier::applyColorChanges$lambda$0, (int)1, null);
        JsonObject changes = JsonElementKt.getJsonObject((JsonElement)json.parseToJsonElement(changesJson));
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        JsonElement jsonElement2 = (JsonElement)changes.get((Object)"textAttributes");
        if (jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonArray((JsonElement)jsonElement2)) != null) {
            $this$forEach$iv = (Iterable)jsonElement2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                change = (JsonElement)element$iv;
                boolean bl = false;
                try {
                    INSTANCE.applyTextAttributeChange(JsonElementKt.getJsonObject((JsonElement)change), scheme);
                }
                catch (Exception e) {
                    if (e instanceof CancellationException) {
                        throw e;
                    }
                    AskAiEditorColorsApplierKt.access$getLOG$p().error("Failed to apply text attribute change: " + change, (Throwable)e);
                }
            }
        }
        if ((jsonElement = (JsonElement)changes.get((Object)"colors")) != null && (jsonElement = JsonElementKt.getJsonArray((JsonElement)jsonElement)) != null) {
            $this$forEach$iv = (Iterable)jsonElement;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                change = (JsonElement)element$iv;
                boolean bl = false;
                try {
                    INSTANCE.applyColorChange(JsonElementKt.getJsonObject((JsonElement)change), scheme);
                }
                catch (Exception e) {
                    if (e instanceof CancellationException) {
                        throw e;
                    }
                    AskAiEditorColorsApplierKt.access$getLOG$p().error("Failed to apply color change: " + change, (Throwable)e);
                }
            }
        }
        Object object = this.notifySchemeChanged(scheme, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object applyTextAttributeChange(@NotNull String key, @NotNull TextAttributes attributes, @NotNull Continuation<? super Unit> $completion) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        TextAttributesKey textAttributesKey = TextAttributesKey.find((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"find(...)");
        TextAttributesKey attributesKey = textAttributesKey;
        scheme.setAttributes(attributesKey, attributes);
        Object object = this.notifySchemeChanged(scheme, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object applyColorChange(@NotNull String key, @Nullable Color color, @NotNull Continuation<? super Unit> $completion) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        ColorKey colorKey = ColorKey.find((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"find(...)");
        ColorKey colorKey2 = colorKey;
        scheme.setColor(colorKey2, color);
        Object object = this.notifySchemeChanged(scheme, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object notifySchemeChanged(EditorColorsScheme scheme, Continuation<? super Unit> $completion) {
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(scheme, null){
            int label;
            final /* synthetic */ EditorColorsScheme $scheme;
            {
                this.$scheme = $scheme;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)$result);
                        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                        EditorColorsManagerImpl editorColorsManagerImpl = editorColorsManager instanceof EditorColorsManagerImpl ? (EditorColorsManagerImpl)editorColorsManager : null;
                        if (editorColorsManagerImpl != null) {
                            editorColorsManagerImpl.schemeChangedOrSwitched(this.$scheme);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void applyTextAttributeChange(JsonObject change, EditorColorsScheme scheme) {
        JsonElement it;
        Object object = (JsonElement)change.get((Object)"key");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
            throw new IllegalArgumentException("Missing 'key' in text attribute change");
        }
        Object keyName = object;
        JsonElement jsonElement = (JsonElement)change.get((Object)"attributes");
        if (jsonElement == null || (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) == null) {
            throw new IllegalArgumentException("Missing 'attributes' in text attribute change");
        }
        JsonElement attributesJson = jsonElement;
        TextAttributesKey textAttributesKey = TextAttributesKey.find((String)keyName);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"find(...)");
        TextAttributesKey key = textAttributesKey;
        TextAttributes textAttributes = scheme.getAttributes(key);
        if (textAttributes == null) {
            textAttributes = new TextAttributes();
        }
        TextAttributes currentAttributes = textAttributes;
        TextAttributes textAttributes2 = currentAttributes.clone();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"clone(...)");
        TextAttributes newAttributes = textAttributes2;
        JsonElement jsonElement2 = (JsonElement)attributesJson.get((Object)"foregroundColor");
        if (jsonElement2 != null) {
            it = jsonElement2;
            boolean bl = false;
            newAttributes.setForegroundColor(INSTANCE.parseColor(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement3 = (JsonElement)attributesJson.get((Object)"backgroundColor");
        if (jsonElement3 != null) {
            it = jsonElement3;
            boolean bl = false;
            newAttributes.setBackgroundColor(INSTANCE.parseColor(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement4 = (JsonElement)attributesJson.get((Object)"effectColor");
        if (jsonElement4 != null) {
            it = jsonElement4;
            boolean bl = false;
            newAttributes.setEffectColor(INSTANCE.parseColor(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement5 = (JsonElement)attributesJson.get((Object)"errorStripeColor");
        if (jsonElement5 != null) {
            it = jsonElement5;
            boolean bl = false;
            newAttributes.setErrorStripeColor(INSTANCE.parseColor(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement6 = (JsonElement)attributesJson.get((Object)"effectType");
        if (jsonElement6 != null) {
            it = jsonElement6;
            boolean bl = false;
            newAttributes.setEffectType(INSTANCE.parseEffectType(JsonElementKt.getJsonPrimitive((JsonElement)it).getContent()));
        }
        JsonElement jsonElement7 = (JsonElement)attributesJson.get((Object)"fontType");
        if (jsonElement7 != null) {
            it = jsonElement7;
            boolean bl = false;
            newAttributes.setFontType(JsonElementKt.getInt((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)it)));
        }
        int fontType = 0;
        fontType = newAttributes.getFontType();
        JsonElement jsonElement8 = (JsonElement)attributesJson.get((Object)"isBold");
        if (jsonElement8 != null) {
            JsonElement isBold = jsonElement8;
            boolean bl = false;
            fontType = JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)isBold)) ? fontType | 1 : fontType & 0xFFFFFFFE;
        }
        JsonElement jsonElement9 = (JsonElement)attributesJson.get((Object)"isItalic");
        if (jsonElement9 != null) {
            JsonElement isItalic = jsonElement9;
            boolean bl = false;
            fontType = JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)isItalic)) ? fontType | 2 : fontType & 0xFFFFFFFD;
        }
        newAttributes.setFontType(fontType);
        scheme.setAttributes(key, newAttributes);
    }

    private final void applyColorChange(JsonObject change, EditorColorsScheme scheme) {
        Color color;
        JsonObject colorJson;
        Object object = (JsonElement)change.get((Object)"key");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
            throw new IllegalArgumentException("Missing 'key' in color change");
        }
        Object keyName = object;
        JsonElement jsonElement = (JsonElement)change.get((Object)"color");
        JsonObject jsonObject = colorJson = jsonElement != null ? JsonElementKt.getJsonObject((JsonElement)jsonElement) : null;
        if (jsonObject != null) {
            JsonObject it = jsonObject;
            boolean bl = false;
            color = INSTANCE.parseColor(it);
        } else {
            color = null;
        }
        Color color2 = color;
        ColorKey colorKey = ColorKey.find((String)keyName);
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"find(...)");
        ColorKey key = colorKey;
        scheme.setColor(key, color2);
    }

    private final Color parseColor(JsonObject colorJson) {
        JsonElement jsonElement = (JsonElement)colorJson.get((Object)"r");
        int r = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getInt((JsonPrimitive)jsonElement) : 0;
        JsonElement jsonElement2 = (JsonElement)colorJson.get((Object)"g");
        int g = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? JsonElementKt.getInt((JsonPrimitive)jsonElement2) : 0;
        JsonElement jsonElement3 = (JsonElement)colorJson.get((Object)"b");
        int b = jsonElement3 != null && (jsonElement3 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement3)) != null ? JsonElementKt.getInt((JsonPrimitive)jsonElement3) : 0;
        JsonElement jsonElement4 = (JsonElement)colorJson.get((Object)"a");
        int a = jsonElement4 != null && (jsonElement4 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement4)) != null ? JsonElementKt.getInt((JsonPrimitive)jsonElement4) : 255;
        return new Color(r, g, b, a);
    }

    private final EffectType parseEffectType(String effectTypeName) {
        EffectType effectType;
        try {
            effectType = EffectType.valueOf((String)effectTypeName);
        }
        catch (IllegalArgumentException e) {
            AskAiEditorColorsApplierKt.access$getLOG$p().warn("Unknown effect type: " + effectTypeName);
            effectType = null;
        }
        return effectType;
    }

    private static final Unit applyColorChanges$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$notifySchemeChanged(AskAiEditorColorsApplier $this, EditorColorsScheme scheme, Continuation $completion) {
        return $this.notifySchemeChanged(scheme, (Continuation<? super Unit>)$completion);
    }
}

