/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.chat;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAContainerPanelFacade;
import com.intellij.ml.llm.core.AIAContentFacade;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionHost;
import com.intellij.ml.llm.core.chat.ui.list.AIAssistantChatListPanel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.ui.components.JBList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010*\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0011*\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/chat/AIAssistantDeleteChat;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "confirmDeletion", "", "project", "Lcom/intellij/openapi/project/Project;", "chats", "", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "deleteChats", "selectedChats", "currentSession", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nAIAssistantDeleteChat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAssistantDeleteChat.kt\ncom/intellij/ml/llm/core/chat/actions/chat/AIAssistantDeleteChat\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n30#2,2:81\n*S KotlinDebug\n*F\n+ 1 AIAssistantDeleteChat.kt\ncom/intellij/ml/llm/core/chat/actions/chat/AIAssistantDeleteChat\n*L\n62#1:81,2\n*E\n"})
public final class AIAssistantDeleteChat
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<ChatSession> selectedChats = this.selectedChats(e);
        ChatSession currentSession = this.currentSession(e);
        Collection collection = selectedChats;
        e.getPresentation().setEnabledAndVisible(!(collection == null || collection.isEmpty()) || currentSession != null);
        if (selectedChats != null && selectedChats.size() != 1) {
            e.getPresentation().setText(LLMBundle.message((String)"dialog.title.delete.chats", (Object[])new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List selectedChats = this.selectedChats(e);
        ChatSession currentSession = this.currentSession(e);
        Collection collection = selectedChats;
        if (!(collection == null || collection.isEmpty())) {
            list2 = selectedChats;
        } else {
            ChatSession chatSession2 = currentSession;
            if (chatSession2 != null) {
                list2 = CollectionsKt.listOf((Object)chatSession2);
            } else {
                return;
            }
        }
        List chatsToDelete = list2;
        if (!this.confirmDeletion(project2, chatsToDelete)) {
            return;
        }
        this.deleteChats(project2, chatsToDelete, e);
    }

    private final boolean confirmDeletion(Project project, List<? extends ChatSession> chats) {
        boolean bl;
        if (chats.size() == 1) {
            bl = MessageDialogBuilder.Companion.yesNo(LLMBundle.message((String)"dialog.title.delete.chat", (Object[])new Object[0]), LLMBundle.message((String)"dialog.message.do.you.want.to.delete.current.chat", (Object[])new Object[0])).ask(project);
        } else {
            Object[] objectArray = new Object[]{chats.size()};
            bl = MessageDialogBuilder.Companion.yesNo(LLMBundle.message((String)"dialog.title.delete.chats", (Object[])new Object[0]), LLMBundle.message((String)"dialog.message.do.you.want.to.delete.selected.chats", (Object[])objectArray)).ask(project);
        }
        return bl;
    }

    private final void deleteChats(Project project, List<? extends ChatSession> chats, AnActionEvent e) {
        block3: {
            DataKey<AIAssistantChatListPanel> dataKey = AIAssistantChatListPanel.Companion.getChatList();
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            AIAssistantChatListPanel chatListPanel = (AIAssistantChatListPanel)((Object)dataKey.getData(dataContext));
            for (ChatSession chatSession2 : chats) {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<ChatSessionHost> serviceClass$iv = ChatSessionHost.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((ChatSessionHost)object).removeChatSession(chatSession2);
                AIAssistantChatListPanel aIAssistantChatListPanel = chatListPanel;
                if (aIAssistantChatListPanel == null) continue;
                aIAssistantChatListPanel.removeChat(chatSession2);
            }
            if (chatListPanel != null) break block3;
            AIAContentFacade aIAContentFacade = AIAContentFacade.Companion.getInstance(project);
            DataContext dataContext2 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            AIAContainerPanelFacade aIAContainerPanelFacade = aIAContentFacade.getPanel(dataContext2);
            if (aIAContainerPanelFacade != null) {
                aIAContainerPanelFacade.goToChatList();
            }
        }
    }

    private final List<ChatSession> selectedChats(AnActionEvent $this$selectedChats) {
        Object object = $this$selectedChats.getDataContext().getData(PlatformDataKeys.CONTEXT_COMPONENT);
        JBList jBList = object instanceof JBList ? (JBList)object : null;
        List list2 = jBList != null ? jBList.getSelectedValuesList() : null;
        return list2 instanceof List ? list2 : null;
    }

    private final ChatSession currentSession(AnActionEvent $this$currentSession) {
        return (ChatSession)$this$currentSession.getDataContext().getData(ChatSession.Companion.getCurrentSession());
    }
}

