/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.chat.actions.codeSnippet.find;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/core/chat/actions/codeSnippet/find/RabinKarpStringMatcher;", "", "<init>", "()V", "prime", "", "modulo", "calculateHash", "string", "", "range", "Lkotlin/ranges/IntRange;", "updateHash", "oldHash", "leftmostPrime", "hasSubstring", "", "substring", "haveCommonSubstring", "string1", "string2", "minLength", "lengthOfCommonSubstring", "intellij.ml.llm.chat"})
@SourceDebugExtension(value={"SMAP\nRabinKarpStringMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RabinKarpStringMatcher.kt\ncom/intellij/ml/llm/core/chat/actions/codeSnippet/find/RabinKarpStringMatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class RabinKarpStringMatcher {
    @NotNull
    public static final RabinKarpStringMatcher INSTANCE = new RabinKarpStringMatcher();
    private static final int prime = 101;
    private static final int modulo = Short.MAX_VALUE;

    private RabinKarpStringMatcher() {
    }

    private final int calculateHash(String string, IntRange range) {
        int n;
        int hash = 0;
        int i = range.getFirst();
        if (i <= (n = range.getLast())) {
            while (true) {
                hash = (hash * prime + string.charAt(i)) % modulo;
                if (i == n) break;
                ++i;
            }
        }
        return hash;
    }

    private final int updateHash(String string, IntRange range, int oldHash, int leftmostPrime) {
        return ((oldHash + modulo - string.charAt(range.getFirst()) * leftmostPrime % modulo) * prime + string.charAt(range.getEndExclusive())) % modulo;
    }

    public final boolean hasSubstring(@NotNull String string, @NotNull String substring) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        if (substring.length() > string.length()) {
            return false;
        }
        int hash = this.calculateHash(substring, StringsKt.getIndices((CharSequence)substring));
        int curHash = this.calculateHash(string, StringsKt.getIndices((CharSequence)substring));
        int l = substring.length();
        int leftmostPrime = 0;
        leftmostPrime = 1;
        int n = l - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            leftmostPrime = leftmostPrime * prime % modulo;
        }
        int i = 0;
        n2 = string.length() - substring.length();
        if (i <= n2) {
            while (true) {
                IntRange curRange = RangesKt.until((int)i, (int)(i + l));
                if (curHash == hash && Intrinsics.areEqual((Object)StringsKt.substring((String)string, (IntRange)curRange), (Object)substring)) {
                    return true;
                }
                if (i < string.length() - substring.length()) {
                    curHash = this.updateHash(string, curRange, curHash, leftmostPrime);
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean haveCommonSubstring(@NotNull String string1, @NotNull String string2, int minLength) {
        int i;
        Intrinsics.checkNotNullParameter((Object)string1, (String)"string1");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string2");
        if (minLength > string1.length() || minLength > string2.length()) {
            return false;
        }
        int leftmostPrime = 0;
        leftmostPrime = 1;
        int n = minLength - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            leftmostPrime = leftmostPrime * prime % modulo;
        }
        Map hashes = new LinkedHashMap();
        int curHash = this.calculateHash(string1, RangesKt.until((int)0, (int)minLength));
        hashes.put(curHash, 0);
        int n3 = string1.length() - minLength;
        for (i = 0; i < n3; ++i) {
            curHash = this.updateHash(string1, RangesKt.until((int)i, (int)(i + minLength)), curHash, leftmostPrime);
            hashes.put(curHash, i + 1);
        }
        curHash = this.calculateHash(string2, RangesKt.until((int)0, (int)minLength));
        i = 0;
        n3 = string2.length() - minLength;
        if (i <= n3) {
            while (true) {
                boolean bl;
                IntRange curRange = RangesKt.until((int)i, (int)(i + minLength));
                Integer n4 = (Integer)hashes.get(curHash);
                if (n4 != null) {
                    int it = ((Number)n4).intValue();
                    boolean bl2 = false;
                    String string = string1.substring(it, it + minLength);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    bl = Intrinsics.areEqual((Object)string, (Object)StringsKt.substring((String)string2, (IntRange)curRange));
                } else {
                    bl = false;
                }
                if (bl) {
                    return true;
                }
                if (i < string2.length() - minLength) {
                    curHash = this.updateHash(string2, curRange, curHash, leftmostPrime);
                }
                if (i == n3) break;
                ++i;
            }
        }
        return false;
    }

    public final int lengthOfCommonSubstring(@NotNull String string1, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string1, (String)"string1");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string2");
        int s = 0;
        int e = Math.min(string1.length(), string2.length()) + 1;
        while (e - s > 1) {
            int m = (s + e) / 2;
            if (this.haveCommonSubstring(string1, string2, m)) {
                s = m;
                continue;
            }
            e = m;
        }
        return s;
    }
}

